#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: HTC.pm 296 2007-03-01 13:48:43Z hikarin $
#

package Img0ch::Template::HTC;

use strict;
use base qw(HTML::Template::Compiled);

sub new {
    my ( $iClass, $args ) = @_;
    my $cachedir = $args->{cachedir};
    my $cmode    = oct $args->{cmode} || 700;
    my $do_cache = $cachedir ? 1 : 0;

    my $iTemplate = $iClass->SUPER::new(
        cache_dir              => $cachedir,
        filename               => $args->{filename},
        global_vars            => 1,
        path                   => $args->{tmplpath},
        search_path_on_include => 1,
    );

    my $bbs = $args->{bbs};
    my $uri = $args->{uri};
    $iTemplate->param(
        {   BaseURI   => $uri,
            BBSPath   => $uri,
            BBSURI    => ( $bbs ? join( '/', $uri, $bbs ) : $uri ),
            BBS       => $bbs,
            CGIURI    => $args->{cgipath},
            StaticURI => $args->{static},
            TimeStamp => time(),
            VERSION   => $args->{version},
            Version   => Img0ch::Kernel->VERSION(),
            %{ $args->{setting} },
        }
    );
    $iTemplate;
}

sub render { \$_[0]->output() }

sub remove_cache {
    my ( $iTemplate ) = @_;
    $iTemplate->clear_cache();
    $iTemplate->clear_filecache();
    return;
}

1;
__END__
