#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Request.pm 265 2007-02-20 15:16:17Z hikarin $
#

package Img0ch::FCGIA::Request;

use strict;
use base qw(Img0ch::RequestIF);

BEGIN { $INC{'Img0ch/Request.pm'} = __FILE__ }

sub new {
    my ( $iClass, $af ) = @_;
    my $params = $af->params();
    my $buffer;
    # while (my $line = $af->read_stdin_line()) {
    #     $buffer .= $line;
    # }
    # hack

    my $cgi = CGI::Minimal->new();
    $buffer = $af->{stdin} || $params->{QUERY_STRING};

    my $content_type = $params->{'CONTENT_TYPE'} || '';
    if ($content_type =~ m{\Amultipart/form-data; boundary=(.*)\z}i) {
        my $boundary = $1;
        $cgi->_burst_multipart_buffer( $buffer, $boundary );
    }
    else {
        $cgi->_burst_URL_encoded_buffer( $buffer, '[&;]' );
    }
    bless { __af => $af,
            __cgi => $cgi,
            __env => $params }, $iClass;
}

sub DESTROY { $_[0]->{__cgi}->reset_globals() }

sub signature {
    my ($iRequest) = @_;
    my $sign = $iRequest->{__sign};
    if ( !$sign ) {
        $sign = $iRequest->SUPER::signature('FastCGI');
        $iRequest->{__sign} = $sign;
    }
    return $sign;
}

*credit = \&signature;

sub init {
    my ( $iRequest, $iConfig ) = @_;
    my $ip = $iRequest->{__env}->{'REMOTE_ADDR'} || '0.0.0.0';
    my $q = $iRequest->{__cgi};

    my $now = time();
    my ( $system_path, $token_type ) = ( '', '' );
    if ($iConfig) {
        $system_path = $iConfig->get('SystemPath');
        $token_type  = $iConfig->get('SignatureType');
    }
    $iRequest->{__now}    = $now;
    $iRequest->{__msec}   = sprintf '%05d', ( $$ + rand(8192) );
    $iRequest->{__ip}     = $ip;
    $iRequest->{__ip_int} = pack 'C4', ( split '\.', $ip );
    $iRequest->{_error}   = 999;
    $iRequest->{__agent}  = $iRequest->detect_agent($system_path);
    $iRequest->{__sign}   =
        $iRequest->SUPER::signature( 'FastCGI', $token_type );

    {
        my $bbs = $iRequest->{__bbs} || $q->param('bbs') || '';
        $bbs =~ /\A([\w\-]+)\z/xms;
        $iRequest->{__bbs} = $1 || ''
    }
    {
        my $key = $iRequest->{__key} || $q->param('key') || $now;
        $key =~ /\A(\d\d\d\d\d\d\d\d\d\d?)\z/xms;
        $iRequest->{__key} = $1 || ''
    }
    1;
}

sub param {
    my ( $iRequest, $key, $unescape ) = @_;
    my $q = $iRequest->{__cgi};
    $unescape ||= 0;

    if ( !wantarray ) {
        my $value = $q->param($key);
        if ( !$unescape ) {
            $value = Img0ch::Kernel::escape_html_entities($value);
        }
        return $value;
    }
    elsif ( wantarray and !$key ) {
        my @result = $q->param();
        return @result;
    }
    else {
        my @r = $q->param($key);
        return
            map { $unescape ? $_ : Img0ch::Kernel::escape_html_entities($_) }
            @r;
    }
}

sub rawdata { \$_[0]->{__cgi}->raw() }

sub get_header {
    my ( $iRequest, $key ) = @_;
    $key =~ tr/\-/_/;
    return $iRequest->{__env}->{$key} || '';
}

sub set_header {
    my ( $iRequest, $key, $value ) = @_;
    $key =~ tr/\-/_/;
    $iRequest->{__header}->{$key} = $value;
    return;
}

sub query { $_[0]->{__env}->{'QUERY_STRING'} }

sub path_info { $_[0]->{__env}->{'PATH_INFO'} }

sub is_uploadable {
    my ( $iRequest, $key ) = @_;
    my $q = $iRequest->{__cgi};
    $q->truncated() and die 'error: malformed request', "\n";

    my $file = $q->param_filename($key) || return 0;
    my ( $fh, $filename ) = File::Temp::tempfile(UNLINK => 1);
    binmode $fh;
    print {$fh} $q->param($key) or die Img0ch::Kernel->throw_exception($!);
    close $fh;

    $iRequest->{__tmp}   = $filename;
    $iRequest->{__file}  = $file;
    $iRequest->{__fsize} = -s $filename;
    return 1;
}

sub tempfile {
    my ($iRequest) = @_;
    my $tmp = $iRequest->{__tmp};
    if ( !$tmp ) {
        require Img0ch::Maple;
        Img0ch::Maple->throw_exception('No file was uploaded');
    }
    return $tmp;
}

sub filename {
    my ( $iRequest, $key ) = @_;
    my $filename = $iRequest->{__file};
    $filename =~ tr/\0'"<>&//d;
    $filename;
}

sub enable_compress {
    $_[0]->{__header}->{'content-encoding'} = 'gzip';
    return;
}

sub send_http_header {
    my ( $iRequest, $type, $charset ) = @_;
    my $af = $iRequest->{__af};
    my $q = $iRequest->{__cgi};
    $type ||= 'text/html';
    $charset = defined $charset ? $charset : 'Shift_JIS';

    my $header = $iRequest->{__header};
    while ( my ( $key, $value ) = each %$header ) {
        $af->print_stdout(ucfirst($key) . ": ${value}\n");
    }
    map { $af->print_stdout(
        "Set-Cookie:  ${_} \n") } @{ $iRequest->{__cookie} || [] };

    my $ctype  = 'Content-Type: ' . $type;
    ( index($type, 'text/') == 0 ) and $ctype .= '; charset=' . $charset;
    $af->print_stdout($ctype . "\n\n");
    return;
}

sub print {
    my ( $iRequest, @args ) = @_;
    my $af = $iRequest->{__af};
    map { $af->print_stdout(${$_}) } @args;
}

package Img0ch::Request;

use strict;
@Img0ch::Request::ISA = qw(Img0ch::FCGIA::Request);

1;
__END__
