#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Host.pm 141 2007-01-28 11:55:15Z hikarin $
#

package Img0ch::Plugin::Filter::Host;

use strict;

sub check {
    my ( $iApp, $plugin_id ) = @_;

    if ( !$iApp->cap()->can_pass_proxy_access() ) {
        require Img0ch::Filter::RemoteHost;
        my $iFRH = Img0ch::Filter::RemoteHost->new( $iApp->bbs() );
        $iFRH->load();
        if ( !$iFRH->write_ok( $iApp->get_remote_host() ) ) {
            $iApp->set_error('POST_FROM_DENIED_HOST');
            return 0;
        }
    }
    return 1;
}

1;
__END__
