/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.Template.Default
 * $Id: default.js 183 2007-02-05 14:03:21Z hikarin $
 *
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};
if ( typeof Img0ch.Template == "undefined" ) Img0ch.Template = {};

Img0ch.Template.Default = {
    "renderRes": function( parentObject, root, resno, res ) {
        var dt  = document.createElement("dt");
        dt.id = "rdt_" + resno;
        var mail = res[1];
        if (mail) {
            dt.innerHTML = String(resno) + " ：<a href=\"mailto:"
                         + mail + "\"><b>" + res[0]
                         + "</b></a> ：" + res[2];
        }
        else {
            dt.innerHTML = String(resno) + " ：<span class=\"ResName\"><b>"
                         + res[0] + "</b></span> ：" + res[2];
        }
        var dd  = document.createElement("dd");
        dd.id = "rdd_" + resno;
        dd.innerHTML = parentObject.rewrite(res[3] || "") + "<br /><br />";
        root.appendChild(dt);
        root.appendChild(dd);
    }
}
