#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: pool.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Zeromin::App::pool;

use strict;

sub load {
    require Zeromin::App::bbs;
    Zeromin::App::bbs::load(shift);
}

sub archive {
    require Zeromin::App::archive;
    Zeromin::App::archive::create(shift);
}

sub create {
    _do_task( shift, 'create', 'can_create_pool', 'CREATED POOL',
        'TRIED CREATING POOl',
    );
}

sub restore {
    _do_task(
        shift, 'restore', 'can_recover_pool',
        'RESTORED POOL',
        'TRIED RESTORING POOL',
    );
}

sub remove {
    _do_task( shift, 'remove', 'can_remove_pool', 'REMOVED POOL',
        'TRIED REMOVING POOL',
    );
}

sub prepare_ap {
    my ($zApp) = @_;
    my $zUser = $zApp->user() || return { code => 1 };
    my $iBBS  = $zApp->bbs()  || return { code => 1 };
    my $iRequest = $zApp->request();

    $zUser->can_autopool_thread() or return { code => 1 };
    my $condition = {
        bydate => $iRequest->param('byDate')
        ? ( $iRequest->param_int('date') * 86400 )
        : 0,
        byres => $iRequest->param('byRes') ? $iRequest->param_int('res') : 0,
        bypos => $iRequest->param('byPos') ? $iRequest->param('pos')     : 0,
        bywriteable => $iRequest->param('byWriteable'),
    };

    require Zeromin::Subject;
    my $zSubject = Zeromin::Subject->new($iBBS);
    $zSubject->load();
    return { code => 0, threads => $zSubject->gets_by_condition($condition) };
}

sub execute_ap {
    my ($zApp) = @_;
    my $result = prepare_ap($zApp);
    if ( $result->{code} == 0 ) {
        require Zeromin::Pool;
        my $iBBS   = $zApp->bbs();
        my $zPool  = Zeromin::Pool->new( $iBBS, 0 );
        my $dir    = $iBBS->bbs();
        my $status = {};
        for my $result_one ( @{ $result->{threads} } ) {
            my $key = $result_one->[0];
            $zPool->set_key($key);
            if ( $zPool->create($key) ) {
                $zApp->logger( 1, 'CREATED POOL: %s/%s', [ $dir, $key ] );
                $status->{$key} = 1;
            }
            else {
                $zApp->logger(
                    0,
                    'TRIED CREATING POOl: %s/%s',
                    [ $dir, $key ]
                );
                $status->{$key} = 0;
            }
        }
        $result->{done} = $status;
    }
    return $result;
}

sub _do_task {
    my ( $zApp, $method, $privilege, $success, $failed ) = @_;
    my $zUser = $zApp->user() || return { code => 1 };
    my $iBBS  = $zApp->bbs()  || return { code => 1 };
    my $iRequest = $zApp->request();
    my $status   = {};

    $zUser->$privilege or return { code => 1 };
    require Zeromin::Pool;
    my $zPool = Zeromin::Pool->new( $iBBS, 0 );
    my $dir   = $iBBS->bbs();
    my @keys  = $iRequest->param('key');

    for my $key (@keys) {
        $zPool->set_key($key);
        $zPool->load();
        if ( $zPool->$method($key) ) {
            $zApp->logger( 1, "$success: %s/%s", [ $dir, $key ] );
            $status->{$key} = 1;
        }
        else {
            $zApp->logger( 0, "$failed: %s/%s", [ $dir, $key ] );
            $status->{$key} = 0;
        }
    }

    return { code => 0, done => $status };
}

1;
__END__
