#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Quotation.pm 93 2007-01-16 13:47:13Z hikarin $
#

package Img0ch::Plugin::Rewrite::Quotation;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();
    my $renderer = $iConfig->get('Renderer') || 'read.cgi';
    my $quote_replacer;

    if ( $iConfig->get_int('UseQueryString') ) {
        my $path = join( '/', ($iConfig->get('CGIServer')
            || $iConfig->get('Server') . '/test'), $renderer )
            . '?bbs=' . $iBBS->bbs() . '&key=';
        $quote_replacer = sub {
            my ( $text, $key ) = @_;
            my $url = $path . $key . '&nofirst=true';
            $$text =~ s{&gt;&gt;(\d+)-(\d+)}
                {<a href="${url}&st=$1&to=$2">>>$1-$2</a>}gxms;
            $$text =~ s{&gt;&gt;(\d+)-}
                {<a href="${url}&st=$1&to=-1">>>$1-</a>}gxms;
            $$text =~ s{&gt;&gt;(\d+)}
                {<a href="${url}&st=$1&to=$1">>>$1</a>}gxms;
            $$text =~ s{>>(\d+)}{&gt;&gt;$1}gxms;
        };
    }
    else {
        my $path = join( '/', ($iConfig->get('CGIServer')
            || $iConfig->get('Server') . '/test'), $renderer )
            . ( $iConfig->get('RendererSeparator') || '/' ) . $iBBS->bbs();
        $quote_replacer = sub {
            my ( $text, $key ) = @_;
            my $url = join '/', $path, $key;
            $$text =~ s{&gt;&gt;([\d\+\-,]+)}
                {<a href="${url}/$1n">>>$1</a>}gxms;
            $$text =~ s{>>([\d\+\-,]+)}{&gt;&gt;$1}gxms;
        };
    }
    my $quote_replacer_mobile = sub {
        my ( $text, $key ) = @_;
        $$text =~ s{&gt;&gt;([\d\+\-,]+)}
            {<a href="$1n">>>$1</a>}gxms;
        $$text =~ s{>>([\d\+\-,]+)}{&gt;&gt;$1}gxms;
    };

    bless [ $quote_replacer, $quote_replacer_mobile ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    $iObject->[0]->( $text, $key );
    return;
}

*from_read = \&from_bbs;

sub from_mobile {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    $iObject->[1]->( $text, $key );
    return;
}

1;
__END__
