#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Mobile.pm 77 2007-01-09 14:03:23Z hikarin $
#

package Img0ch::App::Mobile;

use strict;
use base qw(Img0ch::App::Read);

sub run {
    my ($iApp) = @_;
    if ($iApp->init(
            {   disable => 'DisableMobileInitPlugin',
                type    => 'mobile.init',
                mobile  => 1,
            }
        )
        )
    {
        my $filter = sub { ${ $_[0] } =~ tr/\n//d; ${ $_[0] } };
        if ( $iApp->{_param_key} ne '0000000000' ) {
            $iApp->_load_thread(
                {},
                {   filter   => $filter,
                    mobile   => 1,
                    template => 'i_read',
                    type     => 'mobile.rewrite',
                }
            );
        }
        else {
            $iApp->_load_subject($filter);
        }
    }
    else {
        $iApp->_redirect_error();
    }
}

sub _load_thread {
    my ( $iApp, $template_vars, $option ) = @_;
    my $iConfig  = $iApp->{_config};
    my $iRequest = $iApp->{_request};
    my $server   = $iConfig->get('CGIServer')
        || join('/', $iConfig->get('Server'), 'test');
    my $raw           = $iApp->{_param_raw};
    my $renderer      = $iConfig->get('MobileRenderer') || 'r.cgi';
    my $setting_saved = $iApp->get_param('mode') eq 'SET';
    my $query         = $iRequest->query()
        || $iApp->{_query_with_extend_params};
    my ( $aas_path, $aas_dir ) = $server =~ m{http://(.+?)/(.*)?}xms;

    $query = Img0ch::Kernel::escape_html_entities($query);
    $query =~ s/&amp;/&/gxms;
    $query =~ s/&?mode=SET&?//xms;
    if ( ( $aas_dir || '' ) ne '' ) {
        $aas_dir =~ s{/\z}{}xms;
        $aas_dir =~ tr|/|+|;
        $aas_path .= '+' . $aas_dir;
    }

    my $write   = rindex( $raw, 'w' ) >= 0   ? 1 : 0;
    my $setting = rindex( $raw, 'SET' ) >= 0 ? 1 : 0;
    my $is_form = $write || $setting || $setting_saved;
    my $fontsize = Img0ch::Kernel::intval( $iApp->get_param('size') ) || 3;
    %{$template_vars} = (
        'AAS' => ( rindex( $raw, 'a' ) >= 0 ? 1 : 0 ),
        'AASBase'         => $aas_path,
        'ALinkColor'      => $iApp->get_param('alink'),
        'BackGroundColor' => $iApp->get_param('bgc'),
        'BaseQueryString' => ( $setting_saved ? '' : $query ),
        'CR'              => "\r",
        'Copy'            => ( rindex( $raw, 'c' ) >= 0 ? 1 : 0 ),
        'Fontsize'        => $fontsize,
        'KEY'             => $iApp->{_param_key},
        'LinkColor'       => $iApp->get_param('link'),
        'NameByCookie'    => $iApp->get_param('FROM'),
        'MailByCookie'    => $iApp->get_param('mail'),
        'MailPostAddress' => $iConfig->get('MailPostAddress'),
        'QueryString'     => $query,
        'RCGIURI', => join( '/', $server, $renderer ),
        'SettingForm' => ( $setting and !$setting_saved ),
        'SettingSaved' => $setting_saved,
        'TextColor'    => $iApp->get_param('txt'),
        'VLinkColor'   => $iApp->get_param('vlink'),
        'Write'        => $is_form,
        'WriteForm'    => $write,
    );

    $iApp->SUPER::_load_thread( $template_vars, $option );
}

sub _load_subject {
    my ( $iApp, $filter ) = @_;
    my $iBBS     = $iApp->{_bbs};
    my $iRequest = $iApp->{_request};
    my $iSetting = $iApp->{_setting};

    require Img0ch::Subject;
    require Img0ch::Metadata;
    my $iMeta    = Img0ch::Metadata->new($iBBS);
    my $iSubject = Img0ch::Subject->new($iBBS);
    $iSubject->load();

    my $word  = $iRequest->param('s');
    my $found = [];
    if ($word) {
        my $result = $iSubject->search($word);
        map { push @$found, [ $_, @{ $result->{$_} } ] } keys %$result;
    }
    else {
        map { push @$found, [ $_, @{ $iSubject->get($_) } ] }
            @{ $iSubject->to_array() };
    }

    my $raw       = $iApp->{_param_raw};
    my $floatable = $iRequest->param_int('THREAD')
        || $iSetting->get_int('BBS_MB_THREAD_NUMBER')
        || 1;
    my $start              = Img0ch::Kernel::intval($raw) || 1;
    my $read_subject_stack = [];
    my $i                  = 1;

    for my $subject ( @$found ) {
        if ( $i >= $start and $i < $start + $floatable ) {
            push @{$read_subject_stack},
                {
                'res'     => $subject->[2],
                'key'     => $subject->[0],
                'subject' => $subject->[1],
                'index'   => $i,
                };
        }
        $i++;
    }
    my $count = @{$read_subject_stack};
    my $prev = ( $count ? $start : $iSubject->count() ) - $floatable;

    require Img0ch::Template;
    my $iTemplate = Img0ch::Template->new(
        $iBBS,
        {   file    => 'i_threads',
            setting => $iSetting,
            version => $iRequest->VERSION(),
        }
    );
    $iTemplate->param(
        {   'Banner'  => $iMeta->mobile_banner(),
            'Copy'    => ( rindex( $raw, 'c' ) >= 0 ? 1 : 0 ),
            'Count'   => $count,
            'CR'      => "\r",
            'From'    => $start + 100,
            'Next'    => $start + $floatable,
            'Prev'    => ( ( !$count or $prev > 0 ) ? $prev : 0 ),
            'Search'  => $word,
            'Threads' => $read_subject_stack,
            'Write' => ( rindex( $raw, 'w' ) >= 0 ? 1 : 0 ),
        }
    );
    $iRequest->send_http_header('text/html');
    $iTemplate->flush($filter);
}

1;
__END__
