#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Upload.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Zeromin::Upload;

use strict;
use base qw(Img0ch::Upload);

sub freeze {
    my ($zUpload) = @_;
    my $path = $zUpload->path();
    if ( -d $path ) {
        chmod 0700, $path;
    }
    return 1;
}

sub release {
    my ($zUpload) = @_;
    my $path = $zUpload->path();
    if ( -d $path ) {
        chmod 0755, $path;
    }
    return 1;
}

sub remove {
    my ( $zUpload, $resno ) = @_;
    my $iRepos = $zUpload->{_rs};
    my ( $bbs, $key ) = ( $zUpload->{_dir}, $zUpload->{_key} );
    my $prefix_top = "I:U:I.${bbs}.${key}";

    my $iKernel = $zUpload->{_kernel};
    if ($resno) {
        ( ref $resno || '' ) eq 'ARRAY' or $resno = [$resno];
        my $removed = 0;

        for my $i (@$resno) {
            $i = Img0ch::Kernel::intval($i);
            my $prefix    = join '.', $prefix_top, $i;
            my $extension = $iRepos->remove("${prefix}.extension");
            my $path      = $zUpload->path( $i, $extension );
            if ( -w $path and -f $path ) {
                unlink $path or $iKernel->throw_io_exception($path);
                $iRepos->remove("${prefix}.width");
                $iRepos->remove("${prefix}.height");
                $iRepos->remove("${prefix}.hash");
                $iRepos->remove("${prefix}.download.pass");
                $iRepos->remove("${prefix}.remove.pass");
                $removed++;
            }
        }

        $iRepos->save();
        return $removed;
    }
    else {
        my $path = $zUpload->path();
        if ( -d $path ) {
            local ( $!, *DH );
            opendir *DH, $path
                or $iKernel->throw_io_exception($path);
            my @uploaded_files = readdir *DH;
            closedir *DH or $iKernel->throw_io_exception($path);

            for my $uploaded_file (@uploaded_files) {
                $uploaded_file =~ /\At?(\d+)\.[\w\.]+\z/xms or next;
                my $i                  = $1;
                my $prefix             = join '.', $prefix_top, $i;
                my $uploaded_file_path = join '/', $path, $uploaded_file;
                if ( -w $uploaded_file_path ) {
                    unlink $uploaded_file_path
                        or $iKernel->throw_io_exception($uploaded_file_path);
                    $iRepos->remove("${prefix}.extension");
                    $iRepos->remove("${prefix}.width");
                    $iRepos->remove("${prefix}.height");
                    $iRepos->remove("${prefix}.hash");
                    $iRepos->remove("${prefix}.download.pass");
                    $iRepos->remove("${prefix}.remove.pass");
                }
            }

            $iRepos->save();
            rmdir $path or $iKernel->throw_io_exception($path);
            return 1;
        }
        else {
            return 0;
        }
    }

    return 1;
}

sub repair {
    my ($zUpload) = @_;
    my $iKernel = $zUpload->{_kernel};

    require File::Basename;
    my $path = $zUpload->path();
    -d $path or return 0;
    local ( $!, *DH );

    opendir *DH, $path or $iKernel->throw_io_exception($path);
    my @file_list = readdir *DH;
    require File::Spec;
    my @files = map { File::Spec->catfile( $path, $_ ) } @file_list;
    closedir *DH or $iKernel->throw_io_exception($path);

    my $iRepos = $zUpload->{_rs};
    my ( $bbs, $key ) = ( $zUpload->{_dir}, $zUpload->{_key} );
    my $prefix_top = "I:U:I.${bbs}.${key}";
    foreach my $file (@files) {
        next if $file =~ /\.cgi\z/xms or $file =~ /\.s?pch\z/xms;
        next if $file !~ m{/(\d+)\.(\w+)\z}xms;
        my $resno     = $1 || next;
        my $extension = $2 || next;
        my ( $width, $height ) = $zUpload->get_dimensions($file);
        my $hash = $zUpload->get_digest($file);
        my $prefix = join '.', $prefix_top, $resno;
        $iRepos->set( "${prefix}.extension", $extension );
        $iRepos->set( "${prefix}.width",     $width );
        $iRepos->set( "${prefix}.height",    $height );
        $iRepos->set( "${prefix}.hash",      $hash );
    }

    $iRepos->save();
    return 1;
}

1;
__END__
