#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Remove.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Img0ch::Plugin::Upload::Remove;

use strict;
use Zeromin::Upload;

sub new {
    my ( $iClass, $iBBS, $key ) = @_;
    my $zUpload = Zeromin::Upload->new( $iBBS, $key );
    bless { __upload => $zUpload }, $iClass;
}

*at_replace_res = \&__remove;

*at_erase_res = \&__remove;

*at_remove_file = \&__remove;

sub at_remove_thread {
    my ( $iObject, $plugin_id, $key ) = @_;
    $iObject->{__upload}->remove();
}

sub __remove {
    my ( $iObject, $resno ) = @_;
    $iObject->{__upload}->remove($resno);
}

1;
__END__
