#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: GoogleVideo.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Img0ch::Plugin::Rewrite::StreamService::GoogleVideo;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();

    bless [ ( $iConfig->get_int('googlevideo.width') || 425 ),
            ( $iConfig->get_int('googlevideo.height') || 350 ),
    ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my ( $width, $height ) = ( $iObject->[0], $iObject->[1] );

    $$text =~ s{
        (?:<a\s+href=")?
        http://w?w?w?\.?video\.google\.com/videoplay\?docid=([\d\-]+)
        (?:".+?>)?
        }
        {<object width="${width}" height="${height}">
           <param name="movie"
             value="http://video.google.com/googleplayer.swf?docId=$1&hl=en"
           />
           <embed
             src="http://video.google.com/googleplayer.swf?docId=$1&hl=en"
             type="application/x-shockwave-flash"
             width="${width}" height="${height}"
           />
        </object><br />
        }gxms;
    return;
}

*from_read = \&from_bbs;

1;
__END__
