Zeromin.Ugroup = function(id, bbs, key) {
    this.bbsID    = id  || 0;
    this.bbsDir   = bbs || '';
    this.cache = [];
    this.index = {};
}

Zeromin.Ugroup.prototype = {
    "getID": function () { return this.bbsID },
    "getBBS": function () { return this.bbsDir },
    "getCache": function () { return this.cache; },
    "setCache": function (cache, add) {
        add ? this.cache.push(cache) : this.cache = cache;
        return this;
    },
    "setIndex": function (key, i) {
        this.index[key] = i || this.cache.length - 1;
    },
    "removeCache": function (data) {
        var count = 0;
        for ( var removedID in data ) {
            if ( !data[removedID] ) continue;
            var i = this.index[removedID];
            if ( i ) {
                delete this.index[removedID];
                this.cache.splice(i, 1);
                count++;
            }
        }
        return count;
    },
    "setBBS": function (id, bbs) {
        this.bbsID  = id;
        this.bbsDir = bbs;
        return this;
    },
    "get": function(id) {
        var cache = this.cache;
        var i     = this.index[id];
        return i ? cache[i]
            : { "id":    "",
                "count": 0,
                "name":  "",
                "bbs":   0,
                "privilege": {
                    "plugin":   0,
                    "cap":      0,
                    "archive":  0,
                    "subject":  0,
                    "setting":  0,
                    "meta":     0,
                    "res":      0,
                    "thread":   0,
                    "view":     0,
                    "pool":     0,
                    "user":     0,
                    "bbs":      0,
                    "category": 0,
                    "control":  0
                }
        }
    },
    "getName": function (id) {
/*
        console.log(this.cache);
        console.log(this.index);
        console.log(id);
        console.log(this.get(id));
*/
        return this.get(id).name;
    },
    "load": function (entriesByPage) {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load"),
            function (storage) {
                var data = storage.read() || [];
                var root = document.getElementById("userGroupRoot");
                var ls   = $(document.getElementById("userGroupTable")).empty();
                var zBBS = Zeromin.getBBS();
                $("ul.nav-page", root).remove();
                for ( var i in data ) {
                    var item   = data[i];
                    var id     = item.id;
                    var tdBase = document.createElement("td");
                    tdBase.appendChild(
                        $(document.createElement("input")).attr({
                            "type" : "checkbox",
                            "name" : "id",
                            "value": id
                        }).get(0)
                    );
                    var lnk = $(document.createElement('a'));
                    lnk.href("javascript:Zeromin.getUgroup().setBBS("
                        + self.getID() + ",\"" + self.getBBS()
                        + "\").editForm(\"" + id + "\")");
                    lnk.append(document.createTextNode(item.name));
                    var tdName = document.createElement("td");
                    tdName.appendChild(lnk.get(0));
                    var tdRange = document.createElement("td");
                    tdRange.appendChild(
                        document.createTextNode(
                            zBBS.getName(item.bbs) || "全ての掲示板"
                        )
                    );
                    var tdBelongs = document.createElement("td");
                    tdBelongs.appendChild(
                        document.createTextNode(String(item.count))
                    );
                    var trBase = document.createElement("tr");
                    trBase.appendChild(tdBase);
                    trBase.appendChild(tdName);
                    trBase.appendChild(tdRange);
                    trBase.appendChild(tdBelongs);
                    ls.append(trBase);
                    self.setIndex(id, i);
                }
                Zeromin.DOM.makePager(ls.parent(),
                    (Zeromin.intval(entriesByPage) || 15));
                Zeromin.DOM.renderLeftMenu("leftUgroupMenu");
                Zeromin.DOM.toggleMenu("global");
                Zeromin.DOM.setFunction("USER GROUP - list");
                Zeromin.DOM.statusOK("ユーザーグループ一覧を表示しました", 1000);
                $(".Container", document).hide();
                $(root).show();
            },
            this
        );
    },
    "save": function () {
        var self   = this;
        var param  = this.toComplicatedParam("save",
                         document.getElementById("userGroupForm"));
        var ugroup = Zeromin.DOM.deserialize(param);
        Zeromin.getIO().load(
            param,
            function (storage) {
                var message;
                if ( storage.isReturnedSuccess() ) {
                    var id = storage.get("id");
                    if ( id != null ) {
                        message = "ユーザーグループを作成しました";
                    }
                    else {
                        id = ugroup.id;
                        var removeFrom = new Object();
                        removeFrom[id] = true;
                        self.removeCache(removeFrom);
                        message = "ユーザーグループを編集しました";
                    }
                    self.setCache({
                        "id":    id,
                        "count": 0,
                        "name":  ugroup.name,
                        "bbs":   ugroup.bbs,
                        "privilege": {
                            "plugin":   ugroup.plugin_priv,
                            "cap":      ugroup.cap_priv,
                            "archive":  ugroup.archive_priv,
                            "subject":  ugroup.subject_priv,
                            "setting":  ugroup.setting_priv,
                            "meta":     ugroup.meta_priv,
                            "res":      ugroup.res_priv,
                            "thread":   ugroup.thread_priv,
                            "view":     ugroup.view_priv,
                            "pool":     ugroup.pool_priv,
                            "user":     ugroup.user_priv,
                            "bbs":      ugroup.bbs_priv,
                            "category": ugroup.category_priv,
                            "control":  ugroup.control_priv
                        }
                    }, true);
                    self.setIndex(id);
                }
                storage.writeStatus(
                    message, {
                        "2":  "ユーザーグループ名がありません",
                        "10": "存在しないユーザーグループのため、保存出来ません"
                    }
                );
            },
            null
        );
    },
    "remove": function () {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("remove", document.getElementById("userGroupTable")),
            function (storage) {
                var removed = storage.get("removed");
                if ( removed == null ) {
                    Zeromin.DOM.statusOK("指定された処理は実行されませんでした");
                    return;
                }
                else {
                    self.removeCache(removed);
                    storage.writeStatus("指定されたユーザーグループを削除しました");
                }
            },
            null
        );
    },
    "renderSelectBox": function () {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load"),
            function (storage) {
                var data = storage.read();
                if ( data.length == 0 ) return;
                var sel = $("select.ugroupSelect").empty();
                for ( var i in data ) {
                    var item  = data[i];
                    var opt   = document.createElement("option");
                    opt.value = item.id;
                    opt.appendChild(document.createTextNode(item.name));
                    sel.append(opt);
                }
                Zeromin.DOM.hideState();
            },
            this
        );
    },
    "editForm": function(id) {
        var item = this.get(id);
        var root = document.getElementById("userGroupForm");
        this.render("edit");
        Zeromin.DOM.fillForm(root, item, {
            "radio-callback": function ( item, element ) {
                var v = $.grep(item["bbs"], function (i) { return i == 0 });
                element.checked |= (v.length && element.value == 1);
            },
            "select-multiple-callback": function ( item, element ) {
                var nm  = element.name;
                var val = item[ nm ];
                if ( nm == "bbs" ) {
                    var opt = element.options;
                    var len = opt.length;
                    for ( var i = 0; i < len; i++ ) {
                        var o = opt[i];
                        var v = o.value;
                        o.selected
                            = $.grep(val,
                                function (i) { return i == v }).length
                            ? true : false;
                    }
                }
                else if ( nm == "privilege" ) {
                    var map = {
                        "user":     "User",
                        "cap":      "Cap",
                        "bbs":      "BBS",
                        "setting":  "Setting",
                        "thread":   "Thread",
                        "pool":     "Pool",
                        "archive":  "Archive",
                        "res":      "Res",
                        "meta":     "Meta",
                        "control":  "Control",
                        "category": "Category",
                        "view":     "View",
                        "plugin":   "Plugin"
                    };
                    for ( var i in val ) {
                        var priv_id   = "optgroup#ugroupPrivilege" + map[i];
                        var priv_bit  = val[i];
                        $(priv_id).find("option").each(function () {
                            this.selected =
                                (this.value & priv_bit ? true : false);
                        });
                    }
                }
            }
        });
    },
    "render": function(renderType) {
        Zeromin.getBBS().renderSelectBox();
        Zeromin.DOM.renderLeftMenu("leftUgroupMenu");
        Zeromin.DOM.toggleMenu("global");
        $(".Container", document).hide();
        switch (renderType) {
            case "create":
            default:
            var uf = document.getElementById("userGroupForm");
            Zeromin.DOM.resetForm(uf);
            Zeromin.DOM.setFunction("USER GROUP - create");
            break;
            case "edit":
            Zeromin.DOM.setFunction("USER GROUP - edit");
            break;
        }
        $(document.getElementById("userGroupForm")).show();
    },
    "toComplicatedParam": function(meth, query) {
        var a = [];
        var range_all = false;
        $("input,select", query).each(function () {
            var type = this.type;
            if ( type == "text" || type == "hidden" ) {
                a.push({
                    "name":  this.name,
                    "value": this.value
                });
            }
            else if ( type == "radio" ) {
                if ( this.checked && this.value == 1 ) {
                    a.push({ "name":  "bbs", "value": "0" });
                    range_all = true;
                }
            }
            else if ( type == "select-multiple" ) {
                var optgrp = $("optgroup", this);
                if ( optgrp.length > 0 ) {
                    optgrp.each(function () {
                        var privilege_name = this.id.replace(
                            "ugroupPrivilege", ""
                        ).toLowerCase() + "_priv";
                        var privilege_value = 0;
                        $("option:selected", this).each(function () {
                            privilege_value += Zeromin.intval(this.value);
                        });
                        a.push({
                            "name":  privilege_name,
                            "value": privilege_value
                        });
                    });
                }
                else {
                    if ( range_all ) return;
                    var name = this.name;
                    $("option:selected", this).each(function () {
                        a.push({
                            "name":  name,
                            "value": this.value
                        });
                    });
                }
            }
        });
        a.push({ "name": "C",    "value": "user"  });
        a.push({ "name": "M",    "value": meth    });
        a.push({ "name": "type", "value": "group" });
        return a;
    },
    "toParam": function (meth, query) {
        var a = (query != null) ? $(query).fastSerialize() : [];
        a.push({ "name": "C",    "value": "user"  });
        a.push({ "name": "M",    "value": meth    });
        a.push({ "name": "type", "value": "group" });
        return a;
    },
    "toString": function() { return "" }
};
