Zeromin.Metadata = function(bbs, metaId) {
    this.id     = metaId;
    this.bbsId  = bbs.getID();
    this.bbsDir = bbs.getBBS();
    this.cache  = null;
    this.map    = {
        "1": {
            "key": "head",
            "value": "ローカルルール"
        },
        "2": {
            "key": "meta",
            "value": "メタデータ"
        },
        "3": {
            "key": "foot",
            "value": "フッター"
        }
    };
}

Zeromin.Metadata.prototype = {
    "getID": function () { return this.id },
    "setID": function (id) {
        if ( this.id != id ) {
            this.id    = id;
            this.cache = null;
        }
    },
    "getCache": function () { return this.cache; },
    "setCache": function (cache) {
        this.cache = cache;
        return this;
    },
    "getBBS": function() { return this.bbsDir },
    "setBBS": function (id, bbs) {
        if ( this.bbsDir != bbs ) {
            this.bbsId  = id;
            this.bbsDir = bbs;
        }
        return this;
    },
    "load": function () {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load", null),
            function (storage) {
                var data = storage.slurp();
                if ( data == null ) {
                    return null;
                }
                var id = self.id;
                switch ( id ) {
                    case 1:
                    default:
                    $("table", document.getElementById("mainBanner")
                    ).html(data).parent().show();
                    break;
                    case 3:
                    $("table", document.getElementById("mainBanner")
                    ).html(data).parent().show();
                    break;
                }
                $(document.getElementById("metadataContent")).val(data);
                Zeromin.DOM.renderLeftMenu("leftMetaBBSLocalMenu");
                Zeromin.DOM.toggleMenu("bbs");
                Zeromin.DOM.setFunction("METADATA - list");
                Zeromin.DOM.statusOK(
                    self.map[id].value + "を表示しました",
                    1000
                );
                $(document.getElementById("metadataId")).val(id);
                $(".Container", document).hide();
                $(document.getElementById("metadataRoot")).show();
            },
            this
        );
    },
    "save": function () {
        var self = this;
        var root = document.getElementById("metadataRoot");
        Zeromin.getIO().load(
            this.toParam("save", root),
            function (storage) {
                storage.writeStatus(
                    self.map[self.id].value + "を更新しました",
                    {}
                );
            },
            null
        );
    },
    "toParam": function (meth, query) {
        var a   = (query != null) ? $(query).fastSerialize() : [];
        var map = this.map[this.id];
        var key = map ? map.key : '';
        a.push({ "name": "C",   "value": "bbs" });
        a.push({ "name": "M",   "value": meth });
        a.push({ "name": "bbs", "value": this.bbsId });
        a.push({ "name": "type", "value": key });
        return a;
    },
    "toString": function () { this.map[this.bbsID] }
};
