if ( typeof Zeromin.Log == "undefined" ) {
    Zeromin.Log = {};
}

Zeromin.Log.Thread = function(bbs) {
    this.bbsID  = bbs.getID();
    this.bbsDir = bbs.getBBS();
    this.loaded = false;
}

Zeromin.Log.Thread.prototype = {
    "getID": function () { this.bbsID },
    "getBBS": function () { this.bbsDir },
    "getCache": function () {},
    "setCache": function (cache) {},
    "setBBS": function (id, bbs) {
        if ( this.bbsDir != bbs ) {
            this.bbsID        = id;
            this.bbsDir       = bbs;
        }
        return this;
    },
    "load": function (entriesByPage) {
        var self = this;
        Zeromin.getIO().load(
            [
                { "name" : "C",    "value": "log"      },
                { "name" : "M",    "value": "load"     },
                { "name" : "type", "value": "thread"   },
                { "name" : "bbs",  "value": this.bbsID }
            ],
            function (storage) {
                var data = storage.read() || [];
                var root = document.getElementById("logThreadRoot");
                var ls   = $(document.getElementById("logThreadTable")).empty();
                $("ul.nav-page", root).remove();
                for ( var i in data ) {
                    var item    = data[i];
                    var tdIP = document.createElement("td");
                    tdIP.appendChild(
                        document.createTextNode(item.ip)
                    );
                    var tdIPGroup = document.createElement("td");
                    tdIPGroup.appendChild(
                        document.createTextNode(item.ip_group)
                    );
                    var tdDate = document.createElement("td");
                    tdDate.appendChild(
                        document.createTextNode(Zeromin.getDate(item.atime))
                    );
                    var trBase = document.createElement("tr");
                    trBase.appendChild(tdIP);
                    trBase.appendChild(tdIPGroup);
                    trBase.appendChild(tdDate);
                    ls.append(trBase);
                    self.loaded = true;
                }
                Zeromin.DOM.makePager(ls.parent(),
                    (Zeromin.intval(entriesByPage) || 15));
                Zeromin.DOM.toggleMenu("bbs");
                Zeromin.DOM.renderLeftMenu("leftBBSLogMenu");
                Zeromin.DOM.setFunction(
                    "Log - Thread - " + Zeromin.getBBS().getName()
                );
                Zeromin.DOM.statusOK("スレッド作成ログ一覧を表示しました", 1000);
                $(".Container", document).hide();
                $(root).show();
            },
            this
        );
    },
    "render": function() {
    },
    "toString": function() { return this.getBBS() }
};
