Zeromin.Banner = function(id) {
    this.bbsID = id;
    this.cache = null;
}

Zeromin.Banner.prototype = {
    "getID": function () { return this.bbsID },
    "getCache": function () { return this.cache; },
    "setCache": function (cache) {
        this.cache = cache;
        return this;
    },
    "load": function () {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load", null, this.bbsID),
            function (storage) {
                var data = storage.slurp();
                if ( data == null ) {
                    return null;
                }
                var id   = self.id;
                switch ( id ) {
                    case 1:
                    default:
                    $("table", document.getElementById("mainBanner")
                    ).html(data).parent().show();
                    break;
                    case 3:
                    $("table", document.getElementById("mainBanner")
                    ).html(data).parent().show();
                    break;
                }
                $(document.getElementById("bannerContent")).val(data);
                Zeromin.DOM.renderLeftMenu("leftMetaGlobalMenu");
                Zeromin.DOM.toggleMenu("global");
                Zeromin.DOM.setFunction("BANNER - list");
                Zeromin.DOM.statusOK("告知欄一覧を表示しました", 1000);
                $(document.getElementById("bannerId")).val(id);
                $(".Container", document).hide();
                $(document.getElementById("bannerRoot")).show();
            },
            this
        );
    },
    "save": function () {
        var self = this;
        var root = document.getElementById("bannerRoot");
        Zeromin.getIO().load(
            this.toParam("save", root),
            function (storage) {
                storage.writeStatus("告知欄を更新しました", {});
            },
            null
        );
    },
    "toParam": function (meth, query, bannerId) {
        var a = (query != null) ? $(query).fastSerialize() : [];
        if ( bannerId ) a.push({ "name": "id", "value": bannerId });
        a.push({ "name": "C", "value": "banner" });
        a.push({ "name": "M", "value": meth });
        return a;
    },
    "toString": function () { this.bbsID }
};
