﻿<?xml version="1.0" encoding="utf-8" ?>
<!--/**************************************************************/
/*                        im_note001m v1.00                       */
/* Copyright (c) 2007 Noriyuki KIKUCHI                            */
/* <http://www.i-approach.com>                                    */
/* MIT Style License                                              */
/******************************************************************/
/*                                                                */
/* MIT style license:                                             */
/* http://en.wikipedia.org/wiki/MIT_License                       */
/*                                                                */
/******************************************************************/-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" encoding="utf-8" indent="yes"/>
<xsl:template match="/">
	<html lang="ja">
	<head><title><xsl:value-of select="xn/title" /></title>
	<style  type="text/css">
	.hideblack {  color:black; background-color: black}
	.hidegray {  color:black; background-color: #CCCCCC}
	.hidered {  color:black; background-color: #FF66FF}
	.hideblue {  color:black; background-color: #33CCFF}
	.hidegreen {  color:black; background-color: #33FF33}
<!-- -->
	div {
	margin: 0px 0px 12px 0px;
	line-height: 120%;
	width: 97%
	}
	hr {
	color: #EAEAEA;
	width: 97%;}
	#xn {
	font-size: x-small;
	text-align: right;
	}
	</style>
	</head>
	<body bgcolor="ffffff" leftmargin="10" topmargin="10">
		<p><xsl:value-of select="xn/title" /></p>
		<hr />
		<br />
		<xsl:apply-templates select="xn" />
		<br />
		<br />
		<hr />
	<div id="xn"><A HREF="http://www.i-approach.com/" target="_blank">iMASK</A>?</div>
	</body>
	</html>
	</xsl:template>
<!-- -->
	<xsl:template match="xn" >
		<xsl:for-each select="unit" >
			<xsl:if test="par[not(.='')]" >
		 		<xsl:apply-templates select="par" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
<!-- -->
	<xsl:template match="par">
		<div><p><xsl:value-of select="par" />
		<xsl:apply-templates />
		</p></div>
	</xsl:template>
<!-- -->
	<xsl:template match="hide[@color='black']">
	<font class="hideblack"  onclick="this.style.background='white'"><xsl:apply-templates /></font>
	</xsl:template>
	<xsl:template match="hide[@color='gray']">
	<font class="hidegray"  onclick="this.style.background='white'"><xsl:apply-templates /></font>
	</xsl:template>
	<xsl:template match="hide[@color='blue']">
	<font class="hideblue"  onclick="this.style.background='white'"><xsl:apply-templates /></font>
	</xsl:template>
	<xsl:template match="hide[@color='red']">
	<font class="hidered"  onclick="this.style.background='white'"><xsl:apply-templates /></font>
	</xsl:template>
	<xsl:template match="hide[@color='green']">
	<font class="hidegreen"  onclick="this.style.background='white'"><xsl:apply-templates /></font>
	</xsl:template>
	<xsl:template match="br">
	<br />
	</xsl:template>
	<xsl:template match="b">
	<b><xsl:apply-templates /></b>
	</xsl:template>
	<xsl:template match="u">
	<u><xsl:apply-templates /></u>
	</xsl:template>
</xsl:stylesheet>
<!-- (C)2007 i-approach.com -->
