/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imageviewer;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ThumbnailImage
extends JButton {
    private File file;
    private static final String FOLDER = "jp/sourceforge/imageviewer/resource/FolderIcon.png";
    private static final String NO_SUPPORT = "jp/sourceforge/imageviewer/resource/NoSupport.png";
    private static ImageIcon FOLDER_ICON = null;
    private static ImageIcon NO_SUPPORT_ICON = null;
    static ImageIcon checker = new ImageIcon();

    ThumbnailImage(File file, int size) {
        super(ThumbnailImage.getIcon(file, size));
        this.file = file;
        this.setToolTipText(file.toString());
        FOLDER_ICON = ThumbnailImage.getFolderIcon(size);
        NO_SUPPORT_ICON = ThumbnailImage.getNoSupportIcon(size);
    }

    static ImageIcon getFolderIcon(int size) {
        if (FOLDER_ICON == null) {
            FOLDER_ICON = ThumbnailImage.getIcon(Thread.currentThread().getContextClassLoader().getResource(FOLDER), size);
        }
        return FOLDER_ICON;
    }

    static ImageIcon getNoSupportIcon(int size) {
        if (NO_SUPPORT_ICON == null) {
            NO_SUPPORT_ICON = ThumbnailImage.getIcon(Thread.currentThread().getContextClassLoader().getResource(NO_SUPPORT), size);
        }
        return NO_SUPPORT_ICON;
    }

    static ImageIcon getIcon(URL url, int size) {
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        return ThumbnailImage.getIcon(image, size);
    }

    static ImageIcon getIcon(File file, int size) {
        if (file.isDirectory()) {
            return ThumbnailImage.getFolderIcon(size);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        return ThumbnailImage.getIcon(image, size);
    }

    static ImageIcon getIcon(Image image, int size) {
        checker.setImage(image);
        ImageIcon icon = null;
        if (checker.getIconHeight() < 0) {
            icon = ThumbnailImage.getNoSupportIcon(size);
        } else {
            int height = checker.getIconHeight();
            int width = checker.getIconWidth();
            if (height <= size && width <= size) {
                icon = new ImageIcon(image);
            } else {
                int iconWidth = 0;
                int iconHeight = 0;
                if (height < width) {
                    iconWidth = size;
                    iconHeight = height * size / width;
                } else {
                    iconWidth = width * size / height;
                    iconHeight = size;
                }
                icon = new ImageIcon(image.getScaledInstance(iconWidth, iconHeight, 1));
            }
        }
        image.flush();
        return icon;
    }

    public File getFile() {
        return this.file;
    }
}

