<?php

/*
 * ILUKA
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ꥢ륵
 *
 * $RCSfile$
 * $Revision$
 * $Date$
 **********************************************************/
include("../initial");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibiluka");

/********************************************************
Хѿ
*********************************************************/
$health_check = array("HTTP_GET", "SSL_GET", "TCP_CHECK", "SMTP_CHECK", "MISC_CHECK");

/********************************************************
ƥڡ
*********************************************************/

define("OPERATION", "Configuration virtual_server");
define("TMPLFILE", "iluka_lb_rsconf.tmpl");

/*********************************************************
 * conf_rsfile
 *
 * ꥢ륵եԽ
 *
 * []
 *       $post               Ϥ줿
 *       $vsiport            С륵ФIP_PORT
 *       $rsiport            ꥢ륵ФIP_PORT
 * [֤]
 *       TRUE                 
 *       FALSE                ۾  
 **********************************************************/
function conf_rsfile ($post,$vsiport, $rsiport)
{

    global $msgarr;
    global $err_msg;
    global $log_msg;
    global $web_conf;

    $rsdir      = $web_conf["iluka"]["keepalivedbasedir"]."virtual_server/$vsiport/";
    $rsfile     = $rsdir.$rsiport.".conf";

    /* ե뤬¸ߤ뤫γǧ */
    if (!file_exists($rsfile)) {
        $err_msg = sprintf($msgarr['28086'][SCREEN_MSG], $rsfile);
        $log_msg = sprintf($msgarr['28086'][LOG_MSG], $rsfile);
        return FALSE;
    }

    if (replace_tmpls($post, $conftmpl) === FALSE) {
        return FALSE;
    }

    if (make_rsconf($rsdir, $rsfile, $conftmpl) === FALSE) {
        $err_msg = sprintf($msgarr['28086'][SCREEN_MSG], $rsfile);
        $log_msg = sprintf($msgarr['28086'][LOG_MSG], $rsfile);
        return FALSE;
    }

    return TRUE;
}

/***********************************************************
 * change_tag_rsconf
 *
 * ݻƤη
 *
 * []
 *        $data              ݻ
 * [֤]
 *        $tag                ݻ줿
 **********************************************************/
function change_tag_rsconf ($data)
{
    global $health_check;

    $tag["<<IPADDRESS>>"]          = escape_html($data["ipaddress"]);
    $tag["<<PORT>>"]               = escape_html($data["port"]);
    $tag["<<RSIPADDRESS>>"]        = escape_html($data["rs_ipaddress"]);
    $tag["<<RSPORT>>"]             = escape_html($data["rs_port"]);
    $tag["<<WEIGHT>>"]             = escape_html($data["weight"]);
    $tag["<<PATH>>"]               = escape_html($data["path"]);
    $tag["<<DIGEST>>"]             = escape_html($data["digest"]);
    $tag["<<STATUS_CODE>>"]        = escape_html($data["status_code"]);
    $tag["<<NB_GET_RETRY>>"]       = escape_html($data["nb_get_retry"]);
    $tag["<<DELAY_BEFORE_RETRY>>"] = escape_html($data["delay_before_retry"]);
    $tag["<<CONNECT_IP>>"]         = escape_html($data["connect_ip"]);
    $tag["<<CONNECT_PORT>>"]       = escape_html($data["connect_port"]);
    $tag["<<BINDTO>>"]             = escape_html($data["bindto"]);
    $tag["<<BIND_PORT>>"]          = escape_html($data["bind_port"]);
    $tag["<<CONNECT_TIMEOUT>>"]    = escape_html($data["connect_timeout"]);
    $tag["<<RETRY>>"]              = escape_html($data["retry"]);
    $tag["<<HELO_NAME>>"]          = escape_html($data["helo_name"]);
    $tag["<<MISC_PATH>>"]          = escape_html($data["misc_path"]);
    $tag["<<MISC_TIMEOUT>>"]       = escape_html($data["misc_timeout"]);

    $tag["<<H_CHECK>>"] = "";
    foreach($health_check as $key => $value) {
        if ($data["h_check"] == $key) {
            $tag["<<H_CHECK>>"] .= "<option value=\"$key\" selected>".$value."</option>\n";
        } else {
            $tag["<<H_CHECK>>"] .= "<option value=\"$key\">".$value."</option>\n";
        }
    }

    return $tag;
}

/***********************************************************
 * rsconf_hold_tag
 *
 * 顼Ƥݻ
 *
 * []
 *        $post               Ϥ줿
 * [֤]
 *        $tag                ݻ줿
 **********************************************************/
function rsconf_hold_tag ($post)
{
    global $health_check;

    $tag["<<IPADDRESS>>"]          = escape_html($post["ipaddress"]);
    $tag["<<PORT>>"]               = escape_html($post["port"]);
    $tag["<<RSIPADDRESS>>"]        = escape_html($post["rs_ipaddress"]);
    $tag["<<RSPORT>>"]             = escape_html($post["rs_port"]);
    $tag["<<WEIGHT>>"]             = escape_html($post["weighting"]);
    $tag["<<HELO_NAME>>"]          = escape_html($post["helo_name"]);
    $tag["<<MISC_PATH>>"]          = escape_html($post["misc_path"]);
    $tag["<<MISC_TIMEOUT>>"]       = escape_html($post["misc_timeout"]);
    $tag["<<PATH>>"]               = escape_html($post["http_path"]);
    $tag["<<DIGEST>>"]             = escape_html($post["http_digest"]);
    $tag["<<STATUS_CODE>>"]        = escape_html($post["http_status_code"]);
    $tag["<<NB_GET_RETRY>>"]       = escape_html($post["nb_get_retry"]);
    $tag["<<RETRY>>"]              = escape_html($post["get_retry"]);

    if ($post["h_check"] == 0 || $post["h_check"] == 1 || $post["h_check"] == 4) {
        $connect_ipaddress         = $post["http_connect_ipaddress"];
        $connect_port              = $post["http_connect_port"];
        $connect_source_ipaddress  = $post["http_connect_source_ipaddress"];
        $connect_source_port       = $post["http_connect_source_port"];
        $connect_timeout           = $post["http_connect_timeout"];
        $delay_before_retry        = $post["http_delay_retry"];
    } elseif ($post["h_check"] == 2) {
        $connect_ipaddress         = $post["tcp_connect_ipaddress"];
        $connect_port              = $post["tcp_connect_port"];
        $connect_source_ipaddress  = $post["tcp_connect_source_ipaddress"];
        $connect_source_port       = $post["tcp_connect_source_port"];
        $connect_timeout           = $post["tcp_connect_timeout"];
        $delay_before_retry        = $post["http_delay_retry"];
    } elseif ($post["h_check"] == 3) {
        $connect_ipaddress         = $post["smtp_connect_ipaddress"];
        $connect_port              = $post["smtp_connect_port"];
        $connect_source_ipaddress  = $post["smtp_connect_source_ipaddress"];
        $connect_source_port       = $post["smtp_connect_source_port"];
        $connect_timeout           = $post["smtp_connect_timeout"];
        $delay_before_retry        = $post["smtp_delay_retry"];
    }

    $tag["<<CONNECT_IP>>"]         = escape_html($connect_ipaddress);
    $tag["<<CONNECT_PORT>>"]       = escape_html($connect_port);
    $tag["<<BINDTO>>"]             = escape_html($connect_source_ipaddress);
    $tag["<<BIND_PORT>>"]          = escape_html($connect_source_port);
    $tag["<<CONNECT_TIMEOUT>>"]    = escape_html($connect_timeout);
    $tag["<<DELAY_BEFORE_RETRY>>"] = escape_html($delay_before_retry);

    /* selectedդ */
    $tag["<<H_CHECK>>"] = "";
    foreach($health_check as $key => $value) {
        if ($post["h_check"] == $key) {
            $tag["<<H_CHECK>>"] .= "<option value=\"$key\" selected>".$value."</option>\n";
        } else {
            $tag["<<H_CHECK>>"] .= "<option value=\"$key\">".$value."</option>\n";
        }
    }

    return $tag;
}

/***********************************************************
 * 
 **********************************************************/
/* ե롢ִեɹåå */
$ret = init();
if ($ret === FALSE) {
    syserr_display();
    exit (1);
}

/* С륵Ф¸ߤ뤫γǧ */
$result = check_vs_exists($_POST);
if ($result === 1) {
    err_location("index.php?e=1");
    exit(1);
} elseif ($result === 2) {
    result_log(OPERATION . ":NG:" . $log_msg, LOG_ERR);
    dgp_location("index.php", $err_msg);
    exit(0);
}


/* ꥢ륵Ф¸ߤ뤫γǧ */
$result = check_rs_exists($_POST);
if ($result === 1) {
    err_location("index.php?e=1");
    exit(1);
} elseif ($result === 2) {
    result_log(OPERATION . ":NG:" . $log_msg, LOG_ERR);
    dgp_location("index.php", $err_msg);
    exit(0);
}

/* tmpl */
$tmpl_list = array("../../../../tmpl/iluka/http_get.tmpl",
                   "../../../../tmpl/iluka/ssl_get.tmpl",
                   "../../../../tmpl/iluka/tcp_check.tmpl",
                   "../../../../tmpl/iluka/smtp_check.tmpl",
                   "../../../../tmpl/iluka/misc_check.tmpl");

$reload_result = "";
/***********************************************************
 * main
 **********************************************************/
if (isset($_POST["update"])) {
    if (rsconf_check_form($_POST)) {

        $vsiport    = $_POST["ipaddress"]."_".$_POST["port"];
        $rsiport    = $_POST["rs_ipaddress"]."_".$_POST["rs_port"];

        $lock_fh = lock_file();
        if ($lock_fh === FALSE) {
            result_log(OPERATION . ":NG:" . $log_msg, LOG_ERR);
            syserr_display();
            exit(0);
        }

        $result = conf_rsfile($_POST, $vsiport, $rsiport);
        if ($result === TRUE) {
            $reload_result = rsconf_reload_status($_POST, $vsiport, $rsiport);
            if ($reload_result === FALSE) {
                result_log(OPERATION . ":NG:" . $log_msg, LOG_ERR);
            }
        }

        $result = unlock_file($lock_fh);
        if ($result === FALSE) {
            result_log(OPERATION . ":NG:" . $log_msg, LOG_ERR);
            syserr_display();
            exit(0);
        }

        if ($reload_result === TRUE) {
            $sesskey = $_POST["sk"];
            $msg = "ꥢ륵 ".$_POST["rs_ipaddress"]." ".$_POST["rs_port"]." 򹹿ޤ";
            $post = array("ipaddress" => $_POST["ipaddress"],
                          "port"      => $_POST["port"]);
            iluka_location("rslist.php", $msg, $post);
            exit(0);
        }
    }
    $tag = rsconf_hold_tag($_POST);

} elseif (isset($_POST["cancel"])) {
    $sesskey = $_POST["sk"];
    $msg = ""; 
    $post = array("ipaddress"   => $_POST["ipaddress"],
                  "port"        => $_POST["port"],
                  "rs_ipaddress" => $_POST["rs_ipaddress"],
                  "rs_port"      => $_POST["rs_port"]);
    iluka_location("rslist.php",$msg, $post);
    exit(0);

/* ɽ */
} else {
    if (get_rsconf($_POST, $data) === FALSE) {
        result_log($log_msg, LOG_ERR);
        dgp_location("../", $err_msg);
        exit(0);
    }
    $tag = change_tag_rsconf($data);
}

/***********************************************************
 * ɽ
 **********************************************************/

/*   */
set_tag_common($tag);

/* ڡν */
$ret = display(TMPLFILE, $tag, array(), "", "");
if ($ret === FALSE) {
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
}

?>
