/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.batch;

import com.google.gdata.data.batch.IBatchStatus;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ServiceException;

public class BatchStatus
extends Element
implements IBatchStatus {
    public static final ElementKey<String, BatchStatus> KEY = ElementKey.of(new QName(Namespaces.batchNs, "status"), String.class, BatchStatus.class);
    public static final AttributeKey<Integer> CODE = AttributeKey.of(new QName("code"), Integer.class);
    public static final AttributeKey<ContentType> CONTENT_TYPE = AttributeKey.of(new QName("content-type"), ContentType.class);
    public static final AttributeKey<String> REASON = AttributeKey.of(new QName("reason"));

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY).setContentRequired(false);
        builder.addAttribute(CODE).setRequired(true);
        builder.addAttribute(CONTENT_TYPE);
        builder.addAttribute(REASON).setRequired(true);
    }

    public static BatchStatus createSuccessStatus() {
        BatchStatus status = new BatchStatus();
        status.setCode(200);
        status.setReason("Success");
        return status;
    }

    public static BatchStatus createCreatedStatus() {
        BatchStatus status = new BatchStatus();
        status.setCode(201);
        status.setReason("Created");
        return status;
    }

    public BatchStatus() {
        super(KEY);
    }

    public BatchStatus(ServiceException e) {
        this();
        int code = e.getHttpErrorCodeOverride();
        if (code == -1) {
            code = 500;
        }
        this.setCode(code);
        this.setReason(e.getMessage());
        this.setContentType(e.getResponseContentType());
        this.setContent(e.getResponseBody());
    }

    public int getCode() {
        Integer code = this.getAttributeValue(CODE);
        return code == null ? 0 : code;
    }

    public BatchStatus setCode(Integer code) {
        this.setAttributeValue(CODE, (Object)code);
        return this;
    }

    public boolean hasCode() {
        return this.getCode() != 0;
    }

    public String getContent() {
        return this.getTextValue(KEY);
    }

    public BatchStatus setContent(String content) {
        this.setTextValue(content);
        return this;
    }

    public boolean hasContent() {
        return this.hasTextValue();
    }

    public ContentType getContentType() {
        return this.getAttributeValue(CONTENT_TYPE);
    }

    public BatchStatus setContentType(ContentType contentType) {
        this.setAttributeValue(CONTENT_TYPE, (Object)(contentType == null ? null : new ContentType(contentType.getMediaType())));
        return this;
    }

    public boolean hasContentType() {
        return this.getContentType() != null;
    }

    public String getReason() {
        return this.getAttributeValue(REASON);
    }

    public BatchStatus setReason(String reason) {
        this.setAttributeValue(REASON, (Object)reason);
        return this;
    }

    public boolean hasReason() {
        return this.getReason() != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BatchStatus other = (BatchStatus)obj;
        return BatchStatus.eq(this.getCode(), other.getCode()) && BatchStatus.eq(this.getContent(), other.getContent()) && BatchStatus.eq(this.getContentType(), other.getContentType()) && BatchStatus.eq(this.getReason(), other.getReason());
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 37 * result + this.getCode();
        if (this.getContent() != null) {
            result = 37 * result + this.getContent().hashCode();
        }
        if (this.getContentType() != null) {
            result = 37 * result + this.getContentType().hashCode();
        }
        if (this.getReason() != null) {
            result = 37 * result + this.getReason().hashCode();
        }
        return result;
    }

    public String toString() {
        return "{BatchStatus code=" + this.getAttributeValue(CODE) + " content=" + this.getTextValue() + " contentType=" + this.getAttributeValue(CONTENT_TYPE) + " reason=" + this.getAttributeValue(REASON) + "}";
    }
}

