/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.AttributeMetadataRegistry;
import com.google.gdata.model.AttributeMetadataRegistryBuilder;
import com.google.gdata.model.AttributeTransform;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementMetadataRegistry;
import com.google.gdata.model.ElementMetadataRegistryBuilder;
import com.google.gdata.model.ElementTransform;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.Transform;
import com.google.gdata.util.common.base.Preconditions;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Schema {
    private final Map<RootKey, ElementMetadataRegistry> elements;
    private final Map<RootKey, AttributeMetadataRegistry> attributes;

    public static MetadataRegistry builder() {
        return new MetadataRegistry();
    }

    static RootKey getRootKey(ElementKey<?, ?> key) {
        return RootKey.get(key);
    }

    static RootKey getRootKey(AttributeKey<?> key) {
        return RootKey.get(key);
    }

    Schema(MetadataRegistry registry) {
        this.elements = Schema.buildElements(registry, this);
        this.attributes = Schema.buildAttributes(registry, this);
    }

    private static ImmutableMap<RootKey, AttributeMetadataRegistry> buildAttributes(MetadataRegistry registry, Schema schema) {
        ImmutableMap.Builder<RootKey, AttributeMetadataRegistry> attributeBuilder = ImmutableMap.builder();
        for (Map.Entry<RootKey, AttributeMetadataRegistryBuilder> entry : registry.getAttributes().entrySet()) {
            attributeBuilder.put(entry.getKey(), entry.getValue().create(schema));
        }
        return attributeBuilder.build();
    }

    private static ImmutableMap<RootKey, ElementMetadataRegistry> buildElements(MetadataRegistry registry, Schema schema) {
        ImmutableMap.Builder<RootKey, ElementMetadataRegistry> elementBuilder = ImmutableMap.builder();
        for (Map.Entry<RootKey, ElementMetadataRegistryBuilder> entry : registry.getElements().entrySet()) {
            elementBuilder.put(entry.getKey(), entry.getValue().create(schema));
        }
        return elementBuilder.build();
    }

    public <D, E extends Element> ElementMetadata<D, E> bind(ElementKey<D, E> key) {
        return this.bind(null, key, null);
    }

    public <D, E extends Element> ElementMetadata<D, E> bind(ElementKey<D, E> key, MetadataContext context) {
        return this.bind(null, key, context);
    }

    public <D, E extends Element> ElementMetadata<D, E> bind(ElementKey<?, ?> parent, ElementKey<D, E> child) {
        return this.bind(parent, child, null);
    }

    public <D, E extends Element> ElementMetadata<D, E> bind(ElementKey<?, ?> parent, ElementKey<D, E> child, MetadataContext context) {
        ElementMetadataRegistry childRegistry = this.getElement(child);
        return childRegistry == null ? null : childRegistry.bind(parent, child, context);
    }

    Transform getTransform(ElementKey<?, ?> parent, MetadataKey<?> key, MetadataContext context) {
        if (key instanceof AttributeKey) {
            return this.getTransform(parent, (AttributeKey)key, context);
        }
        return this.getTransform(parent, (ElementKey)key, context);
    }

    AttributeTransform getTransform(ElementKey<?, ?> parent, AttributeKey<?> attribute, MetadataContext context) {
        AttributeMetadataRegistry attributeRegistry = this.getAttribute(attribute);
        return attributeRegistry == null ? null : attributeRegistry.getTransform(parent, attribute, context);
    }

    ElementTransform getTransform(ElementKey<?, ?> parent, ElementKey<?, ?> child, MetadataContext context) {
        ElementMetadataRegistry childRegistry = this.getElement(child);
        return childRegistry == null ? null : childRegistry.getTransform(parent, child, context);
    }

    private ElementMetadataRegistry getElement(ElementKey<?, ?> key) {
        return this.elements.get(Schema.getRootKey(key));
    }

    public <D> AttributeMetadata<D> bind(ElementKey<?, ?> parent, AttributeKey<D> attribute) {
        return this.bind(parent, attribute, null);
    }

    public <D> AttributeMetadata<D> bind(ElementKey<?, ?> parent, AttributeKey<D> attribute, MetadataContext context) {
        AttributeMetadataRegistry attRegistry = this.getAttribute(attribute);
        return attRegistry == null ? null : attRegistry.bind(parent, attribute, context);
    }

    private AttributeMetadataRegistry getAttribute(AttributeKey<?> key) {
        return this.attributes.get(Schema.getRootKey(key));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RootKey {
        private final QName id;
        private final Class<?> type;

        private static RootKey get(ElementKey<?, ?> key) {
            QName id = key.getId();
            Class<Object> elementType = key.getElementType();
            if (elementType != Element.class) {
                Class<? extends Element> superClass = RootKey.getSuper(elementType);
                while (superClass != Element.class) {
                    elementType = superClass;
                    superClass = RootKey.getSuper(elementType);
                }
                return new RootKey(elementType);
            }
            return new RootKey(RootKey.getRootId(id));
        }

        private static RootKey get(AttributeKey<?> key) {
            return new RootKey(RootKey.getRootId(key.getId()));
        }

        private static QName getRootId(QName id) {
            if (id.getNs() != null && !"*".equals(id.getLocalName())) {
                return new QName(id.getNs(), "*");
            }
            return id;
        }

        private static Class<? extends Element> getSuper(Class<? extends Element> type) {
            return type.getSuperclass().asSubclass(Element.class);
        }

        private RootKey(QName id) {
            Preconditions.checkNotNull(id);
            this.id = id;
            this.type = null;
        }

        private RootKey(Class<?> type) {
            Preconditions.checkNotNull(type);
            this.id = null;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RootKey)) {
                return false;
            }
            RootKey other = (RootKey)obj;
            if (this.type != null) {
                return this.type == other.type;
            }
            return this.id.equals(other.id);
        }

        public int hashCode() {
            if (this.type != null) {
                return this.type.hashCode();
            }
            return this.id.hashCode();
        }

        public String toString() {
            return this.type == null ? "{Root (" + this.id + ")}" : "{Root (" + this.type + ")}";
        }
    }
}

