/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.QName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementUtil {
    ElementUtil() {
    }

    static <K extends MetadataKey<?>> K findKey(ElementMetadata<?, ?> meta, QName id, Map<QName, K> keyMap) {
        return ElementUtil.findKey(new MetadataBinder(meta), id, keyMap);
    }

    static <K extends MetadataKey<?>> K findKey(KeyBinder binder, QName id, Map<QName, K> keyMap) {
        if (keyMap.isEmpty()) {
            return null;
        }
        MetadataKey key = (MetadataKey)keyMap.get(id);
        if (key != null) {
            return (K)key;
        }
        if (id.matchesAnyNamespace()) {
            for (Map.Entry<QName, K> mapEntry : keyMap.entrySet()) {
                Metadata<?> keyMetadata;
                QName keyId = mapEntry.getKey();
                if (!id.matches(keyId) && !keyId.matchesAnyLocalName() || !(keyMetadata = binder.bind(key = (MetadataKey)mapEntry.getValue())).isVisible()) continue;
                if (key.getId().matchesAnyLocalName()) {
                    return (K)ElementUtil.makeKey(new QName(key.getId().getNs(), id.getLocalName()), key);
                }
                if (!id.matches(keyMetadata.getName())) continue;
                return (K)key;
            }
        } else if (!id.matchesAnyLocalName() && (key = (MetadataKey)keyMap.get(ElementUtil.toWildcardLocalName(id))) != null) {
            return (K)ElementUtil.makeKey(id, key);
        }
        return null;
    }

    private static QName toWildcardLocalName(QName id) {
        return new QName(id.getNs(), "*");
    }

    private static <K extends MetadataKey<?>> K makeKey(QName id, K key) {
        if (key instanceof AttributeKey) {
            return (K)AttributeKey.of(id, key.getDatatype());
        }
        return (K)ElementKey.of(id, key.getDatatype(), ((ElementKey)key).getElementType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetadataBinder
    implements KeyBinder {
        private final ElementMetadata<?, ?> metadata;

        MetadataBinder(ElementMetadata<?, ?> metadata) {
            this.metadata = metadata;
        }

        @Override
        public Metadata<?> bind(MetadataKey<?> key) {
            if (key instanceof AttributeKey) {
                return this.metadata.bindAttribute((AttributeKey)key);
            }
            return this.metadata.bindElement((ElementKey)key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface KeyBinder {
        public Metadata<?> bind(MetadataKey<?> var1);
    }
}

