/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.ClientLoginAccountType;
import com.google.gdata.client.CookieManager;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.client.Query;
import com.google.gdata.client.Service;
import com.google.gdata.client.SimpleCookieManager;
import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.batch.BatchInterruptedException;
import com.google.gdata.client.http.GoogleGDataRequest;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.RedirectRequiredException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleService
extends Service
implements AuthTokenFactory.TokenListener {
    private AuthTokenFactory authTokenFactory;
    private CookieManager cookieManager;

    public GoogleService(String serviceName, String applicationName) {
        this(serviceName, applicationName, "https", "www.google.com");
    }

    public GoogleService(String serviceName, String applicationName, String protocol, String domainName) {
        this.requestFactory = new GoogleGDataRequest.Factory();
        this.authTokenFactory = new GoogleAuthTokenFactory(serviceName, applicationName, protocol, domainName, this);
        this.cookieManager = new SimpleCookieManager();
        this.initRequestFactory(applicationName);
    }

    public GoogleService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        this.requestFactory = requestFactory;
        this.authTokenFactory = authTokenFactory;
        this.cookieManager = new SimpleCookieManager();
        this.initRequestFactory(applicationName);
    }

    private void initRequestFactory(String applicationName) {
        if (applicationName != null) {
            this.requestFactory.setHeader("User-Agent", applicationName + " " + this.getServiceVersion());
        } else {
            this.requestFactory.setHeader("User-Agent", this.getServiceVersion());
        }
    }

    public AuthTokenFactory getAuthTokenFactory() {
        return this.authTokenFactory;
    }

    public void setAuthTokenFactory(AuthTokenFactory authTokenFactory) {
        this.authTokenFactory = authTokenFactory;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    @Override
    public void tokenChanged(AuthTokenFactory.AuthToken newToken) {
        if (this.cookieManager != null) {
            this.cookieManager.clearCookies();
        }
        this.requestFactory.setAuthToken(newToken);
    }

    public void setUserCredentials(String username, String password) throws AuthenticationException {
        this.setUserCredentials(username, password, ClientLoginAccountType.HOSTED_OR_GOOGLE);
    }

    public void setUserCredentials(String username, String password, ClientLoginAccountType accountType) throws AuthenticationException {
        this.setUserCredentials(username, password, null, null, accountType);
    }

    public void setUserCredentials(String username, String password, String captchaToken, String captchaAnswer) throws AuthenticationException {
        this.setUserCredentials(username, password, captchaToken, captchaAnswer, ClientLoginAccountType.HOSTED_OR_GOOGLE);
    }

    public void setUserCredentials(String username, String password, String captchaToken, String captchaAnswer, ClientLoginAccountType accountType) throws AuthenticationException {
        GoogleAuthTokenFactory googleAuthTokenFactory = this.getGoogleAuthTokenFactory();
        googleAuthTokenFactory.setUserCredentials(username, password, captchaToken, captchaAnswer, accountType);
        this.requestFactory.setAuthToken(this.authTokenFactory.getAuthToken());
    }

    public void setUserToken(String token) {
        GoogleAuthTokenFactory googleAuthTokenFactory = this.getGoogleAuthTokenFactory();
        googleAuthTokenFactory.setUserToken(token);
        this.requestFactory.setAuthToken(this.authTokenFactory.getAuthToken());
    }

    public void setOAuthCredentials(OAuthParameters parameters, OAuthSigner signer) throws OAuthException {
        GoogleAuthTokenFactory googleAuthTokenFactory = this.getGoogleAuthTokenFactory();
        googleAuthTokenFactory.setOAuthCredentials(parameters, signer);
        this.requestFactory.setAuthToken(this.authTokenFactory.getAuthToken());
    }

    public void setAuthSubToken(String token) {
        this.setAuthSubToken(token, null);
    }

    public void setAuthSubToken(String token, PrivateKey key) {
        GoogleAuthTokenFactory googleAuthTokenFactory = this.getGoogleAuthTokenFactory();
        googleAuthTokenFactory.setAuthSubToken(token, key);
        this.requestFactory.setAuthToken(this.authTokenFactory.getAuthToken());
    }

    public String getAuthToken(String username, String password, String captchaToken, String captchaAnswer, String serviceName, String applicationName) throws AuthenticationException {
        GoogleAuthTokenFactory googleAuthTokenFactory = this.getGoogleAuthTokenFactory();
        return googleAuthTokenFactory.getAuthToken(username, password, captchaToken, captchaAnswer, serviceName, applicationName);
    }

    public static String makePostRequest(URL url, Map<String, String> parameters) throws IOException {
        return GoogleAuthTokenFactory.makePostRequest(url, parameters);
    }

    public void setHandlesCookies(boolean handlesCookies) {
        if (this.cookieManager == null) {
            if (handlesCookies) {
                throw new IllegalArgumentException("No cookie manager defined");
            }
            return;
        }
        this.cookieManager.setCookiesEnabled(handlesCookies);
    }

    public boolean handlesCookies() {
        if (this.cookieManager == null) {
            return false;
        }
        return this.cookieManager.cookiesEnabled();
    }

    public void addCookie(GoogleGDataRequest.GoogleCookie cookie) {
        if (this.cookieManager != null) {
            this.cookieManager.addCookie(cookie);
        }
    }

    public Set<GoogleGDataRequest.GoogleCookie> getCookies() {
        if (this.cookieManager == null) {
            throw new IllegalArgumentException("No cookie manager defined");
        }
        return this.cookieManager.getCookies();
    }

    @Override
    public Service.GDataRequest createRequest(Service.GDataRequest.RequestType type, URL requestUrl, ContentType contentType) throws IOException, ServiceException {
        Service.GDataRequest request = super.createRequest(type, requestUrl, contentType);
        if (request instanceof GoogleGDataRequest) {
            ((GoogleGDataRequest)request).setService(this);
        }
        return request;
    }

    @Override
    protected Service.GDataRequest createRequest(Query query, ContentType contentType) throws IOException, ServiceException {
        Service.GDataRequest request = super.createRequest(query, contentType);
        if (request instanceof GoogleGDataRequest) {
            ((GoogleGDataRequest)request).setService(this);
        }
        return request;
    }

    @Override
    public <E extends IEntry> E getEntry(URL entryUrl, Class<E> entryClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        try {
            return super.getEntry(entryUrl, entryClass, ifModifiedSince);
        }
        catch (RedirectRequiredException e) {
            entryUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.getEntry(entryUrl, entryClass, ifModifiedSince);
    }

    @Override
    public <E extends IEntry> E getEntry(URL entryUrl, Class<E> entryClass, String etag) throws IOException, ServiceException {
        try {
            return super.getEntry(entryUrl, entryClass, etag);
        }
        catch (RedirectRequiredException e) {
            entryUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.getEntry(entryUrl, entryClass, etag);
    }

    @Override
    public <E extends IEntry> E update(URL entryUrl, E entry) throws IOException, ServiceException {
        try {
            return super.update(entryUrl, entry);
        }
        catch (RedirectRequiredException e) {
            entryUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.update(entryUrl, entry);
    }

    @Override
    public <E extends IEntry> E insert(URL feedUrl, E entry) throws IOException, ServiceException {
        try {
            return super.insert(feedUrl, entry);
        }
        catch (RedirectRequiredException e) {
            feedUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.insert(feedUrl, entry);
    }

    @Override
    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        try {
            return super.getFeed(feedUrl, feedClass, ifModifiedSince);
        }
        catch (RedirectRequiredException e) {
            feedUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.getFeed(feedUrl, feedClass, ifModifiedSince);
    }

    @Override
    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass, String etag) throws IOException, ServiceException {
        try {
            return super.getFeed(feedUrl, feedClass, etag);
        }
        catch (RedirectRequiredException e) {
            feedUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.getFeed(feedUrl, feedClass, etag);
    }

    @Override
    public <F extends IFeed> F getFeed(Query query, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        try {
            return super.getFeed(query, feedClass, ifModifiedSince);
        }
        catch (RedirectRequiredException e) {
            query = new Query(this.handleRedirectException(e));
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.getFeed(query, feedClass, ifModifiedSince);
    }

    @Override
    public <F extends IFeed> F getFeed(Query query, Class<F> feedClass, String etag) throws IOException, ServiceException {
        try {
            return super.getFeed(query, feedClass, etag);
        }
        catch (RedirectRequiredException e) {
            query = new Query(this.handleRedirectException(e));
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.getFeed(query, feedClass, etag);
    }

    @Override
    public void delete(URL entryUrl) throws IOException, ServiceException {
        try {
            super.delete(entryUrl);
            return;
        }
        catch (RedirectRequiredException e) {
            entryUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        super.delete(entryUrl);
    }

    @Override
    public void delete(URL entryUrl, String etag) throws IOException, ServiceException {
        try {
            super.delete(entryUrl, etag);
            return;
        }
        catch (RedirectRequiredException e) {
            entryUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        super.delete(entryUrl, etag);
    }

    protected URL handleRedirectException(RedirectRequiredException redirect) throws ServiceException {
        try {
            return new URL(redirect.getRedirectLocation());
        }
        catch (MalformedURLException e) {
            ServiceException se = new ServiceException(CoreErrorDomain.ERR.invalidRedirectedToUrl);
            se.setInternalReason("Invalid redirected-to URL - " + redirect.getRedirectLocation());
            throw se;
        }
    }

    protected void handleSessionExpiredException(SessionExpiredException e) throws ServiceException {
        this.authTokenFactory.handleSessionExpiredException(e);
    }

    @Override
    public <F extends IFeed> F batch(URL feedUrl, F inputFeed) throws IOException, ServiceException, BatchInterruptedException {
        try {
            return super.batch(feedUrl, inputFeed);
        }
        catch (RedirectRequiredException e) {
            feedUrl = this.handleRedirectException(e);
        }
        catch (SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return super.batch(feedUrl, inputFeed);
    }

    private GoogleAuthTokenFactory getGoogleAuthTokenFactory() {
        if (!(this.authTokenFactory instanceof GoogleAuthTokenFactory)) {
            throw new IllegalStateException("Invalid authentication token factory");
        }
        return (GoogleAuthTokenFactory)this.authTokenFactory;
    }

    public static class SessionExpiredException
    extends AuthenticationException {
        public SessionExpiredException(String message) {
            super(message);
        }
    }

    public static class CaptchaRequiredException
    extends AuthenticationException {
        private String captchaUrl;
        private String captchaToken;

        public CaptchaRequiredException(String message, String captchaUrl, String captchaToken) {
            super(message);
            this.captchaToken = captchaToken;
            this.captchaUrl = captchaUrl;
        }

        public String getCaptchaToken() {
            return this.captchaToken;
        }

        public String getCaptchaUrl() {
            return this.captchaUrl;
        }
    }

    public static class ServiceUnavailableException
    extends AuthenticationException {
        public ServiceUnavailableException(String message) {
            super(message);
        }
    }

    public static class TermsNotAgreedException
    extends AuthenticationException {
        public TermsNotAgreedException(String message) {
            super(message);
        }
    }

    public static class NotVerifiedException
    extends AuthenticationException {
        public NotVerifiedException(String message) {
            super(message);
        }
    }

    public static class AccountDisabledException
    extends AuthenticationException {
        public AccountDisabledException(String message) {
            super(message);
        }
    }

    public static class AccountDeletedException
    extends AuthenticationException {
        public AccountDeletedException(String message) {
            super(message);
        }
    }

    public static class InvalidCredentialsException
    extends AuthenticationException {
        public InvalidCredentialsException(String message) {
            super(message);
        }
    }
}

