/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.bridge.XBridge;
import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

final class ProxyFactory {
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASH_CODE;
    private static final Method METHOD_TO_STRING;
    private static final Method METHOD_QUERY_INTERFACE;
    private static final Method METHOD_IS_SAME;
    private static final Method METHOD_GET_OID;
    private static final Object debugCountLock;
    private static int debugCount;
    private final RequestHandler requestHandler;
    private final XBridge bridge;

    public ProxyFactory(RequestHandler requestHandler, XBridge xBridge) {
        this.requestHandler = requestHandler;
        this.bridge = xBridge;
    }

    public Object create(String string, Type type) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ProxyFactory.class$("com.sun.star.lib.uno.Proxy"), ProxyFactory.class$("com.sun.star.uno.IQueryInterface"), type.getZClass()}, (InvocationHandler)new Handler(this, string, type));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean isProxy(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            return invocationHandler instanceof Handler && ((Handler)invocationHandler).matches(this);
        }
        return false;
    }

    public static XBridge getBridge(Object object) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof Handler) {
            return ((Handler)invocationHandler).getBridge();
        }
        return null;
    }

    static int getDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            try {
                int n = debugCount;
                Object var2_2 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    private static void incrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            try {
                ++debugCount;
            }
            finally {
                Object var1_1 = null;
            }
            return;
        }
    }

    private static void decrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            try {
                --debugCount;
            }
            finally {
                Object var1_1 = null;
            }
            return;
        }
    }

    static {
        try {
            METHOD_EQUALS = ProxyFactory.class$("java.lang.Object").getMethod("equals", ProxyFactory.class$("java.lang.Object"));
            METHOD_HASH_CODE = ProxyFactory.class$("java.lang.Object").getMethod("hashCode", null);
            METHOD_TO_STRING = ProxyFactory.class$("java.lang.Object").getMethod("toString", null);
            METHOD_QUERY_INTERFACE = ProxyFactory.class$("com.sun.star.uno.IQueryInterface").getMethod("queryInterface", ProxyFactory.class$("com.sun.star.uno.Type"));
            METHOD_IS_SAME = ProxyFactory.class$("com.sun.star.uno.IQueryInterface").getMethod("isSame", ProxyFactory.class$("java.lang.Object"));
            METHOD_GET_OID = ProxyFactory.class$("com.sun.star.uno.IQueryInterface").getMethod("getOid", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
        debugCountLock = new Object();
        debugCount = 0;
    }

    private final class Handler
    implements InvocationHandler {
        private /* synthetic */ ProxyFactory this$0;
        private final String oid;
        private final Type type;

        public Handler(ProxyFactory proxyFactory, String string, Type type) {
            this.this$0 = proxyFactory;
            this.oid = string;
            this.type = type;
            ProxyFactory.incrementDebugCount();
        }

        public boolean matches(ProxyFactory proxyFactory) {
            return this.this$0 == proxyFactory;
        }

        public XBridge getBridge() {
            return this.this$0.bridge;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.equals(METHOD_EQUALS) || method.equals(METHOD_IS_SAME)) {
                return new Boolean(objectArray[0] != null && this.oid.equals(UnoRuntime.generateOid(objectArray[0])));
            }
            if (method.equals(METHOD_HASH_CODE)) {
                return new Integer(this.oid.hashCode());
            }
            if (method.equals(METHOD_TO_STRING)) {
                return "[Proxy:" + System.identityHashCode(object) + "," + this.oid + "," + this.type + "]";
            }
            if (method.equals(METHOD_QUERY_INTERFACE)) {
                if (objectArray[0].equals(this.type)) {
                    return object;
                }
                return this.request("queryInterface", objectArray);
            }
            if (method.equals(METHOD_GET_OID)) {
                return this.oid;
            }
            return this.request(method.getName(), objectArray);
        }

        protected void finalize() throws Throwable {
            try {
                this.request("release", null);
            }
            finally {
                Object var1_1 = null;
                ProxyFactory.decrementDebugCount();
            }
        }

        private Object request(String string, Object[] objectArray) throws Throwable {
            return this.this$0.requestHandler.sendRequest(this.oid, this.type, string, objectArray);
        }
    }
}

