/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkutils.h,v 1.3.2.8 2003/02/12 11:30:15 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKUTILS_H
#define HAVE_SKKUTILS_H
#include <glib.h>

/* String */

gint skk_utils_strlen (const gchar *str);
gint skk_utils_charbytes (const gchar *str);
gint skk_utils_charbytes_nth (const gchar *str, guint nth);
gint skk_utils_charbytes_nth_all (const gchar *str, guint nth);
gint skk_utils_last_charbytes (const gchar *str);
gint skk_utils_last_charbytes_nth_all (const gchar *str, guint nth);
gboolean skk_utils_is_kana (const gchar *str);
gboolean skk_utils_is_hiragana (const gchar *str);
gboolean skk_utils_is_katakana (const gchar *str);
gboolean skk_utils_is_halfwidth_katakana (const gchar *str);
gchar* skk_utils_get_char (const gchar *str, gboolean with_dakuon);
gchar* skk_utils_remove_char_nth (const gchar *str, guint nth);
gchar* skk_utils_escape_char (const gchar *str);

/* List */
void skk_utils_list_free (GList *list, gboolean need_free, GFunc func, gpointer user_data);
GList* skk_utils_list_merge_string (GList *list, GList *list2, gboolean need_free);
gchar* skk_utils_list_to_string_all (GList *list, gchar *delim);

/* SList */
void skk_utils_slist_free (GSList *list, gboolean need_free, GFunc func, gpointer user_data);

/* Convert */
gchar* skk_utils_utf8_to_eucjp (const gchar *str);
#endif /* HAVE_SKKUTILS_H */
