/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkfunction.h,v 1.1.2.6 2003/04/14 23:34:43 famao Exp $ */

/* vi:set ts=4 sw=4: */

#ifndef HAVE_SKK_FUNCTION_H
#define HAVE_SKK_FUNCTION_H

#include <glib.h>
#include "skkbuffer.h"
#include "skkfunctionmap.h"

typedef gint (*SkkFunctionCallback)(SkkBuffer *buf, SkkFunctionMapItem *item, gpointer user_data);

typedef struct _SkkFunction SkkFunction;

struct _SkkFunction {
	guint ref_count;
	SkkFunctionMap *map;
	GHashTable *function_table;
};

SkkFunction *skk_function_new (SkkFunctionMap *map);
void skk_function_clear (SkkFunction *func);
void skk_function_destroy (SkkFunction *func);

void skk_function_add_function (SkkFunction *func, const gchar *name, SkkFunctionCallback callback, gpointer user_data);

gint skk_function_do_function (SkkFunction *func, SkkBuffer *buf, guint ch, guint mask);

#endif
