/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkcannadictimpl.c,v 1.1.2.6 2003/02/17 23:29:35 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <string.h>
#include <stdio.h>
#include "skkqueryimpl.h"
#include "skkcannadictimpl.h"
#include "skktypes.h"

#define CANNA_COMMIT_STRING_BUFSIZE	(8192 * 2)
#define EUC_JP_SS2 0x8E
#define EUC_JP_SS3 0x8F
#define CANNA_NEXT_CHAR(p)      \
  (((*p) == 0) ? (p) :          \
      (((*p) < 0x80) ? ((p) + 1) :     \
	       (((*p) == EUC_JP_SS3) ? ((p) + 3) : \
			     ((p) + 2))))
#define CANNA_GUIDELINE_DELIMITER_P(p)  \
	  (((*p) == ' ') || ((*p) == '\t') ||   \
	      (((*p) == 0xA1) && ((p[1]) == 0xA1)))


static SkkQueryFunctionImpl *get_new (SkkQuery *query);
static GList *do_query (SkkQueryFunctionImpl *impl, const gchar *buf, const gchar *okuri, gint *found_num);
static void destroy (SkkQueryFunctionImpl *impl);
static gchar *get_info (void);
static gint get_type (void);

static gint context_id = 1;
static SkkQueryFunctionImpl dictimpl = {
	get_new,
	NULL,
	NULL,
	NULL,
	do_query,
	NULL,
	NULL,
	destroy,
	get_info,
	get_type,
	NULL,
	NULL,
};

/*
 * Taken from CannaLE
 */
static void
parse_guideline (jrKanjiStatus *pks, int *pnum, unsigned char ***psegs, int **pnb, int *pcurrent)
{
#if 1
    char linestr[1024];
#endif
    unsigned char *str = pks->gline.line;
    unsigned char *p, *st;
    int i, idx, tot, delimiterp;

    tot = 0;
    for (p = str, st = NULL;*p;p = CANNA_NEXT_CHAR(p)) {
    delimiterp = CANNA_GUIDELINE_DELIMITER_P(p);
    if (st && delimiterp) {
        tot++;
        st = NULL;
    }else if (!st && !delimiterp) {
        st = p;
    }
    }
    *pnum = tot;
    *pcurrent = 0;
    *psegs = (unsigned char**) malloc(sizeof(unsigned char*) * tot * 2);
    *pnb = (int*) malloc(sizeof(int) * tot * 2);
    for (p = str, i = 0, idx = 0, st = NULL;
     (idx < tot);p = CANNA_NEXT_CHAR(p)) {
    delimiterp = CANNA_GUIDELINE_DELIMITER_P(p);
    if (st && delimiterp) {
        /* the size of the value */
        (*pnb)[i] = (p - st);
        i++;
        idx++;
        st = NULL;
    }else if (!st && !delimiterp) {
        /* label */
        (*psegs)[i] = st = p;
        (*pnb)[i] = CANNA_NEXT_CHAR(p) - p;
        i++;
        if (pks->gline.revPos == (p - str))
        *pcurrent = idx;
        /* value */
        (*psegs)[i] = CANNA_NEXT_CHAR(p);
    }
    }
#if 1
	for (i = 0; i < (tot * 2); i++) {
    memcpy(linestr, (*psegs)[i], (*pnb)[i]);
    linestr[(*pnb)[i]] = '\0';
    fprintf(stderr, "Seg(%d):%s\n", i, linestr);
    }
#endif
}

static SkkQueryFunctionImpl *
get_new (SkkQuery *query)
{
	SkkCannaDictImpl *impl;
	jrKanjiStatus *pks;
	impl = g_new0 (SkkCannaDictImpl, 1);
	pks = g_new0 (jrKanjiStatus, 1);
	impl->impl = dictimpl;
	impl->context_id = context_id;
	context_id++;
	jrKanjiControl(impl->context_id, KC_INITIALIZE, NULL);
	jrKanjiControl(impl->context_id, KC_SETAPPNAME, "iiimf-skk");
	impl->ksv.ks = pks;
	impl->ksv.buffer = g_new0 (guchar, CANNA_COMMIT_STRING_BUFSIZE);
	impl->ksv.bytes_buffer = CANNA_COMMIT_STRING_BUFSIZE;
	impl->ksv.val = CANNA_MODE_HenkanMode;
	jrKanjiControl (impl->context_id, KC_CHANGEMODE, (char *) &(impl->ksv));
	return (SkkQueryFunctionImpl *) impl;
}

static GList *
do_query (SkkQueryFunctionImpl *impl, const gchar *buf, const gchar *okuri, gint *found_num)
{
	GList *ret = NULL;
	SkkCannaDictImpl *d = (SkkCannaDictImpl *)impl;
	jrKanjiStatusWithValue *pksv = &(d->ksv);
	jrKanjiStatus *pks = d->ksv.ks;
	int n = 0,size;
	char retbuf[CANNA_COMMIT_STRING_BUFSIZE + 1];
	gchar *echoStr = g_strdup (buf);
	gchar *firstval = NULL;
	size = CANNA_COMMIT_STRING_BUFSIZE;
	pks->echoStr = echoStr;
	pks->revPos = 0;
	pks->revLen = strlen (buf);
	pks->length = strlen (buf);
	jrKanjiControl (d->context_id, KC_STOREYOMI, (char*)pksv);
	n = jrKanjiString (d->context_id, ' ', retbuf, size, pks);
	firstval = g_strdup (pks->echoStr);
	ret = g_list_append (ret, (gpointer) skk_dict_item_new_with_value (firstval, NULL));
	g_free (echoStr);
	while (TRUE) {
		n = jrKanjiString (d->context_id, ' ', retbuf, size, pks);
		if (pks->echoStr) {
			if (!strcmp (firstval, pks->echoStr)) {
				break;
			}
			g_list_append (ret, (gpointer) skk_dict_item_new_with_value (pks->echoStr, NULL));
		}
	}
	g_free (firstval);


#if 0	
	n = jrKanjiString (d->context_id, ' ', retbuf, size, pks);
	retbuf[n] = '\0';
	if (n > 0) {
		g_message ("n %d buf %s", n, retbuf);
		ret = g_list_append (ret, (gpointer) skk_dict_item_new_with_value (retbuf, NULL));
		jrKanjiControl (d->context_id, KC_KILL, (char*)pksv);
		if (found_num)
			*found_num = 1;
		return ret;
	}
	if (pks->info & KanjiGLineInfo) {
		if (pks->gline.length > 0) {
			int num, i, cid;
			unsigned char **ps;
			int *segs;
			gchar *val;
			parse_guideline (pks, &num, &ps, &segs, &cid);
			for (cid = 0, i = 0; i < num; i++) {
				cid++;
				g_message ("%s %d", ps[cid], segs[cid]);
				val = g_strndup (ps[cid], segs[cid] - 2);
				ret = g_list_append (ret, (gpointer) skk_dict_item_new_with_value (val, NULL));
				g_free (val);
				cid++;
			}
			g_free (ps);
			g_free (segs);
		}
	}
#endif	
	jrKanjiControl (d->context_id, KC_KILL, (char *)pksv);
	if (found_num)
		*found_num = g_list_length (ret);
	return ret;
}

static void
destroy (SkkQueryFunctionImpl *impl)
{
	SkkCannaDictImpl *d = (SkkCannaDictImpl *)impl;
	jrKanjiControl (d->context_id, KC_FINALIZE, NULL);
	g_free (d->ksv.buffer);
	g_free (d->ksv.ks);
	g_free (d);
	return;
}

static gint
get_type (void)
{
	return SKKQUERY_CANNA_SERVER;
}

static gchar *
get_info (void)
{
	return NULL;
}

SkkQueryFunctionImpl *impl_init (SkkQuery *query)
{
	return get_new (query);
}

#ifdef SKKCANNADICTIMPL_DEBUG
int
main (void)
{
	SkkQueryFunctionImpl *impl = get_new (NULL);
	impl->do_query (impl, "礦ϤƤ󤭤Ǥ", NULL, NULL);
	impl->do_query (impl, "礦", NULL, NULL);
	impl->destroy (impl);
	return 0;
}
#endif


