/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: wmutil.c,v 1.2.2.8 2003/03/27 22:18:25 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#include <X11/Xatom.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "wmutil.h"

#ifdef USE_GTK2
#ifdef HAVE_GDK_X11_LOOKUP_XDISPLAY
#define XATOM_TO_ATOM(X,Y) \
	gdk_x11_xatom_to_atom_for_display ( \
			gdk_x11_lookup_xdisplay (GDK_WINDOW_XDISPLAY ((X))), \
			(Y))
#define ATOM_TO_XATOM(X,Y) \
	gdk_x11_atom_to_xatom_for_display ( \
			gdk_x11_lookup_xdisplay (GDK_WINDOW_XDISPLAY ((X))), \
			(Y))
#else
#define XATOM_TO_ATOM(X,Y) gdk_x11_xatom_to_atom ((Y))
#define ATOM_TO_XATOM(X,Y) gdk_x11_atom_to_xatom ((Y))
#endif
#ifdef GDK_DISABLE_DEPRECATED
#define GDK_ROOT_PARENT() (gdk_get_default_root_window ())
#endif
#else
#define XATOM_TO_ATOM(X,Y) (Y)
#define ATOM_TO_XATOM(X,Y) (Y)
#endif

static Window
_wmutil_window_tray_get_owner (GdkWindow *window) 
{
	Window owner;
	char buffer[256];
	Atom tray;
	g_snprintf (buffer, sizeof (buffer),
			"_NET_SYSTEM_TRAY_S%d",
			XScreenNumberOfScreen (DefaultScreenOfDisplay (GDK_WINDOW_XDISPLAY (window)))
		   );
	tray = XInternAtom (GDK_WINDOW_XDISPLAY (window),
			buffer , TRUE);
	if (tray == None)
		return None;
	owner = XGetSelectionOwner (GDK_WINDOW_XDISPLAY (window),
			tray);
	if (!owner)
		return None;
	g_message ("owner found %lx", owner);
	return owner;
}

void
wmutil_window_desktop_ewmh_client_message (GdkWindow *window, gulong desktop)
{
	GdkAtom wm_desktop = gdk_atom_intern ("_NEW_WM_DESKTOP", FALSE);
	XClientMessageEvent e;
	e.type = ClientMessage;
	e.window = GDK_WINDOW_XWINDOW(window);
	e.message_type = ATOM_TO_XATOM (window, wm_desktop);
	e.format = 32;
	e.data.l[0] = desktop;
	e.data.l[1] = None;
	e.data.l[2] = None;
	e.data.l[3] = None;
	e.data.l[4] = None;
	XSendEvent (GDK_WINDOW_XDISPLAY (window), GDK_ROOT_WINDOW (),
			FALSE, SubstructureNotifyMask, (XEvent *)&e);
}

void
wmutil_window_desktop_ewmh_prop (GdkWindow *window, gulong desktop)
{
	gdk_property_change (window,
			gdk_atom_intern ("_NET_WM_DESKTOP", FALSE),
			XATOM_TO_ATOM(window, XA_CARDINAL),
			32,
			GDK_PROP_MODE_REPLACE,
			(guchar *)&desktop,1);
}

void
wmutil_window_type_ewmh (GdkWindow *window, GdkAtom *types, guint num, GdkPropMode mode)
{
	gdk_property_change (window,
			gdk_atom_intern ("_NET_WM_WINDOW_TYPE", FALSE),
			XATOM_TO_ATOM(window, XA_ATOM),
			32,
			mode,
			(guchar *)types, num);
	return;
}

void
wmutil_window_state_ewmh_client_message (GdkWindow *state, GdkAtom atom1, GdkAtom atom2)
{
	/* 
	 * see http://www.freedesktop.org/standards/wm-spec/x186.html for more detail.
	 */
	GdkAtom wm_state = gdk_atom_intern ("_NEW_WM_STATE", FALSE);
	XClientMessageEvent e;
	e.type = ClientMessage;
	e.window = GDK_WINDOW_XWINDOW(state);
	e.message_type = ATOM_TO_XATOM(state, wm_state);
	e.format = 32;
	e.data.l[0] = _NEW_WM_STATE_ADD;
	e.data.l[1] = ATOM_TO_XATOM (state, atom1);
	e.data.l[2] = ATOM_TO_XATOM (state, atom2);
	e.data.l[3] = None;
	e.data.l[4] = None;
	XSendEvent (GDK_WINDOW_XDISPLAY (state), GDK_ROOT_WINDOW (),
			FALSE, SubstructureNotifyMask, (XEvent *)&e);
}

void
wmutil_window_layer_gnome (GdkWindow *layer, long stack)
{
	GdkAtom wm_layer = gdk_atom_intern ("_WIN_LAYER", FALSE);
	gdk_property_change (layer, wm_layer,
			XATOM_TO_ATOM (layer, XA_CARDINAL),
			32,
			GDK_PROP_MODE_REPLACE,
			(guchar *)&stack, 1);
	return;
}

void
wmutil_window_hints_gnome (GdkWindow *hints, long hints_flags)
{
	GdkAtom wm_hints = gdk_atom_intern ("_WIN_HINTS", FALSE);
	gdk_property_change (hints, wm_hints,
			XATOM_TO_ATOM (hints, XA_CARDINAL),
			32,
			GDK_PROP_MODE_REPLACE,
			(guchar *)&hints_flags, 1);
	return;

}

void
wmutil_window_state_gnome (GdkWindow *state, long state_flags)
{
	GdkAtom wm_state = gdk_atom_intern ("_WIN_STATE", FALSE);
	gdk_property_change (state, wm_state,
			XATOM_TO_ATOM (state, XA_CARDINAL),
			32,
			GDK_PROP_MODE_REPLACE,
			(guchar *)&state_flags, 1);
	return;
}

void
wmutil_window_tray_icewm (GdkWindow *window, gint state)
{
	GdkAtom icewm_tray = gdk_atom_intern ("_ICEWM_TRAY", TRUE);
	if (icewm_tray == None)
		return;
	gdk_property_change (window, icewm_tray,
			XATOM_TO_ATOM (window, XA_CARDINAL),
			32,
			GDK_PROP_MODE_REPLACE,
			(guchar *) &state,
			1);
}

void
wmutil_window_tray_kde (GdkWindow *tray, GdkWindow *transient_for)
{
	GdkAtom kde_tray = gdk_atom_intern ("_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", FALSE);
	Window transient = GDK_WINDOW_XWINDOW (transient_for);
	gdk_property_change (tray, kde_tray,
			XATOM_TO_ATOM (tray, XA_WINDOW),
			32,
			GDK_PROP_MODE_REPLACE,
			(guchar *) &transient,
			1);
	return;
}

void
wmutil_window_state_ewmh_prop (GdkWindow *state, GdkAtom *atoms, guint num, GdkPropMode mode)
{
	GdkAtom wm_state = gdk_atom_intern ("_NET_WM_STATE", FALSE);
	gdk_property_change (state, wm_state,
			XATOM_TO_ATOM (state, XA_ATOM),
			32,
			mode,
			(guchar *)atoms, num);
}

void
wmutil_window_current_desktop_ewmh (GdkWindow *window, gint *desktop)
{
	long *value;
	GdkAtom type_r, cur_desktop;
	gint format_r, length_r;
	cur_desktop = gdk_atom_intern ("_NET_CURRENT_DESKTOP", TRUE);
	if (cur_desktop == None) 
		goto error;
	if (gdk_property_get (GDK_ROOT_PARENT (),
				cur_desktop,
				XATOM_TO_ATOM (window, XA_CARDINAL),
				0,
				128,
				FALSE,
				&type_r,
				&format_r,
				&length_r,
				(guchar **)&value)) {
		if (desktop)
			*desktop = value[0];
		g_free (value);
		return;
	}

error:
	if (desktop) *desktop = -1;
}

void
wmutil_window_workarea_ewmh (GdkWindow *window, gint *x, gint *y, gint *width, gint *height)
{
	long *value;
	GdkAtom type_r, workarea;
	gint format_r, length_r;
	gint cur_desktop;

	wmutil_window_current_desktop_ewmh (window, &cur_desktop);
	if (cur_desktop < 0)
		goto error;
	
	workarea = gdk_atom_intern ("_NET_WORKAREA", TRUE);
	if (workarea == GDK_NONE)
		goto error;
	if (gdk_property_get (GDK_ROOT_PARENT(),
				workarea,
				XATOM_TO_ATOM (window, XA_CARDINAL),
				0,
				128,
				FALSE,
				&type_r,
				&format_r,
				&length_r,
				(guchar **)&value)) {
		if (x) *x = value[cur_desktop * 4];
		if (y) *y = value[cur_desktop * 4 + 1];
		if (width) *width = value[cur_desktop * 4 + 2];
		if (height) *height = value[cur_desktop * 4 + 3];
		g_free (value);
		return;
	}
	

error:
	if (x) *x = -1;
	if (y) *y = -1;
	if (width) *width = -1;
	if (height) *height = -1;
}

static gboolean
is_windowmaker_wm (void)
{
	long *value;
	GdkAtom type_r, iswm;
	gint format_r, length_r;
	iswm = gdk_atom_intern ("_WINDOWMAKER_WM_PROTOCOLS", TRUE);
	if (iswm == GDK_NONE)
		return FALSE;
	if (gdk_property_get (GDK_ROOT_PARENT (),
				iswm,
				XATOM_TO_ATOM (GDK_ROOT_PARENT(), XA_ATOM),
				0,
				128,
				FALSE,
				&type_r,
				&format_r,
				&length_r,
				(guchar **)&value)) {
		g_free (value);
		if (length_r > 0 && XA_ATOM == ATOM_TO_XATOM (GDK_ROOT_PARENT(), type_r) ) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	return FALSE;
}

static gboolean
is_icewm_wm (void)
{
	GdkAtom ice;
	ice = gdk_atom_intern ("_ICEWM_TRAY", TRUE);
	if (ice == GDK_NONE)
		return FALSE;
	return TRUE;
}

static gboolean
is_blackbox_wm (void)
{
	long *value;
	GdkAtom type_r, isbb;
	gint format_r, length_r;
	/*
	 * blackbox-based window manager sets _BLACKBOX_PID property
	 * to RootWindow
	 */
	isbb = gdk_atom_intern ("_BLACKBOX_PID", TRUE);
	if (isbb == GDK_NONE)
		return FALSE;
	if (gdk_property_get (GDK_ROOT_PARENT (),
				isbb,
				XATOM_TO_ATOM (GDK_ROOT_PARENT(), XA_CARDINAL),
				0,
				128,
				FALSE,
				&type_r,
				&format_r,
				&length_r,
				(guchar **)&value)) {
		g_free (value);
		if (length_r > 0 && type_r != None) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	return FALSE;
}

static gboolean
is_kde_wm (void)
{
	long *value;
	GdkAtom type_r, iskde;
	gint format_r, length_r;
	iskde = gdk_atom_intern ("KWIN_RUNNING", TRUE);
	if (iskde == GDK_NONE)
		return FALSE;
	if (gdk_property_get (GDK_ROOT_PARENT (),
				iskde,
				iskde,
				0,
				1,
				FALSE,
				&type_r,
				&format_r,
				&length_r,
				(guchar **)&value)) {
		g_free (value);
		if (length_r > 0 && type_r == iskde) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	return FALSE;
}

static gboolean
is_gnome_wm (void)
{
	long *value;
	GdkAtom type_r, isgnome;
	gint format_r, length_r;
	isgnome = gdk_atom_intern ("_WIN_SUPPORTING_WM_CHECK", TRUE);
	if (isgnome == GDK_NONE)
		return FALSE;
	if (gdk_property_get (GDK_ROOT_PARENT (),
				isgnome,
				XATOM_TO_ATOM (GDK_ROOT_PARENT(), XA_CARDINAL),
				0,
				1,
				FALSE,
				&type_r,
				&format_r,
				&length_r,
				(guchar **)&value)) {
		g_free (value);
		if (length_r > 0 &&
				ATOM_TO_XATOM (GDK_ROOT_PARENT(), type_r) == XA_CARDINAL) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	return FALSE;
}

static gboolean
is_ewmh_wm (void)
{
	long *value;
	GdkAtom type_r, isewmh;
	gint format_r, length_r;
	isewmh = gdk_atom_intern ("_NET_SUPPORTED", TRUE);
	if (isewmh == GDK_NONE)
		return FALSE;
	if (gdk_property_get (GDK_ROOT_PARENT (),
				isewmh,
				XATOM_TO_ATOM (GDK_ROOT_PARENT(), XA_ATOM),
				0,
				128,
				FALSE,
				&type_r,
				&format_r,
				&length_r,
				(guchar **)&value)) {
		g_free (value);
		if (length_r > 0 &&
				ATOM_TO_XATOM (GDK_ROOT_PARENT(), type_r) == XA_ATOM) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	return FALSE;
}

static gboolean
can_trayed_spec (void)
{
	Window owner;
	GdkAtom tray = gdk_atom_intern ("_NET_SYSTEM_TRAY_S0", TRUE);
	if (tray == GDK_NONE) {
		g_message ("tray atom not found");
		return FALSE;
	}
	owner = XGetSelectionOwner (GDK_DISPLAY (), 
			ATOM_TO_XATOM(GDK_ROOT_PARENT(),tray));
	if (owner) {
		g_message ("owner found");
		return TRUE;
	}
	return FALSE;
}

gint
wmutil_window_check_wm_type (void)
{
	gint ret = WM_IS_UNKNOWN;
	if (is_blackbox_wm ()) {
		ret |= WM_IS_BLACKBOX;
	}
	if (is_ewmh_wm ()) {
		ret |= WM_IS_EWMH;
	}
	if (is_kde_wm ()) {
		ret |= WM_IS_KWIN;
	}
	if (is_gnome_wm ()) {
		ret |= WM_IS_GNOME;
	}
	if (is_windowmaker_wm ()) {
		ret |= WM_IS_WMAKER;
	}
	if (is_icewm_wm ()) {
		ret |= WM_IS_ICEWM;
	}
	if (can_trayed_spec ()) {
		ret |= WM_CAN_TRAY;
		ret |= WM_CAN_TRAY_SPEC;
	}
	return ret;
}


void
wmutil_window_tray_spec (GdkWindow *window)
{
	Window owner;
	XClientMessageEvent e;
	owner = _wmutil_window_tray_get_owner (window);
	if (owner == None)
		return;
	g_message ("owner found %lx", owner);
	e.type = ClientMessage;
	e.window = owner;
	e.message_type = ATOM_TO_XATOM (window, gdk_atom_intern ("_NET_SYSTEM_TRAY_OPCODE", FALSE));
	e.format = 32;
	e.data.l[0] = CurrentTime;
	e.data.l[1] = SYSTEM_TRAY_REQUEST_DOCK;
	e.data.l[2] = GDK_WINDOW_XWINDOW (window);
	e.data.l[3] = 0;
	e.data.l[4] = 0;

	XSendEvent (GDK_WINDOW_XDISPLAY (window), 
			owner,
			FALSE, NoEventMask, (XEvent *) &e);
}

void
wmutil_window_tray_xembed (GdkWindow *window)
{
	GdkAtom embed_info = gdk_atom_intern ("_XEMBED_INFO", FALSE);
	/* CARD32 info[2] = { 0, XEMBED_MAPPED }; */
	guint32 info[2] = {0, XEMBED_MAPPED };
	gdk_property_change (window,
			embed_info,
			embed_info, 32,
			GDK_PROP_MODE_REPLACE,
			(guchar *)info, 2);
	return;
}

void
wmutil_window_tray_baloon_start (GdkWindow *window, guint length , guint id)
{
	Window owner;
	XClientMessageEvent e;
	GdkAtom ballon = gdk_atom_intern ("_NET_SYSTEM_TRAY_OPCODE", FALSE);
	owner = _wmutil_window_tray_get_owner (window);
	if (owner == None)
		return;
	e.type = ClientMessage;
	e.message_type = ATOM_TO_XATOM (window, ballon);
	e.format = 32;
	e.window = owner;
	e.data.l[0] = CurrentTime;
	e.data.l[1] = SYSTEM_TRAY_BEGIN_MESSAGE;
	e.data.l[2] = 0;
	e.data.l[3] = length;
	e.data.l[4] = id;

	XSendEvent (GDK_WINDOW_XDISPLAY (window), 
			owner,
			FALSE, NoEventMask, (XEvent *) &e);
	return;
}

void
wmutil_window_tray_baloon_cancel (GdkWindow *window, guint id)
{
	Window owner;
	XClientMessageEvent e;
	GdkAtom ballon = gdk_atom_intern ("_NET_SYSTEM_TRAY_OPCODE", FALSE);
	owner = _wmutil_window_tray_get_owner (window);
	if (owner == None)
		return;
	e.type = ClientMessage;
	e.message_type = ATOM_TO_XATOM (window, ballon);
	e.format = 32;
	e.window = owner;
	e.data.l[0] = CurrentTime;
	e.data.l[1] = SYSTEM_TRAY_CANCEL_MESSAGE;
	e.data.l[2] = id;
	e.data.l[3] = 0;
	e.data.l[4] = 0;

	XSendEvent (GDK_WINDOW_XDISPLAY (window), 
			owner,
			FALSE, NoEventMask, (XEvent *) &e);
	return;
}

/* FIXME */
void
wmutil_window_tray_baloon (GdkWindow *window, const gchar *message, guint length)
{
	Window owner;
	XClientMessageEvent e;
	int i, actual_length;
	GdkAtom baloon = gdk_atom_intern ("_NET_SYSTEM_TRAY_MESSAGE_DATA", FALSE);
	owner = _wmutil_window_tray_get_owner (window);
	if (owner == None)
		return;
	e.type = ClientMessage;
	e.message_type = ATOM_TO_XATOM (window, baloon);
	e.window = owner;
	e.format = 8;
	if (length > 20)
		actual_length = 20;
	else
		actual_length = length;

	for (i = 0; i < actual_length; i++) {
		e.data.b[i] = message[i];
	}
	XSendEvent (GDK_WINDOW_XDISPLAY (window),
			owner,
			FALSE, NoEventMask, (XEvent *) &e);

}

void
wmutil_window_input_icccm (GdkWindow *window, gboolean flag)
{
	XWMHints *hints;

	hints = XGetWMHints (GDK_WINDOW_XDISPLAY (window),
			GDK_WINDOW_XWINDOW (window));
	if (!hints)
		hints = XAllocWMHints ();
	hints->flags |= InputHint;
	hints->input = flag;
	XSetWMHints (GDK_WINDOW_XDISPLAY (window),
			GDK_WINDOW_XWINDOW (window), hints);
	XFree (hints);
	return;
}

void
wmutil_window_hints_icccm (GdkWindow *window, gint state)
{
	XWMHints hints;

	memset (&hints, 0, sizeof (hints));
	hints.flags = StateHint;
	hints.initial_state = state;
	XSetWMHints (GDK_WINDOW_XDISPLAY (window),
			GDK_WINDOW_XWINDOW (window), &hints);
	return;
}
