/*
 * IIIMF-SKK, Japanese Language Engine for 
 *                        IIIMF (Internet/Intranet Input Method Framework)
 * 
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skk_xaux_so.c,v 1.1.1.1.2.2 2003/02/17 01:21:06 famao Exp $ */

/* vi:set ts=4 sw=4: */


/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/* Define Aux classes */

#define		AUX_CLASS_MAX	3

#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "iiimpAux.h"
#include "xaux_common.h"
#include "xaux_so_common.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

extern aux_method_t xaux_so_methods;

static const CARD16     aux_utfname_palette[] = {
                        'o','r','g','.',
			'm','o','m','o','n','g','a','-','l','i','n','u','x',
			'.','s','k','k','.',
			'P','a','l','e','t','t','e','A','u','x',
};
static const CARD16     aux_utfname_lookup[] = {
                        'o','r','g','.',
			'm','o','m','o','n','g','a','-','l','i','n','u','x',
			'.','s','k','k','.', 
			'L','o','o','k','u','p','A','u','x',
};
static const CARD16     aux_utfname_adddict[] = {
                        'o','r','g','.',
			'm','o','m','o','n','g','a','-','l','i','n','u','x',
			'.','s','k','k','.', 'A','d','d','D','i','c','t','A','u','x',
};

/* #define		SKK_XAUX_EXT_DIR	"/usr/lib/im/locale/ja/skk/xaux/" */

xaux_class_t xaux_classes[AUX_CLASS_MAX + 1] = {
	{
		"org.momonga-linux.skk.PaletteAux", 1,
		SKK_XAUX_EXT_DIR "PaletteAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, { (Atom)0 }, 0, { (Atom)0 }, 0,
		aux_utfname_palette,
	},
	{
		"org.momonga-linux.skk.LookupAux", 2,
		SKK_XAUX_EXT_DIR "LookupAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, { (Atom)0 }, 0, { (Atom)0 }, 0,
		aux_utfname_lookup,
	},
	{
		"org.momonga-linux.skk.AddDictAux", 3,
		SKK_XAUX_EXT_DIR "AddDictAux",
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, { (Atom)0 }, 0, { (Atom)0 }, 0,
		aux_utfname_adddict,
	},
	{
		NULL, -1,
		NULL,
		(Window)0, (Window)0,
		(Atom)0, (Atom)0, (Atom)0, { (Atom)0 }, 0, { (Atom)0 }, 0,
		NULL,
	}
};

aux_dir_t aux_dir[AUX_CLASS_MAX + 1] = {
	{
		{
			sizeof (aux_utfname_palette),
			(CARD16 *)aux_utfname_palette,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (aux_utfname_lookup),
			(CARD16 *)aux_utfname_lookup,
		},
		&xaux_so_methods,
	},
	{
		{
			sizeof (aux_utfname_adddict),
			(CARD16 *)aux_utfname_adddict,
		},
		&xaux_so_methods,
	},
	{
		{
			0, NULL, 
		},
		NULL,
	},

};
