/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkkeysymutil_private.h,v 1.1.2.1 2003/03/13 10:01:10 famao Exp $ */

/* vi:set ts=4 sw=4: */

#ifndef HAVE_SKK_KEYSYM_UTIL_PRIVATE_H
#define HAVE_SKK_KEYSYM_UTIL_PRIVATE_H

typedef struct _SkkKeyItem SkkKeyItem;

struct _SkkKeyItem {
	gchar *name;
	gint  code;
};

SkkKeyItem _skkkeyitem[] = {
	{ "SKK_VK_0", SKK_VK_0 },
	{ "SKK_VK_1", SKK_VK_1 },
	{ "SKK_VK_2", SKK_VK_2 },
	{ "SKK_VK_3", SKK_VK_3 },
	{ "SKK_VK_4", SKK_VK_4 },
	{ "SKK_VK_5", SKK_VK_5 },
	{ "SKK_VK_6", SKK_VK_6 },
	{ "SKK_VK_7", SKK_VK_7 },
	{ "SKK_VK_8", SKK_VK_8 },
	{ "SKK_VK_9", SKK_VK_9 },
	{ "SKK_VK_A", SKK_VK_A },
	{ "SKK_VK_AT", SKK_VK_AT },
	{ "SKK_VK_B", SKK_VK_B },
	{ "SKK_VK_BACK_SLASH", SKK_VK_BACK_SLASH },
	{ "SKK_VK_BACK_SPACE", SKK_VK_BACK_SPACE },
	{ "SKK_VK_C", SKK_VK_C },
	{ "SKK_VK_COLON", SKK_VK_COLON },
	{ "SKK_VK_COMMA", SKK_VK_COMMA },
	{ "SKK_VK_D", SKK_VK_D },
	{ "SKK_VK_E", SKK_VK_E },
	{ "SKK_VK_ENTER", SKK_VK_ENTER },
	{ "SKK_VK_EQUAL", SKK_VK_EQUAL },
	{ "SKK_VK_F", SKK_VK_F },
	{ "SKK_VK_G", SKK_VK_G },
	{ "SKK_VK_GREATER", SKK_VK_GREATER },
	{ "SKK_VK_H", SKK_VK_H },
	{ "SKK_VK_I", SKK_VK_I },
	{ "SKK_VK_J", SKK_VK_J },
	{ "SKK_VK_K", SKK_VK_K },
	{ "SKK_VK_L", SKK_VK_L },
	{ "SKK_VK_LESS", SKK_VK_LESS },
	{ "SKK_VK_M", SKK_VK_M },
	{ "SKK_VK_N", SKK_VK_N },
	{ "SKK_VK_O", SKK_VK_O },
	{ "SKK_VK_P", SKK_VK_P },
	{ "SKK_VK_PERIOD", SKK_VK_PERIOD },
	{ "SKK_VK_Q", SKK_VK_Q },
	{ "SKK_VK_QUESTION", SKK_VK_QUESTION },
	{ "SKK_VK_R", SKK_VK_R },
	{ "SKK_VK_S", SKK_VK_S },
	{ "SKK_VK_SEMICOLON", SKK_VK_SEMICOLON },
	{ "SKK_VK_SLASH", SKK_VK_SLASH },
	{ "SKK_VK_SPACE", SKK_VK_SPACE },
	{ "SKK_VK_T", SKK_VK_T },
	{ "SKK_VK_TAB", SKK_VK_TAB },
	{ "SKK_VK_U", SKK_VK_U },
	{ "SKK_VK_V", SKK_VK_V },
	{ "SKK_VK_W", SKK_VK_W },
	{ "SKK_VK_X", SKK_VK_X },
	{ "SKK_VK_Y", SKK_VK_Y },
	{ "SKK_VK_Z", SKK_VK_Z },
	{ "SKK_VK_a", SKK_VK_a },
	{ "SKK_VK_b", SKK_VK_b },
	{ "SKK_VK_c", SKK_VK_c },
	{ "SKK_VK_d", SKK_VK_d },
	{ "SKK_VK_e", SKK_VK_e },
	{ "SKK_VK_f", SKK_VK_f },
	{ "SKK_VK_g", SKK_VK_g },
	{ "SKK_VK_h", SKK_VK_h },
	{ "SKK_VK_i", SKK_VK_i },
	{ "SKK_VK_j", SKK_VK_j },
	{ "SKK_VK_k", SKK_VK_k },
	{ "SKK_VK_l", SKK_VK_l },
	{ "SKK_VK_m", SKK_VK_m },
	{ "SKK_VK_n", SKK_VK_n },
	{ "SKK_VK_o", SKK_VK_o },
	{ "SKK_VK_p", SKK_VK_p },
	{ "SKK_VK_q", SKK_VK_q },
	{ "SKK_VK_r", SKK_VK_r },
	{ "SKK_VK_s", SKK_VK_s },
	{ "SKK_VK_t", SKK_VK_t },
	{ "SKK_VK_u", SKK_VK_u },
	{ "SKK_VK_v", SKK_VK_v },
	{ "SKK_VK_w", SKK_VK_w },
	{ "SKK_VK_x", SKK_VK_x },
	{ "SKK_VK_y", SKK_VK_y },
	{ "SKK_VK_z", SKK_VK_z },
};

#endif /* HAVE_SKK_KEYSYM_UTIL_PRIVATE_H */
