/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkkeysymutil.c,v 1.1.2.10 2003/04/17 06:19:23 famao Exp $ */

/* vi:set ts=4 sw=4: */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#include "skktypes.h"
#include "skkkeysym.h"
#include "skkkeysymutil.h"
#include "skkkeysymutil_private.h"

#define SKK_KEYITEM_SIZE (sizeof (_skkkeyitem)/ sizeof (_skkkeyitem[0]))

static gint
keysearch (gconstpointer a1, gconstpointer a2)
{
	SkkKeyItem *item = (SkkKeyItem *)a2;
	return strcmp (a1, item->name);
}

gint
skk_keysym_keyname_to_keycode (const gchar *keyname)
{
	SkkKeyItem *item;
	if (!keyname)
		return 0;
	item = bsearch (keyname, _skkkeyitem, SKK_KEYITEM_SIZE , sizeof (SkkKeyItem), keysearch);
	if (!item)
		return 0;
	return item->code;
}

gint
skk_keysym_keyname_to_mode (const gchar *mode)
{
	if (!mode)
		return 0;
	if (!strcmp (mode, "SKK_J_MODE")) {
		return SKK_J_MODE;
	} else if (!strcmp (mode, "SKK_ABBREV_MODE")) {
		return SKK_ABBREV_MODE;
	} else if (!strcmp (mode, "SKK_LATIN_MODE")) {
		return SKK_LATIN_MODE;
	} else if (!strcmp (mode, "SKK_JISX0208_LATIN_MODE")) {
		return SKK_JISX0208_LATIN_MODE;
	} else if (!strcmp (mode, "SKK_ALL_MODE")) {
		return SKK_ALL_MODE;
	}
	return 0;
}

gint
skk_keysym_keyname_to_query_mode (const gchar *mode)
{
	if (!mode)
		return 0;
	if (!strcmp (mode, "SKK_QUERY_NONE")) {
		return SKK_QUERY_NONE;
	} else if (!strcmp (mode, "SKK_QUERY_BEGIN")) {
		return SKK_QUERY_BEGIN;
	} else if (!strcmp (mode, "SKK_QUERY_OKURI")) {
		return SKK_QUERY_OKURI;
	} else if (!strcmp (mode, "SKK_QUERY_DONE")) {
		return SKK_QUERY_DONE;
	} else if (!strcmp (mode, "SKK_QUERY_ALL")) {
		return SKK_QUERY_ALL;
	}
	return 0;
}

gint
skk_keysym_keyname_to_mask (const gchar *mask)
{
	if (!mask)
		return 0;
	if (!strcmp (mask, "SKK_SHIFT_MASK")) {
		return SKK_SHIFT_MASK;
	} else if (!strcmp (mask, "SKK_CONTROL_MASK")) {
		return SKK_CONTROL_MASK;
	} else if (!strcmp (mask, "SKK_ALL_MASK")) {
		return SKK_ALL_MASK;
	} else if (!strcmp (mask, "SKK_NONE_MASK")) {
		return SKK_NONE_MASK;
	} else if (!strcmp (mask, "SKK_LOCK_MASK")) {
		return SKK_LOCK_MASK;
	} else if (!strcmp (mask, "SKK_MOD1_MASK")) {
		return SKK_MOD1_MASK;
	} else if (!strcmp (mask, "SKK_ALT_MASK")) {
		return SKK_ALT_MASK;
	} else if (!strcmp (mask, "SKK_MOD2_MASK")) {
		return SKK_MOD2_MASK;
	} else if (!strcmp (mask, "SKK_MOD3_MASK")) {
		return SKK_MOD3_MASK;
	} else if (!strcmp (mask, "SKK_MOD4_MASK")) {
		return SKK_MOD4_MASK;
	} else if (!strcmp (mask, "SKK_MOD5_MASK")) {
		return SKK_MOD5_MASK;
	} else if (!strcmp (mask, "SKK_BUTTON1_MASK")) {
		return SKK_BUTTON1_MASK;
	} else if (!strcmp (mask, "SKK_BUTTON2_MASK")) {
		return SKK_BUTTON2_MASK;
	} else if (!strcmp (mask, "SKK_BUTTON3_MASK")) {
		return SKK_BUTTON3_MASK;
	} else if (!strcmp (mask, "SKK_BUTTON4_MASK")) {
		return SKK_BUTTON4_MASK;
	} else if (!strcmp (mask, "SKK_BUTTON5_MASK")) {
		return SKK_BUTTON5_MASK;
	} else if (!strcmp (mask, "SKK_RELEASE_MASK")) {
		return SKK_RELEASE_MASK;
	} else if (!strcmp (mask, "SKK_MODIFIER_MASK")) {
		return SKK_MODIFIER_MASK;
	}
	return 0;
}


#ifdef SKKKEYSYMUTIL_DEBUG
int
main (void)
{
	int i;
	for (i = 0; i < 1000; i++) {
		printf ("%d\n", skk_keysym_keyname_to_keycode ("SKK_VK_a"));
	}
	return 0;
}
#endif
