/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkkeysym.h,v 1.1.1.1.2.1 2002/05/17 10:53:09 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKKEYSYM_H
#define HAVE_SKKKEYSYM_H

#define SKK_VK_BACK_SPACE	'\b'
#define SKK_VK_ENTER	'\n'
#define SKK_VK_TAB	'\t'
#define SKK_VK_SPACE	0x020
#define SKK_VK_COMMA	0x02c
#define SKK_VK_PERIOD	0x02e
#define SKK_VK_SLASH	0x02f
#define SKK_VK_0	0x030
#define SKK_VK_1	0x031
#define SKK_VK_2	0x032
#define SKK_VK_3	0x033
#define SKK_VK_4	0x034
#define SKK_VK_5	0x035
#define SKK_VK_6	0x036
#define SKK_VK_7	0x037
#define SKK_VK_8	0x038
#define SKK_VK_9	0x039
#define SKK_VK_COLON	0x03a
#define SKK_VK_SEMICOLON	0x03b
#define SKK_VK_LESS	0x03c
#define SKK_VK_EQUAL	0x03d
#define SKK_VK_GREATER	0x03e
#define SKK_VK_QUESTION	0x03f
#define SKK_VK_AT	0x040
#define SKK_VK_A	0x041
#define SKK_VK_B	0x042
#define SKK_VK_C	0x043
#define SKK_VK_D	0x044
#define SKK_VK_E	0x045
#define SKK_VK_F	0x046
#define SKK_VK_G	0x047
#define SKK_VK_H	0x048
#define SKK_VK_I	0x049
#define SKK_VK_J	0x04a
#define SKK_VK_K	0x04b
#define SKK_VK_L	0x04c
#define SKK_VK_M	0x04d
#define SKK_VK_N	0x04e
#define SKK_VK_O	0x04f
#define SKK_VK_P	0x050
#define SKK_VK_Q	0x051
#define SKK_VK_R	0x052
#define SKK_VK_S	0x053
#define SKK_VK_T	0x054
#define SKK_VK_U	0x055
#define SKK_VK_V	0x056
#define SKK_VK_W	0x057
#define SKK_VK_X	0x058
#define SKK_VK_Y	0x059
#define SKK_VK_Z	0x05a
#define SKK_VK_BACK_SLASH	0x05c
#define SKK_VK_a	0x061
#define SKK_VK_b	0x062
#define SKK_VK_c	0x063
#define SKK_VK_d	0x064
#define SKK_VK_e	0x065
#define SKK_VK_f	0x066
#define SKK_VK_g	0x067
#define SKK_VK_h	0x068
#define SKK_VK_i	0x069
#define SKK_VK_j	0x06a
#define SKK_VK_k	0x06b
#define SKK_VK_l	0x06c
#define SKK_VK_m	0x06d
#define SKK_VK_n	0x06e
#define SKK_VK_o	0x06f
#define SKK_VK_p	0x070
#define SKK_VK_q	0x071
#define SKK_VK_r	0x072
#define SKK_VK_s	0x073
#define SKK_VK_t	0x074
#define SKK_VK_u	0x075
#define SKK_VK_v	0x076
#define SKK_VK_w	0x077
#define SKK_VK_x	0x078
#define SKK_VK_y	0x077
#define SKK_VK_z	0x079

#endif /* HAVE_SKKKEYSYM_H */
