/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkfunctionmap_private.h,v 1.1.2.7 2003/04/17 07:49:00 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKFUNCTION_MAP_PRIVATE_H
#define HAVE_SKKFUNCTION_MAP_PRIVATE_H

#include <skkkeysym.h>

#define DefaultItemSize (((sizeof (skk_default_functionmaps))/(sizeof (skk_default_functionmaps[0]))))

static SkkFunctionMapItem skk_default_functionmaps[] =
{
	/* Backward Delete */
	{ "skk-backward-delete", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_ALL , SKK_VK_BACK_SPACE, SKK_ALL_MASK, 0 , FALSE},
	{ "skk-backward-delete", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV) , 
		SKK_QUERY_ALL, SKK_VK_H, SKK_CONTROL_MASK, 0, FALSE},
	{ "skk-backward-delete", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_ALL, SKK_VK_h, SKK_CONTROL_MASK, 0, FALSE},
	/* Cancel */
	{ "skk-cancel", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		~SKK_QUERY_NONE, SKK_VK_g, SKK_CONTROL_MASK, 0, FALSE},
	{ "skk-cancel", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		~SKK_QUERY_NONE, SKK_VK_G, SKK_CONTROL_MASK, 0, FALSE},
	/* Category Change */
	{ "skk-category-change", SKK_FUNC_JMODE, 
		SKK_QUERY_BEGIN, SKK_VK_q, SKK_NONE_MASK, 0, FALSE},
	{ "skk-category-change", SKK_FUNC_ABBREV, 
		SKK_QUERY_BEGIN, SKK_VK_Q, SKK_CONTROL_MASK, 0, FALSE},
	/* Completion */
	{ "skk-do-completion", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_BEGIN, SKK_VK_TAB, SKK_ALL_MASK , 0, FALSE},
	{ "skk-completion-next", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV) , 
		SKK_QUERY_BEGIN, SKK_VK_PERIOD, SKK_ALL_MASK, 0, FALSE},
	{ "skk-completion-prev", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_BEGIN, SKK_VK_COMMA, SKK_ALL_MASK, 0, FALSE},
	{ "skk-complete-translate", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_BEGIN, SKK_VK_SPACE, SKK_ALT_MASK, 0, FALSE},
	/* CodeTable */
	{ "skk-codetable", SKK_FUNC_JMODE, 
		SKK_QUERY_ALL, SKK_VK_BACK_SLASH, SKK_ALL_MASK, 0, FALSE},
	/* Cursor */
	{ "skk-cursor-left", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_BEGIN, SKK_VK_b, SKK_CONTROL_MASK, 0, FALSE},
	{ "skk-cursor-left", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_BEGIN, SKK_VK_B, SKK_CONTROL_MASK, 0, FALSE},
	{ "skk-cursor-right", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_BEGIN, SKK_VK_f, SKK_CONTROL_MASK, 0, FALSE},
	{ "skk-cursor-right", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_BEGIN, SKK_VK_F, SKK_CONTROL_MASK, 0, FALSE},
	/* Kakutei */
	{ "skk-kakutei", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_ALL, SKK_VK_ENTER, SKK_ALL_MASK, SKK_VK_ENTER, FALSE},
	{ "skk-kakutei", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_ALL, SKK_VK_m, SKK_CONTROL_MASK, SKK_VK_ENTER, FALSE},
	{ "skk-kakutei", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_ALL, SKK_VK_M, SKK_CONTROL_MASK, SKK_VK_ENTER, FALSE},
	{ "skk-kakutei", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_ALL, SKK_VK_j, SKK_CONTROL_MASK, 0, FALSE},
	{ "skk-kakutei", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		SKK_QUERY_ALL, SKK_VK_J, SKK_CONTROL_MASK, 0, FALSE},
	/* Kana */
	{ "skk-toggle-kana", SKK_FUNC_JMODE, 
		SKK_QUERY_NONE, SKK_VK_q, SKK_NONE_MASK, 0, FALSE },
	{ "skk-toggle-kana", SKK_FUNC_JMODE, 
		SKK_QUERY_NONE, SKK_VK_Q, ~SKK_CONTROL_MASK , 0, FALSE },
	{ "skk-halfwidth-kana-switch", SKK_FUNC_JMODE, 
		SKK_QUERY_ALL, SKK_VK_q, SKK_ALT_MASK, 0, FALSE},
	{ "skk-halfwidth-kana-switch", SKK_FUNC_JMODE, 
		SKK_QUERY_ALL, SKK_VK_Q, SKK_CONTROL_MASK, 0, FALSE},
	/* Mode */
	{ "skk-mode-change", (SKK_FUNC_JISX0208_LATIN | SKK_FUNC_LATIN), 
		SKK_QUERY_ALL, SKK_VK_J, SKK_CONTROL_MASK, SKK_J_MODE, FALSE},
	{ "skk-mode-change", (SKK_FUNC_JISX0208_LATIN | SKK_FUNC_LATIN), 
		SKK_QUERY_ALL, SKK_VK_j, SKK_CONTROL_MASK, SKK_J_MODE, FALSE},
	{ "skk-mode-change", SKK_FUNC_JMODE, 
		SKK_QUERY_ALL, SKK_VK_l, SKK_ALL_MASK, SKK_LATIN_MODE, FALSE },
	{ "skk-mode-change", SKK_FUNC_JMODE, 
		SKK_QUERY_ALL, SKK_VK_L, SKK_ALL_MASK, SKK_JISX0208_LATIN_MODE , FALSE },
	{ "skk-mode-change", SKK_FUNC_JMODE, 
		SKK_QUERY_ALL, SKK_VK_SLASH, SKK_ALL_MASK, SKK_ABBREV_MODE, FALSE},
	/* Postfix & Prefix */
	{ "skk-postfix", SKK_FUNC_JMODE, 
		(SKK_QUERY_DONE | SKK_QUERY_OKURI), SKK_VK_GREATER, SKK_ALL_MASK, SKK_VK_GREATER, FALSE},
	{ "skk-prefix", SKK_FUNC_JMODE, 
		SKK_QUERY_BEGIN, SKK_VK_LESS, SKK_ALL_MASK, SKK_VK_LESS, FALSE}, 
	/* Today */
	{ "skk-today", SKK_FUNC_JMODE, 
		SKK_QUERY_ALL, SKK_VK_AT, SKK_ALL_MASK, 0, FALSE},
	/* Translate */
	{ "skk-begin-translate", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), 
		~SKK_QUERY_NONE, SKK_VK_SPACE, ~(SKK_ALT_MASK), 0, FALSE},
	/* Undo */
	{ "skk-undo", (SKK_FUNC_JMODE | SKK_FUNC_ABBREV) , 
		SKK_QUERY_DONE, SKK_VK_x, SKK_NONE_MASK, 0, FALSE},
};

#endif /* HAVE_SKKFUNC_PRIVATE_H */
