/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkconf.h,v 1.3.2.23 2003/04/15 12:53:32 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKCONF_H
#define HAVE_SKKCONF_H
#include <glib.h>
#include <skktypes.h>

typedef struct _SkkConf SkkConf;
typedef struct _SkkConfItem SkkConfItem;
typedef struct _SkkConfValue SkkConfValue;

typedef void (*SkkConfCallback) (SkkConf *conf, GSList *value, const gchar *type, gpointer user_data);

struct _SkkConfValue {
	gchar *name;
	gchar *value;
};

struct _SkkConfItem {
	SkkConfType type;
#if 0
	SkkConfItemType itemtype;
#endif
	gchar *name;
	gchar *info;
	gpointer value;
	gboolean user_defined;
};

struct _SkkConf {
	gint ref_count;

	GHashTable *conf_table;

	/* callbacks */
	GSList *callbacks;

	void (*clear) (SkkConf *conf);
};

SkkConf* skk_conf_new (void);
void skk_conf_destroy (SkkConf *conf);
void skk_conf_clear (SkkConf *conf);
void skk_conf_ref (SkkConf *conf);
void skk_conf_unref (SkkConf *conf);

SkkConfItem* skk_conf_item_new (void);
SkkConfItem* skk_conf_item_new_with_value (SkkConfType type, const gchar *name, const gchar *info, gpointer value);
void skk_conf_item_destroy (SkkConfItem *item);
void skk_conf_add_item (SkkConf *conf, SkkConfItem *item);

typedef enum {
	SKKCONF_CONFIG_ITEM=0,
	SKKCONF_CONFIG_RULE,
	SKKCONF_CONFIG_INVALID,
} SkkConfConfigType;

void skk_conf_load_rc(SkkConf *conf, char *user_name);

gboolean skk_conf_get_bool (SkkConf *conf, const gchar *name);
gchar *skk_conf_get_string (SkkConf *conf, const gchar *name);
gint skk_conf_get_num (SkkConf *conf, const gchar *name);

void skk_conf_set_bool (SkkConf *conf, const gchar *name, gboolean value);
void skk_conf_set_string (SkkConf *conf, const gchar *name, const gchar *string);
void skk_conf_set_num (SkkConf *conf, const gchar *name, gint value);

gboolean skk_conf_add_callback (SkkConf *conf, const gchar *key, SkkConfCallback callback, gpointer user_data);

#endif /* HAVE_SKKCONF_H */
