/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: pixmaputil.c,v 1.1.2.1 2003/01/22 15:24:32 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "pixmaputil.h"

static GSList *xpm_list = NULL;

typedef struct _PixmapInfo PixmapInfo;

struct _PixmapInfo {
	gchar **xpm;
	guint type;
};

static gint xpm_list_find (gconstpointer a, gconstpointer b);

static gint
xpm_list_find (gconstpointer a, gconstpointer b)
{
	guint type = GPOINTER_TO_INT (b);
	PixmapInfo *info = (PixmapInfo *)a;
	if (type == info->type)
		return 0;
	return 1;
}

GtkWidget *
pixmap_new_with_xpm (GtkWidget *parent, gchar **xpm)
{
	GdkColormap *colormap;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	GtkWidget *pixmap;

	colormap = gtk_widget_get_colormap (parent);
	gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL,
			colormap, &mask, NULL, xpm);
	if (gdkpixmap == NULL) {
		if (mask)
			gdk_bitmap_unref (mask);
		return NULL;
	}
#ifdef USE_GTK2
#if 0
	pixmap = gtk_image_new_from_pixmap (gdkpixmap, mask);
#else
	pixmap = gtk_pixmap_new (gdkpixmap, mask);
#endif
#else
	pixmap = gtk_pixmap_new (gdkpixmap, mask);
#endif
	gdk_pixmap_unref (gdkpixmap);
	gdk_bitmap_unref (mask);
	return pixmap;
}

GtkWidget *
pixmap_new (GtkWidget *parent, guint type)
{
	GdkColormap *colormap;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	GtkWidget *pixmap;
	GSList *list;
	gchar **xpm = NULL;

	colormap = gtk_widget_get_colormap (parent);

	list = g_slist_find_custom (xpm_list, GINT_TO_POINTER (type), xpm_list_find);
	if (!list)
		return NULL;
	xpm = ((PixmapInfo *)list->data)->xpm;
	gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL,
			colormap, &mask, NULL, xpm);
	if (gdkpixmap == NULL) {
		if (mask)
			gdk_bitmap_unref (mask);
		return NULL;
	}
#ifdef USE_GTK2
	pixmap = gtk_image_new_from_pixmap (gdkpixmap, mask);
#else
	pixmap = gtk_pixmap_new (gdkpixmap, mask);
#endif
	gdk_pixmap_unref (gdkpixmap);
	gdk_bitmap_unref (mask);
	return pixmap;
}

void
pixmap_get (GtkWidget *parent, GdkPixmap **pixmap, GdkBitmap **bitmap, guint type)
{
	GdkColormap *colormap;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	GSList *list;
	gchar **xpm = NULL;

	if (!pixmap && !bitmap)
		return;

	colormap = gtk_widget_get_colormap (parent);

	list = g_slist_find_custom (xpm_list, GINT_TO_POINTER (type), xpm_list_find);
	if (!list) {
		if (pixmap)
			*pixmap = NULL;
		if (bitmap)
			*bitmap = NULL;
		return;
	}
	xpm = ((PixmapInfo *)list->data)->xpm;
	gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL,
			colormap, &mask, NULL, xpm);
	if (gdkpixmap == NULL) {
		if (mask) {
			gdk_bitmap_unref (mask);
			mask = NULL;
		}
	}
	if (pixmap)
		*pixmap = gdkpixmap;
	if (bitmap)
		*bitmap = mask;
	return;
}

void
pixmap_pool_add_xpm (guint type, gchar **xpm)
{
	PixmapInfo *info;
	info = g_new0 (PixmapInfo, 1);
	info->type = type;
	info->xpm = xpm;
	xpm_list = g_slist_prepend (xpm_list, info);
	return;
}

GtkWidget *
pixmap_button_new (const gchar *text, GtkWidget *pixmap)
{
	GtkWidget *button;
	GtkWidget *hbox;
	GtkWidget *label;

	button = gtk_button_new ();
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (button), hbox);
	gtk_widget_show (hbox);
	if (text) {
		label = gtk_label_new (text);
		gtk_box_pack_end (GTK_BOX (hbox), label, FALSE, 0, 0);
		gtk_object_set_data (GTK_OBJECT (button), "_pixmap_button_label", (gpointer)label);
		gtk_widget_show (label);
	}
	if (pixmap) {
#ifndef USE_GTK2
		if (!GTK_IS_PIXMAP (pixmap)) {
#else
#if 0
		if (!GTK_IS_IMAGE (pixmap)) {
#else
		if (!GTK_IS_PIXMAP (pixmap)) {
#endif
#endif
			g_warning ("pixmap_button_new (not a pixmap widget)");
		}
		gtk_box_pack_end (GTK_BOX (hbox), pixmap, FALSE, 0, 0);
		gtk_object_set_data (GTK_OBJECT (button), "_pixmap_button_icon", (gpointer)pixmap);
		gtk_widget_show (pixmap);
	}
	return button;
}

