/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkfunc_private.h,v 1.11 2003/02/19 17:44:51 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKFUNC_PRIVATE_H
#define HAVE_SKKFUNC_PRIVATE_H

#define DefaultItemSize (((sizeof (DefaultItem))/(sizeof (DefaultItem[0]))))

static SkkFuncItem DefaultItem[] =
{
	/* Backward Delete */
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_ALL , SKK_VK_BACK_SPACE, SKK_ALL_MASK, SKKFUNC_BACKWARD_DELETE, 0 , FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV) , QUERY_ALL, SKK_VK_H, SKK_CONTROL_MASK, SKKFUNC_BACKWARD_DELETE, 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_ALL, SKK_VK_h, SKK_CONTROL_MASK, SKKFUNC_BACKWARD_DELETE, 0, FALSE},
	/* Cancel */
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), ~QUERY_NONE, SKK_VK_g, SKK_CONTROL_MASK, SKKFUNC_CANCEL, 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), ~QUERY_NONE, SKK_VK_G, SKK_CONTROL_MASK, SKKFUNC_CANCEL, 0, FALSE},
	/* Category Change */
	{ SKK_FUNC_JMODE, QUERY_NORMAL, SKK_VK_q, SKK_NONE_MASK, SKKFUNC_CATEGORY_CHANGE, 0, FALSE},
	{ SKK_FUNC_ABBREV, QUERY_NORMAL, SKK_VK_q, SKK_CONTROL_MASK, SKKFUNC_CATEGORY_CHANGE, 0, FALSE},
	/* Completion */
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_NORMAL, SKK_VK_TAB, SKK_ALL_MASK , SKKFUNC_COMPLETE_BEGIN, 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV) , QUERY_NORMAL, SKK_VK_PERIOD, SKK_ALL_MASK, SKKFUNC_COMPLETE_NEXT , 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_NORMAL, SKK_VK_COMMA, SKK_ALL_MASK, SKKFUNC_COMPLETE_PREV , 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_NORMAL, SKK_VK_SPACE, SKK_ALT_MASK, SKKFUNC_COMPLETE_TRANSLATE, 0, FALSE},
	/* CodeTable */
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_BACK_SLASH, SKK_ALL_MASK, SKKFUNC_CODETABLE, 0, FALSE},
	/* Cursor */
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_NORMAL, SKK_VK_b, SKK_CONTROL_MASK, SKKFUNC_CURSOR_LEFT, 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_NORMAL, SKK_VK_B, SKK_CONTROL_MASK, SKKFUNC_CURSOR_LEFT, 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_NORMAL, SKK_VK_f, SKK_CONTROL_MASK, SKKFUNC_CURSOR_RIGHT, 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_NORMAL, SKK_VK_F, SKK_CONTROL_MASK, SKKFUNC_CURSOR_RIGHT, 0, FALSE},
	/* Kakutei */
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_ALL, SKK_VK_ENTER, SKK_ALL_MASK, SKKFUNC_KAKUTEI, SKK_VK_ENTER, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_ALL, SKK_VK_m, SKK_CONTROL_MASK, SKKFUNC_KAKUTEI, SKK_VK_ENTER, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_ALL, SKK_VK_M, SKK_CONTROL_MASK, SKKFUNC_KAKUTEI, SKK_VK_ENTER, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_ALL, SKK_VK_j, SKK_CONTROL_MASK, SKKFUNC_KAKUTEI, 0, FALSE},
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), QUERY_ALL, SKK_VK_J, SKK_CONTROL_MASK, SKKFUNC_KAKUTEI, 0, FALSE},
	/* Kana */
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_q, SKK_NONE_MASK, SKKFUNC_KANA_SWITCH, 0, FALSE },
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_Q, SKK_ALL_MASK, SKKFUNC_KANA_SWITCH, 0, FALSE },
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_q, SKK_ALT_MASK, SKKFUNC_HALFWIDTH_KANA_SWITCH, 0, FALSE},
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_q, SKK_CONTROL_MASK, SKKFUNC_HALFWIDTH_KANA_SWITCH, 0, FALSE},
	/* Mode */
	{ (SKK_FUNC_JISX0208_LATIN | SKK_FUNC_LATIN), QUERY_ALL, SKK_VK_J, SKK_CONTROL_MASK, SKKFUNC_MODE_CHANGE, SKK_J_MODE, FALSE},
	{ (SKK_FUNC_JISX0208_LATIN | SKK_FUNC_LATIN), QUERY_ALL, SKK_VK_j, SKK_CONTROL_MASK, SKKFUNC_MODE_CHANGE, SKK_J_MODE, FALSE},
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_l, SKK_ALL_MASK, SKKFUNC_MODE_CHANGE, SKK_LATIN_MODE, FALSE },
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_L, SKK_ALL_MASK, SKKFUNC_MODE_CHANGE, SKK_JISX0208_LATIN_MODE , FALSE },
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_SLASH, SKK_ALL_MASK, SKKFUNC_MODE_CHANGE, SKK_ABBREV_MODE, FALSE},
	/* Postfix & Prefix */
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_GREATER, SKK_ALL_MASK, SKKFUNC_POSTFIX, SKK_VK_GREATER, FALSE},
	{ SKK_FUNC_JMODE, QUERY_NORMAL, SKK_VK_LESS, SKK_ALL_MASK, SKKFUNC_PREFIX, SKK_VK_LESS, FALSE}, 
	/* Today */
	{ SKK_FUNC_JMODE, QUERY_ALL, SKK_VK_AT, SKK_ALL_MASK, SKKFUNC_TODAY, 0, FALSE},
	/* Translate */
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV), ~QUERY_NONE, SKK_VK_SPACE, SKK_ALL_MASK, SKKFUNC_TRANSLATE_BEGIN, 0, FALSE},
	/* Undo */
	{ (SKK_FUNC_JMODE | SKK_FUNC_ABBREV) , QUERY_DONE, SKK_VK_x, SKK_NONE_MASK, SKKFUNC_UNDO, 0, FALSE},


};

#endif /* HAVE_SKKFUNC_PRIVATE_H */
