/*************************************************************************************************/
/*!
   	@file		View.h
	@author 	Fanzo
 	@date 		2008/5/10
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iView.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// msg_view
#define		msg_view_map_begin()								\
protected:														\
virtual															\
void ViewMsg													\
		(														\
		IViewMsg*	msg											\
		)														\
{																\

#define		msg_view_hook( msg_type , callfunc )				\
	if( msg->m_msg == msg_type##_ViewMsg )						\
	{															\
		callfunc( ( msg_type##_ViewPM* )msg );					\
	}


#define		msg_view_map_end( super_class )						\
	return super_class::ViewMsg( msg );							\
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// msg
#define		msg_sys_map_begin()									\
private:														\
bool cb_call Msg												\
		(														\
		IMsg*	msg												\
		)														\
{																\

#define		msg_sys_hook( msg_type , callfunc )					\
	if( msg->m_msg == msg_type##_Msg )							\
	{															\
		return callfunc( ( msg_type##_MsgPM* )msg );			\
	}


#define		msg_sys_map_end()									\
	return false;												\
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

enum ViewMsg
{
	Create_ViewMsg , 
	Update_ViewMsg , 
	Size_ViewMsg , 
	MouseMove_ViewMsg , 
	LButtonDown_ViewMsg , 
	LButtonUp_ViewMsg , 
	LDragStart_ViewMsg , 
	LDrag_ViewMsg , 
	LDragEnd_ViewMsg , 
	LDragCancel_ViewMsg , 
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

class IViewMsg
{
public:
	ViewMsg		m_msg;
};
//Create
class Create_ViewPM : public IViewMsg
{
public:
	irect		m_rect;
};
//Update
class Update_ViewPM : public IViewMsg
{
public:
	iSurface	m_surface;
	irect		m_rect;
};
//Size
class Size_ViewPM : public IViewMsg
{
public:
	irect		m_rect;
};
//MouseMove
class MouseMove_ViewPM : public IViewMsg
{
public:
	ivector2	m_pos;
};
//LButtonDown
class LButtonDown_ViewPM : public IViewMsg
{
public:
	ivector2	m_pos;
};
//LButtonUp
class LButtonUp_ViewPM : public IViewMsg
{
public:
	ivector2	m_pos;
};
//LDragStart
class LDragStart_ViewPM : public IViewMsg
{
public:
	ivector2	m_pos;
};
//LDrag
class LDrag_ViewPM : public IViewMsg
{
public:
	ivector2	m_pos;
};
//LDragEnd
class LDragEnd_ViewPM : public IViewMsg
{
public:
	ivector2	m_pos;
};
//LDragCancel
class LDragCancel_ViewPM : public IViewMsg
{
public:
};

/**************************************************************************************************
"View" class 
**************************************************************************************************/
class View : 
	virtual public object_base , 
	public IView
{
// query
	query_begin();
	iface_hook( IView , IView_IID )
	iface_hook( IViewParentCtrl , IViewParentCtrl_IID )
	iface_hook( IViewChildCtrl , IViewChildCtrl_IID )
	query_end( object_base );

// msgmap
	msg_sys_map_begin()
	msg_sys_hook( MouseMove		, OnMouseMove )
	msg_sys_hook( LButtonDown	, OnLButtonDown )
	msg_sys_hook( LButtonUp		, OnLButtonUp )
	msg_sys_hook( LDragStart	, OnLDragStart )
	msg_sys_hook( LDrag			, OnLDrag )
	msg_sys_hook( LDragEnd		, OnLDragEnd )
	msg_sys_hook( LDragCancel	, OnLDragCancel )
	msg_sys_map_end()
		
// variable member
private:
	rViewParentCtrl		m_parent;
	Straightdata<iView>	m_children;
	irect				m_rect;
	bool				m_show;
	bool				m_drag;

// private functions
private:
//=================================================================================================
//!	Window to View
//!	@retval			---
//-------------------------------------------------------------------------------------------------
irect WindowToView
		(
		const irect&	r
		)
{
	ivector2	lt( r.xmin , r.ymin );
	lt	= WindowToView( lt );
	ivector2	rb( r.xmax , r.ymax );
	rb	= WindowToView( rb );
	return irect( lt.x , lt.y , rb.x , rb.y );
}
//=================================================================================================
//!	View to window
//!	@retval			---
//-------------------------------------------------------------------------------------------------
irect ViewToWindow
		(
		const irect&	r
		)
{
	ivector2	lt( r.xmin , r.ymin );
	lt	= ViewToWindow( lt );
	ivector2	rb( r.xmax , r.ymax );
	rb	= ViewToWindow( rb );
	return irect( lt.x , lt.y , rb.x , rb.y );
}
// "msg_sys" interface
private:
//=================================================================================================
bool OnMouseMove
		(
		MouseMove_MsgPM*	p
		)
{
	if( m_show == false )
		return false;
	ivector2	vp	= WindowToView( p->m_pos );
	irect		vr( ivector2() , m_rect.Size() );
	if( vr.IsInside( vp ) == false )
		return false;
	
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		if( true == m_children[ c_off ]->Msg( p ) )
			return true;
	}
	
	MouseMove_ViewPM	msg;
	msg.m_msg	= MouseMove_ViewMsg;
	msg.m_pos	= vp;
	ViewMsg( &msg );
	return true;
}
//=================================================================================================
bool OnLButtonDown
		(
		LButtonDown_MsgPM*	p
		)
{
	if( m_show == false )
		return false;
	ivector2	vp	= WindowToView( p->m_pos );
	irect		vr( ivector2() , m_rect.Size() );
	if( vr.IsInside( vp ) == false )
		return false;
	
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		if( true == m_children[ c_off ]->Msg( p ) )
			return true;
	}
	
	LButtonDown_ViewPM	msg;
	msg.m_msg	= LButtonDown_ViewMsg;
	msg.m_pos	= vp;
	ViewMsg( &msg );
	return true;
}
//=================================================================================================
bool OnLButtonUp
		(
		LButtonUp_MsgPM*	p
		)
{
	if( m_show == false )
		return false;
	ivector2	vp	= WindowToView( p->m_pos );
	irect		vr( ivector2() , m_rect.Size() );
	if( vr.IsInside( vp ) == false )
		return false;
	
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		if( true == m_children[ c_off ]->Msg( p ) )
			return true;
	}
	
	LButtonUp_ViewPM	msg;
	msg.m_msg	= LButtonUp_ViewMsg;
	msg.m_pos	= vp;
	ViewMsg( &msg );
	return true;
}
//=================================================================================================
bool OnLDragStart
		(
		LDragStart_MsgPM*	p
		)
{
	if( m_show == false )
		return false;
	ivector2	vp	= WindowToView( p->m_pos );
	irect		vr( ivector2() , m_rect.Size() );
	if( vr.IsInside( vp ) == false )
		return false;
	
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		if( true == m_children[ c_off ]->Msg( p ) )
			return true;
	}
	m_drag	= true;
	LDragStart_ViewPM	msg;
	msg.m_msg	= LDragStart_ViewMsg;
	msg.m_pos	= vp;
	ViewMsg( &msg );
	return true;
}
//=================================================================================================
bool OnLDrag
		(
		LDrag_MsgPM*	p
		)
{
	if( m_drag == true )
	{
		ivector2	vp	= WindowToView( p->m_pos );
		LDrag_ViewPM	msg;
		msg.m_msg	= LDrag_ViewMsg;
		msg.m_pos	= vp;
		ViewMsg( &msg );
		return true;
	}
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		if( true == m_children[ c_off ]->Msg( p ) )
			return true;
	}
	return false;
}
//=================================================================================================
bool OnLDragEnd
		(
		LDragEnd_MsgPM*	p
		)
{
	if( m_drag == true )
	{
		ivector2	vp	= WindowToView( p->m_pos );
		LDragEnd_ViewPM	msg;
		msg.m_msg	= LDragEnd_ViewMsg;
		msg.m_pos	= vp;
		ViewMsg( &msg );
		m_drag	= false;
		return true;
	}
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		if( true == m_children[ c_off ]->Msg( p ) )
			return true;
	}
	return false;
}
//=================================================================================================
bool OnLDragCancel
		(
		LDragCancel_MsgPM*	p
		)
{
	if( m_drag == true )
	{
		LDragCancel_ViewPM	msg;
		msg.m_msg	= LDragCancel_ViewMsg;
		ViewMsg( &msg );
		m_drag	= false;
		return true;
	}
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		if( true == m_children[ c_off ]->Msg( p ) )
			return true;
	}
	return false;
}

// "IViewParentCtrl" interface
public:
//=================================================================================================
//!	regist child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RegistChild
		(
		iView&		child
		)
{
	m_children[ m_children.Add() ]	= child;
}
//=================================================================================================
//!	remove child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RemoveChild
		(
		iView&		child
		)
{
	int		off , num = m_children.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( ( object )m_children[ off ] == ( object )child )
		{
			m_children.Delete( off );
			break;
		}
	}
	cb_assert( off != num , L"invalid RemoveChild" );
}
//=================================================================================================
//!	require update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RequireUpdate
		(
		const irect&	update , 
		bool			sync
		)
{
	iViewParentCtrl		p	= m_parent.lock();
	if( p == false )
		return;
	irect				u	= update;
	u = u.Move( ivector2( m_rect.xmin , m_rect.ymin ) );
	p->RequireUpdate( u , sync );
}
//=================================================================================================
//!	ToWindow
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call ViewToWindow
		(
		const ivector2&	pos
		)
{
	ivector2	r( pos.x + m_rect.xmin , pos.y + m_rect.ymin );
	iViewParentCtrl		p = m_parent.lock();
	if( p == true )
		r = p->ViewToWindow( r );
	return r;
}
//=================================================================================================
//!	ToScreen
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call ViewToScreen
		(
		const ivector2&	pos
		)
{
	ivector2	r( pos.x + m_rect.xmin , pos.y + m_rect.ymin );
	iViewParentCtrl		p = m_parent.lock();
	if( p == true )
		r = p->ViewToScreen( r );
	return r;
}
//=================================================================================================
//!	WindowToView
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call WindowToView
		(
		const ivector2&	pos
		)
{
	ivector2	r( m_rect.xmin , m_rect.ymin );
	iViewParentCtrl		p = m_parent.lock();
	if( p == true )
		r = p->ViewToWindow( r );
	return pos - r;
}
//=================================================================================================
//!	ScreenToView
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call ScreenToView
		(
		const ivector2&	pos
		)
{
	ivector2	r( m_rect.xmin , m_rect.ymin );
	iViewParentCtrl		p = m_parent.lock();
	if( p == true )
		r = p->ViewToScreen( r );
	return pos - r;
}
// "IViewChildCtrl" interface
public:
//=================================================================================================
//!	Update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Update
		(
		iSurfaceViewport&	surface , 
		const irect&		update
		)
{
	if( m_show == false )
		return;
	// update
	irect	view_v		= irect( ivector2( 0 , 0 ) , m_rect.Size() );
	irect	update_v	= view_v.And( update );
	{
		if( update_v.IsExist() == false )
			return;
		irect	view_w	= ViewToWindow( view_v );
		surface->SetViewport( view_w );
		surface->SetClip( update_v );

		Update_ViewPM	msg;
		msg.m_msg		= Update_ViewMsg;
		msg.m_rect		= update_v;
		msg.m_surface	= (iSurface)surface;
		ViewMsg( &msg );
	}
	
	// update child
	int	c_off , c_num = m_children.GetDatanum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		irect	c_rect	= m_children[ c_off ]->GetRect();
		irect	cc		= update_v;
		cc = cc.Move( ivector2( -c_rect.xmin , -c_rect.ymin ) );
		m_children[ c_off ]->Update( surface , cc );
	}	
}
// "IView" interface functions
public:
//=================================================================================================
//!	create
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Create
		(
		rViewParentCtrl&	parent , 
		const irect&		rect , 
		bool				show = true
		)
{
	{
		iViewParentCtrl		tp = m_parent.lock();
		if( tp == true )
			tp->RemoveChild( ( iView )this_object() );
	}
	m_parent	= parent;
	m_rect		= rect;
	m_show		= show;
	{
		iViewParentCtrl		tp = m_parent.lock();
		if( tp == true )
			tp->RegistChild( ( iView )this_object() );
	}	
	Create_ViewPM	msg;
	msg.m_msg	= Create_ViewMsg;
	msg.m_rect	= rect;
	ViewMsg( &msg );
	
	return true;	
}
//=================================================================================================
//!	show
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Show
		(
		bool	show
		)
{
	if( show == m_show )
		return;
	m_show	= show;
	RequireUpdate( irect( ivector2() , GetRect().Size() ) , false );
}
//=================================================================================================
//!	move
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Move
		(
		const irect&	rect
		)
{
	// require update
	{
		iViewParentCtrl		tp = m_parent.lock();
		if( tp == true )
		{
			tp->RequireUpdate( m_rect , false );
			tp->RequireUpdate( rect , false );
		}
	}
	// move
	m_rect	= rect;
	
	// msg
	Size_ViewPM	msg;
	msg.m_msg	= Size_ViewMsg;
	msg.m_rect	= rect;
	ViewMsg( &msg );
}
//=================================================================================================
//!	get rect
//!	@retval			---
//-------------------------------------------------------------------------------------------------
irect cb_call GetRect()const
{
	return m_rect;
}

// protected functions
protected:
//=================================================================================================
//!	view msg proc
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void ViewMsg
		(
		IViewMsg	*msg
		)
{
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
View() : m_drag( false ) , m_show( false )
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace View;		

#pragma pack( pop )			//release align
