/*************************************************************************************************/
/*!
   	@file		SourceGenGradationRadialCfgView.h
	@author 	Fanzo
 	@date 		2008/6/8
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SourceGenGradationRadialCfgView" class 
**************************************************************************************************/
class SourceGenGradationRadialCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<ColorlistCfgView>	m_color;
	instance<NormTableCfgView>	m_param;
	instance<PaintGradRadial>	m_source;
	
	rControlMsg						m_msg;
	int								m_id;
	
	const int						m_color_w;

	// edit data
	fvector2			m_pos;
	fvector2			m_vec;
	float				m_rate[4];
	const rgba			m_ec;
	const int			m_handle_r;
	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_color->SetColorNum( 4 );
	m_color->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( m_color_w , p->m_rect.Size().height ) )
			);
	m_color->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_color->SetValue( 0 , rgba( 0 , 0 , 0 , 255 ) );
	m_color->SetValue( 1 , rgba( 255 , 255 , 0 , 255 ) );
	m_color->SetValue( 2 , rgba( 0 , 255 , 255 , 255 ) );
	m_color->SetValue( 3 , rgba( 255 , 255 , 255 , 255 ) );
	m_param->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( m_color_w + 5 , 0 ) , isize( p->m_rect.Size().width - m_color_w - 5 , p->m_rect.Size().height ) )
			);
	m_param->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SourceGenGradationRadialCfgView() : 
		m_id( 0 ) , 
		m_color_w( 130 ) , 
		m_vec( 0.0f , -100.0f ) , 
		m_pos( -10.0f , 0.0f ) , 
		m_ec( 121 , 121 , 40 ) , 
		m_handle_r( 5 )
{
	m_rate[0]= 0.0f;
	m_rate[1]= 0.5f;
	m_rate[2]= 0.7f;
	m_rate[3]= 1.0f;
}		
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint GetSourcePaint
		(
		const faffine&	aff
		)
{
	rgba	color[4] = 
			{
			m_color->GetValue( 0 ) , 
			m_color->GetValue( 1 ) , 
			m_color->GetValue( 2 ) , 
			m_color->GetValue( 3 ) 
			};
	m_source->SetGradationVector( aff.Transform( m_pos ) , aff.TransformVec( m_vec ).Length() );
	m_source->SetColorTable( 4 , m_rate , color );
	m_source->SetInterpolateTable( m_param->GetValue_f() );
	return (iPaint)m_source;
}
//=================================================================================================
int GetEditPointNum()
{
	return 4;
}
//=================================================================================================
fvector2 GetEditPoint
		(
		int				off
		)
{
	return m_pos + m_vec * m_rate[ off ];
}
//=================================================================================================
void SetEditPoint
		(
		int				off , 
		fvector2		pnt
		)
{
	if( off == 0 )
		m_pos	= pnt;
	else if( off == 3 )
		m_vec	= pnt - m_pos;
	else
	{
		float		l	= m_vec.Length();
		if( l == 0.0f )
			return;
		fvector2	uv	= m_vec / l;
		float		r	= uv.Inner( pnt - m_pos ) / l;
		r	= r < m_rate[ off - 1 ] ? m_rate[ off - 1 ] : r;
		r	= r > m_rate[ off + 1 ] ? m_rate[ off + 1 ] : r;
		m_rate[ off ]	 = r;
	}
}	
//=================================================================================================
bool SearchEditPoint
		(
		const fvector2&		pnt , 
		int*				pntoff
		)
{
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
	{
		fvector2	p = GetEditPoint( off );
		frect		r( p.x - m_handle_r , p.y - m_handle_r , p.x + m_handle_r , p.y + m_handle_r );
		if( true == r.IsInside( pnt ) )
		{
			*pntoff	= off;
			return true;
		}
	}
	return false;
}
//=================================================================================================
void DrawEditHandle
		(
		const faffine&	aff , 
		iSurfaceDest&	surface
		)
{
	DrawLine( surface , aff.Transform( GetEditPoint( 0 ) ) , aff.Transform( GetEditPoint( 3 ) ) , 1.0f , m_ec );
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
		DrawCircle( surface , aff.Transform( GetEditPoint( off ) ) , ( float )m_handle_r , m_ec );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace SourceGenGradationRadialCfgView;		

#pragma pack( pop )			//release align
