/*************************************************************************************************/
/*!
   	@file		FontCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"FontCfgView" class 
**************************************************************************************************/
class FontCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<SeparateView>	m_color_t;
	instance<ColorCfgView>	m_color;
	instance<SeparateView>	m_height_t;
	instance<SliderCfgView>	m_height;
	instance<SliderCfgView>	m_width;
	instance<SeparateView>	m_style_t;
	instance<CheckCfgView>	m_style;
	instance<SeparateView>	m_type_t;
	instance<RadioGroupView>	m_type;
	instance<SeparateView>	m_face_t;
	instance<RadioGroupView>	m_face;
	instance<SeparateView>	m_gamma_t;
	instance<GammaCfgView>	m_gamma;
	wstring						m_facename[6];
	
	instance<Font>			m_font;
	
	rControlMsg					m_msg;
	int							m_id;
	const int					m_item_h;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	if( id == 1 )
	{
		IFont::FontQuarity	tbl[] = 
		{
			IFont::iCubic , 
			IFont::Default , 
			IFont::Antialias , 
			IFont::Alias , 
			IFont::ClearType , 
		};
		cb_verify( true == m_font->Create( fsize( m_width->GetValue() , m_height->GetValue() )  , m_facename[m_face->GetSelect()] , Roman_FontCharsetType , ( m_style->GetValue(0) == true ? 700 : 400 ) , m_style->GetValue(1) , tbl[ m_type->GetSelect() ] ) );
	}
	m_font->SetGamma( m_gamma->GetValue_i16() );

	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		x = 0 , y = 0;
	m_color_t->SetString( L"color" );
	m_color_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 13 ) ) );
	y += m_color_t->GetRect().Height();

	m_color->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 60 ) ) );
	m_color->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_color->SetValue( rgba( 0 , 0 , 0 , 255 ) );
	y += m_color->GetRect().Height();

	m_style_t->SetString( L"style" );
	m_style_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 13 ) ) );
	y += m_style_t->GetRect().Height();

	m_style->SetCheckNum( 2 );
	m_style->SetString( 0 , L"bold" );
	m_style->SetString( 1 , L"italic" );
	m_style->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 30 ) ) );
	m_style->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	m_style->SetValue( 0 , false );
	m_style->SetValue( 1 , false );
	y += m_style->GetRect().Height();

	x += 100 + 5;	
	y	= 0;
	m_height_t->SetString( L"height/width" );
	m_height_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 150 , 13 ) ) );
	y += m_height_t->GetRect().Height();

	m_height->SetRange( 0.0f , 30.0f );
	m_height->SetValue( 10.0f );
	m_height->SetFormat( L"H:%.2f" );
	m_height->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 150 , 15 ) ) );
	m_height->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_height->GetRect().Height();

	m_width->SetRange( 0.0f , 30.0f );
	m_width->SetValue( 0.0f );
	m_width->SetFormat( L"W:%.2f" );
	m_width->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 150 , 15 ) ) );
	m_width->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_width->GetRect().Height();

	m_type_t->SetString( L"type" );
	m_type_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 150 , 13 ) ) );
	y += m_style_t->GetRect().Height();

	m_type->SetRadioNum( 5 );
	m_type->SetString( 0 , L"icubic" );
	m_type->SetString( 1 , L"GDI default" );
	m_type->SetString( 2 , L"GDI antialias" );
	m_type->SetString( 3 , L"GDI alias" );
	m_type->SetString( 4 , L"GDI cleartype" );
	m_type->SetColumn( 2 );
	m_type->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 150 , 75 ) ) );
	m_type->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_type->GetRect().Height();

	x += 150 + 5;	
	y	= 0;
	m_face_t->SetString( L"face" );
	m_face_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 13 ) ) );
	y += m_style_t->GetRect().Height();

	m_face->SetRadioNum( _countof( m_facename ) );
	int		i;
	for( i = 0 ; i < _countof( m_facename ) ; i++ )
		m_face->SetString( i , m_facename[i] );
	m_face->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , p->m_rect.Height() - y ) ) );
	m_face->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_face->GetRect().Height();

	x += 100 + 5;	
	y	= 0;
	m_gamma_t->SetString( L"gamma" );
	m_gamma_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( p->m_rect.Width() - x , 13 ) ) );
	y += m_gamma_t->GetRect().Height();

	m_gamma->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( p->m_rect.Width() - x , p->m_rect.Height() - y ) ) );
	m_gamma->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	y += m_gamma->GetRect().Height();
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
FontCfgView() : 
		m_item_h( 20 ) , 
		m_id( 0 )
{
	m_facename[0]	= L"Microsoft Sans Serif";
	m_facename[1]	= L"MS UI Gothic";
	m_facename[2]	= L"CI";
	m_facename[3]	= L"MeiryoKe_Gothic";
	m_facename[4]	= L"Papyrus";
	m_facename[5]	= L"Tahoma";
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , m_facename[0] , Roman_FontCharsetType , 400 , false , IFont::iCubic ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
rgba GetColor()
{
	return m_color->GetValue();
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iFont GetValue()
{
	return (iFont)m_font;	
}
};

/**************************************************************************************************
"FontCfgView_gp" class 
**************************************************************************************************/
class FontCfgView_gp : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<SeparateView>	m_color_t;
	instance<ColorCfgView>	m_color;
	instance<SeparateView>	m_height_t;
	instance<SliderCfgView>	m_height;
	instance<SliderCfgView>	m_width;
	instance<SeparateView>	m_style_t;
	instance<CheckCfgView>	m_style;
	instance<SeparateView>	m_type_t;
	instance<RadioGroupView>	m_type;
	instance<SeparateView>	m_face_t;
	instance<RadioGroupView>	m_face;
	wstring						m_facename[6];
	
	iFont_gp					m_font;
	
	rControlMsg					m_msg;
	int							m_id;
	const int					m_item_h;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	if( id == 1 )
	{
		IFont::FontQuarity	tbl[] = 
		{
			IFont::iCubic , 
			IFont::Default , 
			IFont::Antialias , 
			IFont::Alias , 
			IFont::ClearType , 
		};
		m_font	= icubic::CreateFont( fsize( 0.0f , 10.0f ) , m_facename[m_face->GetSelect()].c_str() , Roman_FontCharsetType , ( m_style->GetValue(0) == false ? 400 : 700 ) , m_style->GetValue(1) , tbl[ m_type->GetSelect() ] );
	}
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		x = 0 , y = 0;
	m_color_t->SetString( L"color" );
	m_color_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 13 ) ) );
	y += m_color_t->GetRect().Height();

	m_color->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 60 ) ) );
	m_color->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_color->SetValue( rgba( 0 , 0 , 0 , 255 ) );
	y += m_color->GetRect().Height();

	m_style_t->SetString( L"style" );
	m_style_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 13 ) ) );
	y += m_style_t->GetRect().Height();

	m_style->SetCheckNum( 2 );
	m_style->SetString( 0 , L"bold" );
	m_style->SetString( 1 , L"italic" );
	m_style->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 30 ) ) );
	m_style->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	m_style->SetValue( 0 , false );
	m_style->SetValue( 1 , false );
	y += m_style->GetRect().Height();

	x += 100 + 5;	
	y	= 0;
	m_height_t->SetString( L"height/width" );
	m_height_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 250 , 13 ) ) );
	y += m_height_t->GetRect().Height();

	m_height->SetRange( 0.0f , 50.0f );
	m_height->SetValue( 10.0f );
	m_height->SetFormat( L"H:%.2f" );
	m_height->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 250 , 15 ) ) );
	m_height->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_height->GetRect().Height();

	m_width->SetRange( 0.0f , 50.0f );
	m_width->SetValue( 0.0f );
	m_width->SetFormat( L"W:%.2f" );
	m_width->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 250 , 15 ) ) );
	m_width->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_width->GetRect().Height();

	m_type_t->SetString( L"type" );
	m_type_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 250 , 13 ) ) );
	y += m_style_t->GetRect().Height();

	m_type->SetRadioNum( 5 );
	m_type->SetString( 0 , L"icubic" );
	m_type->SetString( 1 , L"GDI default" );
	m_type->SetString( 2 , L"GDI antialias" );
	m_type->SetString( 3 , L"GDI alias" );
	m_type->SetString( 4 , L"GDI cleartype" );
	m_type->SetColumn( 2 );
	m_type->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 250 , 75 ) ) );
	m_type->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_type->GetRect().Height();

	x += 250 + 5;	
	y	= 0;
	m_face_t->SetString( L"face" );
	m_face_t->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , 13 ) ) );
	y += m_style_t->GetRect().Height();

	m_face->SetRadioNum( _countof( m_facename ) );
	int		i;
	for( i = 0 ; i < _countof( m_facename ) ; i++ )
		m_face->SetString( i , m_facename[i] );
	m_face->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( x , y ) , isize( 100 , p->m_rect.Height() - y ) ) );
	m_face->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	y += m_face->GetRect().Height();
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
FontCfgView_gp() : 
		m_item_h( 20 ) , 
		m_id( 0 )
{
	m_facename[0]	= L"Microsoft Sans Serif";
	m_facename[1]	= L"MS UI Gothic";
	m_facename[2]	= L"CI";
	m_facename[3]	= L"MeiryoKe_Gothic";
	m_facename[4]	= L"Papyrus";
	m_facename[5]	= L"Tahoma";
	m_font	= icubic::CreateFont( fsize( 0.0f , 10.0f ) , m_facename[0].c_str() , Roman_FontCharsetType , 400 , false , IFont::iCubic );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
rgba GetColor()
{
	return m_color->GetValue();
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iFont_gp GetValue
		(
		fsize*		size
		)
{
	m_font->SetFontSize( fsize( m_width->GetValue() , m_height->GetValue() ) );
	return m_font;	
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace FontCfgView;		

#pragma pack( pop )			//release align
