/*************************************************************************************************/
/*!
   	@file		iTreedata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ITreeNode" interface 
***************************************************************************************************/
cb_guid_define( ITreeNode_IID , 0x847005CE , 0x9167403a , 0xBA2FAE7C , 0x302871F4 );
class ITreeNode;
typedef icubic::iface_object< ITreeNode , ITreeNode_IID >		iTreeNode;
typedef icubic::iface_reference< ITreeNode , ITreeNode_IID >	rTreeNode;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ITreeNode
{
public:
//=================================================================================================
//!	don,t parent link
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetParentWithoutLink
		(
		iTreeNode&		parent
		) = 0;
//=================================================================================================
//!	get parent
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iTreeNode cb_call GetParent() = 0;
//=================================================================================================
//!	get childnum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetChildnum() = 0;
//=================================================================================================
//!	get child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iTreeNode cb_call GetChild
		(
		int		childoff
		) = 0;
//=================================================================================================
//!	insert child
//!	@retval			if error , return -1
//-------------------------------------------------------------------------------------------------
virtual
int cb_call InsertChild
		(
		iTreeNode&		child , 
		int				insertpos
		) = 0;
//=================================================================================================
//!	search child
//!	@retval			if not exist return -1
//-------------------------------------------------------------------------------------------------
virtual
int cb_call SearchChild
		(
		iTreeNode&		child
		) = 0;
//=================================================================================================
//!	remove child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call RemoveChild
		(
		int		childoff
		) = 0;
//=================================================================================================
//!	remove
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Remove() = 0;
//=================================================================================================
//!	search node
//!	@retval			if exist return true.
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Search
		(
		iTreeNode&		node
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
