/*************************************************************************************************/
/*!
   	@file		iPaint.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IPaint" interface 
***************************************************************************************************/
cb_guid_define( IPaint_IID , 0xAB43AA2C , 0x7D0C435d , 0x8210854C , 0xF3CD4CA0 );
class IPaint;
typedef icubic::iface_object< IPaint , IPaint_IID >		iPaint;
typedef icubic::iface_reference< IPaint , IPaint_IID >	rPaint;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPaint
{
public:
	enum Type
	{
		Color , 
		Image , 
	};
public:
//=================================================================================================
//!	get generate format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
Type cb_call PaintType() = 0;
//=================================================================================================
//!	gen source
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
rgba cb_call PaintColor() = 0;
//=================================================================================================
//!	get default pixel format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
pixelformat	cb_call PaintImageFormat() = 0;
//=================================================================================================
//!	begin source image
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call BeginPaintImage() = 0;
//=================================================================================================
//!	gen source
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call PaintImage
		(
		void				*image , 
		int					pixlen , 
		const fvector2&		sp ,		//!< [in] device unit
		const fvector2&		tp			//!< [in] device unit
		) = 0;
//=================================================================================================
//!	end source image
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call EndPaintImage() = 0;
};

/**************************************************************************************************
 "IPaintSolidColor" interface 
***************************************************************************************************/
cb_guid_define( IPaintSolidColor_IID , 0xA0D91EC5 , 0xA75749a6 , 0xB5938A93 , 0x45BF0A09 );
class IPaintSolidColor;
typedef icubic::iface_object< IPaintSolidColor , IPaintSolidColor_IID >		iPaintSolidColor;
typedef icubic::iface_reference< IPaintSolidColor , IPaintSolidColor_IID >	rPaintSolidColor;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPaintSolidColor : public IPaint
{
public:
//=================================================================================================
//!	set color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetColor
		(
		const rgba&	color
		) = 0;
//=================================================================================================
//!	get color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
rgba cb_call GetColor() = 0;
};
/**************************************************************************************************
 "IPaintGradLinear" interface 
***************************************************************************************************/
cb_guid_define( IPaintGradLinear_IID , 0xFBCF5383 , 0x3A6F4559 , 0x8794D922 , 0xF976795E );
class IPaintGradLinear;
typedef icubic::iface_object< IPaintGradLinear , IPaintGradLinear_IID >		iPaintGradLinear;
typedef icubic::iface_reference< IPaintGradLinear , IPaintGradLinear_IID >	rPaintGradLinear;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPaintGradLinear : public IPaint
{
public:
//=================================================================================================
//!	set transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTransform
		(
		const faffine&	trans
		) = 0;
//=================================================================================================
//!	get transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call GetTransform() = 0;
//=================================================================================================
//!	set gradation vector
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call SetGradationVector
		(
		const fvector2	&start_pos , 
		const fvector2	&target_pos
		) = 0;
//=================================================================================================
//!	get gradation
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call GetGradationVector
		(
		fvector2*	start , 
		fvector2*	target
		) = 0;
//=================================================================================================
//!	set color tbl
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call SetColorTable
		(
		int			num , 
		const float	rate[] ,		//!< [in] it need to be 0.0 - 1.0
		const rgba	color[]
		) = 0;
//=================================================================================================
//!	get color tablenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetColorTableNum() = 0;
//=================================================================================================
//!	get color tablenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call GetColorTable
		(
		float	rate[] , 
		rgba	color[]
		) = 0;
};
/**************************************************************************************************
 "IPaintGradRadial" interface 
***************************************************************************************************/
cb_guid_define( IPaintGradRadial_IID , 0x5D3ADA75 , 0x65F347a1 , 0x9223CDE5 , 0x9DC2D6C6 );
class IPaintGradRadial;
typedef icubic::iface_object< IPaintGradRadial , IPaintGradRadial_IID >		iPaintGradRadial;
typedef icubic::iface_reference< IPaintGradRadial , IPaintGradRadial_IID >	rPaintGradRadial;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPaintGradRadial : public IPaint
{
public:
//=================================================================================================
//!	set transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTransform
		(
		const faffine&	trans
		) = 0;
//=================================================================================================
//!	get transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call GetTransform() = 0;
//=================================================================================================
//!	set gradation vector
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call SetGradationVector
		(
		const fvector2	&center_pos , 
		float			length
		) = 0;
//=================================================================================================
//!	get gradation vector
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call GetGradationVector
		(
		fvector2	*center_pos , 
		float		*length
		) = 0;
//=================================================================================================
//!	set color tbl
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call SetColorTable
		(
		int			num , 
		const float	rate[] ,		//!< [in] it need to be 0.0 - 1.0
		const rgba	color[]
		) = 0;
//=================================================================================================
//!	get color tablenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetColorTableNum() = 0;
//=================================================================================================
//!	get color tablenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call GetColorTable
		(
		float	rate[] , 
		rgba	color[]
		) = 0;
};
/**************************************************************************************************
 "IPaintTexture" interface 
***************************************************************************************************/
cb_guid_define( IPaintTexture_IID , 0xB1B97837 , 0x695D4169 , 0xA7B10919 , 0xC83FED46 );
class IPaintTexture;
typedef icubic::iface_object< IPaintTexture , IPaintTexture_IID >		iPaintTexture;
typedef icubic::iface_reference< IPaintTexture , IPaintTexture_IID >	rPaintTexture;

///////////////////////////////////////////////////////////////////////////////////////////////////
class ITexture_IID;
class ITexture;
typedef icubic::iface_object< ITexture , ITexture_IID >		iTexture;
typedef icubic::iface_reference< ITexture , ITexture_IID >	rTexture;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPaintTexture : public IPaint
{
public:
//=================================================================================================
//!	set texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTexture
		(
		iTexture	&gen
		) = 0;
//=================================================================================================
//!	release texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleaseTexture() = 0;
//=================================================================================================
//!	set transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTransform
		(
		const faffine&		trans
		) = 0;
//=================================================================================================
//!	get transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call GetTransform()const = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
