/*************************************************************************************************/
/*!
   	@file		ParserSVG.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<boost/preprocessor.hpp>
#include	<xercesc/parsers/XercesDOMParser.hpp>
#include	<xercesc/dom/DOM.hpp>
#include	<xercesc/dom/DOMNode.hpp>
#include	<xercesc/util/XMLString.hpp>
#include	<xercesc/util/PlatformUtils.hpp>
#include	<xercesc/util/BinInputStream.hpp>
#include	<xercesc/sax/HandlerBase.hpp>
#include	<xercesc/sax/InputSource.hpp>
#include	<xercesc/framework/LocalFileFormatTarget.hpp>
#include	<sstream>
#include	<iomanip>

#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace XERCES_CPP_NAMESPACE;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

/**************************************************************************************************
 enum parse class define
**************************************************************************************************/
#define		df_enum_class_enum_elem( _ , __ , ___ , t_elem )									\
BOOST_PP_SEQ_ELEM(1,t_elem) , 

#define		df_enum_class_table_elem( _ , __ , ___ , t_elem )									\
ConvertTable<Type>( BOOST_PP_SEQ_ELEM(0,t_elem) , BOOST_PP_SEQ_ELEM(1,t_elem) ) , 

//=================================================================================================
//t_name
//t_init		value
//t_enums		((L"name")(value))...((L"name")(value))
//=================================================================================================
#define		df_enum_class( t_name , t_init , t_enums )											\
class BOOST_PP_CAT( t_name , _svgv ) : protected Parser											\
{																								\
public:																							\
	enum Type																					\
	{																							\
		BOOST_PP_SEQ_FOR_EACH_I( df_enum_class_enum_elem , _ , t_enums )						\
	};																							\
	Type		m_type;																			\
	BOOST_PP_CAT( t_name , _svgv )() : m_type( t_init ){}										\
	bool StringTo																				\
			(																					\
			const wstring&	str ,																\
			int*			pos																	\
			)																					\
	{																							\
		if( false == Parse( str , pos ) )														\
			return false;																		\
		return true;																			\
	}																							\
	wstring ToString()																			\
	{																							\
		wostringstream os;																		\
		os << MatchTable( TblPtr() , TblNum() , m_type );										\
		return os.str();																		\
	}																							\
private:																						\
	parse_map_start()																			\
	parse_map_edge( start_node_id , end_node_id , parse )										\
	parse_map_end()																				\
																								\
	const ConvertTable<Type>* TblPtr()															\
	{																							\
		static																					\
		const ConvertTable<Type>	tbl[] =														\
		{																						\
			BOOST_PP_SEQ_FOR_EACH_I( df_enum_class_table_elem , _ , t_enums )					\
		};																						\
		return tbl;																				\
	}																							\
	int TblNum()																				\
	{																							\
		return BOOST_PP_SEQ_SIZE( t_enums );													\
	}																							\
	bool parse																					\
			(																					\
			const wstring&	str ,																\
			int*			pos ,																\
			int*			errpos																\
			)																					\
	{																							\
		df_skip_space();																		\
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )					\
			return false;																		\
		return true;																			\
	}																							\
};


/**************************************************************************************************
 attribute class define
**************************************************************************************************/
#define		df_attribute_enum_class_elem(_ , __ , t_elem)																					\
df_enum_class( BOOST_PP_SEQ_ELEM(2,t_elem) , BOOST_PP_SEQ_ELEM(4,t_elem) , BOOST_PP_SEQ_ELEM(5,t_elem) )

#define		df_attribute_var_collect(_ , __ , t_i , t_elem)											\
public BOOST_PP_CAT( t_elem , _svga ) , 

#define		df_attribute_superhook(_ , __ , t_i , t_elem)											\
super_hook( BOOST_PP_CAT( t_elem , _svga ) )														

#define		df_attribute_var_elem(_ , __ , t_elem)																							\
BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(0,t_elem) , <BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(2,t_elem) , _svgv )> )	BOOST_PP_SEQ_ELEM(3,t_elem);

#define		df_attribute_var_enum(_ , __ , t_elem)																							\
BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(0,t_elem) , <BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(2,t_elem) , _svgv )> )	BOOST_PP_SEQ_ELEM(3,t_elem);

#define		df_attribute_setxml_elem(_ , __ , t_elem)												\
BOOST_PP_CAT(df_ , BOOST_PP_SEQ_ELEM(0,t_elem) )_setxml( BOOST_PP_SEQ_ELEM(1,t_elem) , BOOST_PP_SEQ_ELEM(3,t_elem) , BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(2,t_elem) , _svgv ) , att , style );

#define		df_attribute_setxml_enum(_ , __ , t_elem)												\
BOOST_PP_CAT(df_ , BOOST_PP_SEQ_ELEM(0,t_elem) )_setxml( BOOST_PP_SEQ_ELEM(1,t_elem) , BOOST_PP_SEQ_ELEM(3,t_elem) , BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(2,t_elem) , _svgv ) , att , style );

#define		df_attribute_setxml_collect(_ , __ , t_elem)											\
{																									\
	BOOST_PP_CAT( t_elem , _svga )	parse;															\
	if( false == BOOST_PP_CAT( t_elem , _svga )::SetXml( att , style ) )							\
		return false;																				\
}

#define		df_attribute_storexml_elem(_ , __ , t_elem)												\
BOOST_PP_CAT(df_ , BOOST_PP_SEQ_ELEM(0,t_elem) )_storexml( BOOST_PP_SEQ_ELEM(1,t_elem) , BOOST_PP_SEQ_ELEM(3,t_elem) , node );

#define		df_attribute_storexml_enum(_ , __ , t_elem)												\
BOOST_PP_CAT(df_ , BOOST_PP_SEQ_ELEM(0,t_elem) )_storexml( BOOST_PP_SEQ_ELEM(1,t_elem) , BOOST_PP_SEQ_ELEM(3,t_elem) , node );

#define		df_attribute_storexml_collect(_ , __ , t_elem)											\
{																									\
	if( false == BOOST_PP_CAT( t_elem , _svga )::StoreXml( node ) )									\
		return false;																				\
}

//=================================================================================================
//t_name
//t_iid			(0xFABCE987)(0x0BC94d01)(0xAB6A3112)(0xF9679BD0)
//t_collects	(class1)(class2)
//t_elems		((implied)(L"tagname")(classname)(variablename))
//t_enums		((implied)(L"tagname")(classname)(variablename)(init)(((L"tag")(value))...((L"tag")(value))))
//=================================================================================================
#define		df_attribute_class( t_name , t_iid , t_collects , t_elems , t_enums )					\
BOOST_PP_SEQ_FOR_EACH( df_attribute_enum_class_elem , _ , t_enums )									\
cb_guid_define( t_name##_svga_IID , BOOST_PP_SEQ_ELEM(0,t_iid) , BOOST_PP_SEQ_ELEM(1,t_iid) , BOOST_PP_SEQ_ELEM(2,t_iid) , BOOST_PP_SEQ_ELEM(3,t_iid) );		\
class t_name##_svga;																				\
typedef icubic::iface_object< t_name##_svga , t_name##_svga_IID >		i##t_name##_svga;			\
typedef icubic::iface_reference< t_name##_svga , t_name##_svga_IID >	r##t_name##_svga;			\
class t_name##_svga : 																				\
		BOOST_PP_SEQ_FOR_EACH_I( df_attribute_var_collect , _ , t_collects )						\
		public virtual object_base																	\
{																									\
	query_begin();																					\
	iface_hook( t_name##_svga , t_name##_svga_IID )													\
	BOOST_PP_SEQ_FOR_EACH_I( df_attribute_superhook , _ , t_collects )								\
	query_null_end();																				\
																									\
public:																								\
	BOOST_PP_SEQ_FOR_EACH( df_attribute_var_elem , _ , t_elems )									\
	BOOST_PP_SEQ_FOR_EACH( df_attribute_var_enum , _ , t_enums )									\
	bool SetXml																						\
			(																						\
			DOMNamedNodeMap*	att ,																\
			Style_svgv*			style																\
			)																						\
	{																								\
		BOOST_PP_SEQ_FOR_EACH( df_attribute_setxml_elem , _ , t_elems )								\
		BOOST_PP_SEQ_FOR_EACH( df_attribute_setxml_enum , _ , t_enums )								\
		BOOST_PP_SEQ_FOR_EACH( df_attribute_setxml_collect , _ , t_collects )						\
		return true;																				\
	}																								\
	bool StoreXml																					\
			(																						\
			DOMElement*					node														\
			)																						\
	{																								\
		BOOST_PP_SEQ_FOR_EACH( df_attribute_storexml_elem , _ , t_elems )							\
		BOOST_PP_SEQ_FOR_EACH( df_attribute_storexml_enum , _ , t_enums )							\
		BOOST_PP_SEQ_FOR_EACH( df_attribute_storexml_collect , _ , t_collects )						\
		return true;																				\
	}																								\
};

//=================================================================================================
// setxml/storexml
//=================================================================================================
#define		df_implied_setxml( t_attname , t_variable , t_parse , map , t_style )		\
{																						\
	DOMNode*	node = map->getNamedItem( t_attname );									\
	if( node != 0 && node->getNodeType() == node->ATTRIBUTE_NODE )						\
	{																					\
		t_parse		parse;																\
		wstring		value = wstring( node->getNodeValue() );							\
		if( value != L"" && true == parse.StringTo( value , 0 ) )						\
			t_variable.Set( parse );													\
	}																					\
	if( t_style != 0 )																	\
	{																					\
		t_parse		parse;																\
		wstring		value = t_style->GetValue( t_attname );								\
		if( value != L"" && true == parse.StringTo( value , 0 ) )						\
			t_variable.Set( parse );													\
	}																					\
}
#define		df_required_setxml( t_attname , t_variable , t_parse , map , t_style )		\
{																						\
	DOMNode*	node = map->getNamedItem( t_attname );									\
	if( node != 0 && node->getNodeType() == node->ATTRIBUTE_NODE )						\
	{																					\
		t_parse		parse;																\
		wstring		value = wstring( node->getNodeValue() );							\
		if( value != L"" && true == parse.StringTo( value , 0 ) )						\
			t_variable.Set( parse );													\
	}																					\
	if( t_style != 0 )																	\
	{																					\
		t_parse		parse;																\
		wstring		value = t_style->GetValue( t_attname );								\
		if( value != L"" && true == parse.StringTo( value , 0 ) )						\
			t_variable.Set( parse );													\
	}																					\
	if( t_variable == false )															\
		return false;																	\
}
#define		df_implied_storexml( t_attname , t_variable , node )						\
{																						\
	if( t_variable == true )															\
	{																					\
		node->setAttribute( t_attname , t_variable->ToString().c_str() );				\
	}																					\
}

#define		df_required_storexml( t_attname , t_variable , node )						\
{																						\
	node->setAttribute( t_attname , t_variable->ToString().c_str() );					\
}


/**************************************************************************************************
 element class define
**************************************************************************************************/
//=================================================================================================
//t_name		name
//t_tagname		L"tag"
//t_attr_iid	(0xFABCE987)(0x0BC94d01)(0xAB6A3112)(0xF9679BD0)
//t_iid			(0xFABCE987)(0x0BC94d01)(0xAB6A3112)(0xF9679BD0)
//t_attclasses	(class1)(class2)
//t_attelems	((implied)(L"tagname")(parser)(variablename))
//t_enums		((implied)(L"tagname")(classname)(variablename)(init)(((L"tag")(value))...((L"tag")(value))))
//=================================================================================================
#define		df_element_class( t_name , t_tagname , t_attr_iid , t_iid , t_attclasses , t_attelems , t_enums )			\
df_attribute_class( t_name , t_attr_iid , t_attclasses , t_attelems , t_enums )											\
cb_guid_define( I##t_name##_svg_IID , BOOST_PP_SEQ_ELEM(0,t_iid) , BOOST_PP_SEQ_ELEM(1,t_iid) , BOOST_PP_SEQ_ELEM(2,t_iid) , BOOST_PP_SEQ_ELEM(3,t_iid) );		\
class I##t_name##_svg;																									\
typedef icubic::iface_object< I##t_name##_svg , I##t_name##_svg_IID >		i##t_name##_svg;							\
typedef icubic::iface_reference< I##t_name##_svg , I##t_name##_svg_IID >	r##t_name##_svg;							\
class I##t_name##_svg : public t_name##_svga																			\
{																														\
public:																													\
};																														\
class t_name##_svg : public Element_svge , public I##t_name##_svg														\
{																														\
	query_begin();																										\
	iface_hook( I##t_name##_svg , I##t_name##_svg_IID )																	\
	super_hook( t_name##_svga )																							\
	query_end( Element_svge );																							\
public:																													\
t_name##_svg() : Element_svge( t_tagname ){}																			\
bool cb_call SetXml																										\
		(																												\
		ICmdStack_svg*						stack ,																		\
		XERCES_CPP_NAMESPACE::DOMNode*		node																		\
		);																												\
bool cb_call StoreXml																									\
		(																												\
		ICmdStack_svg*						stack ,																		\
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,																		\
		XERCES_CPP_NAMESPACE::DOMNode*		parent																		\
		);																												\
bool cb_call StoreXml_root																								\
		(																												\
		ICmdStack_svg*						stack ,																		\
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,																		\
		XERCES_CPP_NAMESPACE::DOMElement*	node																		\
		);																												\
};

#define		df_element_setxml_child_elem(_ , __ , t_i , t_elem)															\
	BOOST_PP_EXPR_IF( BOOST_PP_NOT_EQUAL( t_i , 0 ) , else ) if( ctag == BOOST_PP_SEQ_ELEM(1,t_elem) )					\
	{																													\
		instance<BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(0,t_elem) , _svg )>	obj;											\
		stack->PushCmd( c , (iSvgXml)obj );																				\
		InsertChild( (iTreeNode)obj , GetChildnum() );																	\
	}																													\

#define		df_element_setxml_child_text_elem(_ , __ , t_i , t_elem)													\
	BOOST_PP_EXPR_IF( BOOST_PP_NOT_EQUAL( t_i , 0 ) , else ) if( wstring( L"#PCDATA" ) == BOOST_PP_SEQ_ELEM(1,t_elem) )	\
	{																													\
		instance<BOOST_PP_CAT( BOOST_PP_SEQ_ELEM(0,t_elem) , _svg )>	obj;											\
		stack->PushCmd( c , (iSvgXml)obj);																				\
		InsertChild( (iTreeNode)obj , GetChildnum() );																	\
	}

//=================================================================================================
//t_name		name
//t_tagname		L"tag"
//t_children	((Svg)(L"svg"))((Svg)(L"svg"))
//=================================================================================================
#define		df_element_function( t_name , t_tagname , t_children )										\
cb_inline																								\
bool cb_call t_name##_svg::SetXml																		\
		(																								\
		ICmdStack_svg*						stack ,														\
		XERCES_CPP_NAMESPACE::DOMNode*		node														\
		)																								\
{																										\
	if( wstring( node->getNodeName() ) != t_tagname )													\
		return false;																					\
	Style_svgv*		pstyle = 0;																			\
	Style_svgv		style;																				\
	DOMNamedNodeMap*	attlist = node->getAttributes();												\
	{																									\
		DOMNode*			att		= ( attlist == 0 ) ? 0 : attlist->getNamedItem( L"style" );			\
		if( att != 0 && att->getNodeType() == att->ATTRIBUTE_NODE )										\
		{																								\
			if( true == style.StringTo( wstring(att->getNodeValue()) , 0 ) )							\
				pstyle	= &style;																		\
		}																								\
	}																									\
	{																									\
		if( false == BOOST_PP_CAT( t_name , _svga )::SetXml( attlist , pstyle ) )						\
			return false;																				\
	}																									\
	DOMNodeList* children = node->getChildNodes();														\
	if( children != 0 )																					\
	{																									\
		int32		off;																				\
		for( off = children->getLength() - 1 ; off >= 0 ; off-- )										\
		{																								\
			DOMNode* c = ( DOMNode* )children->item( off );												\
			if( c->getNodeType() == c->ELEMENT_NODE )													\
			{																							\
				wstring	ctag( c->getNodeName() );														\
				BOOST_PP_SEQ_FOR_EACH_I( df_element_setxml_child_elem , _ , t_children )				\
			}																							\
			else if( c->getNodeType() == c->TEXT_NODE )													\
			{																							\
				BOOST_PP_SEQ_FOR_EACH_I( df_element_setxml_child_text_elem , _ , t_children )			\
			}																							\
		}																								\
	}																									\
	return true;																						\
}																										\
cb_inline																								\
bool cb_call t_name##_svg::StoreXml																		\
		(																								\
		ICmdStack_svg*						stack ,														\
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,														\
		XERCES_CPP_NAMESPACE::DOMNode*		parent														\
		)																								\
{																										\
	DOMElement*  node = doc->createElement( t_tagname );												\
	parent->appendChild( node );																		\
	{																									\
		if( false == BOOST_PP_CAT( t_name , _svga )::StoreXml( node ) )									\
			return false;																				\
	}																									\
	int		c_off , c_num = GetChildnum();																\
	for( c_off = c_num - 1 ; c_off >= 0 ; c_off-- )														\
	{																									\
		iSvgXml	c = (iSvgXml)GetChild( c_off );															\
		if( c == true )																					\
			stack->PushCmd( node , c );																	\
	}																									\
	return true;																						\
}																										\
cb_inline																								\
bool cb_call t_name##_svg::StoreXml_root																\
		(																								\
		ICmdStack_svg*						stack ,														\
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,														\
		XERCES_CPP_NAMESPACE::DOMElement*	node														\
		)																								\
{																										\
	{																									\
		if( false == BOOST_PP_CAT( t_name , _svga )::StoreXml( node ) )									\
			return false;																				\
	}																									\
	int		c_off , c_num = GetChildnum();																\
	for( c_off = c_num - 1 ; c_off >= 0 ; c_off-- )														\
	{																									\
		iSvgXml	c = (iSvgXml)GetChild( c_off );															\
		if( c == true )																					\
			stack->PushCmd( node , c );																	\
	}																									\
	return true;																						\
}


/**************************************************************************************************
 table function
**************************************************************************************************/
#define		df_table_func_elem(_ , t_type , t_elem)														\
	ConvertTable<t_type>( BOOST_PP_SEQ_ELEM(0,t_elem) , BOOST_PP_SEQ_ELEM(1,t_elem) ) , 

//=================================================================================================
// t_type		enum
// t_func		funcname
// t_table		((L"name")(value)) ... ((L"name")(value))
//=================================================================================================
#define		df_table_func( t_type , t_func , t_table )													\
const ConvertTable<t_type>*	t_func##Ptr()																\
{																										\
	static																								\
	const ConvertTable<t_type>	tbl[] =																	\
	{																									\
		BOOST_PP_SEQ_FOR_EACH( df_table_func_elem , t_type , t_table )									\
	};																									\
	return tbl;																							\
}																										\
int	t_func##Num()																						\
{																										\
	return BOOST_PP_SEQ_SIZE( t_table );																\
}

/**************************************************************************************************
 support function define
**************************************************************************************************/
#define		df_list_operator_svgv( t_type )																\
t_type##_svgv& operator=																				\
	(																									\
	const t_type##_svgv& obj																			\
	)																									\
{																										\
	m_list.Copy( obj.m_list );																			\
	return *this;																						\
}
#define		df_stringto_svgv()																	\
bool StringTo																					\
		(																						\
		const wstring&	str ,																	\
		int*			pos																		\
		)																						\
{																								\
	if( false == Parse( str , pos ) )															\
		return false;																			\
	return true;																				\
}																								\

/**************************************************************************************************
 support function define
**************************************************************************************************/
#define		df_skip_space()											\
{																	\
	SkipSpaceParser		parse;										\
	if( false == parse.Parse( str , pos , errpos ) )				\
		return false;												\
}
#define		df_skip_delimiter()										\
{																	\
	Delimiter		parse;											\
	parse.Parse( str , pos , errpos );								\
}
#define		df_match_string( regex )								\
{																	\
	if( false == MatchString( str , pos , regex , 0 ) )				\
		return false;												\
}
#define		df_delimiter()											\
{																	\
	Delimiter		parse;											\
	if( false == parse.Parse( str , pos , errpos ) )				\
		return false;												\
}
#define		df_delimiter_r( rv )									\
{																	\
	Delimiter		parse;											\
	if( false == parse.Parse( str , pos , errpos ) )				\
		return rv;													\
}
#define		df_number( v )											\
{																	\
	Number_svgv		parse;											\
	if( false == parse.StringTo( str , pos ) )						\
		return false;												\
	v	= parse.m_value;											\
}
#define		df_number_r( v , rv )									\
{																	\
	Number_svgv		parse;											\
	if( false == parse.StringTo( str , pos ) )						\
		return rv;													\
	v	= parse.m_value;											\
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// interface define

/**************************************************************************************************
 "IElement_svg" interface 
***************************************************************************************************/
cb_guid_define( IElement_svg_IID , 0xA4CDC246 , 0x905741ee , 0xB3951827 , 0x9DF872F0 );
class IElement_svg;
typedef icubic::iface_object< IElement_svg , IElement_svg_IID >		iElement_svg;
typedef icubic::iface_reference< IElement_svg , IElement_svg_IID >	rElement_svg;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IElement_svg : public ITreeNode
{
public:
//=================================================================================================
//!	get name
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
wstring cb_call GetTagName() = 0;
};
/**************************************************************************************************
 "ISvgXml" interface 
***************************************************************************************************/
cb_guid_define( ISvgXml_IID , 0xE4C880CD , 0x66DB46b6 , 0x923B676F , 0x4F7301FF );
class ISvgXml;
typedef icubic::iface_object< ISvgXml , ISvgXml_IID >		iSvgXml;
typedef icubic::iface_reference< ISvgXml , ISvgXml_IID >	rSvgXml;
class ICmdStack_svg;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISvgXml
{
public:
//=================================================================================================
//!	load
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call SetXml
		(
		ICmdStack_svg*						stack , 
		XERCES_CPP_NAMESPACE::DOMNode*		node
		) = 0;
//=================================================================================================
//!	save
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call StoreXml
		(
		ICmdStack_svg*						stack ,
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
		XERCES_CPP_NAMESPACE::DOMNode*		parent
		) = 0;
//=================================================================================================
//!	save
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call StoreXml_root
		(
		ICmdStack_svg*						stack ,
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
		XERCES_CPP_NAMESPACE::DOMElement*	node
		) = 0;
};
/**************************************************************************************************
 "ICmdStack_svg" interface 
***************************************************************************************************/
cb_guid_define( ICmdStack_svg_IID , 0x1C57A53C , 0x5CB542c7 , 0xB3EEF92D , 0x720E864D );
class ICmdStack_svg;
typedef icubic::iface_object< ICmdStack_svg , ICmdStack_svg_IID >		iCmdStack_svg;
typedef icubic::iface_reference< ICmdStack_svg , ICmdStack_svg_IID >	rCmdStack_svg;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ICmdStack_svg
{
public:
//=================================================================================================
//!	push cmd
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call PushCmd
		(
		XERCES_CPP_NAMESPACE::DOMNode*		node , 
		iSvgXml&							obj
		) = 0;
};
/**************************************************************************************************
"Element_svge" class 
**************************************************************************************************/
class Element_svge : public t_TreeNode<IElement_svg> , public ISvgXml
{
// query
	query_begin();
	iface_hook( IElement_svg , IElement_svg_IID )
	iface_hook( ISvgXml , ISvgXml_IID )
	query_end( t_TreeNode<IElement_svg> );

// variable member
private:
	const wstring		m_tagname;
	
// "ISVGElement" interface function
//=================================================================================================
//!	get name
//!	@retval			---
//-------------------------------------------------------------------------------------------------
wstring cb_call GetTagName()
{
	return m_tagname;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Element_svge
		(
		const wchar_t*	name
		) : m_tagname( name )
{
}
};
/**************************************************************************************************
"CmdStack_svg" class 
**************************************************************************************************/
class CmdStack_svg : public ICmdStack_svg
{
	class StackData
	{
	public:
		XERCES_CPP_NAMESPACE::DOMNode*		m_node;
		iSvgXml								m_obj;
		StackData() : m_node( 0 ){}
	};
	Stackdata<StackData>	m_stack;
	
// "ICmdStack_svg" interface functions
public:
//=================================================================================================
void cb_call PushCmd
		(
		XERCES_CPP_NAMESPACE::DOMNode*		node , 
		iSvgXml&							obj
		)
{
	m_stack.Push();
	m_stack->m_node = node;
	m_stack->m_obj	= obj;
}
// public functions
public:
//=================================================================================================
bool PopCmd
		(
		XERCES_CPP_NAMESPACE::DOMNode**		node , 
		iSvgXml*							obj
		)
{
	if( m_stack.GetDatanum() == 0 )
		return false;
	*node	= m_stack->m_node;
	*obj	= m_stack->m_obj;
	m_stack.Pop();
	return true;
}
};
/**************************************************************************************************
"PCDATA_svge" class 
**************************************************************************************************/
cb_guid_define( IPCDATA_svge_IID , 0x6C271C67 , 0xB26B4385 , 0x89ADC72D , 0x8BDFB967 );
class IPCDATA_svge;
typedef icubic::iface_object< IPCDATA_svge , IPCDATA_svge_IID >		iPCDATA_svge;
typedef icubic::iface_reference< IPCDATA_svge , IPCDATA_svge_IID >	rPCDATA_svge;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPCDATA_svge
{
public:
	wstring		m_text;
};
class PCDATA_svg : public Element_svge , public IPCDATA_svge
{
	query_begin();
	iface_hook( IPCDATA_svge , IPCDATA_svge_IID )
	query_end( Element_svge );
public:
PCDATA_svg() : Element_svge( L"#PCDATA" ){}
bool cb_call SetXml
		(
		ICmdStack_svg*	stack , 
		DOMNode*		node
		)
{
	if( node->getNodeType() != node->TEXT_NODE )
		return false;
	m_text	= wstring( node->getTextContent() );
	return true;
}
bool cb_call StoreXml
		(
		ICmdStack_svg*						stack ,
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
		XERCES_CPP_NAMESPACE::DOMNode*		parent
		)
{
	DOMText*    node = doc->createTextNode( m_text.c_str() );
	parent->appendChild( node );
	return true;
}
bool cb_call StoreXml_root
		(
		ICmdStack_svg*						stack ,
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
		XERCES_CPP_NAMESPACE::DOMElement*	bnode
		)
{
	DOMText*    node = doc->createTextNode( m_text.c_str() );
	bnode->appendChild( node );
	return false;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// support class

/**************************************************************************************************
"att_element" class 
**************************************************************************************************/
template<class t_class>
class att_element
{
// variable member
private:
	bool		m_set;
	t_class		m_value;

// public functions
public:
//=================================================================================================
att_element
		(
		const att_element<t_class>&	obj
		) : m_set( obj.m_set ) , m_value( obj.m_value )
{
}
//=================================================================================================
att_element
		(
		bool	set
		) : m_set( set )
{
}
//=================================================================================================
operator bool()const
{
	return m_set;
}
//=================================================================================================
const t_class* operator->()const
{
	cb_assert( m_set == true , L"data accessed without set." );
	return &m_value;
}
//=================================================================================================
t_class* operator->()
{
	cb_assert( m_set == true , L"data accessed without set." );
	return &m_value;
}
//=================================================================================================
t_class& operator*()
{
	cb_assert( m_set == true , L"data accessed without set." );
	return m_value;
}
//=================================================================================================
const t_class& operator*()const
{
	cb_assert( m_set == true , L"data accessed without set." );
	return m_value;
}
//=================================================================================================
void Set
		(
		const t_class&	v
		)
{
	m_set	= true;
	m_value	= v;
}
};
/**************************************************************************************************
"required" class 
**************************************************************************************************/
template<class t_class>
class required : public att_element<t_class>
{
public:
//=================================================================================================
required() : att_element<t_class>( true )
{
}
};
/**************************************************************************************************
"implied" class 
**************************************************************************************************/
template<class t_class>
class implied : public att_element<t_class>
{
public:
//=================================================================================================
implied() : att_element<t_class>( false )
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// parser classes define

//-------------------------------------------------------------------------------------------------
class Delimiter : public Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_comma )
	parse_map_edge( start_node_id , end_node_id , parse_space )
	parse_map_end()
	bool parse_comma
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		if( str[*pos] != L',' )
			return false;
		*pos += 1;
		df_skip_space();
		return true;
	}
	bool parse_space
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		{
			SpaceParser		parse;
			if( false == parse.Parse( str , pos , errpos ) )
				return false;
		}
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Integer_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		IntegerParser<10>	parse;
		if( false == parse.Parse( str , pos , errpos ) )
			return false;
		m_value	= parse.m_value;
		return true;
	}
public:
	long	m_value;
	
	Integer_svgv() : m_value( 0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value;
		return os.str();
	}
};
//-------------------------------------------------------------------------------------------------
class Number_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		{
			RealParser	parse;
			if( false == parse.Parse( str , pos , errpos ) )
				return false;
			m_value	= parse.m_value;
		}
		return true;
	}
public:
	double	m_value;
	
	Number_svgv() : m_value( 0.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value;
		return os.str();
	}
};
//-------------------------------------------------------------------------------------------------
class Cdata_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchString( str , pos , L"[.]+" , &m_value ) )
			return false;
		return true;
	}
public:
	wstring		m_value;
	
	df_stringto_svgv();
	wstring ToString()
	{
		return m_value;
	}
};
//-------------------------------------------------------------------------------------------------
class Nmtoken_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		if( false == MatchString( str , pos , L"[A-Za-z0-9-_:\\.]+" , &m_value ) )
			return false;
		return true;
	}
public:
	wstring		m_value;
	
	df_stringto_svgv();
	wstring ToString()
	{
		return m_value;
	}
};
//-------------------------------------------------------------------------------------------------
typedef Nmtoken_svgv	LinkTarget_svgv;
//-------------------------------------------------------------------------------------------------
class ContentType_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchString( str , pos , L"[.]+" , &m_value ) )
			return false;
		return true;
	}
public:
	wstring		m_value;

	df_stringto_svgv();
	wstring ToString()
	{
		return m_value;
	}
};
//-------------------------------------------------------------------------------------------------
class Script_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchString( str , pos , L"[.]+" , &m_value ) )
			return false;
		return true;
	}
public:
	wstring		m_value;
	
	df_stringto_svgv();
	wstring ToString()
	{
		return m_value;
	}
};
//-------------------------------------------------------------------------------------------------
class Length_svgv : protected Parser
{
public:
	enum Type
	{
		none , 
		px , 
		pt , 
		pc , 
		mm , 
		cm , 
		in , 
		percentage , 
	};
	Type		m_type;
	double		m_value;
	
	Length_svgv() : m_type( none ) , m_value( 0.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value << MatchTable( TblPtr() , TblNum() , m_type , L"" );
		return os.str();;
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"px")(px))
			((L"pt")(pt))
			((L"pc")(pc))
			((L"mm")(mm))
			((L"cm")(cm))
			((L"in")(in))
			((L"%")(percentage))
			);
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_value	= parse.m_value;
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			m_type	= none;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
typedef Length_svgv			Coordinate_svgv;
//-------------------------------------------------------------------------------------------------
class Angle_svgv : protected Parser
{
public:
	enum Type
	{
		deg , 
		grad , 
		rad , 
	};
	Type		m_type;
	double		m_value;

	Angle_svgv() : m_type( deg ) , m_value( 0.0 ){}
	double GetRadian()
	{
		if( m_type == deg )
			return m_value * PI_d / 180.0;
		else if( m_type == grad )
			return m_value * 0.02;
		else
			return m_value;
	}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value << MatchTable( TblPtr() , TblNum() , m_type , L"" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"deg")(deg))
			((L"grad")(grad))
			((L"rad")(rad))
			);
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_value	= parse.m_value;
		{
			MatchTable( str , pos , TblPtr() , TblNum() , &m_type );
		}	
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class ColorType_svgv : protected Parser
{
public:
	enum Type
	{
		aliceblue , 
		antiquewhite , 
		aqua , 
		aquamarine , 
		azure , 
		beige , 
		bisque , 
		black , 
		blanchedalmond , 
		blue , 
		blueviolet , 
		brown , 
		burlywood , 
		cadetblue , 
		chartreuse , 
		chocolate , 
		coral , 
		cornflowerblue , 
		cornsilk , 
		crimson , 
		cyan , 
		darkblue , 
		darkcyan , 
		darkgoldenrod , 
		darkgray , 
		darkgreen , 
		darkgrey , 
		darkkhaki , 
		darkmagenta , 
		darkolivegreen , 
		darkorange , 
		darkorchid , 
		darkred , 
		darksalmon , 
		darkseagreen , 
		darkslateblue , 
		darkslategray , 
		darkslategrey , 
		darkturquoise , 
		darkviolet , 
		deeppink , 
		deepskyblue , 
		dimgray , 
		dimgrey , 
		dodgerblue , 
		firebrick , 
		floralwhite , 
		forestgreen , 
		fuchsia , 
		gainsboro , 
		ghostwhite , 
		gold , 
		goldenrod , 
		gray , 
		grey , 
		green , 
		greenyellow , 
		honeydew , 
		hotpink , 
		indianred , 
		indigo , 
		ivory , 
		khaki , 
		lavender , 
		lavenderblush , 
		lawngreen , 
		lemonchiffon , 
		lightblue , 
		lightcoral , 
		lightcyan , 
		lightgoldenrodyellow , 
		lightgray , 
		lightgreen , 
		lightgrey , 
		lightpink , 
		lightsalmon , 
		lightseagreen , 
		lightskyblue , 
		lightslategray , 
		lightslategrey , 
		lightsteelblue , 
		lightyellow , 
		lime , 
		limegreen , 
		linen , 
		magenta , 
		maroon , 
		mediumaquamarine , 
		mediumblue , 
		mediumorchid , 
		mediumpurple , 
		mediumseagreen , 
		mediumslateblue , 
		mediumspringgreen , 
		mediumturquoise , 
		mediumvioletred , 
		midnightblue , 
		mintcream , 
		mistyrose , 
		moccasin , 
		navajowhite , 
		navy , 
		oldlace , 
		olive , 
		olivedrab , 
		orange , 
		orangered , 
		orchid , 
		palegoldenrod , 
		palegreen , 
		paleturquoise , 
		palevioletred , 
		papayawhip , 
		peachpuff , 
		peru , 
		pink , 
		plum , 
		powderblue , 
		purple , 
		red , 
		rosybrown , 
		royalblue , 
		saddlebrown , 
		salmon , 
		sandybrown , 
		seagreen , 
		seashell , 
		sienna , 
		silver , 
		skyblue , 
		slateblue , 
		slategray , 
		slategrey , 
		snow , 
		springgreen , 
		steelblue , 
		tan , 
		teal , 
		thistle , 
		tomato , 
		turquoise , 
		violet , 
		wheat , 
		white , 
		whitesmoke , 
		yellow , 
		yellowgreen , 
	};
	Type	m_type;
	
	ColorType_svgv() : m_type( black ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << MatchTable( TblPtr() , TblNum() , m_type , L"black" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"aliceblue")(aliceblue))
			((L"antiquewhite")(antiquewhite))
			((L"aqua")(aqua))
			((L"aquamarine")(aquamarine))
			((L"azure")(azure))
			((L"beige")(beige))
			((L"bisque")(bisque))
			((L"black")(black))
			((L"blanchedalmond")(blanchedalmond))
			((L"blue")(blue))
			((L"blueviolet")(blueviolet))
			((L"brown")(brown))
			((L"burlywood")(burlywood))
			((L"cadetblue")(cadetblue))
			((L"chartreuse")(chartreuse))
			((L"chocolate")(chocolate))
			((L"coral")(coral))
			((L"cornflowerblue")(cornflowerblue))
			((L"cornsilk")(cornsilk))
			((L"crimson")(crimson))
			((L"cyan")(cyan))
			((L"darkblue")(darkblue))
			((L"darkcyan")(darkcyan))
			((L"darkgoldenrod")(darkgoldenrod))
			((L"darkgray")(darkgray))
			((L"darkgreen")(darkgreen))
			((L"darkgrey")(darkgrey))
			((L"darkkhaki")(darkkhaki))
			((L"darkmagenta")(darkmagenta))
			((L"darkolivegreen")(darkolivegreen))
			((L"darkorange")(darkorange))
			((L"darkorchid")(darkorchid))
			((L"darkred")(darkred))
			((L"darksalmon")(darksalmon))
			((L"darkseagreen")(darkseagreen))
			((L"darkslateblue")(darkslateblue))
			((L"darkslategray")(darkslategray))
			((L"darkslategrey")(darkslategrey))
			((L"darkturquoise")(darkturquoise))
			((L"darkviolet")(darkviolet))
			((L"deeppink")(deeppink))
			((L"deepskyblue")(deepskyblue))
			((L"dimgray")(dimgray))
			((L"dimgrey")(dimgrey))
			((L"dodgerblue")(dodgerblue))
			((L"firebrick")(firebrick))
			((L"floralwhite")(floralwhite))
			((L"forestgreen")(forestgreen))
			((L"fuchsia")(fuchsia))
			((L"gainsboro")(gainsboro))
			((L"ghostwhite")(ghostwhite))
			((L"gold")(gold))
			((L"goldenrod")(goldenrod))
			((L"gray")(gray))
			((L"grey")(grey))
			((L"green")(green))
			((L"greenyellow")(greenyellow))
			((L"honeydew")(honeydew))
			((L"hotpink")(hotpink))
			((L"indianred")(indianred))
			((L"indigo")(indigo))
			((L"ivory")(ivory))
			((L"khaki")(khaki))
			((L"lavender")(lavender))
			((L"lavenderblush")(lavenderblush))
			((L"lawngreen")(lawngreen))
			((L"lemonchiffon")(lemonchiffon))
			((L"lightblue")(lightblue))
			((L"lightcoral")(lightcoral))
			((L"lightcyan")(lightcyan))
			((L"lightgoldenrodyellow")(lightgoldenrodyellow))
			((L"lightgray")(lightgray))
			((L"lightgreen")(lightgreen))
			((L"lightgrey")(lightgrey))
			((L"lightpink")(lightpink))
			((L"lightsalmon")(lightsalmon))
			((L"lightseagreen")(lightseagreen))
			((L"lightskyblue")(lightskyblue))
			((L"lightslategray")(lightslategray))
			((L"lightslategrey")(lightslategrey))
			((L"lightsteelblue")(lightsteelblue))
			((L"lightyellow")(lightyellow))
			((L"lime")(lime))
			((L"limegreen")(limegreen))
			((L"linen")(linen))
			((L"magenta")(magenta))
			((L"maroon")(maroon))
			((L"mediumaquamarine")(mediumaquamarine))
			((L"mediumblue")(mediumblue))
			((L"mediumorchid")(mediumorchid))
			((L"mediumpurple")(mediumpurple))
			((L"mediumseagreen")(mediumseagreen))
			((L"mediumslateblue")(mediumslateblue))
			((L"mediumspringgreen")(mediumspringgreen))
			((L"mediumturquoise")(mediumturquoise))
			((L"mediumvioletred")(mediumvioletred))
			((L"midnightblue")(midnightblue))
			((L"mintcream")(mintcream))
			((L"mistyrose")(mistyrose))
			((L"moccasin")(moccasin))
			((L"navajowhite")(navajowhite))
			((L"navy")(navy))
			((L"oldlace")(oldlace))
			((L"olive")(olive))
			((L"olivedrab")(olivedrab))
			((L"orange")(orange))
			((L"orangered")(orangered))
			((L"orchid")(orchid))
			((L"palegoldenrod")(palegoldenrod))
			((L"palegreen")(palegreen))
			((L"paleturquoise")(paleturquoise))
			((L"palevioletred")(palevioletred))
			((L"papayawhip")(papayawhip))
			((L"peachpuff")(peachpuff))
			((L"peru")(peru))
			((L"pink")(pink))
			((L"plum")(plum))
			((L"powderblue")(powderblue))
			((L"purple")(purple))
			((L"red")(red))
			((L"rosybrown")(rosybrown))
			((L"royalblue")(royalblue))
			((L"saddlebrown")(saddlebrown))
			((L"salmon")(salmon))
			((L"sandybrown")(sandybrown))
			((L"seagreen")(seagreen))
			((L"seashell")(seashell))
			((L"sienna")(sienna))
			((L"silver")(silver))
			((L"skyblue")(skyblue))
			((L"slateblue")(slateblue))
			((L"slategray")(slategray))
			((L"slategrey")(slategrey))
			((L"snow")(snow))
			((L"springgreen")(springgreen))
			((L"steelblue")(steelblue))
			((L"tan")(tan))
			((L"teal")(teal))
			((L"thistle")(thistle))
			((L"tomato")(tomato))
			((L"turquoise")(turquoise))
			((L"violet")(violet))
			((L"wheat")(wheat))
			((L"white")(white))
			((L"whitesmoke")(whitesmoke))
			((L"yellow")(yellow))
			((L"yellowgreen")(yellowgreen))
			);
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
public:
	rgba GetColor()
	{
		static
		rgb	colortbl[] = 
		{
			rgb(240, 248, 255),	//aliceblue
			rgb(250, 235, 215),	//antiquewhite
			rgb( 0, 255, 255),	//aqua
			rgb(127, 255, 212),	//aquamarine
			rgb(240, 255, 255),	//azure
			rgb(245, 245, 220),	//beige
			rgb(255, 228, 196),	//bisque
			rgb( 0, 0, 0),		//black
			rgb(255, 235, 205),	//blanchedalmond
			rgb( 0, 0, 255),	//blue
			rgb(138, 43, 226),	//blueviolet
			rgb(165, 42, 42),	//brown
			rgb(222, 184, 135),	//burlywood
			rgb( 95, 158, 160),	//cadetblue
			rgb(127, 255, 0),	//chartreuse
			rgb(210, 105, 30),	//chocolate
			rgb(255, 127, 80),	//coral
			rgb(100, 149, 237),	//cornflowerblue
			rgb(255, 248, 220),	//cornsilk
			rgb(220, 20, 60),	//crimson
			rgb( 0, 255, 255),	//cyan
			rgb( 0, 0, 139),	//darkblue
			rgb( 0, 139, 139),	//darkcyan
			rgb(184, 134, 11),	//darkgoldenrod
			rgb(169, 169, 169),	//darkgray
			rgb( 0, 100, 0),	//darkgreen
			rgb(169, 169, 169),	//darkgrey
			rgb(189, 183, 107),	//darkkhaki
			rgb(139, 0, 139),	//darkmagenta
			rgb( 85, 107, 47),	//darkolivegreen
			rgb(255, 140, 0),	//darkorange
			rgb(153, 50, 204),	//darkorchid
			rgb(139, 0, 0),		//darkred
			rgb(233, 150, 122),	//darksalmon
			rgb(143, 188, 143),	//darkseagreen
			rgb( 72, 61, 139),	//darkslateblue
			rgb( 47, 79, 79),	//darkslategray
			rgb( 47, 79, 79),	//darkslategrey
			rgb( 0, 206, 209),	//darkturquoise
			rgb(148, 0, 211),	//darkviolet
			rgb(255, 20, 147),	//deeppink
			rgb( 0, 191, 255),	//deepskyblue
			rgb(105, 105, 105),	//dimgray
			rgb(105, 105, 105),	//dimgrey
			rgb( 30, 144, 255),	//dodgerblue
			rgb(178, 34, 34),	//firebrick
			rgb(255, 250, 240),	//floralwhite
			rgb( 34, 139, 34),	//forestgreen
			rgb(255, 0, 255),	//fuchsia
			rgb(220, 220, 220),	//gainsboro
			rgb(248, 248, 255),	//ghostwhite
			rgb(255, 215, 0),	//gold
			rgb(218, 165, 32),	//goldenrod
			rgb(128, 128, 128),	//gray
			rgb(128, 128, 128),	//grey
			rgb( 0, 128, 0),	//green
			rgb(173, 255, 47),	//greenyellow
			rgb(240, 255, 240),	//honeydew
			rgb(255, 105, 180),	//hotpink
			rgb(205, 92, 92),	//indianred
			rgb( 75, 0, 130),	//indigo
			rgb(255, 255, 240),	//ivory
			rgb(240, 230, 140),	//khaki
			rgb(230, 230, 250),	//lavender
			rgb(255, 240, 245),	//lavenderblush
			rgb(124, 252, 0),	//lawngreen
			rgb(255, 250, 205),	//lemonchiffon
			rgb(173, 216, 230),	//lightblue
			rgb(240, 128, 128),	//lightcoral
			rgb(224, 255, 255),	//lightcyan
			rgb(250, 250, 210),	//lightgoldenrodyellow
			rgb(211, 211, 211),	//lightgray
			rgb(144, 238, 144),	//lightgreen
			rgb(211, 211, 211),	//lightgrey
			rgb(255, 182, 193),	//lightpink
			rgb(255, 160, 122),	//lightsalmon
			rgb( 32, 178, 170),	//lightseagreen
			rgb(135, 206, 250),	//lightskyblue
			rgb(119, 136, 153),	//lightslategray
			rgb(119, 136, 153),	//lightslategrey
			rgb(176, 196, 222),	//lightsteelblue
			rgb(255, 255, 224),	//lightyellow
			rgb( 0, 255, 0),	//lime
			rgb( 50, 205, 50),	//limegreen
			rgb(250, 240, 230),	//linen
			rgb(255, 0, 255),	//magenta
			rgb(128, 0, 0),		//maroon
			rgb(102, 205, 170),	//mediumaquamarine
			rgb( 0, 0, 205),	//mediumblue
			rgb(186, 85, 211),	//mediumorchid
			rgb(147, 112, 219),	//mediumpurple
			rgb( 60, 179, 113),	//mediumseagreen
			rgb(123, 104, 238),	//mediumslateblue
			rgb( 0, 250, 154),	//mediumspringgreen
			rgb( 72, 209, 204),	//mediumturquoise
			rgb(199, 21, 133),	//mediumvioletred
			rgb( 25, 25, 112),	//midnightblue
			rgb(245, 255, 250),	//mintcream
			rgb(255, 228, 225),	//mistyrose
			rgb(255, 228, 181),	//moccasin
			rgb(255, 222, 173),	//navajowhite
			rgb( 0, 0, 128),	//navy
			rgb(253, 245, 230),	//oldlace
			rgb(128, 128, 0),	//olive
			rgb(107, 142, 35),	//olivedrab
			rgb(255, 165, 0),	//orange
			rgb(255, 69, 0),	//orangered
			rgb(218, 112, 214),	//orchid
			rgb(238, 232, 170),	//palegoldenrod
			rgb(152, 251, 152),	//palegreen
			rgb(175, 238, 238),	//paleturquoise
			rgb(219, 112, 147),	//palevioletred
			rgb(255, 239, 213),	//papayawhip
			rgb(255, 218, 185),	//peachpuff
			rgb(205, 133, 63),	//peru
			rgb(255, 192, 203),	//pink
			rgb(221, 160, 221),	//plum
			rgb(176, 224, 230),	//powderblue
			rgb(128, 0, 128),	//purple
			rgb(255, 0, 0),		//red
			rgb(188, 143, 143),	//rosybrown
			rgb( 65, 105, 225),	//royalblue
			rgb(139, 69, 19),	//saddlebrown
			rgb(250, 128, 114),	//salmon
			rgb(244, 164, 96),	//sandybrown
			rgb( 46, 139, 87),	//seagreen
			rgb(255, 245, 238),	//seashell
			rgb(160, 82, 45),	//sienna
			rgb(192, 192, 192),	//silver
			rgb(135, 206, 235),	//skyblue
			rgb(106, 90, 205),	//slateblue
			rgb(112, 128, 144),	//slategray
			rgb(112, 128, 144),	//slategrey
			rgb(255, 250, 250),	//snow
			rgb( 0, 255, 127),	//springgreen
			rgb( 70, 130, 180),	//steelblue
			rgb(210, 180, 140),	//tan
			rgb( 0, 128, 128),	//teal
			rgb(216, 191, 216),	//thistle
			rgb(255, 99, 71),	//tomato
			rgb( 64, 224, 208),	//turquoise
			rgb(238, 130, 238),	//violet
			rgb(245, 222, 179),	//wheat
			rgb(255, 255, 255),	//white
			rgb(245, 245, 245),	//whitesmoke
			rgb(255, 255, 0),	//yellow
			rgb(154, 205, 50),	//yellowgreen
		};
		return colortbl[m_type];
	}
};
//-------------------------------------------------------------------------------------------------
class RgbHex_svgv : protected Parser
{
public:
	uint8		r , g , b;

	RgbHex_svgv() : r(0) , g(0) , b(0){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << L"#" << hex << setw(2) << setfill(L'0') << r << setw(2) << setfill(L'0') << g << setw(2) << setfill(L'0') << b;
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	bool parse_s_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"#" );

		int	t_pos	= *pos;
		IntegerParser<16>	parse;
		if( false == parse.Parse( str , &t_pos , errpos ) )
			return false;
		if( t_pos - *pos == 3 )
		{
			r	= ( ( ( parse.m_value >> 8 ) & 0x0F ) << 4 ) + ( ( parse.m_value >> 8 ) & 0x0F );
			g	= ( ( ( parse.m_value >> 4 ) & 0x0F ) << 4 ) + ( ( parse.m_value >> 4 ) & 0x0F );
			b	= ( ( ( parse.m_value >> 0 ) & 0x0F ) << 4 ) + ( ( parse.m_value >> 0 ) & 0x0F );
			*pos	= t_pos;
			return true;
		}
		else if( t_pos - *pos == 6 )
		{
			r	= ( ( parse.m_value >> 16 ) & 0xFF );
			g	= ( ( parse.m_value >> 8 ) & 0x0FF );
			b	= ( ( parse.m_value >> 0 ) & 0x0FF );
			*pos	= t_pos;
			return true;
		}
		return false;
	}
};
//-------------------------------------------------------------------------------------------------
class ValuePercent_svgv : protected Parser
{
public:
	enum Type
	{
		none , 
		percentage , 
	};
	Type		m_type;
	double		m_value;
	
	ValuePercent_svgv() : m_type( none ) , m_value( 0.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == none )
			os << m_value;
		else
			os << m_value << L"%";
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"%")(percentage))
			);
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_value	= parse.m_value;
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			m_type	= none;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Rgb_svgv : protected Parser
{
public:
	uint8		r , g , b;
	
	Rgb_svgv() : r(0) , g(0) , b(0){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << L"rgb(" << r << L"," << g << L"," << b << L")";
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"[rR][gG][bB]\\(" );
		df_skip_space();
		{
			ValuePercent_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			if( parse.m_type == ValuePercent_svgv::percentage )
			{
				float	t	= (float)parse.m_value / 100.0f;
				r = (uint8)( ( t < 0.0f ? 0.0f : ( t > 1.0f ? 1.0f : t ) ) * 255.0f );
			}
			else
				r = (uint8)( parse.m_value < 0.0f ? 0.0f : ( parse.m_value > 255.0f ? 255.0f : parse.m_value ) );
		}
		df_delimiter();
		{
			ValuePercent_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			if( parse.m_type == ValuePercent_svgv::percentage )
			{
				float	t	= (float)parse.m_value / 100.0f;
				g = (uint8)( ( t < 0.0f ? 0.0f : ( t > 1.0f ? 1.0f : t ) ) * 255.0f );
			}
			else
				g = (uint8)( parse.m_value < 0.0f ? 0.0f : ( parse.m_value > 255.0f ? 255.0f : parse.m_value ) );
		}
		df_delimiter();
		{
			ValuePercent_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			if( parse.m_type == ValuePercent_svgv::percentage )
			{
				float	t	= (float)parse.m_value / 100.0f;
				b = (uint8)( ( t < 0.0f ? 0.0f : ( t > 1.0f ? 1.0f : t ) ) * 255.0f );
			}
			else
				b = (uint8)( parse.m_value < 0.0f ? 0.0f : ( parse.m_value > 255.0f ? 255.0f : parse.m_value ) );
		}
		df_skip_space();
		df_match_string( L"\\)" );
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Color_svgv : protected Parser
{
public:
	enum Type
	{
		color , 
		colortype , 
	};
	Type			m_type;
	ColorType_svgv	m_colortype;
	uint8			r , g , b;
	
	Color_svgv() : r(0) , g(0) , b(0) , m_type( color ){}
	df_stringto_svgv();
	wstring ToString()
	{
		if( m_type == color )
		{
			Rgb_svgv	parse;
			parse.r = r;
			parse.g = g;
			parse.b = b;
			return parse.ToString();
		}
		else
		{
			ColorType_svgv	parse;
			parse	= m_colortype;
			return parse.ToString();
		}
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_hex )
	parse_map_edge( start_node_id , end_node_id , parse_rgb )
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_end()
	bool parse_hex
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		RgbHex_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= color;
		r		= parse.r;
		g		= parse.g;
		b		= parse.b;
		return true;
	}
	bool parse_rgb
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Rgb_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= color;
		r		= parse.r;
		g		= parse.g;
		b		= parse.b;
		return true;
	}
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		ColorType_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= colortype;
		m_colortype	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Id_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	bool parse_s_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchString( str , pos , L"[A-Za-z]+[A-Za-z0-9\\-_:\\.]*" , &m_value ) )
			return false;
		return true;
	}
public:
	wstring		m_value;

	df_stringto_svgv();
	wstring ToString()
	{
		return m_value;
	}
};

//-------------------------------------------------------------------------------------------------
class Url_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		{
			if( false == MatchString( str , pos , L"[^\\)]*" , &m_value ) )
				return false;
		}
		return true;
	}
public:
	wstring		m_value;

	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value;
		return os.str();
	}
};

//-------------------------------------------------------------------------------------------------
class XlinkUri_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_id )
	parse_map_edge( start_node_id , end_node_id , parse_url )
	parse_map_end()
	bool parse_id
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		df_match_string( L"#" );
		Id_svgv			parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= id;
		m_id	= parse;
		return true;
	}
	bool parse_url
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Url_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= url;
		m_url	= parse;
		return true;
	}
public:
	enum Type
	{
		id , 
		url
	};
	Type		m_type;
	Id_svgv		m_id;
	Url_svgv	m_url;
	
	XlinkUri_svgv() : m_type( id ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == id )
			os << "#" << m_id.ToString();
		else if( m_type == url )
			os << m_url.ToString();
		return os.str();
	}
};
//-------------------------------------------------------------------------------------------------
class Uri_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_id )
	parse_map_edge( start_node_id , end_node_id , parse_url )
	parse_map_end()
	bool parse_id
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		df_match_string( L"url" );
		df_skip_space();
		df_match_string( L"\\(" );
		df_skip_space();
		df_match_string( L"#" );
		Id_svgv			parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		df_skip_space();
		df_match_string( L"\\)" );
		m_type	= id;
		m_id	= parse;
		return true;
	}
	bool parse_url
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		df_match_string( L"url" );
		df_skip_space();
		df_match_string( L"\\(" );
		Url_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		df_skip_space();
		df_match_string( L"\\)" );
		m_type	= url;
		m_url	= parse;
		return true;
	}
public:
	enum Type
	{
		id , 
		url
	};
	Type		m_type;
	Id_svgv		m_id;
	Url_svgv	m_url;
	
	Uri_svgv() : m_type( id ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == id )
			os << L"url(#" << m_id.ToString() << L")";
		else if( m_type == url )
			os << L"url(" << m_url.ToString() << L")";
		return os.str();
	}
};
//-------------------------------------------------------------------------------------------------
class UriList_svgv : protected Parser
{
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		Uri_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ] = parse;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		Uri_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ] = parse;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
public:
	Array<Uri_svgv>		m_list;
	df_list_operator_svgv( UriList );

	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[off].ToString();
		}
		return os.str();
	}
};
//-------------------------------------------------------------------------------------------------
class Cursor_svgv : protected Parser
{
public:
	enum Type
	{
		_auto , 
		crosshair , 
		_default , 
		pointer , 
		move , 
		e_resize , 
		ne_resize , 
		nw_resize , 
		n_resize , 
		se_resize , 
		sw_resize , 
		s_resize , 
		w_resize , 
		text , 
		wait , 
		help , 
		inherit , 	
	};
	Type			m_type;
	UriList_svgv	m_uri;
	
	Cursor_svgv() : m_type( _auto ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_uri.ToString();
		os << L",";
		os << MatchTable( TblPtr() , TblNum() , m_type , L"auto" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_uri )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"auto")(_auto))
			((L"crosshair")(crosshair))
			((L"default")(_default))
			((L"pointer")(pointer))
			((L"move")(move))
			((L"e-resize")(e_resize))
			((L"ne-resize")(ne_resize))
			((L"nw-resize")(nw_resize))
			((L"n-resize")(n_resize))
			((L"se-resize")(se_resize))
			((L"sw-resize")(sw_resize))
			((L"s-resize")(s_resize))
			((L"w-resize")(w_resize))
			((L"text")(text))
			((L"wait")(wait))
			((L"help")(help))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		{
			if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
				return false;
		}	
		return true;
	}
	bool parse_uri
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		{
			UriList_svgv	parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_uri	= parse;
		}
		df_delimiter_r( true );
		{
			if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
				return false;
		}	
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Paint_svgv : protected Parser
{
public:
	enum Type
	{
		none , 
		currentColor , 
		color , 
		uri , 
		inherit , 
	};
	Type		m_type;
	Color_svgv	m_color;
	Uri_svgv	m_uri;
	
	Paint_svgv() : m_type( color ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == uri )
			os << m_uri.ToString();
		else if( m_type == color )
			os << m_color.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"none" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_color )
	parse_map_edge( start_node_id , end_node_id , parse_uri )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"none")(none))
			((L"currentColor")(currentColor))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_color
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Color_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= color;
		m_color	= parse;
		return true;
	}
	bool parse_uri
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Uri_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= uri;
		m_uri	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Percentage_svgv : protected Parser
{
public:
	double		m_value;

	Percentage_svgv() : m_value( 0.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value << L"%";
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		df_match_string( L"%" );
		m_value	= parse.m_value;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Transform_svgv : protected Parser
{
public:
	faffine		m_value;

	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << L"matrix(" << m_value.m[0][0] << L"," << m_value.m[1][0] << L"," << m_value.m[0][1] << L"," << m_value.m[1][1] << L"," << m_value.m[2][0] << L"," << m_value.m[2][1] << L")";
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_matrix )
	parse_map_edge( start_node_id , end_node_id , parse_translate )
	parse_map_edge( start_node_id , end_node_id , parse_scale )
	parse_map_edge( start_node_id , end_node_id , parse_rotate )
	parse_map_edge( start_node_id , end_node_id , parse_skewx )
	parse_map_edge( start_node_id , end_node_id , parse_skewy )
	parse_map_end()
	bool parse_matrix
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"matrix\\(" );
		df_skip_space();
		double		e[6];
		int		i;
		for( i = 0 ; i < 6 ; i++ )
		{
			Number_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			e[i]	= parse.m_value;
			if( i != 5 )
				df_delimiter();
		}
		df_skip_space();
		df_match_string( L"\\)" );
		m_value	= fmatrix33( ( float )e[0] , ( float )e[2] , ( float )e[4] , ( float )e[1] , ( float )e[3] , ( float )e[5] , 0.0f , 0.0f , 1.0f );
		return true;
	}
	bool parse_translate
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"translate\\(" );
		df_skip_space();
		double		e[2] = { 0.0 , 0.0 };
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			e[0]	= parse.m_value;
		}
		{
			Delimiter		parse;
			if( true == parse.Parse( str , pos , errpos ) )
			{
				Length_svgv		parse;
				if( true == parse.StringTo( str , pos ) )
					e[1]	= parse.m_value;
			}
		}
		df_skip_space();
		df_match_string( L"\\)" );
		m_value	= faffine::GetMove( fvector2( ( float )e[0] , ( float )e[1] ) );
		return true;
	}
	bool parse_scale
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"scale\\(" );
		df_skip_space();
		double		e[2] = { 0.0 , 0.0 };
		{
			Number_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			e[0]	= parse.m_value;
			e[1]	= e[0];
		}
		{
			Delimiter		parse;
			if( true == parse.Parse( str , pos , errpos ) )
			{
				Number_svgv		parse;
				if( true == parse.StringTo( str , pos ) )
					e[1]	= parse.m_value;
			}
		}
		df_skip_space();
		df_match_string( L"\\)" );
		m_value	= faffine::GetScale( ( float )e[0] , ( float )e[1] );
		return true;
	}
	bool parse_rotate
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"rotate\\(" );
		df_skip_space();
		double		e[3] = { 0.0 , 0.0 , 0.0 };
		{
			Angle_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			e[0]	= parse.GetRadian();
		}
		{
			Delimiter		parse;
			if( true == parse.Parse( str , pos , errpos ) )
			{
				Length_svgv		parse;
				if( true == parse.StringTo( str , pos ) )
				{
					e[1]	= parse.m_value;
					{
						Delimiter		parse;
						if( false == parse.Parse( str , pos , errpos ) )
							return false;
					}
					{
						Length_svgv		parse;
						if( false == parse.StringTo( str , pos ) )
							return false;
						e[2] = parse.m_value;			
					}
				}
			}
		}
		df_skip_space();
		df_match_string( L"\\)" );
		m_value	= faffine::GetMove( fvector2( ( float )e[1] , ( float )e[2] ) ) * faffine::GetRotate( ( float )e[0] ) * faffine::GetMove( fvector2( -( float )e[1] , -( float )e[2] ) );
		return true;
	}
	bool parse_skewx
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"skewX\\(" );
		df_skip_space();
		double		e = 0.0;
		{
			Angle_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			e = parse.GetRadian();
		}
		df_skip_space();
		df_match_string( L"\\)" );
		m_value	= faffine::GetSkew( (float)e , 0.0f );
		return true;
	}
	bool parse_skewy
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"skewY\\(" );
		df_skip_space();
		double		e = 0.0;
		{
			Angle_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			e = parse.GetRadian();
		}
		df_skip_space();
		df_match_string( L"\\)" );
		m_value	= faffine::GetSkew( 0.0f , (float)e );
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class TransformList_svgv : protected Parser
{
public:
	Array<Transform_svgv>	m_list;
	
	df_list_operator_svgv( TransformList );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[ off ].ToString();
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Transform_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		Transform_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Frequency_svgv : protected Parser
{
public:
	enum Type
	{
		Hz , 
		kHz
	};
	Type		m_type;
	double		m_value;

	Frequency_svgv() : m_type( Hz ) , m_value( 0.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value;
		os << MatchTable( TblPtr() , TblNum() , m_type , L"Hz" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"Hz")(Hz))
			((L"kHz")(kHz))
			);
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_value	= parse.m_value;
		MatchTable( str , pos , TblPtr() , TblNum() , &m_type );
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Time_svgv : protected Parser
{
public:
	enum Type
	{
		ms , 
		s
	};
	Type		m_type;
	double		m_value;

	Time_svgv() : m_type( ms ) , m_value( 0.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value;
		os << MatchTable( TblPtr() , TblNum() , m_type , L"Hz" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"ms")(ms))
			((L"s")(s))
			);
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_value	= parse.m_value;
		MatchTable( str , pos , TblPtr() , TblNum() , &m_type );
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Marker_svgv : protected Parser
{
public:
	enum Type
	{
		none , 
		inherit , 
		uri , 
	};
	Type		m_type;
	Uri_svgv	m_uri;

	Marker_svgv() : m_type( none ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == uri )
			os << m_uri.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"none" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_uri )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"none")(none))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		MatchTable( str , pos , TblPtr() , TblNum() , &m_type );
		return true;
	}
	bool parse_uri
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Uri_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= uri;
		m_uri	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class BaselineShift_svgv : protected Parser
{
public:
	enum Type
	{
		baseline , 
		sub , 
		super , 
		length , 
		inherit
	};
	Type				m_type;
	Length_svgv			m_length;

	BaselineShift_svgv() : m_type( baseline ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == length )
			os << m_length.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"baseline" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_length )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"baseline")(baseline))
			((L"sub")(sub))
			((L"super")(super))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_length
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= length;
		m_length= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Boolean_svgv : protected Parser
{
public:
	bool		m_value;

	Boolean_svgv() : m_value( false ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_value == false )
			os << L"false";
		else
			os << L"true";
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( true == MatchString( str , pos , L"true" , 0 ) )
		{
			m_value = true;
			return true;
		}
		if( true == MatchString( str , pos , L"false" , 0 ) )
		{
			m_value = false;
			return true;
		}
		return false;
	}
};
//-------------------------------------------------------------------------------------------------
class Class_svgv : protected Parser
{
public:
	Id_svgv		m_value;
	
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value.ToString();
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Id_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_value	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class ClassList_svgv : protected Parser
{
public:
	Array<Class_svgv>	m_list;

	df_list_operator_svgv( ClassList );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[off].ToString();
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Class_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		Class_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Shape_svgv : protected Parser
{
public:
	Length_svgv		m_top;
	Length_svgv		m_right;
	Length_svgv		m_bottom;
	Length_svgv		m_left;

	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << L"shape(";
		os << m_top.ToString();
		os << L",";
		os << m_right.ToString();
		os << L",";
		os << m_bottom.ToString();
		os << L",";
		os << m_left.ToString();
		os << L")";
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"shape\\(" );
		df_skip_space();
		Length_svgv		e[4];
		int		i;
		for( i = 0 ; i < 4 ; i++ )
		{
			if( false == e[i].StringTo( str , pos ) )
				return false;
			if( i != 3 )
				df_delimiter();
		}
		df_skip_space();
		df_match_string( L"\\)" );
		
		m_top		= e[0];
		m_right		= e[1];
		m_bottom	= e[2];
		m_left		= e[3];
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Clip_svgv : protected Parser
{
public:
	enum Type
	{
		shape , 
		_auto , 
		inherit
	};
	Type		m_type;
	Shape_svgv	m_shape;

	Clip_svgv() : m_type( _auto ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == shape )
			os << m_shape.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"auto" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_shape )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"auto")(_auto))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_shape
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Shape_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= shape;
		m_shape	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class ClipPath_svgv : protected Parser
{
public:
	enum Type
	{
		uri , 
		none , 
		inherit , 
	};
	Type		m_type;
	Uri_svgv	m_uri;

	ClipPath_svgv() : m_type( none ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == uri )
			os << m_uri.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"none" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_uri )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"none")(none))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_uri
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Uri_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= uri;
		m_uri	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ClipFillRule , 
		nonzero , 
		((L"nonzero")(nonzero))
		((L"evenodd")(evenodd))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
class Coordinates_svgv : protected Parser
{
public:
	Array<Coordinate_svgv>	m_list;

	df_list_operator_svgv( Coordinates );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[off].ToString();
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Coordinate_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		Coordinate_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};

//-------------------------------------------------------------------------------------------------
class Filter_svgv : protected Parser
{
public:
	enum Type
	{
		uri , 
		none , 
		inherit , 
	};
	Type		m_type;
	Uri_svgv	m_uri;

	Filter_svgv() : m_type( none ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == uri )
			os << m_uri.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"none" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_uri )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"none")(none))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_uri
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Uri_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= uri;
		m_uri	= parse;
		return true;
	}
};

//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		AbsoluteSize , 
		medium , 
		((L"xx-small")(xx_small))
		((L"x-small")(x_small))
		((L"small")(_small))
		((L"medium")(medium))
		((L"large")(large))
		((L"x-large")(x_large))
		((L"xx-large")(xx_large))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		RelativeSize , 
		larger , 
		((L"larger")(larger))
		((L"smaller")(smaller))
		);
//-------------------------------------------------------------------------------------------------
class FontSize_svgv : protected Parser
{
public:
	enum Type
	{
		absolute_size , 
		relative_size , 
		length , 
		inherit , 
	};
	Type				m_type;
	AbsoluteSize_svgv	m_absolute_size;
	RelativeSize_svgv	m_relative_size;
	Length_svgv			m_length;
	
	FontSize_svgv() : m_type( length ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == absolute_size )
			os << m_absolute_size.ToString();
		else if( m_type == relative_size )
			os << m_relative_size.ToString();
		else if( m_type == length )
			os << m_length.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"inherit" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_absolute )
	parse_map_edge( start_node_id , end_node_id , parse_relative )
	parse_map_edge( start_node_id , end_node_id , parse_length )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_absolute
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		AbsoluteSize_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= absolute_size;
		m_absolute_size	= parse;
		return true;
	}
	bool parse_relative
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		RelativeSize_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type			= relative_size;
		m_relative_size	= parse;
		return true;
	}
	bool parse_length
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= length;
		m_length	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class FontSizeAdjust_svgv : protected Parser
{
public:
	enum Type
	{
		number , 
		none , 
		inherit , 
	};
	Type		m_type;
	Number_svgv	m_number;

	FontSizeAdjust_svgv() : m_type( none ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == number )
			os << m_number.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"none" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_number )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"none")(none))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_number
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= number;
		m_number	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class GlyphOrientationHorizontal_svgv : protected Parser
{
public:
	enum Type
	{
		angle , 
		inherit , 
	};
	Type		m_type;
	Angle_svgv	m_angle;
	
	GlyphOrientationHorizontal_svgv() : m_type( angle ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == angle )
			os << m_angle.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"inherit" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_angle )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_angle
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Angle_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= angle;
		m_angle	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class GlyphOrientationVertical_svgv : protected Parser
{
public:
	enum Type
	{
		_auto , 
		angle , 
		inherit , 
	};
	Type		m_type;
	Angle_svgv	m_angle;

	GlyphOrientationVertical_svgv() : m_type( _auto ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == angle )
			os << m_angle.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"auto" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_angle )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"auto")(_auto))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_angle
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Angle_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= angle;
		m_angle	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Kerning_svgv : protected Parser
{
public:
	enum Type
	{
		_auto , 
		length , 
		inherit , 
	};
	Type		m_type;
	Length_svgv	m_length;

	Kerning_svgv() : m_type( _auto ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == length )
			os << m_length.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"auto" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_length )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"auto")(_auto))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_length
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= length;
		m_length	= parse;
		return true;
	}
};

//-------------------------------------------------------------------------------------------------
class Lengths_svgv : protected Parser
{
public:
	Array<Length_svgv>	m_list;

	df_list_operator_svgv( Lengths );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[off].ToString();
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};

//-------------------------------------------------------------------------------------------------
class Mask_svgv : protected Parser
{
public:
	enum Type
	{
		uri , 
		none , 
		inherit , 
	};
	Type		m_type;
	Uri_svgv	m_uri;

	Mask_svgv() : m_type( none ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == uri )
			os << m_uri.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"none" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_uri )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"none")(none))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_uri
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Uri_svgv	parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= uri;
		m_uri	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Opacity_svgv : protected Parser
{
public:
	enum Type
	{
		value , 
		inherit , 
	};
	Type		m_type;
	double		m_value;

	Opacity_svgv() : m_type( value ) , m_value( 1.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == value )
			os << m_value;
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"inherit" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_value )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_value
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Number_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type	= value;
		m_value	= parse.m_value;
		m_value	= m_value < 0.0 ? 0.0 : m_value > 1.0 ? 1.0 : m_value;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class PathData_svgv : protected Parser
{
public:
	enum Type
	{
		moveto_abs , 
		moveto_rel , 
		close_abs , 
		close_rel , 
		lineto_abs , 
		lineto_rel , 
		lineto_horizontal_abs , 
		lineto_horizontal_rel , 
		lineto_vertical_abs , 
		lineto_vertical_rel , 
		curveto_cubic_abs , 
		curveto_cubic_rel , 
		curveto_quadratic_abs , 
		curveto_quadratic_rel , 
		curveto_cubic_smooth_abs , 
		curveto_cubic_smooth_rel , 
		curveto_quadratic_smooth_abs , 
		curveto_quadratic_smooth_rel , 
		arc_abs , 
		arc_rel , 
	};
	class Seg
	{
	public:
#pragma pack( push , 1 )		//set align
		struct s_data_ary
		{
			double	p[6];
		};
		struct s_moveto_abs
		{
			double	x , y;
		};
		struct s_moveto_rel
		{
			double	x , y;
		};
		struct s_close_abs
		{
		};
		struct s_close_rel
		{
		};
		struct s_lineto_abs
		{
			double	x , y;
		};
		struct s_lineto_rel
		{
			double	x , y;
		};
		struct s_lineto_horizontal_abs
		{
			double	x;
		};
		struct s_lineto_horizontal_rel
		{
			double	x;
		};
		struct s_lineto_vertical_abs
		{
			double	y;
		};
		struct s_lineto_vertical_rel
		{
			double	y;
		};
		struct s_curveto_cubic_abs
		{
			double	x1,y1,x2,y2,x,y;
		};
		struct s_curveto_cubic_rel
		{
			double	x1,y1,x2,y2,x,y;
		};
		struct s_curveto_quadratic_abs
		{
			double	x1,y1,x,y;
		};
		struct s_curveto_quadratic_rel
		{
			double	x1,y1,x,y;
		};
		struct s_curveto_cubic_smooth_abs
		{
			double	x2,y2,x,y;
		};
		struct s_curveto_cubic_smooth_rel
		{
			double	x2,y2,x,y;
		};
		struct s_curveto_quadratic_smooth_abs
		{
			double	x,y;
		};
		struct s_curveto_quadratic_smooth_rel
		{
			double	x,y;
		};
		struct s_arc_abs
		{
			double	rx,ry,x_axis_rotation;
			bool	large_arc_flag , sweep_flag;
			double	x,y;
		};
		struct s_arc_rel
		{
			double	rx,ry,x_axis_rotation;
			bool	large_arc_flag , sweep_flag;
			double	x,y;
		};
		struct s_arc
		{
			double	rx,ry,x_axis_rotation;
			bool	large_arc_flag , sweep_flag;
			double	x,y;
		};
#pragma pack( pop )			//release align
		Type	m_type;
		union
		{
			s_data_ary						m_data_ary;
			s_moveto_abs					m_moveto_abs;
			s_moveto_rel					m_moveto_rel;
			s_close_abs						m_close_abs;
			s_close_rel						m_close_rel;
			s_lineto_abs					m_lineto_abs;
			s_lineto_rel					m_lineto_rel;
			s_lineto_horizontal_abs			m_lineto_horizontal_abs;
			s_lineto_horizontal_rel			m_lineto_horizontal_rel;
			s_lineto_vertical_abs			m_lineto_vertical_abs;
			s_lineto_vertical_rel			m_lineto_vertical_rel;
			s_curveto_cubic_abs				m_curveto_cubic_abs;
			s_curveto_cubic_rel				m_curveto_cubic_rel;
			s_curveto_quadratic_abs			m_curveto_quadratic_abs;
			s_curveto_quadratic_rel			m_curveto_quadratic_rel;
			s_curveto_cubic_smooth_abs		m_curveto_cubic_smooth_abs;
			s_curveto_cubic_smooth_rel		m_curveto_cubic_smooth_rel;
			s_curveto_quadratic_smooth_abs	m_curveto_quadratic_smooth_abs;
			s_curveto_quadratic_smooth_rel	m_curveto_quadratic_smooth_rel;
			s_arc_abs						m_arc_abs;
			s_arc_rel						m_arc_rel;
			s_arc							m_arc;
		}m_value;
		Seg() : m_type( moveto_abs )
		{
			MemoryZero( &m_value , sizeof( m_value ) );
		}
	};
	Array<Seg>			m_list;
	
	PathData_svgv() : m_list( Expand_ArrayCashType , 64 ){}
	df_list_operator_svgv( PathData );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;

		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";

			Seg		d = m_list[ off ];
			wstring		v;
			if( ( v = MatchTable( Tbl0Ptr() , Tbl0Num() , d.m_type , L"" ) ) != L"" )
				os << v;
			else if( ( v = MatchTable( Tbl1Ptr() , Tbl1Num() , d.m_type , L"" ) ) != L"" )
				os << v << d.m_value.m_data_ary.p[0];
			else if( ( v = MatchTable( Tbl2Ptr() , Tbl2Num() , d.m_type , L"" ) ) != L"" )
				os << v << d.m_value.m_data_ary.p[0] << L"," << d.m_value.m_data_ary.p[1];
			else if( ( v = MatchTable( Tbl4Ptr() , Tbl4Num() , d.m_type , L"" ) ) != L"" )
				os << v << d.m_value.m_data_ary.p[0] << L"," << d.m_value.m_data_ary.p[1] << L"," << d.m_value.m_data_ary.p[2] << L"," << d.m_value.m_data_ary.p[3];
			else if( ( v = MatchTable( Tbl6Ptr() , Tbl6Num() , d.m_type , L"" ) ) != L"" )
				os << v << d.m_value.m_data_ary.p[0] << L"," << d.m_value.m_data_ary.p[1] << L"," << d.m_value.m_data_ary.p[2] << L"," << d.m_value.m_data_ary.p[3] << L"," << d.m_value.m_data_ary.p[4] << L"," << d.m_value.m_data_ary.p[5];
			else if( ( v = MatchTable( TblArcPtr() , TblArcNum() , d.m_type , L"" ) ) != L"" )
				os << v << d.m_value.m_arc.rx << L"," << d.m_value.m_arc.ry << L"," << d.m_value.m_arc.x_axis_rotation << L"," << ( d.m_value.m_arc.large_arc_flag == false ? 0 : 1 )  << L"," << ( d.m_value.m_arc.sweep_flag == false ? 0 : 1 ) << L"," << d.m_value.m_arc.x << L"," << d.m_value.m_arc.y;
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , start_node_id , parse_p0 )
	parse_map_edge( start_node_id , start_node_id , parse_p1 )
	parse_map_edge( start_node_id , start_node_id , parse_p2 )
	parse_map_edge( start_node_id , start_node_id , parse_p4 )
	parse_map_edge( start_node_id , start_node_id , parse_p6 )
	parse_map_edge( start_node_id , start_node_id , parse_arc )
	parse_map_edge( start_node_id , end_node_id , parse_none )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl0 , 
			((L"Z")(close_abs))
			((L"z")(close_rel))
			);
	df_table_func
			( 
			Type , 
			Tbl1 , 
			((L"H")(lineto_horizontal_abs))
			((L"h")(lineto_horizontal_rel))
			((L"V")(lineto_vertical_abs))
			((L"v")(lineto_vertical_rel))
			);
	df_table_func
			( 
			Type , 
			Tbl2 , 
			((L"M")(moveto_abs))
			((L"m")(moveto_rel))
			((L"L")(lineto_abs))
			((L"l")(lineto_rel))
			((L"T")(curveto_quadratic_smooth_abs))
			((L"t")(curveto_quadratic_smooth_rel))
			);
	df_table_func
			( 
			Type , 
			Tbl4 , 
			((L"S")(curveto_cubic_smooth_abs))
			((L"s")(curveto_cubic_smooth_rel))
			((L"Q")(curveto_quadratic_abs))
			((L"q")(curveto_quadratic_rel))
			);
	df_table_func
			( 
			Type , 
			Tbl6 , 
			((L"C")(curveto_cubic_abs))
			((L"c")(curveto_cubic_rel))
			);
	df_table_func
			( 
			Type , 
			TblArc , 
			((L"A")(arc_abs))
			((L"a")(arc_rel))
			);
	bool parse_p0
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Seg		d;
		df_skip_space();
		if( false == MatchTable( str , pos , Tbl0Ptr() , Tbl0Num() , &d.m_type ) )
			return false;
		m_list[ m_list.Add() ] = d;
		return true;
	}
	bool parse_p1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Seg		d;
		df_skip_space();
		if( false == MatchTable( str , pos , Tbl1Ptr() , Tbl1Num() , &d.m_type ) )
			return false;
		while( true )
		{
			df_skip_delimiter();
			df_number_r( d.m_value.m_data_ary.p[0] , true );
			m_list[ m_list.Add() ] = d;
		}
		return true;
	}
	bool parse_p2
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Seg		d;
		df_skip_space();
		if( false == MatchTable( str , pos , Tbl2Ptr() , Tbl2Num() , &d.m_type ) )
			return false;
		while( true )
		{
			int		i;
			for( i = 0 ; i < 2 ; i++ )
			{
				df_skip_delimiter();
				df_number_r( d.m_value.m_data_ary.p[i] , true );
			}
			m_list[ m_list.Add() ] = d;
		}
		return true;
	}
	bool parse_p4
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Seg		d;
		df_skip_space();
		if( false == MatchTable( str , pos , Tbl4Ptr() , Tbl4Num() , &d.m_type ) )
			return false;
		while( true )
		{
			int		i;
			for( i = 0 ; i < 4 ; i++ )
			{
				df_skip_delimiter();
				df_number_r( d.m_value.m_data_ary.p[i] , true );
			}
			m_list[ m_list.Add() ] = d;
		}
		return true;
	}
	bool parse_p6
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Seg		d;
		df_skip_space();
		if( false == MatchTable( str , pos , Tbl6Ptr() , Tbl6Num() , &d.m_type ) )
			return false;
		while( true )
		{
			int		i;
			for( i = 0 ; i < 6 ; i++ )
			{
				df_skip_delimiter();
				df_number_r( d.m_value.m_data_ary.p[i] , true );
			}
			m_list[ m_list.Add() ] = d;
		}
		return true;
	}
	bool parse_arc
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Seg		d;
		df_skip_space();
		if( false == MatchTable( str , pos , TblArcPtr() , TblArcNum() , &d.m_type ) )
			return false;

		while( true )
		{
			df_skip_delimiter();
			df_number_r( d.m_value.m_arc.rx , true );
			df_skip_delimiter();
			df_number_r( d.m_value.m_arc.ry , true );
			df_skip_delimiter();
			df_number_r( d.m_value.m_arc.x_axis_rotation , true );
			df_skip_delimiter();
			{
				Integer_svgv	parse;
				if( false == parse.StringTo( str , pos ) )
					return true;
				d.m_value.m_arc.large_arc_flag	= parse.m_value == 0 ? false : true;
			}
			df_skip_delimiter();
			{
				Integer_svgv	parse;
				if( false == parse.StringTo( str , pos ) )
					return false;
				d.m_value.m_arc.sweep_flag	= parse.m_value == 0 ? false : true;
			}
			df_skip_delimiter();
			df_number_r( d.m_value.m_arc.x , true );
			df_skip_delimiter();
			df_number_r( d.m_value.m_arc.y , true );
			m_list[ m_list.Add() ] = d;
		}
		return true;
	}
	bool parse_none
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
/*
		df_skip_delimiter();
		if( *pos != str.length() )
			return false;
*/
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Points_svgv : protected Parser
{
public:
	class CoordinatePairs
	{
	public:
		Coordinate_svgv		m_value[2];
	};
	Array<CoordinatePairs>	m_list;
	
	df_list_operator_svgv( Points );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[off].m_value[0].ToString();
			os << L",";
			os << m_list[off].m_value[1].ToString();
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		CoordinatePairs		d;
		{
			Coordinate_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			d.m_value[ 0 ] = parse;
		}
		df_delimiter();
		{
			Coordinate_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			d.m_value[ 1 ] = parse;
		}
		m_list[ m_list.Add() ]	= d;

		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		CoordinatePairs		d;
		{
			Coordinate_svgv	parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			d.m_value[ 0 ] = parse;
		}
		df_delimiter();
		{
			Coordinate_svgv	parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			d.m_value[ 1 ] = parse;
		}
		m_list[ m_list.Add() ]	= d;

		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};

//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Align , 
		none , 
		((L"none")(none))
		((L"xMinYMin")(xMinYMin))
		((L"xMidYMin")(xMidYMin))
		((L"xMaxYMin")(xMaxYMin))
		((L"xMinYMid")(xMinYMid))
		((L"xMidYMid")(xMidYMid))
		((L"xMaxYMid")(xMaxYMid))
		((L"xMinYMax")(xMinYMax))
		((L"xMidYMax")(xMidYMax))
		((L"xMaxYMax")(xMaxYMax))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		MeetOrSlice , 
		meet , 
		((L"meet")(meet))
		((L"slice")(slice))
		);
//-------------------------------------------------------------------------------------------------
class PreserveAspectRatio_svgv : protected Parser
{
public:
	bool				m_defer;
	Align_svgv			m_align;
	bool				m_meet_or_slice_f;
	MeetOrSlice_svgv	m_meet_or_slice;

	PreserveAspectRatio_svgv() : m_defer( false ) , m_meet_or_slice_f( false ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_defer == true )
			os << L"defer,";
		os << m_align.ToString();
		if( m_meet_or_slice_f == true )
		{
			os << L",";
			os << m_meet_or_slice.ToString();
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_end()
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		m_defer = MatchString( str , pos , L"defer" , 0 );
		if( m_defer == true )
			df_delimiter();
		{
			Align_svgv	parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_align = parse;
		}
		df_delimiter_r( true );
		{
			MeetOrSlice_svgv	parse;
			if( true == parse.StringTo( str , pos ) )
			{
				m_meet_or_slice_f	= true;
				m_meet_or_slice	= parse;
			}
		}
		return true;
	}
};

//-------------------------------------------------------------------------------------------------
class LetterSpacing_svgv : protected Parser
{
public:
	enum Type
	{
		normal , 
		length , 
		inherit , 
	};
	Type			m_type;
	Length_svgv		m_length;

	LetterSpacing_svgv() : m_type( normal ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == length )
			os << m_length.ToString();		
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"normal" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_length )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"normal")(normal))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_length
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= length;
		m_length	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class DashArray_svgv : protected Parser
{
public:
	Array<Length_svgv>	m_list;

	df_list_operator_svgv( DashArray );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[ off ].ToString();
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class StrokeDashArray_svgv : protected Parser
{
public:
	enum Type
	{
		 none , 
		 dasharray , 
		 inherit , 
	};
	Type			m_type;
	DashArray_svgv	m_dasharray;
	
	StrokeDashArray_svgv() : m_type( none ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == dasharray )
			os << m_dasharray.ToString();	
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"none" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_dasharray )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"none")(none))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_dasharray
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		DashArray_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= dasharray;
		m_dasharray	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class StrokeDashOffset_svgv : protected Parser
{
public:
	enum Type
	{
		length , 
		inherit
	};
	Type		m_type;
	Length_svgv	m_length;
	
	StrokeDashOffset_svgv() : m_type( length ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == length )
			os << m_length.ToString();	
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"inherit" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_length )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_length
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= length;
		m_length	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class Miterlimit_svgv : protected Parser
{
public:
	double		m_value;

	Miterlimit_svgv() : m_value( 1.0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_value;
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		{
			RealParser	parse;
			if( false == parse.Parse( str , pos , errpos ) )
				return false;
			m_value = parse.m_value;
		}	
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class StrokeMiterlimit_svgv : protected Parser
{
public:
	enum Type
	{
		miterlimit , 
		inherit , 
	};
	Type			m_type;
	Miterlimit_svgv	m_miterlimit;
	
	StrokeMiterlimit_svgv() : m_type( miterlimit ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == miterlimit )
			os << m_miterlimit.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"inherit" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_miterlimit )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_miterlimit
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Miterlimit_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= miterlimit;
		m_miterlimit= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class StrokeWidth_svgv : protected Parser
{
public:
	enum Type
	{
		length , 
		inherit , 
	};
	Type		m_type;
	Length_svgv	m_length;

	StrokeWidth_svgv() : m_type( length )
	{
		m_length.m_type		= Length_svgv::none;
		m_length.m_value	= 1.0f;
	}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == length )
			os << m_length.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"inherit" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_length )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_length
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Length_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type		= length;
		m_length	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class ViewBox_svgv : protected Parser
{
public:
	Length_svgv	m_x;
	Length_svgv	m_y;
	Length_svgv	m_width;
	Length_svgv	m_height;

	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		os << m_x.ToString();
		os << L",";
		os << m_y.ToString();
		os << L",";
		os << m_width.ToString();
		os << L",";
		os << m_height.ToString();
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_x = parse;
		}
		df_delimiter();
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_y = parse;
		}
		df_delimiter();
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_width = parse;
		}
		df_delimiter();
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_height = parse;
		}	
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class FamilyName_svgv : protected Parser
{
public:
	wstring		m_value;

	df_stringto_svgv();
	wstring ToString()
	{
		return m_value;
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_quot )
	parse_map_edge( start_node_id , end_node_id , parse_dquot )
	parse_map_edge( start_node_id , end_node_id , parse_text )
	parse_map_end()
	bool parse_quot
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		df_match_string( L"'" );
		if( false == MatchString( str , pos , L"[^']*" , &m_value ) )
			return false;
		df_match_string( L"'" );
		return true;
	}
	bool parse_dquot
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		df_match_string( L"\"" );
		if( false == MatchString( str , pos , L"[^\"]*" , &m_value ) )
			return false;
		df_match_string( L"\"" );
		return true;
	}
	bool parse_text
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		if( false == MatchString( str , pos , L"[^ \t\r\n]*" , &m_value ) )
			return false;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class FamilyNameList_svgv : protected Parser
{
public:
	Array<FamilyName_svgv>	m_list;
	
	df_list_operator_svgv( FamilyNameList );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( off != 0 )
				os << L",";
			os << m_list[ off ].ToString();	
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		FamilyName_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		FamilyName_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_list[ m_list.Add() ]	= parse;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class FontFamily_svgv : protected Parser
{
public:
	enum Type
	{
		inherit , 
		familynamelist , 
	};
	Type					m_type;
	FamilyNameList_svgv		m_familynamelist;

	FontFamily_svgv() : m_type( familynamelist ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == familynamelist )
			os << m_familynamelist.ToString();
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"inherit" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_familynamelist )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_familynamelist
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		FamilyNameList_svgv		parse;
		if( false == parse.StringTo( str , pos ) )
			return false;
		m_type				= familynamelist;
		m_familynamelist	= parse;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FontStretch , 
		normal , 
		((L"normal")(normal))
		((L"wider")(wider))
		((L"narrower")(narrower))
		((L"ultra-condensed")(ultra_condensed))
		((L"extra-condensed")(extra_condensed))
		((L"condensed")(condensed))
		((L"semi-condensed")(semi_condensed))
		((L"semi-expanded")(semi_expanded))
		((L"expanded")(expanded))
		((L"extra-expanded")(extra_expanded))
		((L"ultra-expanded")(ultra_expanded))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FontStyle , 
		normal , 
		((L"normal")(normal))
		((L"italic")(italic))
		((L"oblique")(oblique))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FontVariant , 
		normal , 
		((L"normal")(normal))
		((L"small-caps")(small_caps))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FontWeight , 
		normal , 
		((L"normal")(normal))
		((L"bold")(bold))
		((L"bolder")(bolder))
		((L"lighter")(lighter))
		((L"100")(_100))
		((L"200")(_200))
		((L"300")(_300))
		((L"400")(_400))
		((L"500")(_500))
		((L"600")(_600))
		((L"700")(_700))
		((L"800")(_800))
		((L"900")(_900))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
class StyleName : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()

// variable
public:
	wstring		m_value;
	
// parser edge functions
private:
bool parse
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	if( false == MatchString( str , pos , L"[A-Za-z][A-Za-z0-9\\-_]*" , &m_value ) )
		return false;
	return true;
}
};
//-------------------------------------------------------------------------------------------------
class StyleValue : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()

// variable
public:
	wstring		m_value;
	
// parser edge functions
private:
bool parse
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	if( false == MatchString( str , pos , L"[^;\"]+" , &m_value ) )
		return false;
	return true;
}
};
//-------------------------------------------------------------------------------------------------
class Style_svgv : protected Parser
{
public:
	class Attr
	{
	public:
		wstring		m_name;
		wstring		m_value;
	};
	Array<Attr>		m_list;

	df_list_operator_svgv( Style );
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			os << m_list[off].m_name;
			os << L":";
			os << m_list[off].m_value;
			os << L";";
		}
		return os.str();
	}
	wstring GetValue
			(
			const wstring&	name
			)
	{
		int		off , num = m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( m_list[off].m_name == name )
				return m_list[off].m_value;
		}
		return L"";
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		Style_svgv::Attr	att;
		df_skip_space();
		{
			StyleName		parse;
			if( false == parse.Parse( str , pos , errpos ) )
				return false;
			att.m_name = parse.m_value;
		}
		df_skip_space();
		df_match_string( L":" );
		df_skip_space();
		{
			StyleValue		parse;
			if( false == parse.Parse( str , pos , errpos ) )
				return false;
			att.m_value = parse.m_value;
		}
		m_list[ m_list.Add() ] = att;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		df_match_string( L";" );

		Style_svgv::Attr	att;
		df_skip_space();
		{
			StyleName		parse;
			if( false == parse.Parse( str , pos , errpos ) )
				return false;
			att.m_name = parse.m_value;
		}
		df_skip_space();
		df_match_string( L":" );
		df_skip_space();
		{
			StyleValue		parse;
			if( false == parse.Parse( str , pos , errpos ) )
				return false;
			att.m_value = parse.m_value;
		}	
		m_list[ m_list.Add() ] = att;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class EnableBackground_svgv : protected Parser
{
public:
	enum Type
	{
		accumulate , 
		_new , 
		inherit , 
	};
	Type			m_type;
	Length_svgv		m_x;
	Length_svgv		m_y;
	Length_svgv		m_width;
	Length_svgv		m_height;
	
	EnableBackground_svgv() : m_type( accumulate ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == _new )
		{
			os << L"new ";
			os << m_x.ToString();
			os << L",";
			os << m_y.ToString();
			os << L",";
			os << m_width.ToString();
			os << L",";
			os << m_height.ToString();
		}
		else
			os << MatchTable( TblPtr() , TblNum() , m_type , L"accumulate" );
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , end_node_id , parse_new )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl , 
			((L"accumulate")(accumulate))
			((L"inherit")(inherit))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		if( false == MatchTable( str , pos , TblPtr() , TblNum() , &m_type ) )
			return false;
		return true;
	}
	bool parse_new
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_match_string( L"new" );
		df_skip_space();
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_x	= parse;
		}
		df_delimiter();
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_y	= parse;
		}
		df_delimiter();
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_width	= parse;
		}
		df_delimiter();
		{
			Length_svgv		parse;
			if( false == parse.StringTo( str , pos ) )
				return false;
			m_height	= parse;
		}
		m_type	= _new;	
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class TextDecoration_svgv : protected Parser
{
public:
	enum Type
	{
		none , 
		decoration , 
		inherit , 
	};
	enum Decoration
	{
		underline		= 1<<0 , 
		overline		= 1<<1 , 
		line_through	= 1<<2 , 
		blink			= 1<<3 , 
	};
	Type	m_type;
	int		m_decoration;

	TextDecoration_svgv() : m_type( none ) , m_decoration( 0 ){}
	df_stringto_svgv();
	wstring ToString()
	{
		wostringstream os;
		if( m_type == decoration )
		{
			bool	f = false;
			if( ( m_decoration & underline ) != 0 )
			{
				if( f != false )
					os << L",";
				os << MatchTable( Tbl2Ptr() , Tbl2Num() , underline );
				f = true;
			}
			if( ( m_decoration & overline ) != 0 )
			{
				if( f != false )
					os << L",";
				os << MatchTable( Tbl2Ptr() , Tbl2Num() , overline );
				f = true;
			}
			if( ( m_decoration & line_through ) != 0 )
			{
				if( f != false )
					os << L",";
				os << MatchTable( Tbl2Ptr() , Tbl2Num() , line_through );
				f = true;
			}
			if( ( m_decoration & blink ) != 0 )
			{
				if( f != false )
					os << L",";
				os << MatchTable( Tbl2Ptr() , Tbl2Num() , blink );
				f = true;
			}
		}
		else
		{
			os << MatchTable( Tbl1Ptr() , Tbl1Num() , m_type , L"none" );
		}
		return os.str();
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_type )
	parse_map_edge( start_node_id , 1 , parse_s_to_1 )
	parse_map_edge( 1 , 1 , parse_1_to_1 )
	parse_map_edge( 1 , end_node_id , parse_1_to_e )
	parse_map_end()
	df_table_func
			( 
			Type , 
			Tbl1 , 
			((L"none")(none))
			((L"inherit")(inherit))
			);
	df_table_func
			( 
			Decoration , 
			Tbl2 , 
			((L"underline")(underline))
			((L"overline")(overline))
			((L"overline")(overline))
			((L"line-through")(line_through))
			((L"blink")(blink))
			);
	bool parse_type
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		if( false == MatchTable( str , pos , Tbl1Ptr() , Tbl1Num() , &m_type ) )
			return false;
		return true;	
	}
	bool parse_s_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		Decoration	t;
		if( false == MatchTable( str , pos , Tbl2Ptr() , Tbl2Num() , &t ) )
			return false;
		m_type			= decoration;
		m_decoration	= t;
		return true;
	}
	bool parse_1_to_1
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_delimiter();
		Decoration	t;
		if( false == MatchTable( str , pos , Tbl2Ptr() , Tbl2Num() , &t ) )
			return false;
		m_decoration |= t;
		return true;
	}
	bool parse_1_to_e
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
class LanguageCode_svgv : public Parser
{
public:
	wstring		m_value;
	
	df_stringto_svgv();
	wstring ToString()
	{
		return m_value;
	}
private:
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse )
	parse_map_end()
	bool parse
			(
			const wstring&	str , 
			int*			pos , 
			int*			errpos
			)
	{
		df_skip_space();
		if( false == MatchString( str , pos , L"[^ \t\r\n]+" , &m_value ) )
			return false;
		return true;
	}
};
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		XmlSpace , 
		_default , 
		((L"default")(_default))
		((L"preserve")(preserve))
		);
//-------------------------------------------------------------------------------------------------
typedef Cdata_svgv	FeatureList_svgv;
//-------------------------------------------------------------------------------------------------
typedef Cdata_svgv	ExtensionList_svgv;
//-------------------------------------------------------------------------------------------------
typedef Cdata_svgv	LanguageCodes_svgv;
//-------------------------------------------------------------------------------------------------
typedef Uri_svgv	XmlnsXlink_svgv;
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		XlinkType , 
		simple , 
		((L"simple")(simple))
		((L"extended")(extended))
		((L"locator")(locator))
		((L"arc")(arc))
		);
//-------------------------------------------------------------------------------------------------
typedef Cdata_svgv	XlinkRole_svgv;
//-------------------------------------------------------------------------------------------------
typedef Uri_svgv	XlinkArcrole_svgv;
//-------------------------------------------------------------------------------------------------
typedef Cdata_svgv	XlinkTitle_svgv;
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		XlinkShow , 
		embed , 
		((L"embed")(embed))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		XlinkActuate , 
		onLoad , 
		((L"onRequest")(onRequest))
		((L"onLoad")(onLoad))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		StrokeLinecap , 
		butt , 
		((L"butt")(butt))
		((L"round")(round))
		((L"square")(square))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		StrokeLinejoin , 
		miter , 
		((L"miter")(miter))
		((L"round")(round))
		((L"bevel")(bevel))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ColorInterpolation , 
		_auto , 
		((L"auto")(_auto))
		((L"sRGB")(sRGB))
		((L"linearRGB")(linearRGB))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ColorRendering , 
		_auto , 
		((L"auto")(_auto))
		((L"optimizeSpeed")(optimizeSpeed))
		((L"optimizeQuality")(optimizeQuality))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Display , 
		none , 
		((L"inline")(inline_))
		((L"block")(block))
		((L"list-item")(list_item))
		((L"run-in")(run_in))
		((L"compact")(compact))
		((L"marker")(marker))
		((L"table")(table))
		((L"inline-table")(inline_table))
		((L"table-row-group")(table_row_group))
		((L"table-header-group")(table_header_group))
		((L"table-footer-group")(table_footer_group))
		((L"table-row")(table_row))
		((L"table-column-group")(table_column_group))
		((L"table-column")(table_column))
		((L"table-cell")(table_cell))
		((L"table-caption")(table_caption))
		((L"none")(none))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ImageRendering , 
		_auto , 
		((L"auto")(_auto))
		((L"optimizeSpeed")(optimizeSpeed))
		((L"optimizeQuality")(optimizeQuality))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		PointerEvents , 
		none , 
		((L"visiblePainted")(visiblePainted))
		((L"visibleFill")(visibleFill))
		((L"visibleStroke")(visibleStroke))
		((L"visible")(visible))
		((L"painted")(painted))
		((L"fill")(fill))
		((L"stroke")(stroke))
		((L"all")(all))
		((L"none")(none))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ShapeRendering , 
		_auto , 
		((L"auto")(_auto))
		((L"optimizeSpeed")(optimizeSpeed))
		((L"crispEdges")(crispEdges))
		((L"geometricPrecision")(geometricPrecision))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		TextRendering , 
		_auto , 
		((L"auto")(_auto))
		((L"optimizeSpeed")(optimizeSpeed))
		((L"optimizeLegibility")(optimizeLegibility))
		((L"geometricPrecision")(geometricPrecision))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Visibility , 
		visible , 
		((L"visible")(visible))
		((L"hidden")(hidden))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		AlignmentBaseline , 
		baseline , 
		((L"baseline")(baseline))
		((L"top")(top))
		((L"before-edge")(before_edge))
		((L"text-top")(text_top))
		((L"text-before-edge")(text_before_edge))
		((L"middle")(middle))
		((L"bottom")(bottom))
		((L"after-edge")(after_edge))
		((L"text-bottom")(text_bottom))
		((L"text-after-edge")(text_after_edge))
		((L"ideographic")(ideographic))
		((L"lower")(lower))
		((L"hanging")(hanging))
		((L"mathematical")(mathematical))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Direction , 
		ltr , 
		((L"ltr")(ltr))
		((L"rtl")(rtl))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		UnicodeBidi , 
		normal , 
		((L"normal")(normal))
		((L"embed")(embed))
		((L"bidi-override")(bidi_override))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		DominantBaseline , 
		_auto , 
		((L"auto")(_auto))
		((L"autosense-script")(autosense_script))
		((L"no-change")(no_change))
		((L"reset")(reset))
		((L"ideographic")(ideographic))
		((L"lower")(lower))
		((L"hanging")(hanging))
		((L"mathematical")(mathematical))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		TextAnchor , 
		start , 
		((L"start")(start))
		((L"middle")(middle))
		((L"end")(end))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		WritingMode , 
		lr_tb , 
		((L"lr-tb")(lr_tb))
		((L"rl-tb")(rl_tb))
		((L"tb-rl")(tb_rl))
		((L"lr")(lr))
		((L"rl")(rl))
		((L"tb")(tb))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Overflow , 
		_auto , 
		((L"visible")(visible))
		((L"hidden")(hidden))
		((L"scroll")(scroll))
		((L"auto")(_auto))
		((L"inherit")(inherit))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ZoomAndPan , 
		magnify , 
		((L"disable")(disable))
		((L"magnify")(magnify))
		((L"zoom")(zoom))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		LengthAdjust , 
		spacing , 
		((L"spacing")(spacing))
		((L"spacingAndGlyphs")(spacingAndGlyphs))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Method , 
		align , 
		((L"align")(align))
		((L"stretch")(stretch))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Spacing , 
		_auto , 
		((L"auto")(_auto))
		((L"exact")(exact))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		MarkerUnits , 
		strokeWidth , 
		((L"strokeWidth")(strokeWidth))
		((L"userSpaceOnUse")(userSpaceOnUse))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		RenderingIntent , 
		_auto , 
		((L"auto")(_auto))
		((L"perceptual")(perceptual))
		((L"relative-colorimetric")(relative_colorimetric))
		((L"saturation")(saturation))
		((L"absolute-colorimetric")(absolute_colorimetric))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		SpreadMethod , 
		pad , 
		((L"pad")(pad))
		((L"reflect")(reflect))
		((L"repeat")(repeat))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Units , 
		userSpaceOnUse , 
		((L"userSpaceOnUse")(userSpaceOnUse))
		((L"objectBoundingBox")(objectBoundingBox))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		Mode , 
		normal , 
		((L"normal")(normal))
		((L"multiply")(multiply))
		((L"screen")(screen))
		((L"darken")(darken))
		((L"lighten")(lighten))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FeColorMatrixType , 
		matrix , 
		((L"matrix")(matrix))
		((L"saturate")(saturate))
		((L"hueRotate")(hueRotate))
		((L"luminanceToAlpha")(luminanceToAlpha))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ComponentTransferFunctionType , 
		identity , 
		((L"identity")(identity))
		((L"table")(table))
		((L"discrete")(discrete))
		((L"linear")(linear))
		((L"gamma")(gamma))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FeCompositeOperator , 
		over , 
		((L"over")(over))
		((L"in")(in))
		((L"out")(out))
		((L"atop")(atop))
		((L"xor")(xor))
		((L"arithmetic")(arithmetic))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		EdgeMode , 
		duplicate , 
		((L"duplicate")(duplicate))
		((L"wrap")(wrap))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		ChannelSelector , 
		A , 
		((L"R")(R))
		((L"G")(G))
		((L"B")(B))
		((L"A")(A))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FeMorphologyOperator , 
		erode , 
		((L"erode")(erode))
		((L"dilate")(dilate))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		StitchTiles , 
		noStitch , 
		((L"stitch")(stitch))
		((L"noStitch")(noStitch))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		FeTurbulenceType , 
		turbulence , 
		((L"fractalNoise")(fractalNoise))
		((L"turbulence")(turbulence))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		AXlinkShow , 
		replace , 
		((L"new")(_new))
		((L"replace")(replace))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		AnimTimingRestart , 
		always , 
		((L"always")(always))
		((L"never")(never))
		((L"whenNotActive")(whenNotActive))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		AnimTimingFill , 
		remove , 
		((L"remove")(remove))
		((L"freeze")(freeze))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		CalcMode , 
		linear , 
		((L"discrete")(discrete))
		((L"linear")(linear))
		((L"paced")(paced))
		((L"spline")(spline))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		AnimAdditionAdditive , 
		replace , 
		((L"replace")(replace))
		((L"sum")(sum))
		);
//-------------------------------------------------------------------------------------------------
df_enum_class
		(
		AnimAdditionAccumulate , 
		none , 
		((L"none")(none))
		((L"sum")(sum))
		);
///////////////////////////////////////////////////////////////////////////////////////////////////
// attribute classes define

//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		stdAttrs , 
		(0xEA845963)(0x7B8A498b)(0xB950670D)(0xE4AA606E) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"id")(Id)(m_id)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		langSpaceAttrs , 
		(0x50DBE65D)(0x16044019)(0x8907512D)(0x6DDA2B35) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"xml:lang")(LanguageCode)(m_xml_lang))
		((implied)(L"xml:space")(XmlSpace)(m_xml_space)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		testAttrs , 
		(0x20DABBEB)(0xAA0B4139)(0xB33DB5BE)(0xF36B020F) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"requiredFeatures")(FeatureList)(m_required_features))
		((implied)(L"requiredExtensions")(ExtensionList)(m_required_extensions))
		((implied)(L"systemLanguage")(LanguageCodes)(m_system_language)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		xlinkRefAttrs , 
		(0x9AD2328C)(0x65D84a53)(0x946A15B3)(0xF2EB7792) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"xmlns:xlink")(XmlnsXlink)(m_xmlns_xlink)) 
		((implied)(L"xlink:type")(XlinkType)(m_xlink_type)) 
		((implied)(L"xlink:role")(XlinkArcrole)(m_xlink_role)) 
		((implied)(L"xlink:arcrole")(XlinkArcrole)(m_xlink_arcrole)) 
		((implied)(L"xlink:title")(XlinkTitle)(m_xlink_title)) 
		((implied)(L"xlink:show")(XlinkShow)(m_xlink_show)) 
		((implied)(L"xlink:actuate")(XlinkActuate)(m_xlink_actuate)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_Containers , 
		(0x51DC32FD)(0x322F48d2)(0x8F235FD5)(0xB77ADD33) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"enable-background")(EnableBackground)(m_enable_background)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_feFlood , 
		(0x343EF823)(0xEF4D4a43)(0xAF5B4EDA)(0x04EFC6C7) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"flood-color")(Color)(m_flood_color)) 
		((implied)(L"flood-opacity")(Opacity)(m_flood_opacity)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_FillStroke , 
		(0xE1A92363)(0x8BB64209)(0x9B0D846B)(0x97444B47) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"fill")(Paint)(m_fill)) 
		((implied)(L"fill-opacity")(Opacity)(m_fill_opacity)) 
		((implied)(L"fill-rule")(ClipFillRule)(m_fill_rule)) 
		((implied)(L"stroke")(Paint)(m_stroke)) 
		((implied)(L"stroke-dasharray")(StrokeDashArray)(m_stroke_dasharray)) 
		((implied)(L"stroke-dashoffset")(StrokeDashOffset)(m_stroke_dashoffset)) 
		((implied)(L"stroke-linecap")(StrokeLinecap)(m_stroke_linecap)) 
		((implied)(L"stroke-linejoin")(StrokeLinejoin)(m_stroke_linejoin)) 
		((implied)(L"stroke-miterlimit")(StrokeMiterlimit)(m_stroke_miterlimit)) 
		((implied)(L"stroke-opacity")(Opacity)(m_stroke_opacity)) 
		((implied)(L"stroke-width")(StrokeWidth)(m_stroke_width)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_FontSpecification , 
		(0xF92B8EB8)(0x2F044b56)(0xB0FBA615)(0x458A9D84) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"font-family")(FontFamily)(m_fontfamily)) 
		((implied)(L"font-size")(FontSize)(m_font_size)) 
		((implied)(L"font-size-adjust")(FontSizeAdjust)(m_font_size_adjust)) 
		((implied)(L"font-stretch")(FontStretch)(m_font_stretch)) 
		((implied)(L"font-style")(FontStyle)(m_font_style)) 
		((implied)(L"font-variant")(FontVariant)(m_font_variant)) 
		((implied)(L"font-weight")(FontWeight)(m_font_weight)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_Gradients , 
		(0xB3AC6153)(0x55BC4e17)(0x84AE7597)(0x02BFC397) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"stop-color")(Color)(m_stop_color)) 
		((implied)(L"stop-opacity")(Opacity)(m_stop_opacity)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_Graphics , 
		(0xC55810E5)(0x0040400c)(0x9711068E)(0x6FB0CBD9) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"clip-path")(ClipPath)(m_clip_path)) 
		((implied)(L"clip-rule")(ClipFillRule)(m_clip_rule)) 
		((implied)(L"color")(Color)(m_color)) 
		((implied)(L"color-interpolation")(ColorInterpolation)(m_color_interpolation)) 
		((implied)(L"color-rendering")(ColorRendering)(m_color_rendering)) 
		((implied)(L"cursor")(Cursor)(m_cursor)) 
		((implied)(L"display")(Display)(m_display)) 
		((implied)(L"filter")(Filter)(m_filter)) 
		((implied)(L"image-rendering")(ImageRendering)(m_image_rendering)) 
		((implied)(L"mask")(Mask)(m_mask)) 
		((implied)(L"opacity")(Opacity)(m_opacity)) 
		((implied)(L"pointer-events")(PointerEvents)(m_pointer_events)) 
		((implied)(L"shape-rendering")(ShapeRendering)(m_shape_rendering)) 
		((implied)(L"text-rendering")(TextRendering)(m_text_rendering)) 
		((implied)(L"visibility")(Visibility)(m_visibility)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_Images , 
		(0x40BCEB86)(0xC1624560)(0x91CAE50F)(0x6872CE86) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"color-profile")(Cdata)(m_color_profile)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_LightingEffects , 
		(0x8BAE48C2)(0x44B84810)(0xBC601A28)(0xB0EF8333) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"lighting-color")(Color)(m_lighting_color)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_Markers , 
		(0xEBC9C569)(0x53064d4d)(0x92DD2BEC)(0x866C9140) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"marker-start")(Marker)(m_marker_start))
		((implied)(L"marker-mid")(Marker)(m_marker_mid))
		((implied)(L"marker-end")(Marker)(m_marker_end)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_TextContentElements , 
		(0x9C1B8A07)(0x35724ac1)(0xA2AD5241)(0xD766638A) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"alignment-baseline")(AlignmentBaseline)(m_alignment_baseline))
		((implied)(L"baseline-shift")(BaselineShift)(m_baseline_shift))
		((implied)(L"direction")(Direction)(m_direction))
		((implied)(L"glyph-orientation-horizontal")(GlyphOrientationHorizontal)(m_glyph_orientation_horizontal))
		((implied)(L"glyph-orientation-vertical")(GlyphOrientationVertical)(m_glyph_orientation_vertical))
		((implied)(L"kerning")(Kerning)(m_kerning))
		((implied)(L"letter-spacing")(LetterSpacing)(m_letter_spacing))
		((implied)(L"text-decoration")(TextDecoration)(m_text_decoration))
		((implied)(L"unicode-bidi")(UnicodeBidi)(m_unicode_bidi))
		((implied)(L"word-spacing")(LetterSpacing)(m_word_spacing)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_TextElements , 
		(0xC1959FB0)(0x2B004e86)(0xAAAF75AF)(0xD562E0E7) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"dominant-baseline")(DominantBaseline)(m_dominant_baseline))
		((implied)(L"text-anchor")(TextAnchor)(m_text_anchor))
		((implied)(L"writing-mode")(WritingMode)(m_writing_mode)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_Viewports , 
		(0xBBA095A6)(0x3DBF427a)(0xA8E5A2EF)(0x749629A2) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"clip")(Clip)(m_clip))
		((implied)(L"overflow")(Overflow)(m_overflow)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		graphicsElementEvents , 
		(0xA705D5D0)(0xA95F4307)(0x80CFF168)(0xF589CDEF) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"onfocusin")(Script)(m_onfocusin))
		((implied)(L"onfocusout")(Script)(m_onfocusout))
		((implied)(L"onactivate")(Script)(m_onactivate))
		((implied)(L"onclick")(Script)(m_onclick))
		((implied)(L"onmousedown")(Script)(m_onmousedown))
		((implied)(L"onmouseup")(Script)(m_onmouseup))
		((implied)(L"onmouseover")(Script)(m_onmouseover))
		((implied)(L"onmousemove")(Script)(m_onmousemove))
		((implied)(L"onmouseout")(Script)(m_onmouseout))
		((implied)(L"onload")(Script)(m_onload)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		documentEvents , 
		(0xD266B792)(0xD99D4a19)(0xB6299C18)(0xDE0294EF) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"onunload")(Script)(m_onunload))
		((implied)(L"onabort")(Script)(m_onabort))
		((implied)(L"onerror")(Script)(m_onerror))
		((implied)(L"onresize")(Script)(m_onresize))
		((implied)(L"onscroll")(Script)(m_onscroll))
		((implied)(L"onzoom")(Script)(m_onzoom)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		animationEvents , 
		(0x523577A6)(0xDF454335)(0xBFD0CC09)(0x6AFF059A) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"onbegin")(Script)(m_onbegin))
		((implied)(L"onend")(Script)(m_onend))
		((implied)(L"onrepeat")(Script)(m_onrepeat)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		StructuredText , 
		(0x86A89E55)(0xF022448a)(0x812CE5A6)(0xC0C788C4) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"content")(ContentType)(m_content)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		filter_primitive_attributes , 
		(0xA6F7E82F)(0x727041a6)(0x9BF886F8)(0x19FF9807) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((implied)(L"width")(Length)(m_width))
		((implied)(L"length")(Length)(m_length))
		((implied)(L"result")(Cdata)(m_result)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		filter_primitive_attributes_with_in , 
		(0xF01EBB5D)(0xC35E451c)(0xBA630D47)(0x370D3659) , 
		(filter_primitive_attributes) , 
		((implied)(L"in")(Cdata)(m_in)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		component_transfer_function_attributes , 
		(0x819A6C14)(0x4233459d)(0x82DD6CF0)(0xD1BB1D12) , 
		BOOST_PP_SEQ_NIL , 
		((required)(L"type")(ComponentTransferFunctionType)(m_type))
		((implied)(L"tableValues")(Cdata)(m_table_values))
		((implied)(L"slope")(Number)(m_slope))
		((implied)(L"intercept")(Number)(m_intercept))
		((implied)(L"amplitude")(Number)(m_amplitude))
		((implied)(L"exponent")(Number)(m_exponent))
		((implied)(L"offset")(Number)(m_offset)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		animElementAttrs , 
		(0x237E7C74)(0x9CE94c53)(0x98F4EA1D)(0xDB0E1A01) , 
		(xlinkRefAttrs) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		animAttributeAttrs , 
		(0xEFE1BD5F)(0xB2FE4f96)(0x855B63CA)(0x5DF34BA7) , 
		BOOST_PP_SEQ_NIL , 
		((required)(L"attributeName")(Cdata)(m_attributeName))
		((implied)(L"attributeType")(Cdata)(m_attributeType)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		animTargetAttrs , 
		(0xF2678DB5)(0x1AAA484a)(0xA9B172CF)(0x83693D96) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((required)(L"attributeName")(Cdata)(m_attributeName))
		((implied)(L"attributeType")(Cdata)(m_attributeType)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		animTimingAttrs , 
		(0x0F1A74BC)(0x042A4dda)(0x966A5F3C)(0xC9CE0A63) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"begin")(Cdata)(m_begin))
		((implied)(L"dur")(Cdata)(m_dur))
		((implied)(L"end")(Cdata)(m_end))
		((implied)(L"min")(Cdata)(m_min))
		((implied)(L"max")(Cdata)(m_max))
		((implied)(L"restart")(AnimTimingRestart)(m_restart))
		((implied)(L"repeatCount")(Cdata)(m_repeatCount))
		((implied)(L"repeatDur")(Cdata)(m_repeatDur))
		((implied)(L"fill")(AnimTimingFill)(m_fill)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		animValueAttrs , 
		(0x01DB5D47)(0xAB36402f)(0x85239144)(0x46D48466) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"calcMode")(CalcMode)(m_calcMode))
		((implied)(L"values")(Cdata)(m_values))
		((implied)(L"keyTimes")(Cdata)(m_keyTimes))
		((implied)(L"keySplines")(Cdata)(m_keySplines))
		((implied)(L"from")(Cdata)(m_from))
		((implied)(L"to")(Cdata)(m_to))
		((implied)(L"by")(Cdata)(m_by)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		animAdditionAttrs , 
		(0xF233E7E7)(0x4DE940d2)(0x8941E41C)(0xC920284A) , 
		BOOST_PP_SEQ_NIL , 
		((implied)(L"additive")(AnimAdditionAdditive)(m_additive))
		((implied)(L"accumulate")(AnimAdditionAccumulate)(m_accumulate)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_attribute_class
		(
		PresentationAttributes_All , 
		(0xD1AC7DCD)(0xEAB2494d)(0x8179679F)(0xCED9E1CA) , 
		(PresentationAttributes_Containers)
		(PresentationAttributes_feFlood)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_FontSpecification)
		(PresentationAttributes_Gradients)
		(PresentationAttributes_LightingEffects)
		(PresentationAttributes_Markers)
		(PresentationAttributes_TextContentElements)
		(PresentationAttributes_TextElements)
		(PresentationAttributes_Viewports) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);

///////////////////////////////////////////////////////////////////////////////////////////////////
// element classes define

//-------------------------------------------------------------------------------------------------
df_element_class
		(
		svg , 
		L"svg" , 
		(0x6B5AF244)(0x2B8C42f4)(0xA4D02459)(0xB2673D8E) , 
		(0x29143C86)(0x56874304)(0x8EB0AF27)(0x345680FF) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All)
		(graphicsElementEvents)
		(documentEvents) , 
		((implied)(L"xmlns")(Cdata)(m_xmlns))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"viewBox")(ViewBox)(m_viewBox))
		((implied)(L"preserveAspectRatio")(PreserveAspectRatio)(m_preserveAspectRatio))
		((implied)(L"zoomAndPan")(ZoomAndPan)(m_zoom_and_pan))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((implied)(L"width")(Length)(m_width))
		((implied)(L"height")(Length)(m_height))
		((implied)(L"contentScriptType")(ContentType)(m_contentScriptType))
		((implied)(L"contentStyleType")(ContentType)(m_contentStyleType)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		g , 
		L"g" , 
		(0xDC96C334)(0x16FC4b29)(0x983A167B)(0xDD46718A) , 
		(0x3723306B)(0x29B44cdb)(0x95090C5B)(0xA8F14C9A) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		defs , 
		L"defs" , 
		(0xE7DF998F)(0x5546450c)(0xB9CC0EE9)(0xA2F88D6A) , 
		(0x46DE88A5)(0x951A4c45)(0xB26FF694)(0xC1FC2096) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		desc , 
		L"desc" , 
		(0x32153373)(0xCD9B4933)(0xBE81F10D)(0xAFA54A46) , 
		(0x322EB71E)(0xE4254a4d)(0x80A269F3)(0x56E3C9E1) , 
		(stdAttrs)
		(langSpaceAttrs)
		(StructuredText) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		title , 
		L"title" , 
		(0xB7AD6047)(0x9441409e)(0x9EB54140)(0xEDD9E70D) , 
		(0xCF8E7B46)(0x05524522)(0x8A2F3FE9)(0x3D8880C3) , 
		(stdAttrs)
		(langSpaceAttrs)
		(StructuredText) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		symbol , 
		L"symbol" , 
		(0xC2752CA1)(0x4F7A401d)(0x81B8FFBA)(0xEAB6C9F7) , 
		(0xFEC15AB6)(0xD65946b9)(0x9A3DFD09)(0x4C6FA39B) , 
		(stdAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"viewBox")(ViewBox)(m_viewBox))
		((implied)(L"preserveAspectRatio")(PreserveAspectRatio)(m_preserveAspectRatio)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		use , 
		L"use" , 
		(0x3AA2ED4E)(0x62834b60)(0x8993CB40)(0x55148351) , 
		(0xAF5AC811)(0xA3E642f0)(0xB154F02E)(0x26376E2C) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All)
		(graphicsElementEvents) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((implied)(L"width")(Length)(m_width))
		((implied)(L"height")(Length)(m_height)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		image , 
		L"image" , 
		(0xAE394F43)(0x4D884105)(0x923346B3)(0xF2A312F4) , 
		(0x83782ECC)(0x399A4d3f)(0xB81ADD62)(0x7E0FF10E) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_Images) 
		(PresentationAttributes_Viewports)
		(graphicsElementEvents) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((required)(L"width")(Length)(m_width))
		((required)(L"height")(Length)(m_height)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		switch , 
		L"switch" , 
		(0x9A3F21CF)(0xF21F44e5)(0xBDFF0587)(0x06F6B0B9) , 
		(0x7273415B)(0x5E134e77)(0xA1556EC2)(0xC507286C) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		style , 
		L"style" , 
		(0x892DEEA6)(0x6D1B49ee)(0x8704E3CA)(0x6FC237E2) , 
		(0x45F4A83A)(0x566341ce)(0xB9439AB6)(0x2C8EC8AC) , 
		(stdAttrs) , 
		((implied)(L"xml:space")(Cdata)(m_xml_space))
		((required)(L"type")(ContentType)(m_type))
		((implied)(L"media")(Cdata)(m_media))
		((implied)(L"title")(Cdata)(m_title)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		path , 
		L"path" , 
		(0xA9BFA64A)(0x974E4ac4)(0x9E66F754)(0x1D8BEDDB) , 
		(0x02D404B2)(0xE1794c5c)(0xAB0D30C4)(0xB6476FEF) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_Markers)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((required)(L"d")(PathData)(m_d))
		((implied)(L"pathLength")(Number)(m_pathLength)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		rect , 
		L"rect" , 
		(0xDAAA7917)(0xA28B4d37)(0x84B7A5CD)(0x6F663248) , 
		(0x9F3CA14A)(0x481B4b10)(0x94EDA027)(0xC5344E26) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_Graphics)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((required)(L"width")(Length)(m_width))
		((required)(L"height")(Length)(m_height))
		((implied)(L"rx")(Length)(m_rx))
		((implied)(L"ry")(Length)(m_ry)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		circle , 
		L"circle" , 
		(0xD710B81C)(0xDE15475a)(0x9E1C205C)(0xB01B8F21) , 
		(0x410C584A)(0x1B214024)(0xA7AA1991)(0xBC74A8EE) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_Graphics)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"cx")(Coordinate)(m_cx))
		((implied)(L"cy")(Coordinate)(m_cy))
		((required)(L"r")(Length)(m_r)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		ellipse , 
		L"ellipse" , 
		(0x8287BA2B)(0xFC5D4e8d)(0x8F1FD31E)(0x80DC6EF6) , 
		(0xA9D8CD89)(0x17134f00)(0xBFE482D9)(0x43087675) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_Graphics)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"cx")(Coordinate)(m_cx))
		((implied)(L"cy")(Coordinate)(m_cy))
		((required)(L"rx")(Length)(m_rx))
		((required)(L"ry")(Length)(m_ry)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		line , 
		L"line" , 
		(0x3DB121EE)(0xAF894ec5)(0x979670C7)(0xBD28730D) , 
		(0x15279E62)(0xDCFE4332)(0x90C0F457)(0xF636929C) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_Markers)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((required)(L"x1")(Coordinate)(m_x1))
		((required)(L"y1")(Coordinate)(m_y1))
		((required)(L"x2")(Coordinate)(m_x2))
		((required)(L"y2")(Coordinate)(m_y2)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		polyline , 
		L"polyline" , 
		(0x7582408D)(0xB1F04875)(0xAFFC0643)(0x71127100) , 
		(0x53C712A2)(0x09984a8f)(0x94AD8094)(0xA5728F93) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_Markers)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((required)(L"points")(Points)(m_points)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		polygon , 
		L"polygon" , 
		(0x24C7C1DE)(0xC4BF4bd8)(0xB1D306BB)(0x05371E1A) , 
		(0xC2DBF78C)(0x82A64167)(0x82EFBAA3)(0x6C9D4396) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_Markers)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((required)(L"points")(Points)(m_points)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		text , 
		L"text" , 
		(0xA299C735)(0x4B304bc1)(0x82CB563D)(0x1799538A) , 
		(0x9E899BC2)(0x45AC4730)(0xBB75DAFF)(0x61107604) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_FontSpecification)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_TextContentElements)
		(PresentationAttributes_TextElements)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((implied)(L"textLength")(Length)(m_textLength))
		((implied)(L"lengthAdjust")(LengthAdjust)(m_lengthAdjust)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		tspan , 
		L"tspan" , 
		(0x0FA47676)(0xF50E4be9)(0x83E8F614)(0x78BA4646) , 
		(0x03ADA0EC)(0x498D4878)(0xA4239B40)(0x7D79BE04) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_FontSpecification)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_TextContentElements)
		(PresentationAttributes_TextElements)
		(graphicsElementEvents) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((implied)(L"dx")(Lengths)(m_dx))
		((implied)(L"dy")(Lengths)(m_dy))
		((implied)(L"textLength")(Length)(m_textLength))
		((implied)(L"lengthAdjust")(LengthAdjust)(m_lengthAdjust)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		tref , 
		L"tref" , 
		(0xBD0C8685)(0xFCE2425e)(0xBEB9F735)(0x8409B978) , 
		(0xC57829E2)(0x4A164cfa)(0x934CD59A)(0xA580EDA2) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_FontSpecification)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_TextContentElements)
		(graphicsElementEvents) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((implied)(L"dx")(Lengths)(m_dx))
		((implied)(L"dy")(Lengths)(m_dy))
		((implied)(L"rotate")(Angle)(m_rotate))
		((implied)(L"textLength")(Length)(m_textLength))
		((implied)(L"lengthAdjust")(LengthAdjust)(m_lengthAdjust)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		textPath , 
		L"textPath" , 
		(0x8EB426C4)(0xF7F34601)(0xAFC83881)(0x7EF49ED4) , 
		(0xBA59E05B)(0x11CB404e)(0x90B203F2)(0x7CAA85EB) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_FontSpecification)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_TextContentElements)
		(graphicsElementEvents) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"startOffset")(Percentage)(m_startOffset))
		((implied)(L"textLength")(Length)(m_textLength))
		((implied)(L"lengthAdjust")(LengthAdjust)(m_lengthAdjust))
		((implied)(L"method")(Method)(m_method))
		((implied)(L"spacing")(Spacing)(m_spacing)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		altGlyph , 
		L"altGlyph" , 
		(0x5814E52F)(0xE75346af)(0x8FC87E54)(0x7418F2FA) , 
		(0x1A7BA1E2)(0x56F54be2)(0xBCA8861D)(0x168D9096) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_FontSpecification)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_TextContentElements)
		(graphicsElementEvents) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"glyphRef")(Cdata)(m_glyphRef))
		((implied)(L"format")(Cdata)(m_format))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"x")(Coordinates)(m_x))
		((implied)(L"y")(Coordinates)(m_y))
		((implied)(L"dx")(Lengths)(m_dx))
		((implied)(L"dy")(Lengths)(m_dy))
		((implied)(L"rotate")(Angle)(m_rotate)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		altGlyphDef , 
		L"altGlyphDef" , 
		(0xA34069D8)(0xCF224bc2)(0x872FA5D5)(0x5ACDB345) , 
		(0x0D19D7B2)(0xDDE047a8)(0x9C343F48)(0x3B70E8FB) , 
		(stdAttrs) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		altGlyphItem , 
		L"altGlyphItem" , 
		(0x7E4DA21C)(0x46BF477d)(0xADCF53DE)(0x1BF929BF) , 
		(0x9C1665A0)(0xC02D4a4e)(0xB643CADD)(0x97FC1308) , 
		(stdAttrs) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		glyphRef , 
		L"glyphRef" , 
		(0x9DDAEE97)(0x83E3441d)(0xAAE97F4A)(0xACB0298D) , 
		(0xE7A3ACAE)(0x18014da2)(0x8B067F90)(0x613E13F0) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(PresentationAttributes_FontSpecification) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"glyphRef")(Cdata)(m_glyphRef))
		((implied)(L"x")(Number)(m_x))
		((implied)(L"y")(Number)(m_y))
		((implied)(L"dx")(Number)(m_dx))
		((implied)(L"dy")(Number)(m_dy)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		marker , 
		L"marker" , 
		(0x6451B5B6)(0xFD1746b0)(0xA00C55A7)(0x178E96B8) , 
		(0x8A69CF2C)(0xBF9B44e1)(0xB2DD825D)(0x5C48BE19) , 
		(stdAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"preserveAspectRatio")(PreserveAspectRatio)(m_preserveAspectRatio))
		((implied)(L"refX")(Coordinate)(m_ref_x))
		((implied)(L"refY")(Coordinate)(m_ref_y))
		((implied)(L"markerUnits")(MarkerUnits)(m_markerUnits))
		((implied)(L"markerWidth")(Length)(m_markerWidth))
		((implied)(L"markerHeight")(Length)(m_markerHeight))
		((implied)(L"orient")(Cdata)(m_orient)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		color_profile , 
		L"color-profile" , 
		(0x908DD082)(0xA3C9498f)(0x8391E28E)(0xC0DEA26A) , 
		(0xBA12B130)(0x8DDB4436)(0x8489CB4A)(0xC4AD36D8) , 
		(stdAttrs)
		(xlinkRefAttrs) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"local")(Cdata)(m_local))
		((required)(L"name")(Cdata)(m_name))
		((required)(L"rendering-intent")(RenderingIntent)(m_rendering_intent)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		linearGradient , 
		L"linearGradient" , 
		(0x18851E1B)(0x2C7A4066)(0x9ECABCDD)(0x8B69D6D1) , 
		(0x73BEC235)(0x3DDA4762)(0xB2152EEA)(0xF2C41391) , 
		(stdAttrs)
		(xlinkRefAttrs) 
		(PresentationAttributes_Gradients) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"gradientUnits")(Units)(m_gradientUnits))
		((implied)(L"gradientTransform")(TransformList)(m_gradientTransform))
		((implied)(L"x1")(Coordinate)(m_x1))
		((implied)(L"y1")(Coordinate)(m_y1))
		((implied)(L"x2")(Coordinate)(m_x2))
		((implied)(L"y2")(Coordinate)(m_y2))
		((implied)(L"spreadMethod")(SpreadMethod)(m_spreadMethod)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		radialGradient , 
		L"radialGradient" , 
		(0xE98F61EB)(0x0330409b)(0xAE71101A)(0x34584F35) , 
		(0xE21B0AA3)(0x325D4c6d)(0xA2E633B2)(0xFA6B9C48) , 
		(stdAttrs)
		(xlinkRefAttrs) 
		(PresentationAttributes_Gradients) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"gradientUnits")(Units)(m_gradientUnits))
		((implied)(L"gradientTransform")(TransformList)(m_gradientTransform))
		((implied)(L"cx")(Coordinate)(m_cx))
		((implied)(L"cy")(Coordinate)(m_cy))
		((implied)(L"r")(Length)(m_r))
		((implied)(L"fx")(Coordinate)(m_fx))
		((implied)(L"fy")(Coordinate)(m_fy))
		((implied)(L"spreadMethod")(SpreadMethod)(m_spreadMethod)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		pattern , 
		L"pattern" , 
		(0xB421C13B)(0xE362498c)(0xA651A29A)(0x790A3EA0) , 
		(0x5166CA4E)(0xF9D44b88)(0x8F83823E)(0x28A80602) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(testAttrs)
		(PresentationAttributes_All) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"viewBox")(ViewBox)(m_viewBox))
		((implied)(L"preserveAspectRatio")(PreserveAspectRatio)(m_preserveAspectRatio))
		((implied)(L"patternUnits")(Units)(m_patternUnits))
		((implied)(L"patternContentUnits")(Units)(m_patternContentUnits))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((required)(L"width")(Length)(m_width))
		((required)(L"height")(Length)(m_height)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		stop , 
		L"stop" , 
		(0x598D7E9F)(0xFC92449d)(0xBA557812)(0x748FBAAC) , 
		(0xE21B0AA3)(0x325D4c6d)(0xA2E633B2)(0xFA6B9C48) , 
		(stdAttrs)
		(PresentationAttributes_Gradients) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((required)(L"offset")(Length)(m_offset)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		clipPath , 
		L"clipPath" , 
		(0x7F0D5A00)(0x2012470b)(0xB02567B5)(0x3A0C8E58) , 
		(0xFCAD9BBE)(0x38D849e3)(0x804955A8)(0x2A2D76B5) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_FillStroke)
		(PresentationAttributes_FontSpecification)
		(PresentationAttributes_Graphics)
		(PresentationAttributes_TextContentElements)
		(PresentationAttributes_TextElements) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"clipPathUnits")(Units)(m_clipPathUnits)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		mask , 
		L"mask" , 
		(0xD230BD0D)(0x8D494989)(0x98B01376)(0x159EB184) , 
		(0x1E64005D)(0xA55849cf)(0xADFAF4F8)(0x38834535) , 
		(stdAttrs)
		(testAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"maskUnits")(Units)(m_maskUnits))
		((implied)(L"maskContentUnits")(Units)(m_maskContentUnits))
		((implied)(L"width")(Length)(m_width))
		((implied)(L"height")(Length)(m_height)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		filter , 
		L"filter" , 
		(0x0CB29384)(0x1B194a57)(0x97E3929E)(0x901CF00C) , 
		(0x6AAB8161)(0xE63A4219)(0xB0BE8C96)(0x24E3BD4C) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(langSpaceAttrs)
		(PresentationAttributes_All) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"filterUnits")(Units)(m_filterUnits))
		((implied)(L"primitiveUnits")(Units)(m_primitiveUnits))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((implied)(L"width")(Length)(m_width))
		((implied)(L"height")(Length)(m_height))
		((implied)(L"filterRes")(Cdata)(m_filterRes)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feDistantLight , 
		L"feDistantLight" , 
		(0x7F538C95)(0xF8CB48e6)(0x8B05D4DF)(0x542E6F7D) , 
		(0xD62B35A5)(0x75F54ccc)(0xBA0251D0)(0x3C62F842) , 
		(stdAttrs) , 
		((implied)(L"azimuth")(Number)(m_azimuth))
		((implied)(L"elevation")(Number)(m_elevation)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		fePointLight , 
		L"fePointLight" , 
		(0x163FB8AA)(0x23F545a8)(0x9F85443E)(0x9CF812EE) , 
		(0xAFE7B9F4)(0x10F34fe7)(0xA748BFCD)(0xAA00D047) , 
		(stdAttrs) , 
		((implied)(L"x")(Number)(m_x))
		((implied)(L"y")(Number)(m_y))
		((implied)(L"z")(Number)(m_z)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feSpotLight , 
		L"feSpotLight" , 
		(0xF66A3D17)(0xA14C4054)(0x97F6248C)(0xB0D98930) , 
		(0x86742F32)(0xCCC4416a)(0xBEA2AFEE)(0xABC3847D) , 
		(stdAttrs) , 
		((implied)(L"x")(Number)(m_x))
		((implied)(L"y")(Number)(m_y))
		((implied)(L"z")(Number)(m_z))
		((implied)(L"pointsAtX")(Number)(m_pointsAtX))
		((implied)(L"pointsAtY")(Number)(m_pointsAtY))
		((implied)(L"pointsAtZ")(Number)(m_pointsAtZ))
		((implied)(L"specularExponent")(Number)(m_specularExponent))
		((implied)(L"limitingConeAngle")(Number)(m_limitingConeAngle)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feBlend , 
		L"feBlend" , 
		(0x2A6477CC)(0xA83F4f10)(0x9AF3F69A)(0xD6DF9A55) , 
		(0x2EC8F606)(0x5CFE4c19)(0xB57A5828)(0xE962A182) , 
		(stdAttrs)
		(filter_primitive_attributes_with_in) , 
		((required)(L"in2")(Cdata)(m_in2))
		((implied)(L"mode")(Mode)(m_mode)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feColorMatrix , 
		L"feColorMatrix" , 
		(0xEC3CFCDC)(0x4CDF448a)(0x9F753653)(0xB965929A) , 
		(0x3CDF06D8)(0x728A4d92)(0x9C9D50B5)(0x6D843049) , 
		(stdAttrs)
		(filter_primitive_attributes_with_in) , 
		((implied)(L"type")(FeColorMatrixType)(m_type))
		((implied)(L"values")(Cdata)(m_values)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feComponentTransfer , 
		L"feComponentTransfer" , 
		(0x579E12AE)(0x909B459a)(0x9BBC74B0)(0x22533FF7) , 
		(0x2453DB31)(0xC8E748ca)(0xBD91B9FA)(0x11C49EBF) , 
		(stdAttrs)
		(filter_primitive_attributes_with_in) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feFuncR , 
		L"feFuncR" , 
		(0x23B99319)(0xE99046d8)(0x8DB0664E)(0xBA255AF1) , 
		(0x21123F9C)(0xD1E74b63)(0xB6BBDC0D)(0xD9F63767) , 
		(stdAttrs)
		(component_transfer_function_attributes) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feFuncG , 
		L"feFuncG" , 
		(0xAF99B5C7)(0xD2864109)(0x9921148D)(0x35528E52) , 
		(0xE4A625C3)(0x54784ece)(0x9F4C5889)(0xCE31693F) , 
		(stdAttrs)
		(component_transfer_function_attributes) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feFuncB , 
		L"feFuncB" , 
		(0xEE355C48)(0x83A54e69)(0xA1832DE1)(0x58EC1D13) , 
		(0x08CE55E8)(0x72A542f4)(0xA52D3B8C)(0x52375E33) , 
		(stdAttrs)
		(component_transfer_function_attributes) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feFuncA , 
		L"feFuncA" , 
		(0x94AB8574)(0xBA594067)(0xB71FAEC3)(0x403BC4B5) , 
		(0x121B5066)(0x53DA40ac)(0x95633D76)(0xAC058982) , 
		(stdAttrs)
		(component_transfer_function_attributes) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feComposite , 
		L"feComposite" , 
		(0x38C57E97)(0xC7D943ba)(0x8194E2D7)(0xE7C4601B) , 
		(0x2BF53C60)(0xFF7149e4)(0xA6EBDDDD)(0x91652FB0) , 
		(stdAttrs)
		(filter_primitive_attributes_with_in) , 
		((required)(L"in2")(Cdata)(m_in2))
		((implied)(L"operator")(FeCompositeOperator)(m_operator))
		((implied)(L"k1")(Number)(m_k1))
		((implied)(L"k2")(Number)(m_k2))
		((implied)(L"k3")(Number)(m_k3))
		((implied)(L"k4")(Number)(m_k4)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feConvolveMatrix , 
		L"feConvolveMatrix" , 
		(0x5BC3C03D)(0x79AE4dea)(0x9EA75BE2)(0xD7DC7EA2) , 
		(0xF750E085)(0x0EC944bc)(0x8EC6B3B7)(0x4728047B) , 
		(filter_primitive_attributes_with_in) , 
		((required)(L"order")(Cdata)(m_order))
		((required)(L"kernelMatrix")(Cdata)(m_kernelMatrix))
		((implied)(L"divisor")(Number)(m_divisor))
		((implied)(L"bias")(Number)(m_bias))
		((implied)(L"targetX")(Integer)(m_targetX))
		((implied)(L"targetY")(Integer)(m_targetY))
		((implied)(L"edgeMode")(EdgeMode)(m_edgeMode))
		((implied)(L"kernelUnitLength")(Cdata)(m_kernelUnitLength))
		((implied)(L"preserveAlpha")(Boolean)(m_preserveAlpha)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feDiffuseLighting , 
		L"feDiffuseLighting" , 
		(0x9E33FEFB)(0x2783444f)(0x92D8804A)(0x6F4F4282) , 
		(0xAFD7114E)(0xC1BB4ab9)(0x844894E4)(0xB7F7BBD7) , 
		(stdAttrs)
		(PresentationAttributes_LightingEffects)
		(filter_primitive_attributes_with_in) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"surfaceScale")(Number)(m_surfaceScale))
		((implied)(L"diffuseConstant")(Number)(m_diffuseConstant)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feDisplacementMap , 
		L"feDisplacementMap" , 
		(0xD65ECF54)(0xCA9940ba)(0x80D3C7AF)(0x178D6E62) , 
		(0xBCC70054)(0x716A49a9)(0xBFC4D2B0)(0x57C9C427) , 
		(filter_primitive_attributes_with_in) , 
		((required)(L"in2")(Cdata)(m_in2))
		((implied)(L"scale")(Number)(m_scale))
		((implied)(L"xChannelSelector")(ChannelSelector)(m_xChannelSelector))
		((implied)(L"yChannelSelector")(ChannelSelector)(m_yChannelSelector)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feFlood , 
		L"feFlood" , 
		(0x4FF7949A)(0x870D46cf)(0x97C064F3)(0x0AC9C72B) , 
		(0xA72F3503)(0x4272421f)(0xA1ABC236)(0x77990877) , 
		(stdAttrs)
		(PresentationAttributes_feFlood)
		(filter_primitive_attributes_with_in) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feGaussianBlur , 
		L"feGaussianBlur" , 
		(0x71A7DF0C)(0x6CA8497e)(0xA60A29CA)(0x92B377C7) , 
		(0x45D9BC77)(0x9C71417d)(0xB64DCF86)(0x04F01800) , 
		(stdAttrs)
		(filter_primitive_attributes_with_in) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"stdDeviation")(Cdata)(m_stdDeviation)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feImage , 
		L"feImage" , 
		(0x253F694E)(0xED3945d2)(0x948DC9D3)(0x7966F035) , 
		(0x3463CE99)(0x41E647a6)(0x8235B90C)(0x8008F9E5) , 
		(stdAttrs)
		(xlinkRefAttrs)
		(PresentationAttributes_All)
		(filter_primitive_attributes) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feMerge , 
		L"feMerge" , 
		(0x333366EC)(0x223A44a4)(0x9E927224)(0x5BC17FBE) , 
		(0xB8D48FDE)(0x958042ff)(0xA0D31CF5)(0x0AE76684) , 
		(stdAttrs)
		(filter_primitive_attributes) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feMergeNode , 
		L"feMergeNode" , 
		(0x972D8969)(0x8CC14cb6)(0xACB4BDC3)(0x3EAAE128) , 
		(0x13A55020)(0x72BF4d9d)(0xB76EF886)(0x3D9F676A) , 
		(stdAttrs) , 
		((implied)(L"in")(Cdata)(m_in)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feMorphology , 
		L"feMorphology" , 
		(0xA3375660)(0xF3E3443a)(0x9C49EDDA)(0x55A7611A) , 
		(0xA1A3D3ED)(0x5D414a73)(0x8DA8479F)(0xE9B1BF64) , 
		(stdAttrs)
		(filter_primitive_attributes_with_in) , 
		((implied)(L"operator")(FeMorphologyOperator)(m_operator))
		((implied)(L"radius")(Length)(m_radius)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feOffset , 
		L"feOffset" , 
		(0x6D4599BD)(0xB4744675)(0xA8D8FFB0)(0x1BBDD479) , 
		(0x5806C95D)(0x25414ab3)(0xBBCEE2C0)(0xD51146EF) , 
		(stdAttrs)
		(filter_primitive_attributes_with_in) , 
		((implied)(L"dx")(Length)(m_dx))
		((implied)(L"dy")(Length)(m_dy)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feSpecularLighting , 
		L"feSpecularLighting" , 
		(0x1490F3ED)(0x0F1746da)(0xB2CB641A)(0xC2E2809E) , 
		(0x8644B1BC)(0xE8C14474)(0xAF7ACA3C)(0x1FC63228) , 
		(stdAttrs)(PresentationAttributes_LightingEffects)(filter_primitive_attributes_with_in) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"surfaceScale")(Number)(m_surfaceScale))
		((implied)(L"specularConstant")(Number)(m_specularConstant))
		((implied)(L"specularExponent")(Number)(m_specularExponent)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feTile , 
		L"feTile" , 
		(0x2548E305)(0xCE114b5a)(0xB7915897)(0x1A3898FE) , 
		(0xCFD65BC0)(0x8EF4447f)(0x8F85CEF9)(0x8C2F4F76) , 
		(stdAttrs)(filter_primitive_attributes_with_in) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		feTurbulence , 
		L"feTurbulence" , 
		(0xE510FB25)(0xDBF54e9a)(0xBF8C9826)(0x44950EFF) , 
		(0x98B27D32)(0xC0094edb)(0xBDB12A6F)(0x9729AF94) , 
		(stdAttrs)(PresentationAttributes_LightingEffects)(filter_primitive_attributes_with_in) , 
		((implied)(L"baseFrequency")(Cdata)(m_baseFrequency))
		((implied)(L"numOctaves")(Integer)(m_numOctaves))
		((implied)(L"stitchTiles")(StitchTiles)(m_stitchTiles))
		((implied)(L"type")(FeTurbulenceType)(m_type)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		cursor , 
		L"cursor" , 
		(0x234C1C50)(0x98BD4f24)(0xB065A353)(0x0473CBE9) , 
		(0xE31650AB)(0xB8064083)(0xA4B80B92)(0xBB3549F2) , 
		(stdAttrs)(xlinkRefAttrs)(testAttrs) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href))
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		a , 
		L"a" , 
		(0xBD93BA0F)(0x161D48a1)(0x83ADE648)(0x3C0D9779) , 
		(0x746CFCD7)(0xDDBB4131)(0x8FD6E15D)(0x66C87E13) , 
		(stdAttrs)(testAttrs)(langSpaceAttrs)(PresentationAttributes_All)(graphicsElementEvents) , 
		((implied)(L"xmlns:xlink")(XmlnsXlink)(m_xmlns_xlink))
		((implied)(L"xlink:type")(XlinkType)(m_xlink_type))
		((implied)(L"xlink:role")(XlinkArcrole)(m_xlink_role)) 
		((implied)(L"xlink:arcrole")(XlinkArcrole)(m_xlink_arcrole)) 
		((implied)(L"xlink:title")(XlinkTitle)(m_xlink_title)) 
		((implied)(L"xlink:show")(AXlinkShow)(m_xlink_show)) 
		((implied)(L"xlink:actuate")(XlinkActuate)(m_xlink_actuate)) 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href)) 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) 
		((implied)(L"class")(ClassList)(m_class)) 
		((implied)(L"style")(Style)(m_style)) 
		((implied)(L"transform")(TransformList)(m_transform)) 
		((implied)(L"target")(LinkTarget)(m_target)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		view , 
		L"view" , 
		(0x8A04B467)(0xBAD64a9b)(0x9E569D60)(0x7DF01CB6) , 
		(0xCFB99D61)(0x568C4b71)(0x9EE4110F)(0xEA12D6C6) , 
		(stdAttrs) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) 
		((implied)(L"viewBox")(ViewBox)(m_viewBox)) 
		((implied)(L"preserveAspectRatio")(PreserveAspectRatio)(m_preserveAspectRatio)) 
		((implied)(L"zoomAndPan")(ZoomAndPan)(m_zoomAndPan)) 
		((implied)(L"viewTarget")(Cdata)(m_viewTarget)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		script , 
		L"script" , 
		(0xFA2A6725)(0x045D4367)(0xBAADF580)(0x11E44564) , 
		(0x58E518A4)(0x32954bff)(0x9909F7FA)(0x2DCD6935) , 
		(stdAttrs)(xlinkRefAttrs) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href)) 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) 
		((required)(L"type")(ContentType)(m_ContentType)) , 
		BOOST_PP_SEQ_NIL 
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		animate , 
		L"animate" , 
		(0xCEFD96D6)(0x46944067)(0xA4D2852A)(0x6468B035) , 
		(0xC3EE5E46)(0xB3CC4700)(0x96C9A136)(0x9F439E18) , 
		(stdAttrs)(testAttrs)(animationEvents)(animElementAttrs)(animAttributeAttrs)(animTimingAttrs)(animValueAttrs)(animAdditionAttrs) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))  , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		set , 
		L"set" , 
		(0xE60DBF92)(0x74A849c2)(0x858A0B88)(0x4777DA11) , 
		(0x9FA4DE9C)(0xAEF640fd)(0x802EE321)(0x686DFC39) , 
		(stdAttrs)(testAttrs)(animationEvents)(animElementAttrs)(animAttributeAttrs)(animTimingAttrs) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) 
		((implied)(L"to")(Cdata)(m_to)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		animateMotion , 
		L"animateMotion" , 
		(0x33FDBE79)(0x5FCE42e6)(0xBDCC16E4)(0x282C5F41) , 
		(0xA50FD930)(0xC9614040)(0xBAA900CE)(0x99400716) , 
		(stdAttrs)(testAttrs)(animationEvents)(animElementAttrs)(animTimingAttrs)(animAdditionAttrs) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) 
		((implied)(L"calcMode")(CalcMode)(m_calcMode)) 
		((implied)(L"values")(Cdata)(m_values)) 
		((implied)(L"keyTimes")(Cdata)(m_keyTimes)) 
		((implied)(L"keySplines")(Cdata)(m_keySplines)) 
		((implied)(L"from")(Cdata)(m_from)) 
		((implied)(L"to")(Cdata)(m_to)) 
		((implied)(L"by")(Cdata)(m_by)) 
		((implied)(L"path")(Cdata)(m_path)) 
		((implied)(L"keyPoints")(Cdata)(m_keyPoints)) 
		((implied)(L"rotate")(Cdata)(m_rotate)) 
		((implied)(L"origin")(Cdata)(m_origin)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		mpath , 
		L"mpath" , 
		(0xAF0D7AC9)(0x5F534263)(0x96F8B568)(0x4CA5B1FA) , 
		(0x29B56CB6)(0x714542f3)(0x80F6DF4A)(0xF467D2D8) , 
		(stdAttrs)(xlinkRefAttrs) , 
		((implied)(L"xlink:href")(XlinkUri)(m_xlink_href)) 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		animateColor , 
		L"animateColor" , 
		(0xB87B29BD)(0xF9B24d37)(0x9F07305C)(0x9AE890D8) , 
		(0x4F2AAC47)(0xD6DE4fca)(0x86FCABA6)(0x4E1FCEC8) , 
		(stdAttrs)(testAttrs)(animationEvents)(animElementAttrs)(animAttributeAttrs)(animTimingAttrs)(animValueAttrs)(animAdditionAttrs) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		animateTransform , 
		L"animateTransform" , 
		(0x53DADA3D)(0xBCB845b6)(0xA791EF7E)(0x5633D4C9) , 
		(0x5E1AD960)(0xB0E44782)(0x98C8FBAD)(0x4272D7D6) , 
		(stdAttrs)(testAttrs)(animationEvents)(animElementAttrs)(animAttributeAttrs)(animTimingAttrs)(animValueAttrs)(animAdditionAttrs) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired)) , 
		((implied)(L"type")(AnimateTransformType)(m_type)(translate)(((L"translate")(translate))((L"scale")(scale))((L"rotate")(rotate))((L"skewX")(skewX))((L"skewY")(skewY))))
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		font , 
		L"font" , 
		(0x65C2BFD9)(0x667A427d)(0xB4783E50)(0xB32F4076) , 
		(0x03CAB7BA)(0xEE2A4fda)(0x8E534D77)(0xCD270EE1) , 
		(stdAttrs)(PresentationAttributes_All) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"horiz-origin-x")(Number)(m_horiz_origin_x))
		((implied)(L"horiz-origin-y")(Number)(m_horiz_origin_y))
		((required)(L"horiz-adv-x")(Number)(m_horiz_adv_x))
		((implied)(L"vert-origin-x")(Number)(m_vert_origin_x))
		((implied)(L"vert-origin-y")(Number)(m_vert_origin_y))
		((implied)(L"vert-adv-y")(Number)(m_vert_adv_y)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		glyph , 
		L"glyph" , 
		(0x4A942CE3)(0xB0364cd8)(0x91966803)(0x1D475881) , 
		(0x06759BED)(0xDD6546bb)(0x94E2546E)(0x36D21BE0) , 
		(stdAttrs)(PresentationAttributes_All) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"unicode")(Cdata)(m_unicode))
		((implied)(L"glyph-name")(Cdata)(m_glyph_name))
		((implied)(L"d")(PathData)(m_d))
		((implied)(L"orientation")(Cdata)(m_orientation))
		((implied)(L"arabic-form")(Cdata)(m_arabic_form))
		((implied)(L"lang")(LanguageCodes)(m_lang))
		((implied)(L"horiz-adv-x")(Number)(m_horiz_adv_x))
		((implied)(L"vert-origin-x")(Number)(m_vert_origin_x))
		((implied)(L"vert-origin-y")(Number)(m_vert_origin_y))
		((implied)(L"vert-adv-y")(Number)(m_vert_adv_y)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		missing_glyph , 
		L"missing-glyph" , 
		(0x48B2E916)(0xE4C24fff)(0xB2058C5B)(0x53EAABCB) , 
		(0x8AFFBC61)(0x0D134914)(0xBBD2F66B)(0x9A352232) , 
		(stdAttrs)(PresentationAttributes_All) , 
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"d")(PathData)(m_d))
		((implied)(L"horiz-adv-x")(Number)(m_horiz_adv_x))
		((implied)(L"vert-origin-x")(Number)(m_vert_origin_x))
		((implied)(L"vert-origin-y")(Number)(m_vert_origin_y))
		((implied)(L"vert-adv-y")(Number)(m_vert_adv_y)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		hkern , 
		L"hkern" , 
		(0x03D4C0F3)(0x4D8A45df)(0xBC20A0EA)(0x688D5208) , 
		(0xCB8F8C36)(0x55034d26)(0xA0A43F75)(0x9F942164) , 
		(stdAttrs) , 
		((implied)(L"u1")(Cdata)(m_u1))
		((implied)(L"g1")(Cdata)(m_g1))
		((implied)(L"u2")(Cdata)(m_u2))
		((implied)(L"g2")(Cdata)(m_g2))
		((required)(L"k")(Number)(m_k)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		vkern , 
		L"vkern" , 
		(0x8B6046E1)(0x0FA54936)(0x82D058D5)(0x8736F1A2) , 
		(0xD0B06FBB)(0x70FD4c48)(0x8457E9DA)(0xAE1EF3A2) , 
		(stdAttrs) , 
		((implied)(L"u1")(Cdata)(m_u1))
		((implied)(L"g1")(Cdata)(m_g1))
		((implied)(L"u2")(Cdata)(m_u2))
		((implied)(L"g2")(Cdata)(m_g2))
		((required)(L"k")(Number)(m_k)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		font_face , 
		L"font-face" , 
		(0x491558C7)(0xB9494029)(0x9E541125)(0x5EA09F62) , 
		(0x5285CE16)(0xB64E43c1)(0xABA476F5)(0xD92BAD0D) , 
		(stdAttrs) , 
		((implied)(L"font-family")(FontFamily)(m_font_family))
		((implied)(L"font-style")(FontStyle)(m_font_style))
		((implied)(L"font-variant")(FontVariant)(m_font_variant))
		((implied)(L"font-weight")(FontWeight)(m_font_weight))
		((implied)(L"font-stretch")(FontStretch)(m_font_stretch))
		((implied)(L"font-size")(FontSize)(m_font_size))
		((implied)(L"unicode-range")(Cdata)(m_unicode_range))
		((implied)(L"units-per-em")(Number)(m_units_per_em))
		((implied)(L"panose-1")(Cdata)(m_panose_1))
		((implied)(L"stemv")(Number)(m_stemv))
		((implied)(L"stemh")(Number)(m_stemh))
		((implied)(L"slope")(Number)(m_slope))
		((implied)(L"cap-height")(Number)(m_cap_height))
		((implied)(L"x-height")(Number)(m_x_height))
		((implied)(L"accent-height")(Number)(m_accent_height))
		((implied)(L"ascent")(Number)(m_ascent))
		((implied)(L"descent")(Number)(m_descent))
		((implied)(L"widths")(Cdata)(m_widths))
		((implied)(L"bbox")(Cdata)(m_bbox))
		((implied)(L"ideographic")(Number)(m_ideographic))
		((implied)(L"alphabetic")(Number)(m_alphabetic))
		((implied)(L"mathematical")(Number)(m_mathematical))
		((implied)(L"hanging")(Number)(m_hanging))
		((implied)(L"v-ideographic")(Number)(m_v_ideographic))
		((implied)(L"v-alphabetic")(Number)(m_v_alphabetic))
		((implied)(L"v-mathematical")(Number)(m_v_mathematical))
		((implied)(L"v-hanging")(Number)(m_v_hanging))
		((implied)(L"underline-position")(Number)(m_underline_position))
		((implied)(L"underline-thickness")(Number)(m_underline_thickness))
		((implied)(L"strikethrough-position")(Number)(m_strikethrough_position))
		((implied)(L"strikethrough-thickness")(Number)(m_strikethrough_thickness))
		((implied)(L"overline-position")(Number)(m_overline_position))
		((implied)(L"overline-thickness")(Number)(m_overline_thickness)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		font_face_src , 
		L"font-face-src" , 
		(0xEB82A8B7)(0x10F14175)(0x9C4286B3)(0x9F49DF4A) , 
		(0x4A93A924)(0xD39048a2)(0x8D29892A)(0x8F31FE99) , 
		(stdAttrs) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		font_face_uri , 
		L"font-face-uri" , 
		(0xBFE2674A)(0x1A814dac)(0xBC834415)(0xE4E42FD3) , 
		(0xD0B06FBB)(0x70FD4c48)(0x8457E9DA)(0xAE1EF3A2) , 
		(stdAttrs)(xlinkRefAttrs) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		font_face_format , 
		L"font-face-format" , 
		(0x5B08F5B3)(0xE8904fca)(0xAAB13F50)(0xE90A5728) , 
		(0x0FDC5181)(0x581D4f2b)(0x91E7B744)(0x5C365470) , 
		(stdAttrs) , 
		((implied)(L"string")(Cdata)(m_string)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		font_face_name , 
		L"font-face-name" , 
		(0x9E2EEE50)(0x71914e68)(0xAB09A3F5)(0x86C144A2) , 
		(0x54A0E853)(0x27D946db)(0xAEC899DA)(0xEC8BED51) , 
		(stdAttrs) , 
		((implied)(L"name")(Cdata)(m_name)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		definition_src , 
		L"definition-src" , 
		(0x0914D8C7)(0xE7144d75)(0xB72CB6C0)(0xC98A0B85) , 
		(0x7FEE4196)(0x31EC495b)(0x9371BAEB)(0xB1E58B97) , 
		(stdAttrs)(xlinkRefAttrs) , 
		((required)(L"xlink:href")(XlinkUri)(m_xlink_href)) , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		metadata , 
		L"metadata" , 
		(0x4B834656)(0x475B447c)(0xB575D6F9)(0xE35E3289) , 
		(0x32C74933)(0x16164a22)(0x8ADB0BB5)(0x22B36EB7) , 
		(stdAttrs) , 
		BOOST_PP_SEQ_NIL , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_class
		(
		foreignObject , 
		L"foreignObject" , 
		(0x4036B6A0)(0xAD0D424f)(0xB8EC9BC2)(0x2FCAFA75) , 
		(0x9CC0220E)(0x3F5D404f)(0x99898426)(0x96192415) , 
		(stdAttrs)(testAttrs)(langSpaceAttrs)(PresentationAttributes_All)(graphicsElementEvents)(StructuredText) , 
		((implied)(L"externalResourcesRequired")(Boolean)(m_externalResourcesRequired))
		((implied)(L"class")(ClassList)(m_class))
		((implied)(L"style")(Style)(m_style))
		((implied)(L"transform")(TransformList)(m_transform))
		((implied)(L"x")(Coordinate)(m_x))
		((implied)(L"y")(Coordinate)(m_y))
		((required)(L"width")(Length)(m_width))
		((required)(L"height")(Length)(m_height)) , 
		BOOST_PP_SEQ_NIL
		);
///////////////////////////////////////////////////////////////////////////////////////////////////
// element parse define
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		svg , 
		L"svg" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((text)(L"text"))
		((path)(L"path"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((symbol)(L"symbol"))
		((style)(L"style"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		g , 
		L"g" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		defs , 
		L"defs" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		desc , 
		L"desc" , 
		((PCDATA)(L"#PCDATA"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		title , 
		L"title" , 
		((PCDATA)(L"#PCDATA"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		symbol , 
		L"symbol" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		use , 
		L"use" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		image , 
		L"image" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		switch , 
		L"switch" , 
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((switch)(L"switch"))
		((a)(L"a"))
		((foreignObject)(L"foreignObject"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		style , 
		L"style" , 
		((PCDATA)(L"#PCDATA"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		path , 
		L"path" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		rect , 
		L"rect" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		circle , 
		L"circle" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		ellipse , 
		L"ellipse" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		line , 
		L"line" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		polyline , 
		L"polyline" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		polygon , 
		L"polygon" , 		
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		text , 
		L"text" , 
		((PCDATA)(L"#PCDATA"))
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((tspan)(L"tspan"))
		((tref)(L"tref"))
		((textPath)(L"textPath"))
		((altGlyph)(L"altGlyph"))
		((a)(L"a"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		tspan , 
		L"tspan" , 
		((PCDATA)(L"#PCDATA"))
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((tspan)(L"tspan"))
		((tref)(L"tref"))
		((altGlyph)(L"altGlyph"))
		((a)(L"a"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateColor)(L"animateColor"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		tref , 
		L"tref" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateColor)(L"animateColor"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		textPath , 
		L"textPath" , 
		((PCDATA)(L"#PCDATA"))
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((tspan)(L"tspan"))
		((tref)(L"tref"))
		((altGlyph)(L"altGlyph"))
		((a)(L"a"))
		((animate)(L"animate"))
		((set)(L"set"))		
		((animateColor)(L"animateColor"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		altGlyph , 
		L"altGlyph" , 
		((PCDATA)(L"#PCDATA"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		altGlyphDef , 
		L"altGlyphDef" , 
		((glyphRef)(L"glyphRef"))
		((altGlyphItem)(L"altGlyphItem"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		altGlyphItem , 
		L"altGlyphItem" , 
		((glyphRef)(L"glyphRef"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		glyphRef , 
		L"glyphRef" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		marker , 
		L"marker" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))		
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		color_profile , 
		L"color-profile" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		linearGradient , 
		L"linearGradient" , 
		((stop)(L"stop"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		radialGradient , 
		L"radialGradient" , 
		((stop)(L"stop"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		stop , 
		L"stop" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateColor)(L"animateColor"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		pattern , 
		L"pattern" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		clipPath , 
		L"clipPath" , 
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		mask , 
		L"mask" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		filter , 
		L"filter" , 
		((feBlend)(L"feBlend"))
		((feFlood)(L"feFlood"))
		((feColorMatrix)(L"feColorMatrix"))
		((feComponentTransfer)(L"feComponentTransfer"))
		((feComposite)(L"feComposite"))
		((feConvolveMatrix)(L"feConvolveMatrix"))
		((feDiffuseLighting)(L"feDiffuseLighting"))
		((feDisplacementMap)(L"feDisplacementMap"))
		((feGaussianBlur)(L"feGaussianBlur"))
		((feImage)(L"feImage"))
		((feMerge)(L"feMerge"))
		((feMorphology)(L"feMorphology"))
		((feOffset)(L"feOffset"))
		((feSpecularLighting)(L"feSpecularLighting"))
		((feTile)(L"feTile"))
		((feTurbulence)(L"feTurbulence"))
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feDistantLight , 
		L"feDistantLight" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		fePointLight , 
		L"fePointLight" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feSpotLight , 
		L"feSpotLight" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feBlend , 
		L"feBlend" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feColorMatrix , 
		L"feColorMatrix" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feComponentTransfer , 
		L"feComponentTransfer" , 
		((feFuncR)(L"feFuncR"))
		((feFuncG)(L"feFuncG"))
		((feFuncB)(L"feFuncB"))
		((feFuncA)(L"feFuncA"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feFuncR , 
		L"feFuncR" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feFuncG , 
		L"feFuncG" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feFuncB , 
		L"feFuncB" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feFuncA , 
		L"feFuncA" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feComposite , 
		L"feComposite" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feConvolveMatrix , 
		L"feConvolveMatrix" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feDiffuseLighting , 
		L"feDiffuseLighting" , 
		((feDistantLight)(L"feDistantLight"))
		((fePointLight)(L"fePointLight"))
		((feSpotLight)(L"feSpotLight"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateColor)(L"animateColor"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feDisplacementMap , 
		L"feDisplacementMap" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feFlood , 
		L"feFlood" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateColor)(L"animateColor"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feGaussianBlur , 
		L"feGaussianBlur" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feImage , 
		L"feImage" , 
		((animate)(L"animate"))
		((set)(L"set"))
		((animateTransform)(L"animateTransform"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feMerge , 
		L"feMerge" , 
		((feMergeNode)(L"feMergeNode"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feMergeNode , 
		L"feMergeNode" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feMorphology , 
		L"feMorphology" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feOffset , 
		L"feOffset" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feSpecularLighting , 
		L"feSpecularLighting" , 
		((feDistantLight)(L"feDistantLight"))
		((fePointLight)(L"fePointLight"))
		((feSpotLight)(L"feSpotLight"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateColor)(L"animateColor"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feTile , 
		L"feTile" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		feTurbulence , 
		L"feTurbulence" , 
		((animate)(L"animate"))
		((set)(L"set"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		cursor , 
		L"cursor" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		a , 
		L"a" , 
		((PCDATA)(L"#PCDATA"))
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		view , 
		L"view" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		script , 
		L"script" , 
		((PCDATA)(L"#PCDATA"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		animate , 
		L"animate" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		set , 
		L"set" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		animateMotion , 
		L"animateMotion" , 
		((mpath)(L"mpath"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		mpath , 
		L"mpath" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		animateColor , 
		L"animateColor" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		animateTransform , 
		L"animateTransform" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		font , 
		L"font" , 
		((font_face)(L"font-face"))
		((missing_glyph)(L"missing-glyph"))
		((glyph)(L"glyph"))
		((hkern)(L"hkern"))
		((vkern)(L"vkern"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		glyph , 
		L"glyph" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		missing_glyph , 
		L"missing-glyph" , 
		((desc)(L"desc"))
		((title)(L"title"))
		((metadata)(L"metadata"))
		((defs)(L"defs"))
		((path)(L"path"))
		((text)(L"text"))
		((rect)(L"rect"))
		((circle)(L"circle"))
		((ellipse)(L"ellipse"))
		((line)(L"line"))
		((polyline)(L"polyline"))
		((polygon)(L"polygon"))
		((use)(L"use"))
		((image)(L"image"))
		((svg)(L"svg"))
		((g)(L"g"))
		((view)(L"view"))
		((switch)(L"switch"))
		((a)(L"a"))
		((altGlyphDef)(L"altGlyphDef"))
		((script)(L"script"))
		((style)(L"style"))
		((symbol)(L"symbol"))
		((marker)(L"marker"))
		((clipPath)(L"clipPath"))
		((mask)(L"mask"))
		((linearGradient)(L"linearGradient"))
		((radialGradient)(L"radialGradient"))
		((pattern)(L"pattern"))
		((filter)(L"filter"))
		((cursor)(L"cursor"))
		((font)(L"font"))
		((animate)(L"animate"))
		((set)(L"set"))
		((animateMotion)(L"animateMotion"))
		((animateColor)(L"animateColor"))
		((animateTransform)(L"animateTransform"))
		((color_profile)(L"color-profile"))
		((font_face)(L"font-face"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		hkern , 
		L"hkern" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		vkern , 
		L"vkern" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		font_face , 
		L"font-face" , 
		((font_face_src)(L"font-face-src"))
		((definition_src)(L"definition-src"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		font_face_src , 
		L"font-face-src" , 
		((font_face_uri)(L"font-face-uri"))
		((font_face_name)(L"font-face-name"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		font_face_uri , 
		L"font-face-uri" , 
		((font_face_format)(L"font-face-format"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		font_face_format , 
		L"font-face-format" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		font_face_name , 
		L"font-face-name" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		definition_src , 
		L"definition-src" , 
		BOOST_PP_SEQ_NIL
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		metadata , 
		L"metadata" , 
		((PCDATA)(L"#PCDATA"))
		);
//-------------------------------------------------------------------------------------------------
df_element_function
		( 
		foreignObject , 
		L"foreignObject" , 
		((PCDATA)(L"#PCDATA"))
		);

/**************************************************************************************************
"ParserSVG" class 
**************************************************************************************************/
class ParserSVG
{
public:
	enum OutputOption
	{
		Format_OutputOption	= ( 1 << 0 ) , 
	};
// member class
private:
	class BinInputStream_bs : public XERCES_CPP_NAMESPACE::BinInputStream
	{
		cb_copy_impossible( BinInputStream_bs );
	private:
		IFileStreamRead*	m_reader;

	// "BinInputStream" interface
	private:
		unsigned int curPos()const
		{
			return ( unsigned int )m_reader->GetPosition();
		}
		unsigned int readBytes
				(
				XMLByte* const		toFill,
				const unsigned int	maxToRead
				)
		{
			cb_assert( sizeof( XMLByte ) == 1 , L"invalid size of XMLByte" );
			if( m_reader == false )
				return 0;
			
			unsigned int	readbyte = min( maxToRead , ( unsigned int )( m_reader->GetSize() - m_reader->GetPosition() ) );
			uint64		pos = m_reader->GetPosition();
			if( false == m_reader->Read( toFill , 1 , readbyte , Little_EndianType ) )
			{
				m_reader->Seek( pos );
				return 0;
			}
			return readbyte;
		}
	// public function
	public:
		BinInputStream_bs
				(
				IFileStreamRead*		reader
				) : m_reader( reader )
		{
		}
		~BinInputStream_bs()
		{
		}
	};
	class InputSource_bs : public XERCES_CPP_NAMESPACE::InputSource
	{
		cb_copy_impossible( InputSource_bs );
	private:
		IFileStreamRead*	m_reader;

	// "InputSource" interface
	private:
		XERCES_CPP_NAMESPACE::BinInputStream* makeStream()const
		{
			return new BinInputStream_bs( m_reader );
		}
	// public function
	public:
		InputSource_bs
				(
				IFileStreamRead*		reader
				) : 
				XERCES_CPP_NAMESPACE::InputSource( XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager ) , 
				m_reader( reader )
		{
		}
	};
	class FormatTarget_bs : public XMLFormatTarget
	{
	private:
		IStreamWrite*		m_writer;
		
	// "XMLFormatTarget" interface
	private:
		void writeChars
				(
				const XMLByte* const	toWrite,
				const unsigned int		count,
				XMLFormatter* const		formatter
				)
		{
			if( m_writer == false )
				return;
			m_writer->Write( toWrite , 1 , count , Little_EndianType );
		}
	public:
		FormatTarget_bs
				(
				IStreamWrite*		writer
				) : m_writer( writer )
		{
		}
	};
// private functions
private:
//=================================================================================================
//!	trace
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Trace
		(
		DOMNode&		node
		)
{
	wstring		name( node.getNodeName() );
	OutputDebugString( L"**" );
	OutputDebugString( name.c_str() );
	OutputDebugString( L"\n" );
	
	short	type = node.getNodeType();
	
	DOMNamedNodeMap*	attlist = node.getAttributes();
	if( attlist != 0 )
	{
	uint32		att_off;
	for( att_off = 0 ; att_off < attlist->getLength() ; att_off++ )
	{
		DOMNode*	att = attlist->item( att_off );
		if( att->getNodeType() == att->ATTRIBUTE_NODE )
		{
			wstring		name( att->getNodeName() );
			wstring		value( att->getNodeValue() );
			OutputDebugString( L"[att]" );
			OutputDebugString( name.c_str() );
			OutputDebugString( L"=" );
			OutputDebugString( value.c_str() );
			OutputDebugString( L"\n" );
		}	
	}
	}
    DOMNodeList* children = node.getChildNodes();
    uint32		off;
    for( off = 0 ; off < children->getLength() ; off++ )
    {
        DOMNode* c = ( DOMNode* )children->item( off );
        if( c->getNodeType() == c->ELEMENT_NODE )
        {
			Trace( *c );
        }
        else if( c->getNodeType() == c->TEXT_NODE )
        {
			wstring		text( c->getTextContent() );
			OutputDebugString( L"[text]" );
			OutputDebugString( text.c_str() );
			OutputDebugString( L"\n" );
        }
		else if( c->getNodeType() == node.PROCESSING_INSTRUCTION_NODE )
		{
			DOMProcessingInstruction*	p = (DOMProcessingInstruction*)c;
			wstring	target( p->getTarget() );
			wstring	data( p->getData() );
			OutputDebugString( L"[processing]" );
			OutputDebugString( target.c_str() );
			OutputDebugString( L"=" );
			OutputDebugString( data.c_str() );
			OutputDebugString( L"\n" );
		}
    }
	
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ParserSVG()
{
	XMLPlatformUtils::Initialize();
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~ParserSVG()
{
	XMLPlatformUtils::Terminate();
}
//=================================================================================================
//!	load
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iTreeNode Load
		(
		IFileStreamRead*		reader
		)
{
	instance<svg_svg>	svg;
	try 
	{
		InputSource_bs		fr( reader );
		XercesDOMParser		parser;
	    parser.setValidationScheme(XercesDOMParser::Val_Auto);
		parser.setDoNamespaces(false);
		parser.setDoSchema(false);
		parser.setCreateEntityReferenceNodes(false);

//		parser.setValidationScheme( XercesDOMParser::Val_Always );
//		parser.setDoNamespaces( true );
		parser.parse( fr );
		        
		XERCES_CPP_NAMESPACE::DOMDocument* doc = parser.getDocument();
		if( doc == 0 )
			throw 0;
		XERCES_CPP_NAMESPACE::DOMElement* root = doc->getDocumentElement();
		if( root == 0 )
			throw 0;
		if( wstring( root->getNodeName() ) != L"svg" )
			throw 0;
#ifdef cb_debug			
//Trace( *root );
#endif
		// load cmd
		CmdStack_svg		stack;
		stack.PushCmd( root , (iSvgXml)svg );
		
		XERCES_CPP_NAMESPACE::DOMNode*	node;
		iSvgXml							obj;
		while( true == stack.PopCmd( &node , &obj ) )
		{
			if( obj == false )
				continue;
			if( false == obj->SetXml( &stack , node ) )
				throw 0;
		}
	} 
	catch(...) 
	{
		return iTreeNode();
	}
	return (iTreeNode)svg;
}
//=================================================================================================
//!	load
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iTreeNode Load
		(
		const wchar_t*		path
		)
{
	instance< FileReader >			file;
	if( false == file->Open( path ) )
		return iTreeNode();
	return Load( ( iFileStreamRead )file );
}
//=================================================================================================
//!	save
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool Save
		(
		IStreamWrite*		owriter , 
		iTreeNode&			svg , 
		const wstring&		encode = L"UTF-8" , 
		int					option = 0
		)
{
	XMLPlatformUtils::Initialize();
	
	XERCES_CPP_NAMESPACE::DOMDocument*	doc		= 0;
	DOMWriter*							writer	= 0;
	
	try
	{
		DOMImplementation*		impl	= DOMImplementation::getImplementation();
		if( impl == 0 )
			throw 0;
		DOMDocumentType*		doctype = impl->createDocumentType( L"svg" , L"-//W3C//DTD SVG 1.0//EN" , L"http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd" );
		if( doctype == 0 )
			throw 0;
		doc		= impl->createDocument( NULL , L"svg" , doctype );
		if( doc == 0 )
			throw 0;
		DOMElement*				root	= doc->getDocumentElement();
		if( root == 0 )
			throw 0;

		// svg
		CmdStack_svg		stack;
		iSvgXml		mn = ( iSvgXml )svg;
		if( mn == false )
			throw 0;
		if( false == mn->StoreXml_root( &stack , doc , root ) )
			throw 0;
			
		XERCES_CPP_NAMESPACE::DOMNode*	node;
		iSvgXml							obj;
		while( true == stack.PopCmd( &node , &obj ) )
		{
			if( obj == false )
				continue;
			if( false == obj->StoreXml( &stack , doc , node ) )
				throw 0;
		}

		// write	
		writer = impl->createDOMWriter();
		writer->setEncoding( encode.c_str() );
		if( ( option & Format_OutputOption ) != 0 )
		{
			if( writer->canSetFeature( XMLUni::fgDOMWRTFormatPrettyPrint , true ) )
			    writer->setFeature( XMLUni::fgDOMWRTFormatPrettyPrint , true );
		}
		FormatTarget_bs		target( owriter );
		if( false == writer->writeNode( &target , *doc ) )
			throw 0;
	}
	catch( ... )
	{
		if( writer != 0 )
			writer->release();
		if( doc != 0 )
			doc->release();
		return false;
	}
	doc->release();
	writer->release();
	return true;
}
//=================================================================================================
//!	save
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool Save
		(
		const wchar_t*		path , 
		iTreeNode&			svg , 
		const wstring&		encode = L"UTF-8" , 
		int					option = 0
		)
{
	instance< FileWriter >			file;
	if( false == file->Open( path ) )
		return false;
	return Save( ( iStreamWrite )file , svg , encode , option );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
