/*************************************************************************************************/
/*!
   	@file		FontManager.h
	@author 	Fanzo
 	@date 		2008/4/14
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iFontManager.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
#ifdef cb_windows
struct lfCharsetConv
{
	BYTE				m_lfcharset;
	FontCharsetType		m_fontcharset;
};
//=================================================================================================
//!	lfCharsetConvTbl
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
lfCharsetConv*	GetlfCharsetConvTbl
		(
		int		*num
		)
{
	static
	lfCharsetConv		convtbl[] = 
	{
		ANSI_CHARSET , Roman_FontCharsetType , 
		SHIFTJIS_CHARSET , Japanese_FontCharsetType , 
/*
		ANSI_CHARSET , "ANSI_CHARSET" , 
		BALTIC_CHARSET , "BALTIC_CHARSET" , 
		CHINESEBIG5_CHARSET , "CHINESEBIG5_CHARSET" , 
		DEFAULT_CHARSET , "DEFAULT_CHARSET" , 
		EASTEUROPE_CHARSET ,"EASTEUROPE_CHARSET" , 
		GB2312_CHARSET , "GB2312_CHARSET" , 
		GREEK_CHARSET , "GREEK_CHARSET" , 
		HANGUL_CHARSET , "HANGUL_CHARSET" , 
		MAC_CHARSET , "MAC_CHARSET" , 
		OEM_CHARSET , "OEM_CHARSET" , 
		RUSSIAN_CHARSET , "RUSSIAN_CHARSET" , 
		SHIFTJIS_CHARSET , "SHIFTJIS_CHARSET" , 
		SYMBOL_CHARSET , "SYMBOL_CHARSET" , 
		TURKISH_CHARSET , "TURKISH_CHARSET" , 
		VIETNAMESE_CHARSET , "VIETNAMESE_CHARSET" , 
		ANSI_CHARSET  , "ANSI_CHARSET" ,  
		DEFAULT_CHARSET , "DEFAULT_CHARSET" ,  
		SYMBOL_CHARSET , "SYMBOL_CHARSET" ,  
		SHIFTJIS_CHARSET , "SHIFTJIS_CHARSET" , 
		HANGUL_CHARSET  , "HANGUL_CHARSET" ,  
		GB2312_CHARSET  , "GB2312_CHARSET" ,  
		CHINESEBIG5_CHARSET  , "CHINESEBIG5_CHARSET" ,  
		OEM_CHARSET  , "OEM_CHARSET" ,  
		JOHAB_CHARSET  , "JOHAB_CHARSET" ,  
		HEBREW_CHARSET , "HEBREW_CHARSET" ,  
		ARABIC_CHARSET  , "ARABIC_CHARSET" ,  
		GREEK_CHARSET , "GREEK_CHARSET" ,  
		TURKISH_CHARSET , "TURKISH_CHARSET" ,  
		VIETNAMESE_CHARSET , "VIETNAMESE_CHARSET" ,  
		THAI_CHARSET , "HAI_CHARSET" ,  
		EASTEUROPE_CHARSET , "EASTEUROPE_CHARSET" ,  
		RUSSIAN_CHARSET , "RUSSIAN_CHARSET" ,  
		MAC_CHARSET , "MAC_CHARSET" ,  
		BALTIC_CHARSET  , "BALTIC_CHARSET" ,  
*/
	};
	*num	= cb_countof( convtbl );
	return convtbl;
}
//=================================================================================================
//!	lfCharsetToFontCharsetType
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void lfCharsetToFontCharsetType
		(
		BYTE			charset , 
		FontCharsetType	*fct
		)
{
	int		off , num;
	lfCharsetConv*	convtbl	= GetlfCharsetConvTbl( &num );
	for( off = 0 ; off < num ; off++ )
	{
		if( convtbl[ off ].m_lfcharset == charset )
		{
			*fct	= convtbl[ off ].m_fontcharset;
			return;
		}
	}
	*fct	= Unknown_FontCharsetType;
}
//=================================================================================================
//!	FontCharsetTypeTolfCharset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
bool FontCharsetTypeTolfCharset
		(
		FontCharsetType	fct , 
		BYTE			*charset
		)
{
	int		off , num;
	lfCharsetConv*	convtbl	= GetlfCharsetConvTbl( &num );
	for( off = 0 ; off < num ; off++ )
	{
		if( convtbl[ off ].m_fontcharset == fct )
		{
			*charset	= convtbl[ off ].m_lfcharset;
			return true;
		}
	}
	return false;
}
#endif

#ifdef cb_windows
/**************************************************************************************************
"FontManager_bs" class 
**************************************************************************************************/
class FontManager_bs : 
	public IFontManager_win
{
// member class	
	class FontsetInfoEx
	{
	public:
		FontsetInfo			m_fontinfo;
		LOGFONTW			m_logfont;
	};
// variable member
private:
	bool					m_update;
	Array<FontsetInfoEx>	m_fontsetlist;

	// default
	int						m_default_off;

// static functions
//=======================================================================
//!	font callback.
//!	@retval			---
//-----------------------------------------------------------------------
static
int CALLBACK EnumFontFamiliesProcStatic
		(
		ENUMLOGFONTW	*lpelf , 
		NEWTEXTMETRIC	*lpntm , 
		int				fonttype , 
		LPARAM			lparam
		) 
{
	FontsetInfoEx		info;
	info.m_logfont	= lpelf->elfLogFont;
	
	//set fontformat
	if( ( fonttype & RASTER_FONTTYPE ) != 0 )
		info.m_fontinfo.m_format_mask |= Raster_FontFormatType;
	if( ( fonttype & TRUETYPE_FONTTYPE ) != 0 )
		info.m_fontinfo.m_format_mask |= TrueType_FontFormatType;
		
	//language
	lfCharsetToFontCharsetType( lpelf->elfLogFont.lfCharSet , &info.m_fontinfo.m_charset );

	//facename
	info.m_fontinfo.m_facename		= lpelf->elfLogFont.lfFaceName;

	//pitch
	info.m_fontinfo.m_pitchtype	= ( ( lpelf->elfLogFont.lfPitchAndFamily & FIXED_PITCH ) != 0 ) ? Fix_FontPitchType : Variable_FontPitchType;
	
	//add list
	Array<FontsetInfoEx>*list	= &( ( FontManager_bs* )lparam )->m_fontsetlist;
	list->Add( info );

	return 1;
} 
// private functions
private:
//=================================================================================================
//!	UpdateFontlist
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateFontlist()
{
	if( m_update == true )
		return;
	m_update	= true;
	
	m_default_off	= -1;
	m_fontsetlist.Resize( 0 );
	HDC			hdc		= ::GetDC( NULL );
	LOGFONTW		logfont;
	::ZeroMemory( &logfont , sizeof( logfont ) );
	logfont.lfCharSet	= DEFAULT_CHARSET;
	::EnumFontFamiliesExW( hdc , &logfont , ( FONTENUMPROC )EnumFontFamiliesProcStatic , ( LPARAM )this , 0 ); 
	::ReleaseDC( NULL , hdc );
}
//=================================================================================================
//!	Update default
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateDefault()
{
	if( m_default_off != -1 )
		return;
	UpdateFontlist();
	
	//gui's font is default.
	HFONT	font = ( HFONT )::GetStockObject( DEFAULT_GUI_FONT );
	cb_assert( font != NULL , L"fali to ::GetStockObject( DEFAULT_GUI_FONT )" );
	
	//font info.
	LOGFONTW		info;
	cb_verify( 0 != ::GetObject( ( HFONT )font , sizeof( info ) , &info ) );
	
	//search facename from fontlist.
	int		off , num = m_fontsetlist.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( m_fontsetlist[ off ].m_fontinfo.m_facename == info.lfFaceName )
			break;
	}
	cb_assert( off < num , L"can't fine default font." );
	m_default_off	= off;
}

// "IFontManager" interface functions
public:
//=================================================================================================
//!	get default fontsetinfo
//!	@retval			---
//-------------------------------------------------------------------------------------------------
FontsetInfo cb_call GetDefaultFontsetInfo()
{
	UpdateDefault();
	return m_fontsetlist[ m_default_off ].m_fontinfo;
}
//=================================================================================================
//!	get fontset num
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetFontsetNum()
{
	UpdateFontlist();
	return m_fontsetlist.GetDatanum();
}
//=================================================================================================
//!	get fontsetinfo
//!	@retval			---
//-------------------------------------------------------------------------------------------------
FontsetInfo cb_call GetFontsetInfo
		(
		int		off
		)
{
	return m_fontsetlist[ off ].m_fontinfo;
}

// "IFontManager_win" interface functions
public:
//=================================================================================================
//!	get LOGFONT
//!	@retval			---
//-------------------------------------------------------------------------------------------------
LOGFONTW cb_call GetLOGFONT
		(
		int		off
		)
{
	return m_fontsetlist[ off ].m_logfont;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
FontManager_bs() : 
		m_fontsetlist( Constant_ArrayCashType , 128 ) , 
		m_update( false ) , 
		m_default_off( -1 )
{
}
};
/**************************************************************************************************
"FontManager" class 
**************************************************************************************************/
class FontManager : 
	virtual public object_base , 
	public FontManager_bs
{
// query
	query_begin();
	iface_hook( IFontManager , IFontManager_IID )
	iface_hook( IFontManager_win , IFontManager_win_IID )
	query_end( object_base );

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
FontManager()
{
}
};
#endif		// cb_windows

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
