/*************************************************************************************************/
/*!
   	@file		edgemappolygon.h
	@author 	Fanzo
 	@date 		2008/3/23
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iEdgemapPolygon.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

namespace edgemappolygon
{
class LogicAnd
{
public:
	bool Logic( int prev_cnt , int cnt )
	{
		if( ( prev_cnt != 3 && cnt == 3 )
		||  ( prev_cnt == 3 && cnt != 3 ) )
			return true;
		return false;
	}
};
class LogicSub
{
public:
	bool Logic( int prev_cnt , int cnt )
	{
		if( ( ( prev_cnt == 1 ) && ( cnt != 1 ) )
		||  ( ( prev_cnt != 1 ) && ( cnt == 1 ) ) )
			return true;
		return false;
	}
};
};
/**************************************************************************************************
"EdgemapPolygon_bs" class 
**************************************************************************************************/
class EdgemapPolygon_bs : 
		public IEdgemapPolygon
{
	cb_copy_impossible( EdgemapPolygon_bs );

// member class
protected:
	class PolygonEdgeEx : public PolygonEdge
	{
	public:
		float		m_u;
		float		m_v;
		int			m_direction;
		int			m_logic;
	};
// variable member
private:
	IMemAllocLump*							m_allocator;
	ArrayAllocator< PolygonScanlineInfo >	m_linefactory;
	
	antialias						m_antialias;
	irect							m_area_fx;
	
	int								m_start_y;	
	int								m_end_y;	
	PolygonInfo*					m_first;
	PolygonInfo*					m_last;

// private functions
private:
//=================================================================================================
//!	create PolygonEdgeEx
//!	@retval			---
//-------------------------------------------------------------------------------------------------
PolygonEdgeEx* CreatePolygonEdgeEx()
{
	return ( PolygonEdgeEx* )m_allocator->Allocate( sizeof( PolygonEdgeEx ) );
}
//=================================================================================================
//!	create PolygonInfo
//!	@retval			---
//-------------------------------------------------------------------------------------------------
PolygonInfo* CreatePolygonInfo()
{
	return ( PolygonInfo* )m_allocator->Allocate( sizeof( PolygonInfo ) );
}
//=================================================================================================
//!	get scope y
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void GetScopeY
		(
		const faffine&		affine , 
		int					vertexnum , 
		const fvector2		vertex[] , 
		float				*min , 
		float				*max
		)
{
	float	miny	= affine.Transform( vertex[ 0 ] ).y;
	float	maxy	= miny;
	int		vertexoff;
	for( vertexoff = 1 ; vertexoff < vertexnum ; vertexoff++ )
	{
		fvector2	p = affine.Transform( vertex[vertexoff] );
		miny	= miny < p.y ? miny : p.y;
		maxy	= maxy > p.y ? maxy : p.y;
	}
	*min	= miny;
	*max	= maxy;
}
//=================================================================================================
//!	subpixelunit
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 ToFx
		(
		const fvector2 &pos
		)const
{
	fvector2	r;
	r.x = floor( pos.x * outlinedgemap_anti_scale_x() + 0.5f );
	r.y = floor( pos.y * anti_scale( m_antialias ) + 0.5f );
	return r;
}
//=================================================================================================
//!	subpixelunit
//!	@retval			---
//-------------------------------------------------------------------------------------------------
irect ToFx
		(
		const irect&	r
		)const
{
	int		x_sft = outlinedgemap_anti_shift_x();
	int		y_sft = anti_shift( m_antialias );
	return irect( r.xmin << x_sft , r.ymin << y_sft , r.xmax << x_sft , r.ymax << y_sft );
}
//=================================================================================================
//!	subpixelunit
//!	@retval			---
//-------------------------------------------------------------------------------------------------
irect FxTo
		(
		const irect&	r_fx
		)const
{
	int		x_sft = outlinedgemap_anti_shift_x();
	int		y_sft = anti_shift( m_antialias );
	return irect( r_fx.xmin >> x_sft , r_fx.ymin >> y_sft , r_fx.xmax >> x_sft , r_fx.ymax >> y_sft );
}
//=================================================================================================
//!	add outlineedge
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void AddEdge
		(
		PolygonInfo*	pi , 
		int				x_fx , 
		int				y_fx , 
		const fvector2&	uv , 
		int				dir
		)
{
	int				dy		= y_fx - ( pi->m_start_y << anti_shift( m_antialias ) );
	PolygonEdgeEx*	node	= (PolygonEdgeEx*)pi->m_line[ dy ].m_edge;
	PolygonEdgePtr*	prev	= &pi->m_line[ dy ].m_edge;

	// search
	while( node != 0 )
	{
		if( node->m_x == x_fx )
		{
			node->m_direction += dir;
			if( node->m_direction == 0 )
				*prev	= node->m_next;
			return;
		}
		else if( x_fx < node->m_x )
			break;
		prev = &node->m_next;
		node = (PolygonEdgeEx*)node->m_next;
	}
	// add node
	PolygonEdgeEx	*e	= CreatePolygonEdgeEx();
	e->m_next		= *prev;
	*prev			= e;

	e->m_direction	= dir;
	e->m_x			= x_fx;
	e->m_u			= uv.x;
	e->m_v			= uv.y;
}
//=================================================================================================
//!	set segment
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void AddSegment
		(
		PolygonInfo*	pi , 
		const fvector2&	start , 
		const fvector2&	target , 
		fvector2		suv , 
		fvector2		tuv	
		)
{
	fvector2	s	= ToFx( start );
	fvector2	t	= ToFx( target );
	int			ssy	= ( int )floorf( 0.5f + clip( s.y , (float)( pi->m_start_y << anti_shift( m_antialias ) ) , (float)( pi->m_end_y << anti_shift( m_antialias ) ) ) );
	int			tty	= ( int )floorf( 0.5f + clip( t.y , (float)( pi->m_start_y << anti_shift( m_antialias ) ) , (float)( pi->m_end_y << anti_shift( m_antialias ) ) ) );
	int			dir	= 1;
	if( ssy == tty )
		return;
	if( ssy > tty )
	{
		swap( &ssy , &tty );
		swap( &s , &t );
		swap( &suv , &tuv );
		dir = -1;
	}
	float		ssx = ( t.x - s.x ) * ( ( ssy + 0.5f ) - s.y ) / ( t.y - s.y ) + s.x;
	float		ttx = ( t.x - s.x ) * ( ( tty + 0.5f ) - s.y ) / ( t.y - s.y ) + s.x;
	float		dx	= ( ttx - ssx ) / ( tty - ssy );

	fvector2	ssuv	= ( tuv - suv ) * ( ( ssy + 0.5f ) - s.y ) / ( t.y - s.y ) + suv;
	fvector2	ttuv	= ( tuv - suv ) * ( ( tty + 0.5f ) - s.y ) / ( t.y - s.y ) + suv;
	fvector2	duv		= ( ttuv - ssuv ) / (float)( tty - ssy );
	
	int		y;
	for( y = ssy ; y < tty ; y++ )
	{
		AddEdge( pi , ( int )floorf( ssx + 0.5f ) , y , ssuv , dir );
		ssx += dx;
		ssuv+= duv;
	}
}
//=================================================================================================
//!	update scanline info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateScanlineInfo
		(
		PolygonInfo*	pi , 
		int				linenum
		)
{
	int		lineoff;
	for( lineoff = 0 ; lineoff < linenum ; lineoff++ )
	{
		PolygonEdgeEx*	pe = ( PolygonEdgeEx* )pi->m_line[ lineoff ].m_edge;
		if( pe == 0 )
			continue;
		float	fx = ( float )outlinedgemap_anti_scale_x();
		pi->m_line[ lineoff ].m_sx	= pe->m_x / fx;
		pi->m_line[ lineoff ].m_su	= pe->m_u;
		pi->m_line[ lineoff ].m_sv	= pe->m_v;
		pe	= ( PolygonEdgeEx* )pe->m_next;
		pi->m_line[ lineoff ].m_tx	= pe->m_x / fx;
		pi->m_line[ lineoff ].m_tu	= pe->m_u;
		pi->m_line[ lineoff ].m_tv	= pe->m_v;
	}
}
//=================================================================================================
//!	LogicPath_and
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_logic >
PolygonEdge* LogicPath
		(
		PolygonEdgeEx*	edge , 
		t_logic&		lg
		)
{
	int		count = 0;
	
	PolygonEdge	first;
	first.m_next	= 0;
	PolygonEdge	*prev = &first;
	
	while( edge != 0 )
	{
		int	n_count = count + edge->m_logic;

		if( true == lg.Logic( count , n_count ) )
		{
			prev->m_next	= edge;
			prev			= edge;
		}
		count = n_count;
		edge	= ( PolygonEdgeEx* )edge->m_next;
	}
	prev->m_next = 0;
	return first.m_next;
}
//=================================================================================================
//!	clip_and_line
//!	@retval			---
//-------------------------------------------------------------------------------------------------
PolygonEdge* CreateLogicPath
		(
		PolygonEdge*		ptgt , 
		const OutlineEdge*	psrc
		)
{
	PolygonEdgeEx*		t_edge = (PolygonEdgeEx*)ptgt;
	const OutlineEdge*	s_edge = ( psrc == 0 ) ? 0 : psrc;
	
	PolygonEdge		first;
	first.m_x		= INT_MIN;
	PolygonEdge*	prev = &first;
	PolygonEdge*	prev_tgt = 0;
	
	int			t_dir		= 1;
	int			s_dir		= 2;
	while( s_edge !=0 || t_edge != 0 )
	{
		if( s_edge == 0 || ( t_edge != 0 && t_edge->m_x <= s_edge->x ) )
		{
			if( prev->m_x == t_edge->m_x )
				( ( PolygonEdgeEx* )prev )->m_logic += t_dir;
			else
			{
				prev->m_next	= t_edge;
				prev			= t_edge;
				( ( PolygonEdgeEx* )t_edge )->m_logic = t_dir;
			}
			t_dir		= t_dir == 1 ? -1 : 1;
			prev_tgt	= t_edge;
			t_edge		= (PolygonEdgeEx*)t_edge->m_next;
		}
		else
		{
			if( prev->m_x == s_edge->x )
				( ( PolygonEdgeEx* )prev )->m_logic += s_dir;
			else
			{
				PolygonEdgeEx	*e = CreatePolygonEdgeEx();
				e->m_x			= s_edge->x;
				e->m_next		= 0;
				e->m_logic		= s_dir;
				prev->m_next	= e;
				prev			= e;
			}
			s_dir	= s_dir == 2 ? -2 : 2;
			s_edge	= s_edge->m_next;
		}
	}
	prev->m_next = 0;
	return first.m_next;
}
//=================================================================================================
//!	operate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_logic >
void cb_call OperateLogic
		(
		PolygonInfo*				pi , 
		const EdgemapOutlineInfo&	ei , 
		t_logic&					lg
		)
{
	irect	d_area		= FxTo( m_area_fx ).And( irect( m_area_fx.xmin >> anti_shift( m_antialias ) , pi->m_start_y , m_area_fx.xmax >> anti_shift( m_antialias ) , pi->m_end_y )/*.And( ei.m_area )*/ );
	
	int		d_to_f8		= 8 - anti_shift( m_antialias );
	int		s_to_f8		= 8 - anti_shift( ei.m_antialias );
	
	int		dsy_f8		= d_area.ymin << 8;
	int		dty_f8		= d_area.ymax << 8;
	int		ddy_f8		= 1 << d_to_f8;
	int		dsy			= m_area_fx.ymin;
	int		ssy			= ei.m_area.ymin << anti_shift( ei.m_antialias );
	int		sly			= ( ei.m_area.ymax - ei.m_area.ymin ) << anti_shift( ei.m_antialias );

	int		y;
	for( y = dsy_f8 ; y < dty_f8 ; y+=ddy_f8 )
	{
		int		dy	= ( y >> d_to_f8 ) - ( pi->m_start_y << anti_shift( m_antialias ) );
		int		sy	= ( y >> s_to_f8 ) - ( ei.m_area.ymin << anti_shift( ei.m_antialias ) );
		PolygonEdge	*e;
		if( 0 <= sy && sy < sly )
			e = CreateLogicPath( pi->m_line[ dy ].m_edge , ei.m_line[ sy ].m_edge );
		else
			e = CreateLogicPath( pi->m_line[ dy ].m_edge , 0 );
		pi->m_line[ dy ].m_edge = LogicPath( ( PolygonEdgeEx* )e , lg );
	}	
}
// "IEdgemapPolygonInfo" interface functions
public:
//=================================================================================================
//!	get polygonedge info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call GetEdgemapPolygonInfo
		(
		EdgemapPolygonInfo*		info
		)const
{
	if( m_first == 0 )
		return false;
	info->m_antialias	= m_antialias;
	info->m_start_y		= m_start_y;
	info->m_end_y		= m_end_y;
	info->m_polygon		= m_first;
	return true;
}
// "IEdgemapPolygon" interface functions
public:
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Initialize
		(
		antialias		antialias , 
		const irect		&area
		)
{
	m_allocator->DeallocateAll();
	m_linefactory.Initialize( area.Height() << anti_shift( antialias ) );
	
	m_first		= 0;
	m_last		= 0;
	m_antialias	= antialias;
	m_area_fx	= ToFx( area );
}
//=================================================================================================
//!	add polygon
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call AddPolygon
		(
		int					vertnum , 
		const fvector2		vert[] , 
		const fvector2		uvmap[] , 
		const faffine&		affine
		)
{
	if( vertnum < 3 )
		return;

	// calc polygon scope
	int	miny_fx , maxy_fx;
	{
		float	fminy , fmaxy;
		GetScopeY( affine , vertnum , vert , &fminy , &fmaxy );
		miny_fx	= ( int32 )floorf( fminy );
		maxy_fx	= ( int32 )ceilf( fmaxy );
		miny_fx <<= anti_shift( m_antialias );
		maxy_fx <<= anti_shift( m_antialias );
		miny_fx	= clip( miny_fx , m_area_fx.ymin , m_area_fx.ymax );
		maxy_fx	= clip( maxy_fx , m_area_fx.ymin , m_area_fx.ymax );
	}
	if( miny_fx >= maxy_fx )
		return;
	
	// create PolygonInfo
	PolygonInfo*	pi	= CreatePolygonInfo();
	pi->m_next			= 0;
	pi->m_start_y		= miny_fx >> anti_shift( m_antialias );
	pi->m_end_y			= maxy_fx >> anti_shift( m_antialias );
	pi->m_line			= m_linefactory.Allocate( maxy_fx - miny_fx );
	MemoryZero( pi->m_line , sizeof( pi->m_line[0] ) * ( maxy_fx - miny_fx ) );

	// add edgeline
	int		vertoff;
	for( vertoff = 0 ; vertoff < vertnum ; vertoff++ )
	{
		int		t_vertoff = ( vertoff + 1 == vertnum ) ? 0 : ( vertoff + 1 );
		AddSegment( pi , affine.Transform( vert[ vertoff ] ) , affine.Transform( vert[ t_vertoff ] ) , uvmap[ vertoff ] , uvmap[ t_vertoff ] );
	}
	// updateScanlineInfo
	UpdateScanlineInfo( pi , maxy_fx - miny_fx );
	
	// update start , end y
	if( m_first == 0 )
	{
		m_start_y	= pi->m_start_y;
		m_end_y		= pi->m_end_y;
	}
	else
	{
		m_start_y	= pi->m_start_y < m_start_y ? pi->m_start_y : m_start_y;
		m_end_y		= pi->m_end_y > m_end_y ? pi->m_end_y : m_end_y;
	}
	// update list
	if( m_last == 0 )
	{
		m_first	= pi;
		m_last	= pi;
	}
	else
	{
		m_last->m_next	= pi;
		m_last			= pi;
	}
}
//=================================================================================================
//!	Operate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Operate
		(
		PolygonOperator			ope , 
		IEdgemapOutlineInfo*	info
		)
{
	EdgemapOutlineInfo	ei =info->GetEdgemapOutlineInfo();
	if( ope == And_PolygonOperator )
	{
		PolygonInfo*	pi	= m_first;
		while( pi != 0 )
		{
			edgemappolygon::LogicAnd	lg;
			OperateLogic( pi , ei , lg );
			pi	= pi->m_next;
		}
	}
	else if( ope == Sub_PolygonOperator )
	{
		PolygonInfo*	pi	= m_first;
		while( pi != 0 )
		{
			edgemappolygon::LogicSub	lg;
			OperateLogic( pi , ei , lg );
			pi	= pi->m_next;
		}
	}
}
// public functions
public:
//=================================================================================================
EdgemapPolygon_bs		
		(
		IMemAllocLump*	alloc
		) :	
		m_allocator( alloc ) , 
		m_first( 0 ) , 
		m_last( 0 ) , 
		m_antialias( none_antialias ) , 
		m_start_y( 0 ) , 
		m_end_y( 0 )
{
	cb_assert( m_allocator != 0 , L"Allocator isn't exist." );
}
//=================================================================================================
~EdgemapPolygon_bs()
{
	ReleaseAllocator();
}
//=================================================================================================
void ReleaseAllocator()
{
	if( m_allocator == 0 )
		return;
	m_allocator->DeallocateAll();
	m_allocator = 0;
	m_first		= 0;
	m_last		= 0;
	m_area_fx	= irect();
}
};

/**************************************************************************************************
"EdgemapPolygon" class 
**************************************************************************************************/
class EdgemapPolygon : 
		public EdgemapPolygon_bs , 
		virtual public object_base
{
	query_begin()
	iface_hook( IEdgemapPolygon , IEdgemapPolygon_IID )
	iface_hook( IEdgemapPolygonInfo , IEdgemapPolygonInfo_IID )
	query_end( object_base )

private:
	MemAllocLump_inc		m_allocator;
	
public:
//=================================================================================================
EdgemapPolygon() : EdgemapPolygon_bs( &m_allocator ) , m_allocator( sizeof( PolygonEdgeEx ) * 512 )
{
}
//=================================================================================================
~EdgemapPolygon()
{
	ReleaseAllocator();
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
