/*************************************************************************************************/
/*!
   	@file		edgemapoutline.h
	@author 	Fanzo
 	@date 		2008/3/2
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iEdgemapOutline.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

class LogicAnd
{
public:
	bool CalcArea
			(
			irect*			area , 
			const irect&	dest , 
			const irect&	src
			)
	{
		if( src.IsExist() == false )
		{
			*area = dest;
			return true;
		}
		if( dest.IsExist() == false )
		{
			*area = src;
			return true;
		}
		*area = dest | src;
		return true;
	}		
	bool Logic( int prev_cnt , int cnt )
	{
		if( ( prev_cnt != 3 && cnt == 3 )
		||  ( prev_cnt == 3 && cnt != 3 ) )
			return true;
		return false;
	}
};
class LogicOr
{
public:
	bool CalcArea
			(
			irect*			area , 
			const irect&	dest , 
			const irect&	src
			)
	{
		if( src.IsExist() == false )
			return false;
		if( dest.IsExist() == false )
		{
			*area = src;
			return true;
		}
		*area = dest | src;
		return true;
	}		
	bool Logic( int prev_cnt , int cnt )
	{
		if( ( prev_cnt == 0 && cnt > 0 )
		||  ( prev_cnt > 0 && cnt == 0 ) )
			return true;
		return false;
	}
};
class LogicXor
{
public:
	bool CalcArea
			(
			irect*			area , 
			const irect&	dest , 
			const irect&	src
			)
	{
		if( src.IsExist() == false )
			return false;
		if( dest.IsExist() == false )
		{
			*area = src;
			return true;
		}
		*area = dest | src;
		return true;
	}		
	bool Logic( int prev_cnt , int cnt )
	{
		if( ( ( prev_cnt == 1 || prev_cnt == 2 ) && ( cnt != 1 && cnt != 2 ) )
		||  ( ( prev_cnt != 1 && prev_cnt != 2 ) && ( cnt == 1 || cnt == 2 ) ) )
			return true;
		return false;
	}
};
class LogicSub
{
public:
	bool CalcArea
			(
			irect*			area , 
			const irect&	dest , 
			const irect&	src
			)
	{
		if( src.IsExist() == false )
		{
			*area = dest;
			return true;
		}
		if( dest.IsExist() == false )
		{
			*area = src;
			return true;
		}
		*area = dest | src;
		return true;
	}		
	bool Logic( int prev_cnt , int cnt )
	{
		if( ( ( prev_cnt == 1 ) && ( cnt != 1 ) )
		||  ( ( prev_cnt != 1 ) && ( cnt == 1 ) ) )
			return true;
		return false;
	}
};
/**************************************************************************************************
"EdgemapOutline_bs" class 
**************************************************************************************************/
class EdgemapOutline_bs : 
		public IEdgemapOutline
{
	class Scanline
	{
	public:
		antialias						m_antialias;
	private:
		irect							m_world;
		irect							m_world_fx;
		bool							m_area_f;
		irect							m_area;
		irect							m_area_fx;
		Array< OutlineScanlineInfo >	m_scans;
		EdgemapOutlineInfo				m_info;
		
	private:
		//=================================================================================================
		bool GetArea
				(
				irect*			rect , 
				const frect&	fbb , 
				const faffine&	affine
				)
		{
			fvector2	pnt[4] = 
			{
				fvector2( fbb.xmin , fbb.ymin ) , 
				fvector2( fbb.xmax , fbb.ymin ) , 
				fvector2( fbb.xmin , fbb.ymax ) , 
				fvector2( fbb.xmax , fbb.ymax ) , 
			};
			int		i;
			for( i = 0 ; i < _countof( pnt ) ; i++ )
				pnt[ i ]	= affine.Transform( pnt[i] );
			frect	fr( pnt[0].x , pnt[0].y , pnt[0].x , pnt[0].y );
			for( i = 1 ; i < _countof( pnt ) ; i++ )
			{
				fr.xmin		= min( fr.xmin , pnt[i].x );
				fr.ymin		= min( fr.ymin , pnt[i].y );
				fr.xmax	= max( fr.xmax , pnt[i].x );
				fr.ymax	= max( fr.ymax , pnt[i].y );
			}
			irect	area;
			area.xmin	= ( int )floorf( fr.xmin );
			area.ymin	= ( int )floorf( fr.ymin );
			area.xmax	= ( int )ceilf( fr.xmax );
			area.ymax	= ( int )ceilf( fr.ymax );
			if( area.IsExist() == false )
				return false;
			*rect	= area;
			return true;
		}
	public:
		//=================================================================================================
		Scanline() : 
				m_area_f( false ) , 
				m_scans( Expand_ArrayCashType , 128 ) , 
				m_antialias( x4_antialias )
		{
		}
		//=================================================================================================
		void Initialize
				(
				antialias		anti , 
				const irect&	world
				)
		{
			m_antialias		= anti;
			m_world			= world;
			m_world_fx		= ToFx( world );
			m_area_f		= false;
			m_area			= irect();
			m_area_fx		= irect();
			m_scans.Resize( ToFx_y(m_world.Height()) );
		}
		//=================================================================================================
		void Reset()
		{
			m_area_f	= false;
		}
		//=================================================================================================
		bool IsExist()
		{
			if( m_area_f == false )
				return false;
			return m_area.IsExist();
		}
		//=================================================================================================
		int ToFx_x
				(
				int		x
				)const
		{
			return x << outlinedgemap_anti_shift_x();
		}
		//=================================================================================================
		int ToFx_y
				(
				int		y
				)const
		{
			return y << anti_shift( m_antialias );
		}
		//=================================================================================================
		ivector2 ToFx
				(
				const ivector2&	v
				)const
		{
			return ivector2( ToFx_x( v.x ) , ToFx_y( v.y ) );
		}
		//=================================================================================================
		fvector2 ToFx
				(
				const fvector2 &pos
				)const
		{
			fvector2	r;
			r.x = floor( pos.x * outlinedgemap_anti_scale_x() + 0.5f );
			r.y = floor( pos.y * anti_scale( m_antialias ) + 0.5f );
			return r;
		}
		//=================================================================================================
		irect ToFx
				(
				const irect&	v
				)const
		{
			return irect( ToFx_x(v.xmin) , ToFx_y(v.ymin) , ToFx_x(v.xmax) , ToFx_y(v.ymax) );
		}
		//=================================================================================================
		int FxTo_x
				(
				int		x
				)const
		{
			return x >> outlinedgemap_anti_shift_x();
		}
		//=================================================================================================
		int FxTo_y
				(
				int		y
				)const
		{
			return y >> anti_shift( m_antialias );
		}		
		//=================================================================================================
		ivector2 FxTo
				(
				const ivector2&	v
				)const
		{
			return ivector2( FxTo_x( v.x ) , FxTo_y( v.y ) );
		}
		//=================================================================================================
		irect FxTo
				(
				const irect&	v
				)const
		{
			return irect( FxTo_x(v.xmin) , FxTo_y(v.ymin) , FxTo_x(v.xmax) , FxTo_y(v.ymax) );
		}
		//=================================================================================================
		int	ToScan
				(
				int		y
				)const
		{
			return ToFx_y( y - m_area.ymin );
		}
		//=================================================================================================
		int	FxToScan
				(
				int		y_fx
				)const
		{
			return y_fx - m_area_fx.ymin;
		}
		//=================================================================================================
		int	ScanTo
				(
				int		scan
				)const
		{
			return FxTo_y( scan ) + m_area.ymin;
		}
		//=================================================================================================
		int	ScanToFx
				(
				int		scan
				)const
		{
			return scan + m_area_fx.ymin;
		}
		//=================================================================================================
		float ClipFx_x
				(
				float	x_fx
				)const
		{
			return clip( x_fx , (float)m_area_fx.xmin , (float)m_area_fx.xmax );
		}
		//=================================================================================================
		int ClipFx_x
				(
				int		x_fx
				)const
		{
			return clip( x_fx , m_area_fx.xmin , m_area_fx.xmax );
		}
		//=================================================================================================
		float ClipFx_y
				(
				float	y_fx
				)const
		{
			return clip( y_fx , (float)m_area_fx.ymin , (float)m_area_fx.ymax );
		}
		//=================================================================================================
		irect And
				(
				const irect&	src
				)const
		{
			return m_area & src;
		}
		//=================================================================================================
		irect GetArea()
		{
			return m_area;
		}
		//=================================================================================================
		const EdgemapOutlineInfo& cb_call GetEdgemapOutlineInfo()
		{
			m_info.m_antialias	= m_antialias;
			m_info.m_area		= m_area;
			m_info.m_line		= GetScanline( 0 );
			return m_info;
		}
		//=================================================================================================
		bool SetArea
				(
				const frect&	area , 
				const faffine&	affine
				)
		{
			irect		r;
			if( false == GetArea( &r , area , affine ) )
				return false;
			return SetArea( r );
		}
		//=================================================================================================
		bool SetArea
				(
				const irect&	area
				)
		{
			if( m_area_f == false )
			{
				irect	r = m_world & area;
				if( r.xmin >= r.xmax && r.ymin >= r.ymax )
					return false;
				MemoryZero
						( 
						&m_scans[ ToFx_y( r.ymin - m_world.ymin ) ] , 
						sizeof( OutlineScanlineInfo ) * ToFx_y( r.Height() )
						);
				m_area_f	= true;
				m_area		= r;
				m_area_fx	= ToFx( m_area );
			}
			else
			{
				irect	r	= m_world & area;
				if( r.xmin >= r.xmax && r.ymin >= r.ymax )
					return false;
				int		ih	= m_area.ymin - r.ymin;
				if( ih > 0 )
					MemoryZero
							( 
							&m_scans[ ToFx_y( r.ymin - m_world.ymin ) ] , 
							sizeof( OutlineScanlineInfo ) * ToFx_y( ih )
							);
				ih	= r.ymax - m_area.ymax;
				if( ih > 0 )
					MemoryZero
							( 
							&m_scans[ ToFx_y( m_area.ymax - m_world.ymin ) ] , 
							sizeof( OutlineScanlineInfo ) * ToFx_y( ih )
							);
				m_area	= r | m_area;
				m_area_fx	= ToFx( m_area );
			}
			return true;
		}
		//=================================================================================================
		OutlineScanlineInfo* GetScanline
				(
				int*		num
				)
		{
			if( m_area_f == false )
			{
				store( num , 0 );
				return 0;
			}
			int	h = m_area_fx.Height();
			store( num , h );
			return &m_scans[ m_area_fx.ymin - m_world_fx.ymin ];
		}
		//=================================================================================================
		int GetScanNum()
		{
			return m_area_f == false ? 0 : m_area_fx.Height();
		}
		//=================================================================================================
		OutlineScanlineInfo& operator[]
				(
				int		scan
				)
		{
			return m_scans[ scan + m_area_fx.ymin - m_world_fx.ymin ];
		}
		//=================================================================================================
		const OutlineScanlineInfo& operator[]
				(
				int		scan
				)const
		{
			return m_scans[ scan + m_area_fx.ymin - m_world_fx.ymin ];
		}
	};
protected:
	struct OutlineEdgeEx : public OutlineEdge
	{
		int				m_direction;
		int				m_logic;
	};
	cb_copy_impossible( EdgemapOutline_bs );
	
// variable member
private:
	IMemAllocLump*		m_allocator;
	Scanline			m_scanline;	
	
// private functions
private:
//=================================================================================================
//!	create OutlineEdgeEx
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineEdgeEx* CreateOutlineEdgeEx()
{
	return ( OutlineEdgeEx* )m_allocator->Allocate( sizeof( OutlineEdgeEx ) );
}
//=================================================================================================
//!	add outlineedge
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void AddEdge
		(
		int		x_fx , 
		int		y_fx , 
		int		dir
		)
{
	int				dy		= m_scanline.FxToScan( y_fx );
	OutlineEdgeEx*	node	= (OutlineEdgeEx*)m_scanline[ dy ].m_edge;
	OutlineEdgePtr*	prev	= &m_scanline[ dy ].m_edge;

	// search
	while( node != 0 )
	{
		if( node->x == x_fx )
		{
			node->m_direction += dir;
			if( node->m_direction == 0 )
				*prev	= node->m_next;
			return;
		}
		else if( x_fx < node->x )
			break;

		prev = &node->m_next;
		node = (OutlineEdgeEx*)node->m_next;
	}
	// add node
	OutlineEdgeEx	*e;
	e = CreateOutlineEdgeEx();
	e->m_next = (*prev);
	(*prev) = e;

	e->m_direction	= dir;
	e->x			= x_fx;
}
//=================================================================================================
//!	set segment
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void AddSegment
		(
		const fvector2	&start , 
		const fvector2	&target
		)
{
	fvector2	s	= m_scanline.ToFx( start );
	fvector2	t	= m_scanline.ToFx( target );
	int			ssy	= (int)m_scanline.ClipFx_y( s.y );
	int			tty	= (int)m_scanline.ClipFx_y( t.y );
	int			dir	= 1;
	if( ssy == tty )
		return;
	if( ssy > tty )
	{
		swap( &ssy , &tty );
		swap( &s , &t );
		dir = -1;
	}
	float	ssx = ( t.x - s.x ) * ( ( ssy + 0.5f ) - s.y ) / ( t.y - s.y ) + s.x;
	float	ttx = ( t.x - s.x ) * ( ( tty + 0.5f ) - s.y ) / ( t.y - s.y ) + s.x;
	float	dx	= ( ttx - ssx ) / ( tty - ssy );
	
	int		y;
	for( y = ssy ; y < tty ; y++ )
	{
		AddEdge( (int)m_scanline.ClipFx_x( ssx ) , y , dir );
		ssx += dx;
	}
}
//=================================================================================================
//!	set node
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void AddOutline
		(
		OutlineNode*	pnode , 
		const faffine&	affine
		)
{
	if( pnode == 0)
		return;
	fvector2	start	= affine.Transform( fvector2( pnode->x , pnode->y ) );
	fvector2	t_start = start;
	while( pnode->m_next != 0 )
	{
		fvector2	target	= affine.Transform( fvector2( pnode->m_next->x , pnode->m_next->y ) );
		AddSegment( start , target );
		
		// update
		start	= target;
		pnode	= pnode->m_next;
	}
	if( start != t_start )
		AddSegment( start , t_start );
}
//=================================================================================================
//!	update lines winding
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ConvertEdgeToLine_winding
		(
		OutlineScanlineInfo*	plines
		)
{
	OutlineEdgeEx	first;
	OutlineEdgeEx	*prev_node = &first;
	
	OutlineEdgeEx	*now_node = (OutlineEdgeEx*)plines->m_edge;
	int		prev_dir = 0;
	int		now_dir	 = 0;

	while( now_node != 0 )
	{
		now_dir += now_node->m_direction;

		if( prev_dir == 0 && now_dir != 0 )
		{
			prev_node->m_next = now_node;
			prev_node = now_node;
		}
		else if( prev_dir != 0 && now_dir == 0 )
		{
			prev_node->m_next = now_node;
			prev_node = now_node;
		}
		prev_dir = now_dir;
		now_node = (OutlineEdgeEx*)now_node->m_next;
	}
	prev_node->m_next = 0;
	plines->m_edge = first.m_next;
}
//=================================================================================================
//!	update lines even odd
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ConvertEdgeToLine_evenodd
		(
		OutlineScanlineInfo*	plines
		)
{
	OutlineEdgeEx	first;
	OutlineEdgeEx	*prev_node = &first;

	OutlineEdgeEx	*now_node = (OutlineEdgeEx*)plines->m_edge;
	int		prev_dir = 0;
	int		now_dir	 = 0;

	while( now_node != 0 )
	{
		now_dir += now_node->m_direction;

		if( ( prev_dir & 1 ) == 0 && ( now_dir & 1 ) != 0 )
		{
			prev_node->m_next = now_node;
			prev_node = now_node;
		}
		else if( ( prev_dir & 1 ) != 0 && ( now_dir & 1 ) == 0 )
		{
			prev_node->m_next = now_node;
			prev_node = now_node;
		}
		prev_dir = now_dir;
		now_node = (OutlineEdgeEx*)now_node->m_next;
	}
	prev_node->m_next = 0;
	plines->m_edge = first.m_next;
}
//=================================================================================================
//!	LogicPath_and
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_logic >
OutlineEdge* LogicPath
		(
		OutlineEdgeEx*	outlineedge , 
		t_logic&		lg
		)
{
	int		count = 0;
	
	OutlineEdge	first;
	first.m_next	= 0;
	OutlineEdge	*prev = &first;
	
	while( outlineedge != 0 )
	{
		int	n_count = count + outlineedge->m_logic;

		if( true == lg.Logic( count , n_count ) )
		{
			prev->m_next	= outlineedge;
			prev	= outlineedge;
		}
		count = n_count;
		outlineedge	= ( OutlineEdgeEx* )outlineedge->m_next;
	}
	prev->m_next = 0;
	return first.m_next;
}
//=================================================================================================
//!	clip_and_line
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineEdge* CreateLogicPath
		(
		OutlineScanlineInfo*		ptgt , 
		const OutlineScanlineInfo*	psrc
		)
{
	OutlineEdge*		t_edge = ptgt->m_edge;
	const OutlineEdge*	s_edge = ( psrc == 0 ) ? 0 : psrc->m_edge;
	ptgt->m_edge	= 0;
	
	OutlineEdge	first;
	first.x	= INT_MIN;
	OutlineEdge	*prev = &first;

	int			t_dir		= 1;
	int			s_dir		= 2;
	while( s_edge !=0 || t_edge != 0 )
	{
		if( s_edge == 0 || ( t_edge != 0 && t_edge->x <= s_edge->x ) )
		{
			if( prev->x == t_edge->x )
				( ( OutlineEdgeEx* )prev )->m_logic += t_dir;
			else
			{
				prev->m_next = t_edge;
				prev	= t_edge;
				( ( OutlineEdgeEx* )t_edge )->m_logic = t_dir;
			}
			t_dir	= t_dir == 1 ? -1 : 1;
			t_edge	= t_edge->m_next;
		}
		else
		{
			int		sx = (int)m_scanline.ClipFx_x( s_edge->x );
			if( prev->x == sx )
				( ( OutlineEdgeEx* )prev )->m_logic += s_dir;
			else
			{
				OutlineEdgeEx	*e = CreateOutlineEdgeEx();
				e->x			= sx;
				e->m_next	= 0;
				e->m_logic		= s_dir;
				prev->m_next = e;
				prev	= e;
			}
			s_dir	= s_dir == 2 ? -2 : 2;
			s_edge	= s_edge->m_next;
		}
	}
	prev->m_next = 0;
	return first.m_next;
}
//=================================================================================================
//!	operate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_logic >
void cb_call OperateLogic
		(
		const EdgemapOutlineInfo&	ei , 
		t_logic&					lg
		)
{
	irect	calc_area;
	if( false == lg.CalcArea( &calc_area , m_scanline.GetArea() , ei.m_area ) )
		return;
	m_scanline.SetArea( calc_area );
	calc_area = m_scanline.And( calc_area );

	int		d_to_f8			= 8 - anti_shift( m_scanline.m_antialias );
	int		s_to_f8			= 8 - anti_shift( ei.m_antialias );
	int		sscan_f8		= (calc_area.ymin - ei.m_area.ymin) << 8;
	int		sscan_d_f8		= 1 << d_to_f8;
	int		sscan_max		= ei.m_area.Height() << anti_shift( ei.m_antialias );
	
	int		scan , scan_max = m_scanline.ToScan( calc_area.ymax );
	for( scan = m_scanline.ToScan( calc_area.ymin ) ; scan < scan_max ; scan++ )
	{
		int	sscan	= sscan_f8 >> s_to_f8;
		OutlineEdge	*e;
		if( 0 <= sscan && sscan < sscan_max )
			e = CreateLogicPath( &m_scanline[ scan ] , &ei.m_line[ sscan ] );
		else
			e = CreateLogicPath( &m_scanline[ scan ] , 0 );
		m_scanline[ scan ].m_edge = LogicPath( ( OutlineEdgeEx* )e , lg );
		
		sscan_f8 += sscan_d_f8;
	}
}

// "IEdgemapOutlineInfo" interface functions
public:
//=================================================================================================
const EdgemapOutlineInfo& cb_call GetEdgemapOutlineInfo()
{
	return m_scanline.GetEdgemapOutlineInfo();
}
// "IEdgemapOutline" interface functions
public:
//=================================================================================================
void cb_call Initialize
		(
		antialias		antialias , 
		const irect		&area
		)
{
	m_scanline.Initialize( antialias , area );
}
//=================================================================================================
void cb_call BeginOutline()
{
	m_allocator->DeallocateAll();
	m_scanline.Reset();
}
//=================================================================================================
void cb_call SetOutline
		(
		IOutlineInfo*	outline , 
		const faffine&	affine
		)
{
	OutlineInfo		oi;
	if( false == outline->GetOutlineInfo( &oi ) )
		return;
	if( false == m_scanline.SetArea( oi.m_boundbox , affine ) )
		return;

	const OutlineSeg*	os	= oi.m_first;
	while( os != 0 )
	{
		AddOutline( os->m_node , affine );
		os	= os->m_next;
	}
}
//=================================================================================================
void cb_call EndOutline
		(
		PathFillRule	rule
		)
{
	int		scannum;
	OutlineScanlineInfo*	plines = m_scanline.GetScanline( &scannum );
	if( plines == 0 )
		return;
	if( rule == Winding_PathFillRule )
	{
		int	scanoff;
		for( scanoff = 0 ; scanoff < scannum ; scanoff++ )
			ConvertEdgeToLine_winding( &plines[ scanoff ] );
	}
	else
	{
		int	scanoff;
		for( scanoff = 0 ; scanoff < scannum ; scanoff++ )
			ConvertEdgeToLine_evenodd( &plines[ scanoff ] );
	}
}
//=================================================================================================
void cb_call Operate
		(
		PathOperator			ope , 
		IEdgemapOutlineInfo*	info
		)
{
	EdgemapOutlineInfo	ei = info->GetEdgemapOutlineInfo();
	if( ope == And_PathOperator )
	{
		LogicAnd	lg;
		OperateLogic( ei , lg );
	}
	else if( ope == Or_PathOperator )
	{
		LogicOr	lg;
		OperateLogic( ei , lg );
	}
	else if( ope == Xor_PathOperator )
	{
		LogicXor	lg;
		OperateLogic( ei , lg );
	}
	else if( ope == Sub_PathOperator )
	{
		LogicSub	lg;
		OperateLogic( ei , lg );
	}
}
// protected functions
public:
//=================================================================================================
EdgemapOutline_bs
		(
		IMemAllocLump*	alloc
		) :	m_allocator( alloc )
{
	cb_assert( m_allocator != 0 , L"Allocator isn't exist." );
}
//=================================================================================================
~EdgemapOutline_bs()
{
	ReleaseAllocator();
}
//=================================================================================================
//!	ReleaseAllocator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ReleaseAllocator()
{
	if( m_allocator == 0 )
		return;
	m_allocator->DeallocateAll();
	m_allocator = 0;
	m_scanline.Reset();
}
};
/**************************************************************************************************
"EdgemapOutline" class 
**************************************************************************************************/
class EdgemapOutline : 
		public EdgemapOutline_bs , 
		virtual public object_base
{
// query
	query_begin()
	iface_hook( IEdgemapOutlineInfo , IEdgemapOutlineInfo_IID )
	iface_hook( IEdgemapOutline , IEdgemapOutline_IID )
	query_end( object_base )

private:
	MemAllocLump_inc		m_allocator;
	
public:
//=================================================================================================
EdgemapOutline() : EdgemapOutline_bs( &m_allocator ) , m_allocator( sizeof( OutlineEdgeEx ) * 512 )
{
}
//=================================================================================================
~EdgemapOutline()
{
	ReleaseAllocator();
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
