/*************************************************************************************************/
/*!
   	@file		guid.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		cb_guid_define( NAME , D1 , D2 , D3 , D4 )				\
class NAME : public icubic::guid											\
{																		\
public:																	\
	NAME() : icubic::guid( D1, D2, D3, D4 ){}							\
	static																\
	const NAME& get_const()												\
	{																	\
		static NAME	obj;												\
		return obj;														\
	}																	\
};														

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

#pragma pack( push , 1 )		//set align
/****************************************************************************
"guid" class 
****************************************************************************/
/////////////////////////////////////////////////////////////////////////////
class guid
{
// variable member
public:
	uint32		Data1;
    uint16		Data2;
    uint16		Data3;
    uint8		Data4[ 8 ];

// public functions
public:
//=================================================================================================
guid()
{
	Data1		= 0;
	Data2		= 0;
	Data3		= 0;
	MemoryZero( Data4 , sizeof( Data4[0] ) * _countof( Data4 ) );
}
//=================================================================================================
guid
		(
		uint32		data1 ,
		uint32		data2 ,
		uint32		data3 ,
		uint32		data4
		)
{
	Data1		= data1;
	Data2		= (data2 >> 16) & 0xFFFF;
	Data3		= data2 & 0xFFFF;
	Data4[0]	= ( data3 >> 24 ) & 0xFF;
	Data4[1]	= ( data3 >> 16 ) & 0xFF;
	Data4[2]	= ( data3 >> 8 ) & 0xFF;
	Data4[3]	= data3 & 0xFF;
	Data4[4]	= ( data4 >> 24 ) & 0xFF;
	Data4[5]	= ( data4 >> 16 ) & 0xFF;
	Data4[6]	= ( data4 >> 8 ) & 0xFF;
	Data4[7]	= data4 & 0xFF;
}
//=================================================================================================
/*
guid
		(
		uint32		data1 ,
		uint16		data2 ,
		uint16		data3 ,
		uint8		data4[8]
		)
{
	Data1		= data1;
	Data2		= data2;
	Data3		= data3;
	MemoryCopy( Data4 , data4 , 8 );
}
*/
//=================================================================================================
bool operator==
		( 
		const guid& obj 
		)const
{
	if( *( (uint64*)this ) == *( (uint64*)&obj )
	&&  *( ((uint64*)this) + 1 ) == *( ((uint64*)&obj) + 1 ) )
		return true;
	return false;
}
//=================================================================================================
bool operator!=
		( 
		const guid& obj 
		)const
{
	if( *this == obj )
		return false;
	return true;
}
#ifdef cb_windows
//=================================================================================================
guid& operator=
		(
		const GUID& obj
		)
{
	Data1	= obj.Data1;
	Data2	= obj.Data2;
	Data3	= obj.Data3;
	int		off , num = _countof( Data4 );
	for( off = 0 ; off < num ; off++ )
		Data4[off]	= obj.Data4[off];
	return *this;
}
//=================================================================================================
operator GUID()const
{
	GUID	clsid;
	clsid.Data1	= Data1;
	clsid.Data2	= Data2;
	clsid.Data3	= Data3;
	int		off , num = _countof( Data4 );
	for( off = 0 ; off < num ; off++ )
		clsid.Data4[off]	= Data4[off];
	return clsid;
}
#endif
//=================================================================================================
bool IsNull()const
{
	if( Data1 != 0 )
		return false;
	if( Data2 != 0 )
		return false;
	if( Data3 != 0 )
		return false;
	if( Data4[0] != 0 )
		return false;
	if( Data4[1] != 0 )
		return false;
	if( Data4[2] != 0 )
		return false;
	if( Data4[3] != 0 )
		return false;
	if( Data4[4] != 0 )
		return false;
	if( Data4[5] != 0 )
		return false;
	if( Data4[6] != 0 )
		return false;
	if( Data4[7] != 0 )
		return false;
	return true;
}
};
#pragma pack( pop )			//release align

cb_guid_define( null_guid , 0x00000000 , 0x00000000 , 0x00000000 , 0x00000000 );

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

#ifdef cb_windows
//=================================================================================================
cb_inline
GUID to_GUID
		(
		const guid&		id
		)
{
	GUID	rid = 
			{ 
			id.Data1 , 
			id.Data2 , 
			id.Data3 , 
			id.Data4[0] , 
			id.Data4[1] , 
			id.Data4[2] , 
			id.Data4[3] , 
			id.Data4[4] , 
			id.Data4[5] , 
			id.Data4[6] , 
			id.Data4[7]
			};
	return rid;
}
//=================================================================================================
cb_inline
guid to_guid
		(
		const GUID&		id
		)
{
	guid	rid;
	rid.Data1	= id.Data1;
	rid.Data2	= id.Data2;
	rid.Data3	= id.Data3;
	MemoryCopy( rid.Data4 , id.Data4 , 8 );
	return rid;
}
#endif
};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
