/*************************************************************************************************/
/*!
   	@file		atomic.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#if defined( cb_windows )
	#define		cb_atomic_increment			::InterlockedIncrement
	#define		cb_atomic_decrement			::InterlockedDecrement
	#define		cb_atomic_compare_exchange	::InterlockedCompareExchange
	#define		cb_atomic_exchange			::InterlockedExchange
	#define		cb_atomic_exchange_add		::InterlockedExchangeAdd
#else
	#error		unknown os.
#endif


///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

#if defined( cb_windows )
//=================================================================================================
cb_inline
int32 atomic_get
		(
		int32*	dest
		)
{
	return ::InterlockedExchangeAdd( dest , 0 );
}
//=================================================================================================
cb_inline
int32 atomic_increment
		(
		int32*	dest
		)
{
	return ::InterlockedIncrement( dest );
}
//=================================================================================================
cb_inline
int32 atomic_decrement
		(
		int32*	dest
		)
{
	return ::InterlockedDecrement( dest );
}
//=================================================================================================
cb_inline
int32 atomic_compare_exchange
		(
		int32*	dest , 
		int32	exchange , 
		int32	compare
		)
{
	return ::InterlockedCompareExchange( dest , exchange , compare );
}
//=================================================================================================
cb_inline
int32 atomic_exchange
		(
		int32*	dest , 
		int32	value
		)
{
	return ::InterlockedExchange( dest , value );
}
//=================================================================================================
cb_inline
int32 atomic_exchange_add
		(
		int32*	dest , 
		int32	add
		)
{
	return ::InterlockedExchangeAdd( dest , add );
}

#else
	#error		unknown os.
#endif
///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
