/*************************************************************************************************/
/*!
   	@file		EnumAudioDriver.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"EnumAudioDriverInOut" class 
**************************************************************************************************/
class EnumAudioDriverInOut : 
	virtual public object_base , 
	public IEnumAudioDriver
{
	query_begin();
	iface_hook( IEnumAudioDriver , IEnumAudioDriver_IID )
	query_end( object_base );
	
// variable member
private:
	Array<iEnumAudioDevice>			m_drivers;
	
// private functions
private:
//=================================================================================================
guid GetIdentifierId()
{
	cb_guid_define( IdentifierId , 0x0D217D41 , 0x77A146d1 , 0x9C258BD2 , 0x02415FB3 );
	static
	IdentifierId	id;
	return id;	
}
	
// "IEnumAudioDriverInOut" interface functions
public:
//=================================================================================================
void cb_call Enum()
{
	int32	drvoff;
	for( drvoff = 0 ; drvoff < m_drivers.GetDatanum() ; drvoff++ )
		m_drivers[ drvoff ]->Enum();
}
//=================================================================================================
bool cb_call SearchDevice
		(
		int32*			drvoff , 
		int32*			devoff , 
		IAudioDeviceId*	id
		)
{
	int32	t_drvoff;
	for( t_drvoff = 0 ; t_drvoff < m_drivers.GetDatanum() ; t_drvoff++ )
	{
		int32	t_devoff;
		if( true == m_drivers[t_drvoff]->SearchDevice( &t_devoff , id ) )
		{
			store( drvoff , t_drvoff );
			store( devoff , t_devoff );
			return true;
		}
	}
	return false;
}
//=================================================================================================
int32 cb_call GetDriverNum()
{
	return m_drivers.GetDatanum();
}
//=================================================================================================
iEnumAudioDevice cb_call GetEnumAudioDevice
		(
		int32		drvid
		)
{
	if( drvid < 0 || drvid >= m_drivers.GetDatanum() )
		return iEnumAudioDevice();
	return m_drivers[ drvid ];
}
// public functions
public:
//=================================================================================================
EnumAudioDriverInOut() : m_drivers( 4 )
{
	m_drivers[0]	= (iEnumAudioDevice)instance<mme::EnumAudioDevicePair>();
	m_drivers[1]	= (iEnumAudioDevice)instance<ds::EnumAudioDevicePair>();
	m_drivers[2]	= (iEnumAudioDevice)instance<asio::EnumAudioDevice>();
	m_drivers[3]	= (iEnumAudioDevice)instance<wdm::EnumAudioDevicePair>();
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
