/*************************************************************************************************/
/*!
   	@file		window.h
	@author 	Fanzo
 	@date 		2008/3/4
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<windows.h>
#include	"iCubicGraphics/iCubicGraphics.h"
#include	"../iFace/iWindow.h"

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		msg_win_map_begin()									\
protected:														\
virtual															\
LRESULT WndProc													\
		(														\
		HWND	hwnd,											\
		UINT	msg,											\
		WPARAM	wparam,											\
		LPARAM	lparam , 										\
		bool	*def											\
		)														\
{																\

#define		msg_win_hook( msg_type , callfunc )					\
	if( msg == msg_type )										\
	{															\
		callfunc( wparam , lparam );							\
		*def = false;											\
	}


#define		msg_win_map_end()									\
	return 0;													\
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define


/**************************************************************************************************
"Window" class 
**************************************************************************************************/
class Window : 
	virtual public object_base , 
	public IWindow , 
	public IViewParentCtrl
{
// query
	query_begin();
	iface_hook( IViewParentCtrl , IViewParentCtrl_IID )
	iface_hook( IWindow , IWindow_IID )
	query_end( object_base );

//msgmap
	msg_win_map_begin()
	msg_win_hook( WM_CREATE		, OnCreate );
	msg_win_hook( WM_DESTROY	, OnDestroy );
	msg_win_hook( WM_SIZE		, OnSize );
	msg_win_hook( WM_PAINT		, OnPaint );
	msg_win_hook( WM_MOUSEMOVE	, OnMouseMove );
	msg_win_hook( WM_LBUTTONDOWN, OnLButtonDown );
	msg_win_hook( WM_LBUTTONUP	, OnLButtonUp );
	msg_win_hook( WM_CANCELMODE	, OnCancelMode );
	msg_win_map_end()

// variable member
private:
	HWND							m_hwnd;
	iView							m_view;
	iSurface						m_surface;
	instance<SurfaceViewport>	m_surface_viewport;
	
	const int					m_draglen;
	bool						m_lbutton;
	ivector2					m_startpos;
	bool						m_drag;
	
// static functions
//=================================================================================================
//!	wnd proc
//!	@retval			---
//-------------------------------------------------------------------------------------------------
static
LRESULT CALLBACK WndProcStatic
		(
		HWND	hwnd, 
		UINT	msg, 
		WPARAM	wparam, 
		LPARAM	lparam
		)
{
	if( msg == WM_CREATE )
		SetWindowLongPtr( hwnd , GWLP_USERDATA , ( LONG_PTR )( ( ( LPCREATESTRUCT )lparam )->lpCreateParams ) );

	Window	*pwin = ( Window* )GetWindowLongPtr( hwnd , GWLP_USERDATA );
	if( pwin != 0 )
		return pwin->PreWndProc( hwnd , msg , wparam , lparam );
	return DefWindowProc( hwnd, msg, wparam, lparam);
}

// private functions
private:
//=================================================================================================
//!	PreWndProc
//!	@retval			---
//-------------------------------------------------------------------------------------------------
LRESULT PreWndProc
		(
		HWND	hwnd, 
		UINT	msg, 
		WPARAM	wparam, 
		LPARAM	lparam
		)
{
	// PreWndProc
	if( msg == WM_CREATE )
		m_hwnd = hwnd;

	// WndProc		
	bool	def = true;
	LRESULT	r = WndProc( hwnd , msg , wparam , lparam , &def );

	if( def == false )
		return r;
	else
		return DefWindowProc( hwnd, msg, wparam, lparam);
}
//=================================================================================================
//!	regist class
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ATOM MyRegisterClass
		(
		HINSTANCE			hinst , 
		const wchar_t		*class_name
		)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProcStatic;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hinst;
	wcex.hIcon			= NULL;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= NULL;
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= class_name;
	wcex.hIconSm		= NULL;

	return RegisterClassEx( &wcex );
}
//=================================================================================================
//!	Update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Update
		(
		const irect&	update
		)
{
	if( m_view == false )
		return;
	
	irect	r	= m_view->GetRect();
	irect	c	= update;
	c = c.Move( ivector2( -r.xmin , -r.ymin ) );
	m_view->Update( (iSurfaceViewport)m_surface_viewport , c );
	m_surface_viewport->SetViewport( irect( m_surface_viewport->GetViewportMax() ) );
	m_surface_viewport->SetClip( irect( m_surface_viewport->GetViewportMax() ) );
}
// msg
//=================================================================================================
//!	destroy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnCreate
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	CREATESTRUCT*	cs	= ( CREATESTRUCT* )lparam;
	m_surface	= CreateSurface_win_rgb( isize( cs->cx , cs->cy ) );
	m_surface_viewport->SetSurface( (iSurface)m_surface );
}
//=================================================================================================
//!	destroy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnDestroy
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	m_hwnd = NULL;
	PostQuitMessage(0);
}
//=================================================================================================
//!	size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnSize
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	isize	size( ( short )LOWORD(lparam) , ( short )HIWORD(lparam) );
	m_surface = CreateSurface_win_rgb( size );
	m_surface_viewport->SetSurface( (iSurface)m_surface );
	if( m_view == true )
		m_view->Move( irect( ivector2( 0 , 0 ) , size ) );
	::InvalidateRect( m_hwnd , NULL , FALSE );
}
//=================================================================================================
//!	paint
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnPaint
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	PAINTSTRUCT ps;
	HDC	hdc = BeginPaint( m_hwnd , &ps );
	Update( irect( ps.rcPaint.left , ps.rcPaint.top , ps.rcPaint.right , ps.rcPaint.bottom ) );
	irect	v , a;
	HDC		s_hdc	= m_surface->GetSourceHDC( &v , &a );
	::BitBlt( hdc , v.xmin + a.xmin , v.ymin + a.ymin , a.Width() , a.Height() , s_hdc , v.xmin + a.xmin , v.ymin + a.ymin , SRCCOPY );
	EndPaint( m_hwnd , &ps );
}
//=================================================================================================
//!	mousemove
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnMouseMove
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	ivector2	pos( ( short )LOWORD(lparam) , ( short )HIWORD(lparam) );
	if( m_view == false )
		return;
	if( m_lbutton == true && m_drag == false )
	{
		ivector2	dp = pos - m_startpos;
		if( dp.x * dp.x + dp.y * dp.y > m_draglen )
		{
			LDragStart_MsgPM	msg;
			msg.m_msg	= LDragStart_Msg;
			msg.m_pos	= m_startpos;
			m_view->Msg( &msg );
			m_drag	= true;
		}
	}
	if( m_drag == false )
	{		
		MouseMove_MsgPM	msg;
		msg.m_msg	= MouseMove_Msg;
		msg.m_pos	= pos;
		m_view->Msg( &msg );
	}
	else
	{
		LDrag_MsgPM	msg;
		msg.m_msg	= LDrag_Msg;
		msg.m_pos	= pos;
		m_view->Msg( &msg );
	}
}
//=================================================================================================
//!	lbuttondown
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnLButtonDown
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	if( m_view == false )
		return;
	ivector2	pos( ( short )LOWORD(lparam) , ( short )HIWORD(lparam) );
	LButtonDown_MsgPM	msg;
	msg.m_msg	= LButtonDown_Msg;
	msg.m_pos	= pos;
	m_view->Msg( &msg );
	
	m_lbutton	= true;
	m_startpos	= pos;
	::SetCapture( m_hwnd );
}
//=================================================================================================
//!	lbuttonup
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnLButtonUp
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	if( m_view == false )
		return;
	::ReleaseCapture();
	
	ivector2	pos( ( short )LOWORD(lparam) , ( short )HIWORD(lparam) );
	if( m_drag == true )
	{
		LDragEnd_MsgPM	msg;
		msg.m_msg	= LDragEnd_Msg;
		msg.m_pos	= pos;
		m_view->Msg( &msg );
	}
	else
	{
		LButtonUp_MsgPM	msg;
		msg.m_msg	= LButtonUp_Msg;
		msg.m_pos	= pos;
		m_view->Msg( &msg );
	}
	m_lbutton	= false;
	m_drag		= false;
}
//=================================================================================================
//!	cancelmode
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void OnCancelMode
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	if( m_view == false )
		return;
	if( m_drag == true )
	{
		LDragCancel_MsgPM	msg;
		msg.m_msg	= LDragCancel_Msg;
		m_view->Msg( &msg );
	}
}
// "IViewParentCtrl" interface
public:
//=================================================================================================
//!	regist child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RegistChild
		(
		iView&		child
		)
{
//	cb_assert( m_view == false , L"algorithm error." );
	m_view	= child;
}
//=================================================================================================
//!	remove child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RemoveChild
		(
		iView&		child
		)
{
	cb_assert( ( object )m_view == ( object )child , L"algorithm error" );
	m_view.release();
}
//=================================================================================================
//!	require update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RequireUpdate
		(
		const irect&	update , 
		bool			sync
		)
{
	if( sync == false )
	{
		RECT	r	= { update.xmin , update.ymin , update.xmax , update.ymax };
		::InvalidateRect( m_hwnd , &r , FALSE );
	}
	else
	{
		Update( update );
	}
}
//=================================================================================================
//!	ToWindow
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call ViewToWindow
		(
		const ivector2&	pos
		)
{
	return pos;
}
//=================================================================================================
//!	ToScreen
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call ViewToScreen
		(
		const ivector2&	pos
		)
{
	POINT	r = { pos.x , pos.y };
	::ClientToScreen( m_hwnd , &r );
	return ivector2( r.x , r.y );
}
//=================================================================================================
//!	WindowToView
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call WindowToView
		(
		const ivector2&	pos
		)
{
	return pos;
}
//=================================================================================================
//!	ScreenToView
//!	@retval			---
//-------------------------------------------------------------------------------------------------
ivector2 cb_call ScreenToView
		(
		const ivector2&	pos
		)
{
	ivector2	r( 0 , 0 );
	r = ViewToScreen( r );
	return pos - r;
}

// "IWindow" interface
public:
//=================================================================================================
//!	create
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Create
		(
		const wstring&	title ,
		const irect&	rect , 
		iView&			view
		)
{
	Destroy();
	MyRegisterClass( NULL , L"BA5D8630-FC3A-43be-99ED-2B31D24D91F0" );

	m_view	= view;
	m_hwnd = CreateWindow
			(
			L"BA5D8630-FC3A-43be-99ED-2B31D24D91F0", 
			title.c_str() , 
			WS_OVERLAPPEDWINDOW,
			rect.xmin , rect.ymin , rect.xmax , rect.ymax, 
			NULL, 
			NULL, 
			NULL , 
			this
			);
	if (m_hwnd == NULL)
	{
		m_view.release();
		return false;
	}
	RECT	r;
	::GetClientRect( m_hwnd , &r );
	m_view->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( 0 , 0 ) , isize( r.right - r.left , r.bottom - r.top ) ) );
	::ShowWindow( m_hwnd , SW_SHOW );
	::UpdateWindow( m_hwnd );

	MSG		msg;
	while ( GetMessage( &msg , NULL , 0, 0 ) )
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return true;
}
//=================================================================================================
//!	destroy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Destroy()
{
	if( m_hwnd != NULL )
		::DestroyWindow( m_hwnd );
	m_view.release();
}


// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Window() : m_hwnd( NULL ) , m_drag( false ) , m_lbutton( false ) , m_draglen( 2 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~Window()
{
	Destroy();
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace window1

//using namespace window1;		

