/*************************************************************************************************/
/*!
   	@file		Slider.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ISliderMsg" interface 
***************************************************************************************************/
cb_guid_define( ISliderMsg_IID , 0x8DC9B62E , 0xCE6D49b6 , 0xA2AFBBBA , 0xAAB64291 );
class ISliderMsg;
typedef icubic::iface_object< ISliderMsg , ISliderMsg_IID >		iSliderMsg;
typedef icubic::iface_reference< ISliderMsg , ISliderMsg_IID >	rSliderMsg;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISliderMsg
{
public:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ValueChanged_slider
		(
		int		id
		) = 0;
};

/**************************************************************************************************
"Slider" class 
**************************************************************************************************/
class Slider : public View
{
	msg_view_map_begin()
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( LButtonDown , OnLButtonDown )
	msg_view_hook( LButtonUp , OnLButtonUp )
	msg_view_hook( LDragStart , OnLDragStart )
	msg_view_hook( LDrag , OnLDrag )
	msg_view_hook( LDragEnd , OnLDragEnd )
	msg_view_map_end( View )

// variable member
private:
//	rCheckBoxMsg						m_msg;
	instance<PaintSolidColor>		m_back;
	const int							m_edgelen;
	const int							m_rail_w;
	float								m_value;
	rSliderMsg							m_msg;
	int									m_id;
	
// private functions
private:
//=================================================================================================
irect GetRailRect()
{
	ivector2	sp( m_edgelen , GetRect().Size().height / 2 );
	ivector2	tp( GetRect().Size().width - m_edgelen , GetRect().Size().height / 2 );
	return irect( sp.x , sp.y - m_rail_w / 2 , tp.x , tp.y + m_rail_w / 2 );
}
//=================================================================================================
fvector2 GetKnobPos()
{
	fvector2	sp( ( float )m_edgelen , ( float )GetRect().Size().height / 2.0f );
	fvector2	tp( ( float )GetRect().Size().width - m_edgelen , ( float )GetRect().Size().height / 2.0f );
	return ( tp - sp ) * m_value + sp;
}
// msg functions
protected:
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
//	PaintRect( p->m_surface , p->m_rect , ( iSourceGen )m_back , rgbaaa() );

	DrawSliderRail( (iSurfaceDest)p->m_surface , GetRailRect() , rgb( 0 , 0 , 255 ) , rgb( 0 , 0 , 100 ) );
	DrawSliderKnob( (iSurfaceDest)p->m_surface , GetKnobPos() , 4.0f , rgb( 0 , 255 , 100 ) , rgb( 0 , 0 , 0 ) );
}
//=================================================================================================
void OnLButtonDown
		(
		LButtonDown_ViewPM*	p
		)
{
	ivector2	pos = p->m_pos;
	irect		r	= GetRailRect();
	pos.x	= pos.x < r.xmin ? r.xmin : pos.x;
	pos.x	= pos.x > r.xmax ? r.xmax : pos.x;
	float	v = ( float )( pos.x - r.xmin ) / ( float )( r.xmax - r.xmin );
	if( v != m_value )
	{
		m_value	= v;
		RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
		iSliderMsg	ck = m_msg.lock();
		if( ck == true )
			ck->ValueChanged_slider( m_id );
	}
}
//=================================================================================================
void OnLButtonUp
		(
		LButtonUp_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLDragStart
		(
		LDragStart_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLDrag
		(
		LDrag_ViewPM*	p
		)
{
	ivector2	pos = p->m_pos;
	irect		r	= GetRailRect();
	pos.x	= pos.x < r.xmin ? r.xmin : pos.x;
	pos.x	= pos.x > r.xmax ? r.xmax : pos.x;
	float	v = ( float )( pos.x - r.xmin ) / ( float )( r.xmax - r.xmin );
	if( v != m_value )
	{
		m_value	= v;
		RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
		iSliderMsg	ck = m_msg.lock();
		if( ck == true )
			ck->ValueChanged_slider( m_id );
	}
}
//=================================================================================================
void OnLDragEnd
		(
		LDragEnd_ViewPM*	p
		)
{
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Slider() : m_edgelen( 8 ) , m_rail_w( 3 ) , m_value( 1.0f ) , m_id( 0 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rSliderMsg&		msg , 
		int				id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set check
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		float		v
		)
{
	m_value	= v < 0.0f ? 0.0f : v > 1.0f ? 1.0f : v;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	get check
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float GetValue()const
{
	return m_value;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace Slider;		

#pragma pack( pop )			//release align
