/*************************************************************************************************/
/*!
   	@file		SVGFileCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SVGFileCfgView" class 
**************************************************************************************************/
class SVGFileCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

	class FileData
	{
	public:
		wstring		m_path;
		wstring		m_folder;
	};
// variable member
private:
	instance<RadioGroupView>			m_select;
	Array<FileData>						m_filelist;
	int									m_cmdid;
	iGraphicsCmds						m_cmd;
	
	rControlMsg							m_msg;
	int									m_id;
	const int							m_sh;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	m_cmd	= LoadCmd();
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
//=================================================================================================
iGraphicsCmds LoadCmd()
{
	int		cmdid = m_select->GetSelect();
	if( cmdid == m_cmdid )
		return m_cmd;
		
	m_cmdid	= cmdid;
	if( m_cmdid < 0 || m_cmdid >= m_filelist.GetDatanum() )
		return iGraphicsCmds();
		
	instance< FileReader >			file;
	if( false == file->Open( m_filelist[m_cmdid].m_path.c_str() ) )
	{
		instance<GraphicsCmds>	cmds;
		instance<PaintText_cmd>	text;
		instance<PaintSolidColor_ipr>	paint;
		paint->SetColor( rgba( 0 , 0 , 0 , 255 ) );
		text->m_paint		= (iPaint_ipr)paint;
		text->m_blender		= (iBlender)instance<BlenderOverlap>();
		text->m_text		= L"no svg file.";
		instance<Font>	font;
		font->Create( fsize( 0.0f , 10.0f ) , L"Arial" , Unicode_FontCharsetType );
		text->m_font		= (iFont)font;
		text->m_fontsize	= value_ip( value_ip::px , 20.0f );
		text->m_pos			= point_ipr( value_ipr( value_ipr::px , 10.0f ) , value_ipr( value_ipr::ratio , 0.5f ) );
		cmds->AddCmd( (iGraphicsCmd)text );
		return (iGraphicsCmds)cmds;
	}
	instance<LoaderVectorfile_svg>	loader;
	loader->AddFileSerchFolder( m_filelist[m_cmdid].m_folder.c_str() );
	return loader->Load( (iStreamRead)file );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_select->SetAlign( Vert_RadioAlign );
	int		off , num = m_filelist.GetDatanum();
	m_select->SetRadioNum( num );
	for( off = 0 ; off < num ; off++ )
	{
		wchar_t		buf[256];
		cb_swprintf( buf , L"svg_%d",off+1 );
		m_select->SetString( off , buf );
	}
	m_select->SetSelect( 0 );
	m_select->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Width() , p->m_rect.Height() ) )
			);
	m_select->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_cmd = LoadCmd();
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SVGFileCfgView() : 
		m_sh( 15 ) , 
		m_id( 0 ) , 
		m_cmdid( -1 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set colornum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void AddSVGFile
		(
		const wstring&	path , 
		const wstring&	folder
		)
{
	int		off	= m_filelist.Add();
	m_filelist[off].m_path		= path;
	m_filelist[off].m_folder	= folder;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iGraphicsCmds GetValue()
{
	return m_cmd;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
