/*************************************************************************************************/
/*!
   	@file		NormTableSplineCfgView.h
	@author 	Fanzo
 	@date 		2008/6/8
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormTableSplineCfgView" class 
**************************************************************************************************/
class NormTableSplineCfgView : public View
{
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( LDragStart , OnLDragStart )
	msg_view_hook( LDrag , OnLDrag )
	msg_view_hook( LDragEnd , OnLDragEnd )
	msg_view_hook( LDragCancel , OnLDragCancel )
	msg_view_map_end( View )

// variable member
private:
	rControlMsg								m_msg;
	int										m_id;
	
	instance<NormFunctionSpline>			m_norm;
	bool									m_tbl_i16_flag;
	instance<NormTable_i16>				m_tbl_i16;
	bool									m_tbl_f_flag;
	instance<NormTable_f>				m_tbl_f;

	int										m_edit_pnt;
	fvector2								m_pnt[5];
	
	const int								m_handle_r;
	const rgba								m_hc;
	
// private functions
private:
//=================================================================================================
fvector2 ToClient
		(
		const fvector2&		p
		)
{
	isize		size = GetRect().Size();
	return fvector2( p.x * ( size.width - m_handle_r * 2 ) + m_handle_r , size.height - ( p.y * ( size.height - m_handle_r * 2 ) + m_handle_r ) );
}
//=================================================================================================
fvector2 ToNormalized
		(
		const fvector2&		p
		)
{
	isize		size	= GetRect().Size();
	fvector2	l		= fvector2( size.width - m_handle_r * 2 , size.height - m_handle_r * 2 );
	l.x	= l.x == 0.0f ? 1.0f : l.x;
	l.y	= l.y == 0.0f ? 1.0f : l.y;
	fvector2	v		= ( p - fvector2( m_handle_r , m_handle_r ) ) / l;
	v.x	= v.x < 0.0f ? 0.0f : ( v.x > 1.0f ? 1.0f : v.x );
	v.y	= v.y < 0.0f ? 0.0f : ( v.y > 1.0f ? 1.0f : v.y );
	v.y = 1.0f - v.y;
	return v;
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	// back
	DrawNormalizedBack( (iSurfaceDest)p->m_surface , GetRect().Size() , m_handle_r - 1 );
	
	// curve
	fvector2		pnt[257];
	int				pntoff;
	for( pntoff = 0 ; pntoff < _countof( pnt ) ; pntoff++ )
	{
		pnt[pntoff]		= fvector2( ( pntoff / 256.0f ) , m_norm->GetNormalizedValue( pntoff / 256.0f ) );
		pnt[pntoff].y	= clip( pnt[pntoff].y , 0.0f , 1.0f );
		pnt[pntoff]		= ToClient( pnt[pntoff] );
	}
	DrawLine( (iSurfaceDest)p->m_surface , pnt , _countof( pnt ) , 1.0f , m_hc );

	// handle
	for( pntoff = 0 ; pntoff < _countof( m_pnt ) ; pntoff++ )
		DrawCircle( (iSurfaceDest)p->m_surface , ToClient( m_pnt[ pntoff ] ) , ( float )m_handle_r , m_hc );
}
//=================================================================================================
void OnLDragStart
		(
		LDragStart_ViewPM*	p
		)
{
	int		pntoff;
	for( pntoff = 0 ; pntoff < _countof( m_pnt ) ; pntoff++ )
	{
		fvector2	pnt = ToClient( m_pnt[ pntoff ] );
		irect		rc( ( int )pnt.x - m_handle_r , ( int )pnt.y - m_handle_r , ( int )pnt.x + m_handle_r , ( int )pnt.y + m_handle_r );
		if( true == rc.IsInside( p->m_pos ) )
			m_edit_pnt = pntoff;
	}
}
//=================================================================================================
void OnLDrag
		(
		LDrag_ViewPM*	p
		)
{
	if( m_edit_pnt == -1 )
		return;
	fvector2	pp = ToNormalized( p->m_pos );
	if( m_edit_pnt == 0 || ( m_edit_pnt == _countof(m_pnt) - 1 ) )
	{
		m_pnt[ m_edit_pnt ].y = pp.y;
	}
	else
	{
		float	minx = m_pnt[ m_edit_pnt-1 ].x + 0.001f;
		float	maxx = m_pnt[ m_edit_pnt+1 ].x - 0.001f;
		pp.x = clip( pp.x , m_pnt[ m_edit_pnt-1 ].x + 0.001f , m_pnt[ m_edit_pnt+1 ].x - 0.001f );
		m_pnt[ m_edit_pnt ] = pp;
	}
	cb_verify( true == m_norm->SetParam( Free_SplineEdgetype , m_pnt , _countof( m_pnt ) , 0.0f , 0.0f ) );
	m_tbl_i16_flag	= false;
	m_tbl_f_flag	= false;

	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
void OnLDragEnd
		(
		LDragEnd_ViewPM*	p
		)
{
	m_edit_pnt = -1;
}
//=================================================================================================
void OnLDragCancel
		(
		LDragCancel_ViewPM*	p
		)
{
	m_edit_pnt = -1;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormTableSplineCfgView() : 
		m_handle_r( 4 ) , 
		m_id( 0 ) , 
		m_hc( 100 , 100 , 220 ) , 
		m_edit_pnt( -1 ) , 
		m_tbl_i16_flag( false ) , 
		m_tbl_f_flag( false )
{
	m_pnt[0]	= fvector2( 0.0f  , 1.0f );
	m_pnt[1]	= fvector2( 0.25f , 0.8f );
	m_pnt[2]	= fvector2( 0.5f  , 0.5f );
	m_pnt[3]	= fvector2( 0.75f , 0.2f );
	m_pnt[4]	= fvector2( 1.0f  , 0.0f );
	cb_verify( true == m_norm->SetParam( Free_SplineEdgetype , m_pnt , _countof( m_pnt ) , 0.0f , 0.0f ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set param
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetCoefficient
		(
		const fvector2	points[5]
		)
{
	int		off;
	for( off = 0 ; off < 5 ; off++ )
	{
		m_pnt[off]	= points[off];
	}
	cb_verify( true == m_norm->SetParam( Free_SplineEdgetype , m_pnt , _countof( m_pnt ) , 0.0f , 0.0f ) );
	m_tbl_i16_flag	= false;
	m_tbl_f_flag	= false;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_i16 GetValue_i16()
{
	if( m_tbl_i16_flag == false )
	{
		m_tbl_i16->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_i16_flag	= true;
	}
	return (iNormTable_i16)m_tbl_i16;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_f GetValue_f()
{
	if( m_tbl_f_flag == false )
	{
		m_tbl_f->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_f_flag	= true;
	}
	return (iNormTable_f)m_tbl_f;
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace NormTableSplineCfgView;		

#pragma pack( pop )			//release align
